# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualNetworkArgs', 'VirtualNetwork']

@pulumi.input_type
class VirtualNetworkArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 address_spaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bgp_community: Optional[pulumi.Input[_builtins.str]] = None,
                 ddos_protection_plan: Optional[pulumi.Input['VirtualNetworkDdosProtectionPlanArgs']] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input['VirtualNetworkEncryptionArgs']] = None,
                 flow_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint_vnet_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualNetwork resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_spaces: The address space that is used the virtual network. You can supply more than one address space.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] bgp_community: The BGP community attribute in format `<as-number>:<community-value>`.
               
               > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        :param pulumi.Input['VirtualNetworkDdosProtectionPlanArgs'] ddos_protection_plan: A `ddos_protection_plan` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: List of IP addresses of DNS servers
               
               > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        :param pulumi.Input['VirtualNetworkEncryptionArgs'] encryption: A `encryption` block as defined below.
        :param pulumi.Input[_builtins.int] flow_timeout_in_minutes: The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]] ip_address_pools: One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] location: The location/region where the virtual network is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_endpoint_vnet_policies: The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]] subnets: Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.
               
               > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if address_spaces is not None:
            pulumi.set(__self__, "address_spaces", address_spaces)
        if bgp_community is not None:
            pulumi.set(__self__, "bgp_community", bgp_community)
        if ddos_protection_plan is not None:
            pulumi.set(__self__, "ddos_protection_plan", ddos_protection_plan)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if flow_timeout_in_minutes is not None:
            pulumi.set(__self__, "flow_timeout_in_minutes", flow_timeout_in_minutes)
        if ip_address_pools is not None:
            pulumi.set(__self__, "ip_address_pools", ip_address_pools)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint_vnet_policies is not None:
            pulumi.set(__self__, "private_endpoint_vnet_policies", private_endpoint_vnet_policies)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="addressSpaces")
    def address_spaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The address space that is used the virtual network. You can supply more than one address space.

        > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        """
        return pulumi.get(self, "address_spaces")

    @address_spaces.setter
    def address_spaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_spaces", value)

    @_builtins.property
    @pulumi.getter(name="bgpCommunity")
    def bgp_community(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The BGP community attribute in format `<as-number>:<community-value>`.

        > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        """
        return pulumi.get(self, "bgp_community")

    @bgp_community.setter
    def bgp_community(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_community", value)

    @_builtins.property
    @pulumi.getter(name="ddosProtectionPlan")
    def ddos_protection_plan(self) -> Optional[pulumi.Input['VirtualNetworkDdosProtectionPlanArgs']]:
        """
        A `ddos_protection_plan` block as documented below.
        """
        return pulumi.get(self, "ddos_protection_plan")

    @ddos_protection_plan.setter
    def ddos_protection_plan(self, value: Optional[pulumi.Input['VirtualNetworkDdosProtectionPlanArgs']]):
        pulumi.set(self, "ddos_protection_plan", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses of DNS servers

        > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['VirtualNetworkEncryptionArgs']]:
        """
        A `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['VirtualNetworkEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="flowTimeoutInMinutes")
    def flow_timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        """
        return pulumi.get(self, "flow_timeout_in_minutes")

    @flow_timeout_in_minutes.setter
    def flow_timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "flow_timeout_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressPools")
    def ip_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]]]:
        """
        One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.

        > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        """
        return pulumi.get(self, "ip_address_pools")

    @ip_address_pools.setter
    def ip_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]]]):
        pulumi.set(self, "ip_address_pools", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the virtual network is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointVnetPolicies")
    def private_endpoint_vnet_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "private_endpoint_vnet_policies")

    @private_endpoint_vnet_policies.setter
    def private_endpoint_vnet_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint_vnet_policies", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]]]:
        """
        Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.

        > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VirtualNetworkState:
    def __init__(__self__, *,
                 address_spaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bgp_community: Optional[pulumi.Input[_builtins.str]] = None,
                 ddos_protection_plan: Optional[pulumi.Input['VirtualNetworkDdosProtectionPlanArgs']] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input['VirtualNetworkEncryptionArgs']] = None,
                 flow_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 guid: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint_vnet_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VirtualNetwork resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_spaces: The address space that is used the virtual network. You can supply more than one address space.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] bgp_community: The BGP community attribute in format `<as-number>:<community-value>`.
               
               > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        :param pulumi.Input['VirtualNetworkDdosProtectionPlanArgs'] ddos_protection_plan: A `ddos_protection_plan` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: List of IP addresses of DNS servers
               
               > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        :param pulumi.Input['VirtualNetworkEncryptionArgs'] encryption: A `encryption` block as defined below.
        :param pulumi.Input[_builtins.int] flow_timeout_in_minutes: The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        :param pulumi.Input[_builtins.str] guid: The GUID of the Virtual Network.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]] ip_address_pools: One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] location: The location/region where the virtual network is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_endpoint_vnet_policies: The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]] subnets: Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.
               
               > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if address_spaces is not None:
            pulumi.set(__self__, "address_spaces", address_spaces)
        if bgp_community is not None:
            pulumi.set(__self__, "bgp_community", bgp_community)
        if ddos_protection_plan is not None:
            pulumi.set(__self__, "ddos_protection_plan", ddos_protection_plan)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if flow_timeout_in_minutes is not None:
            pulumi.set(__self__, "flow_timeout_in_minutes", flow_timeout_in_minutes)
        if guid is not None:
            pulumi.set(__self__, "guid", guid)
        if ip_address_pools is not None:
            pulumi.set(__self__, "ip_address_pools", ip_address_pools)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint_vnet_policies is not None:
            pulumi.set(__self__, "private_endpoint_vnet_policies", private_endpoint_vnet_policies)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="addressSpaces")
    def address_spaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The address space that is used the virtual network. You can supply more than one address space.

        > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        """
        return pulumi.get(self, "address_spaces")

    @address_spaces.setter
    def address_spaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_spaces", value)

    @_builtins.property
    @pulumi.getter(name="bgpCommunity")
    def bgp_community(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The BGP community attribute in format `<as-number>:<community-value>`.

        > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        """
        return pulumi.get(self, "bgp_community")

    @bgp_community.setter
    def bgp_community(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_community", value)

    @_builtins.property
    @pulumi.getter(name="ddosProtectionPlan")
    def ddos_protection_plan(self) -> Optional[pulumi.Input['VirtualNetworkDdosProtectionPlanArgs']]:
        """
        A `ddos_protection_plan` block as documented below.
        """
        return pulumi.get(self, "ddos_protection_plan")

    @ddos_protection_plan.setter
    def ddos_protection_plan(self, value: Optional[pulumi.Input['VirtualNetworkDdosProtectionPlanArgs']]):
        pulumi.set(self, "ddos_protection_plan", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses of DNS servers

        > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['VirtualNetworkEncryptionArgs']]:
        """
        A `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['VirtualNetworkEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="flowTimeoutInMinutes")
    def flow_timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        """
        return pulumi.get(self, "flow_timeout_in_minutes")

    @flow_timeout_in_minutes.setter
    def flow_timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "flow_timeout_in_minutes", value)

    @_builtins.property
    @pulumi.getter
    def guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the Virtual Network.
        """
        return pulumi.get(self, "guid")

    @guid.setter
    def guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guid", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressPools")
    def ip_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]]]:
        """
        One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.

        > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        """
        return pulumi.get(self, "ip_address_pools")

    @ip_address_pools.setter
    def ip_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkIpAddressPoolArgs']]]]):
        pulumi.set(self, "ip_address_pools", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the virtual network is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointVnetPolicies")
    def private_endpoint_vnet_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "private_endpoint_vnet_policies")

    @private_endpoint_vnet_policies.setter
    def private_endpoint_vnet_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint_vnet_policies", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]]]:
        """
        Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.

        > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:network/virtualNetwork:VirtualNetwork")
class VirtualNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_spaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bgp_community: Optional[pulumi.Input[_builtins.str]] = None,
                 ddos_protection_plan: Optional[pulumi.Input[Union['VirtualNetworkDdosProtectionPlanArgs', 'VirtualNetworkDdosProtectionPlanArgsDict']]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['VirtualNetworkEncryptionArgs', 'VirtualNetworkEncryptionArgsDict']]] = None,
                 flow_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkIpAddressPoolArgs', 'VirtualNetworkIpAddressPoolArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint_vnet_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkSubnetArgs', 'VirtualNetworkSubnetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a virtual network including any configured subnets. Each subnet can
        optionally be configured with a security group to be associated with the subnet.

        > **NOTE on Virtual Networks and Subnet's:** This provider currently
        provides both a standalone Subnet resource, and allows for Subnets to be defined in-line within the Virtual Network resource.
        At this time you cannot use a Virtual Network with in-line Subnets in conjunction with any Subnet resources. Doing so will cause a conflict of Subnet configurations and will overwrite Subnet's.
        **NOTE on Virtual Networks and DNS Servers:** This provider currently provides both a standalone virtual network DNS Servers resource, and allows for DNS servers to be defined in-line within the Virtual Network resource.
        At this time you cannot use a Virtual Network with in-line DNS servers in conjunction with any Virtual Network DNS Servers resources. Doing so will cause a conflict of Virtual Network DNS Servers configurations and will overwrite virtual networks DNS servers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-security-group",
            location=example.location,
            resource_group_name=example.name)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            dns_servers=[
                "10.0.0.4",
                "10.0.0.5",
            ],
            subnets=[
                {
                    "name": "subnet1",
                    "address_prefixes": ["10.0.1.0/24"],
                },
                {
                    "name": "subnet2",
                    "address_prefixes": ["10.0.2.0/24"],
                    "security_group": example_network_security_group.id,
                },
            ],
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Virtual Networks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetwork:VirtualNetwork exampleNetwork /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_spaces: The address space that is used the virtual network. You can supply more than one address space.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] bgp_community: The BGP community attribute in format `<as-number>:<community-value>`.
               
               > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        :param pulumi.Input[Union['VirtualNetworkDdosProtectionPlanArgs', 'VirtualNetworkDdosProtectionPlanArgsDict']] ddos_protection_plan: A `ddos_protection_plan` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: List of IP addresses of DNS servers
               
               > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        :param pulumi.Input[Union['VirtualNetworkEncryptionArgs', 'VirtualNetworkEncryptionArgsDict']] encryption: A `encryption` block as defined below.
        :param pulumi.Input[_builtins.int] flow_timeout_in_minutes: The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkIpAddressPoolArgs', 'VirtualNetworkIpAddressPoolArgsDict']]]] ip_address_pools: One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] location: The location/region where the virtual network is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_endpoint_vnet_policies: The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkSubnetArgs', 'VirtualNetworkSubnetArgsDict']]]] subnets: Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.
               
               > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a virtual network including any configured subnets. Each subnet can
        optionally be configured with a security group to be associated with the subnet.

        > **NOTE on Virtual Networks and Subnet's:** This provider currently
        provides both a standalone Subnet resource, and allows for Subnets to be defined in-line within the Virtual Network resource.
        At this time you cannot use a Virtual Network with in-line Subnets in conjunction with any Subnet resources. Doing so will cause a conflict of Subnet configurations and will overwrite Subnet's.
        **NOTE on Virtual Networks and DNS Servers:** This provider currently provides both a standalone virtual network DNS Servers resource, and allows for DNS servers to be defined in-line within the Virtual Network resource.
        At this time you cannot use a Virtual Network with in-line DNS servers in conjunction with any Virtual Network DNS Servers resources. Doing so will cause a conflict of Virtual Network DNS Servers configurations and will overwrite virtual networks DNS servers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network_security_group = azure.network.NetworkSecurityGroup("example",
            name="example-security-group",
            location=example.location,
            resource_group_name=example.name)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"],
            dns_servers=[
                "10.0.0.4",
                "10.0.0.5",
            ],
            subnets=[
                {
                    "name": "subnet1",
                    "address_prefixes": ["10.0.1.0/24"],
                },
                {
                    "name": "subnet2",
                    "address_prefixes": ["10.0.2.0/24"],
                    "security_group": example_network_security_group.id,
                },
            ],
            tags={
                "environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Virtual Networks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetwork:VirtualNetwork exampleNetwork /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/virtualNetworks/myvnet1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_spaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bgp_community: Optional[pulumi.Input[_builtins.str]] = None,
                 ddos_protection_plan: Optional[pulumi.Input[Union['VirtualNetworkDdosProtectionPlanArgs', 'VirtualNetworkDdosProtectionPlanArgsDict']]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['VirtualNetworkEncryptionArgs', 'VirtualNetworkEncryptionArgsDict']]] = None,
                 flow_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkIpAddressPoolArgs', 'VirtualNetworkIpAddressPoolArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint_vnet_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkSubnetArgs', 'VirtualNetworkSubnetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkArgs.__new__(VirtualNetworkArgs)

            __props__.__dict__["address_spaces"] = address_spaces
            __props__.__dict__["bgp_community"] = bgp_community
            __props__.__dict__["ddos_protection_plan"] = ddos_protection_plan
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["flow_timeout_in_minutes"] = flow_timeout_in_minutes
            __props__.__dict__["ip_address_pools"] = ip_address_pools
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["private_endpoint_vnet_policies"] = private_endpoint_vnet_policies
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["guid"] = None
        super(VirtualNetwork, __self__).__init__(
            'azure:network/virtualNetwork:VirtualNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_spaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bgp_community: Optional[pulumi.Input[_builtins.str]] = None,
            ddos_protection_plan: Optional[pulumi.Input[Union['VirtualNetworkDdosProtectionPlanArgs', 'VirtualNetworkDdosProtectionPlanArgsDict']]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            encryption: Optional[pulumi.Input[Union['VirtualNetworkEncryptionArgs', 'VirtualNetworkEncryptionArgsDict']]] = None,
            flow_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            guid: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkIpAddressPoolArgs', 'VirtualNetworkIpAddressPoolArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_endpoint_vnet_policies: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkSubnetArgs', 'VirtualNetworkSubnetArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'VirtualNetwork':
        """
        Get an existing VirtualNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_spaces: The address space that is used the virtual network. You can supply more than one address space.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] bgp_community: The BGP community attribute in format `<as-number>:<community-value>`.
               
               > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        :param pulumi.Input[Union['VirtualNetworkDdosProtectionPlanArgs', 'VirtualNetworkDdosProtectionPlanArgsDict']] ddos_protection_plan: A `ddos_protection_plan` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: List of IP addresses of DNS servers
               
               > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        :param pulumi.Input[Union['VirtualNetworkEncryptionArgs', 'VirtualNetworkEncryptionArgsDict']] encryption: A `encryption` block as defined below.
        :param pulumi.Input[_builtins.int] flow_timeout_in_minutes: The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        :param pulumi.Input[_builtins.str] guid: The GUID of the Virtual Network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkIpAddressPoolArgs', 'VirtualNetworkIpAddressPoolArgsDict']]]] ip_address_pools: One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.
               
               > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        :param pulumi.Input[_builtins.str] location: The location/region where the virtual network is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_endpoint_vnet_policies: The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualNetworkSubnetArgs', 'VirtualNetworkSubnetArgsDict']]]] subnets: Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.
               
               > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkState.__new__(_VirtualNetworkState)

        __props__.__dict__["address_spaces"] = address_spaces
        __props__.__dict__["bgp_community"] = bgp_community
        __props__.__dict__["ddos_protection_plan"] = ddos_protection_plan
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["flow_timeout_in_minutes"] = flow_timeout_in_minutes
        __props__.__dict__["guid"] = guid
        __props__.__dict__["ip_address_pools"] = ip_address_pools
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_endpoint_vnet_policies"] = private_endpoint_vnet_policies
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tags"] = tags
        return VirtualNetwork(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressSpaces")
    def address_spaces(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The address space that is used the virtual network. You can supply more than one address space.

        > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        """
        return pulumi.get(self, "address_spaces")

    @_builtins.property
    @pulumi.getter(name="bgpCommunity")
    def bgp_community(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The BGP community attribute in format `<as-number>:<community-value>`.

        > **NOTE** The `as-number` segment is the Microsoft ASN, which is always `12076` for now.
        """
        return pulumi.get(self, "bgp_community")

    @_builtins.property
    @pulumi.getter(name="ddosProtectionPlan")
    def ddos_protection_plan(self) -> pulumi.Output[Optional['outputs.VirtualNetworkDdosProtectionPlan']]:
        """
        A `ddos_protection_plan` block as documented below.
        """
        return pulumi.get(self, "ddos_protection_plan")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IP addresses of DNS servers

        > **NOTE** Since `dns_servers` can be configured both inline and via the separate `network.VirtualNetworkDnsServers` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Virtual Network should exist. Changing this forces a new Virtual Network to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.VirtualNetworkEncryption']]:
        """
        A `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="flowTimeoutInMinutes")
    def flow_timeout_in_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The flow timeout in minutes for the Virtual Network, which is used to enable connection tracking for intra-VM flows. Possible values are between `4` and `30` minutes.
        """
        return pulumi.get(self, "flow_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> pulumi.Output[_builtins.str]:
        """
        The GUID of the Virtual Network.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter(name="ipAddressPools")
    def ip_address_pools(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualNetworkIpAddressPool']]]:
        """
        One or two `ip_address_pool` blocks as defined below. Only one association of each IP type(IPv4 or IPv6) is allowed.

        > **Note:** Exactly one of `address_space` or `ip_address_pool` must be specified.
        """
        return pulumi.get(self, "ip_address_pools")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location/region where the virtual network is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpointVnetPolicies")
    def private_endpoint_vnet_policies(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Private Endpoint VNet Policies for the Virtual Network. Possible values are `Disabled` and `Basic`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "private_endpoint_vnet_policies")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the virtual network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence['outputs.VirtualNetworkSubnet']]:
        """
        Can be specified multiple times to define multiple subnets. Each `subnet` block supports fields documented below.

        > **NOTE** Since `subnet` can be configured both inline and via the separate `network.Subnet` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

