# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ContactProfileLink',
    'ContactProfileLinkChannel',
    'ContactProfileLinkChannelEndPoint',
    'SpacecraftLink',
]

@pulumi.output_type
class ContactProfileLink(dict):
    def __init__(__self__, *,
                 channels: Sequence['outputs.ContactProfileLinkChannel'],
                 direction: _builtins.str,
                 name: _builtins.str,
                 polarization: _builtins.str):
        """
        :param Sequence['ContactProfileLinkChannelArgs'] channels: A list of contact profile link channels. A `channels` block as defined below.
        :param _builtins.str direction: Direction of the link. Possible values are `Uplink` and `Downlink`.
        :param _builtins.str name: Name of the link.
        :param _builtins.str polarization: Polarization of the link. Possible values are `LHCP`, `RHCP`, `linearVertical` and `linearHorizontal`.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "polarization", polarization)

    @_builtins.property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.ContactProfileLinkChannel']:
        """
        A list of contact profile link channels. A `channels` block as defined below.
        """
        return pulumi.get(self, "channels")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Direction of the link. Possible values are `Uplink` and `Downlink`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the link.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def polarization(self) -> _builtins.str:
        """
        Polarization of the link. Possible values are `LHCP`, `RHCP`, `linearVertical` and `linearHorizontal`.
        """
        return pulumi.get(self, "polarization")


@pulumi.output_type
class ContactProfileLinkChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthMhz":
            suggest = "bandwidth_mhz"
        elif key == "centerFrequencyMhz":
            suggest = "center_frequency_mhz"
        elif key == "endPoints":
            suggest = "end_points"
        elif key == "demodulationConfiguration":
            suggest = "demodulation_configuration"
        elif key == "modulationConfiguration":
            suggest = "modulation_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactProfileLinkChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactProfileLinkChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactProfileLinkChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_mhz: _builtins.float,
                 center_frequency_mhz: _builtins.float,
                 end_points: Sequence['outputs.ContactProfileLinkChannelEndPoint'],
                 name: _builtins.str,
                 demodulation_configuration: Optional[_builtins.str] = None,
                 modulation_configuration: Optional[_builtins.str] = None):
        """
        :param _builtins.float bandwidth_mhz: Bandwidth in MHz.
        :param _builtins.float center_frequency_mhz: Center frequency in MHz.
        :param Sequence['ContactProfileLinkChannelEndPointArgs'] end_points: Customer End point to store/retrieve data during a contact. An `end_point` block as defined below.
        :param _builtins.str name: Name of the channel.
        :param _builtins.str demodulation_configuration: Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        :param _builtins.str modulation_configuration: Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
        pulumi.set(__self__, "bandwidth_mhz", bandwidth_mhz)
        pulumi.set(__self__, "center_frequency_mhz", center_frequency_mhz)
        pulumi.set(__self__, "end_points", end_points)
        pulumi.set(__self__, "name", name)
        if demodulation_configuration is not None:
            pulumi.set(__self__, "demodulation_configuration", demodulation_configuration)
        if modulation_configuration is not None:
            pulumi.set(__self__, "modulation_configuration", modulation_configuration)

    @_builtins.property
    @pulumi.getter(name="bandwidthMhz")
    def bandwidth_mhz(self) -> _builtins.float:
        """
        Bandwidth in MHz.
        """
        return pulumi.get(self, "bandwidth_mhz")

    @_builtins.property
    @pulumi.getter(name="centerFrequencyMhz")
    def center_frequency_mhz(self) -> _builtins.float:
        """
        Center frequency in MHz.
        """
        return pulumi.get(self, "center_frequency_mhz")

    @_builtins.property
    @pulumi.getter(name="endPoints")
    def end_points(self) -> Sequence['outputs.ContactProfileLinkChannelEndPoint']:
        """
        Customer End point to store/retrieve data during a contact. An `end_point` block as defined below.
        """
        return pulumi.get(self, "end_points")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the channel.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="demodulationConfiguration")
    def demodulation_configuration(self) -> Optional[_builtins.str]:
        """
        Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
        """
        return pulumi.get(self, "demodulation_configuration")

    @_builtins.property
    @pulumi.getter(name="modulationConfiguration")
    def modulation_configuration(self) -> Optional[_builtins.str]:
        """
        Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
        """
        return pulumi.get(self, "modulation_configuration")


@pulumi.output_type
class ContactProfileLinkChannelEndPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPointName":
            suggest = "end_point_name"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactProfileLinkChannelEndPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactProfileLinkChannelEndPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactProfileLinkChannelEndPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_point_name: _builtins.str,
                 port: _builtins.str,
                 protocol: _builtins.str,
                 ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_point_name: Name of an end point.
        :param _builtins.str port: TCP port to listen on to receive data.
        :param _builtins.str protocol: Protocol of an end point. Possible values are `TCP` and `UDP`.
        :param _builtins.str ip_address: IP address of an end point.
        """
        pulumi.set(__self__, "end_point_name", end_point_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @_builtins.property
    @pulumi.getter(name="endPointName")
    def end_point_name(self) -> _builtins.str:
        """
        Name of an end point.
        """
        return pulumi.get(self, "end_point_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        TCP port to listen on to receive data.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol of an end point. Possible values are `TCP` and `UDP`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        IP address of an end point.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class SpacecraftLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthMhz":
            suggest = "bandwidth_mhz"
        elif key == "centerFrequencyMhz":
            suggest = "center_frequency_mhz"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacecraftLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacecraftLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacecraftLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_mhz: _builtins.float,
                 center_frequency_mhz: _builtins.float,
                 direction: _builtins.str,
                 name: _builtins.str,
                 polarization: _builtins.str):
        """
        :param _builtins.float bandwidth_mhz: Bandwidth in Mhz.
        :param _builtins.float center_frequency_mhz: Center frequency in Mhz.
               
               > **Note:** The value of `center_frequency_mhz +/- bandwidth_mhz / 2` should fall in one of these ranges: `Uplink/LHCP`: [2025, 2120]; `Uplink/Linear`: [399, 403],[435, 438],[449, 451]; `Uplink/RHCP`: [399, 403],[435, 438],[449, 451],[2025, 2120]; `Downlink/LHCP`: [2200, 2300], [7500, 8400]; `Downlink/Linear`: [399, 403], [435, 438], [449, 451]; Downlink/Linear`: [399, 403], [435, 438], [449, 451], [2200, 2300], [7500, 8400]
        :param _builtins.str direction: Direction if the communication. Possible values are `Uplink` and `Downlink`.
        :param _builtins.str name: Name of the link.
        :param _builtins.str polarization: Polarization. Possible values are `RHCP`, `LHCP`, `linearVertical` and `linearHorizontal`.
        """
        pulumi.set(__self__, "bandwidth_mhz", bandwidth_mhz)
        pulumi.set(__self__, "center_frequency_mhz", center_frequency_mhz)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "polarization", polarization)

    @_builtins.property
    @pulumi.getter(name="bandwidthMhz")
    def bandwidth_mhz(self) -> _builtins.float:
        """
        Bandwidth in Mhz.
        """
        return pulumi.get(self, "bandwidth_mhz")

    @_builtins.property
    @pulumi.getter(name="centerFrequencyMhz")
    def center_frequency_mhz(self) -> _builtins.float:
        """
        Center frequency in Mhz.

        > **Note:** The value of `center_frequency_mhz +/- bandwidth_mhz / 2` should fall in one of these ranges: `Uplink/LHCP`: [2025, 2120]; `Uplink/Linear`: [399, 403],[435, 438],[449, 451]; `Uplink/RHCP`: [399, 403],[435, 438],[449, 451],[2025, 2120]; `Downlink/LHCP`: [2200, 2300], [7500, 8400]; `Downlink/Linear`: [399, 403], [435, 438], [449, 451]; Downlink/Linear`: [399, 403], [435, 438], [449, 451], [2200, 2300], [7500, 8400]
        """
        return pulumi.get(self, "center_frequency_mhz")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        Direction if the communication. Possible values are `Uplink` and `Downlink`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the link.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def polarization(self) -> _builtins.str:
        """
        Polarization. Possible values are `RHCP`, `LHCP`, `linearVertical` and `linearHorizontal`.
        """
        return pulumi.get(self, "polarization")


