# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LocalRulestackCertificateArgs', 'LocalRulestackCertificate']

@pulumi.input_type
class LocalRulestackCertificateArgs:
    def __init__(__self__, *,
                 rulestack_id: pulumi.Input[_builtins.str],
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 self_signed: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LocalRulestackCertificate resource.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input[_builtins.str] description: The description for the Certificate.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Networks Rulestack Certificate.
        :param pulumi.Input[_builtins.bool] self_signed: Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
               
               > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        pulumi.set(__self__, "rulestack_id", rulestack_id)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if self_signed is not None:
            pulumi.set(__self__, "self_signed", self_signed)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comment for Audit purposes.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Certificate.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @key_vault_certificate_id.setter
    def key_vault_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Networks Rulestack Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="selfSigned")
    def self_signed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.

        > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        return pulumi.get(self, "self_signed")

    @self_signed.setter
    def self_signed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "self_signed", value)


@pulumi.input_type
class _LocalRulestackCertificateState:
    def __init__(__self__, *,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 self_signed: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LocalRulestackCertificate resources.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input[_builtins.str] description: The description for the Certificate.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Networks Rulestack Certificate.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.bool] self_signed: Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
               
               > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rulestack_id is not None:
            pulumi.set(__self__, "rulestack_id", rulestack_id)
        if self_signed is not None:
            pulumi.set(__self__, "self_signed", self_signed)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comment for Audit purposes.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Certificate.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @key_vault_certificate_id.setter
    def key_vault_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Networks Rulestack Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter(name="selfSigned")
    def self_signed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.

        > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        return pulumi.get(self, "self_signed")

    @self_signed.setter
    def self_signed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "self_signed", value)


@pulumi.type_token("azure:paloalto/localRulestackCertificate:LocalRulestackCertificate")
class LocalRulestackCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 self_signed: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Palo Alto Networks Rulestack Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_local_rulestack_certificate = azure.paloalto.LocalRulestackCertificate("example",
            name="example",
            rulestack_id=example_local_rulestack.id,
            self_signed=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw` - 2022-08-29

        ## Import

        Palo Alto Networks Rulestack Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/localRulestackCertificate:LocalRulestackCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/myLocalRulestack/certificates/myCertificate
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input[_builtins.str] description: The description for the Certificate.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Networks Rulestack Certificate.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.bool] self_signed: Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
               
               > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocalRulestackCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Palo Alto Networks Rulestack Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_local_rulestack_certificate = azure.paloalto.LocalRulestackCertificate("example",
            name="example",
            rulestack_id=example_local_rulestack.id,
            self_signed=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw` - 2022-08-29

        ## Import

        Palo Alto Networks Rulestack Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/localRulestackCertificate:LocalRulestackCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/myLocalRulestack/certificates/myCertificate
        ```

        :param str resource_name: The name of the resource.
        :param LocalRulestackCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocalRulestackCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 self_signed: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocalRulestackCertificateArgs.__new__(LocalRulestackCertificateArgs)

            __props__.__dict__["audit_comment"] = audit_comment
            __props__.__dict__["description"] = description
            __props__.__dict__["key_vault_certificate_id"] = key_vault_certificate_id
            __props__.__dict__["name"] = name
            if rulestack_id is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack_id'")
            __props__.__dict__["rulestack_id"] = rulestack_id
            __props__.__dict__["self_signed"] = self_signed
        super(LocalRulestackCertificate, __self__).__init__(
            'azure:paloalto/localRulestackCertificate:LocalRulestackCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
            self_signed: Optional[pulumi.Input[_builtins.bool]] = None) -> 'LocalRulestackCertificate':
        """
        Get an existing LocalRulestackCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input[_builtins.str] description: The description for the Certificate.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Networks Rulestack Certificate.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        :param pulumi.Input[_builtins.bool] self_signed: Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
               
               > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocalRulestackCertificateState.__new__(_LocalRulestackCertificateState)

        __props__.__dict__["audit_comment"] = audit_comment
        __props__.__dict__["description"] = description
        __props__.__dict__["key_vault_certificate_id"] = key_vault_certificate_id
        __props__.__dict__["name"] = name
        __props__.__dict__["rulestack_id"] = rulestack_id
        __props__.__dict__["self_signed"] = self_signed
        return LocalRulestackCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The comment for Audit purposes.
        """
        return pulumi.get(self, "audit_comment")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Certificate.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `versionles_id` of the Key Vault Certificate to use. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Palo Alto Networks Rulestack Certificate.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the TODO. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.
        """
        return pulumi.get(self, "rulestack_id")

    @_builtins.property
    @pulumi.getter(name="selfSigned")
    def self_signed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should a Self Signed Certificate be used. Defaults to `false`. Changing this forces a new Palo Alto Networks Rulestack Certificate to be created.

        > **Note:** One and only one of `self_signed` or `key_vault_certificate_id` must be specified.
        """
        return pulumi.get(self, "self_signed")

