# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EndpointCustomDnsConfigArgs',
    'EndpointCustomDnsConfigArgsDict',
    'EndpointIpConfigurationArgs',
    'EndpointIpConfigurationArgsDict',
    'EndpointNetworkInterfaceArgs',
    'EndpointNetworkInterfaceArgsDict',
    'EndpointPrivateDnsZoneConfigArgs',
    'EndpointPrivateDnsZoneConfigArgsDict',
    'EndpointPrivateDnsZoneConfigRecordSetArgs',
    'EndpointPrivateDnsZoneConfigRecordSetArgsDict',
    'EndpointPrivateDnsZoneGroupArgs',
    'EndpointPrivateDnsZoneGroupArgsDict',
    'EndpointPrivateServiceConnectionArgs',
    'EndpointPrivateServiceConnectionArgsDict',
]

MYPY = False

if not MYPY:
    class EndpointCustomDnsConfigArgsDict(TypedDict):
        fqdn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fully qualified domain name to the `private_dns_zone`.
        """
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of all IP Addresses that map to the `private_dns_zone` fqdn.
        """
elif False:
    EndpointCustomDnsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointCustomDnsConfigArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name to the `private_dns_zone`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_addresses: A list of all IP Addresses that map to the `private_dns_zone` fqdn.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name to the `private_dns_zone`.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of all IP Addresses that map to the `private_dns_zone` fqdn.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)


if not MYPY:
    class EndpointIpConfigurationArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the Name of the IP Configuration. Changing this forces a new resource to be created.
        """
        private_ip_address: pulumi.Input[_builtins.str]
        """
        Specifies the static IP address within the private endpoint's subnet to be used. Changing this forces a new resource to be created.
        """
        member_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the member name this IP address applies to. If it is not specified, it will use the value of `subresource_name`. Changing this forces a new resource to be created.

        > **Note:** `member_name` will be required and will not take the value of `subresource_name` in the next major version.
        """
        subresource_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the subresource this IP address applies to. `subresource_names` corresponds to `group_id`. Changing this forces a new resource to be created.
        """
elif False:
    EndpointIpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointIpConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 private_ip_address: pulumi.Input[_builtins.str],
                 member_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the IP Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_ip_address: Specifies the static IP address within the private endpoint's subnet to be used. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] member_name: Specifies the member name this IP address applies to. If it is not specified, it will use the value of `subresource_name`. Changing this forces a new resource to be created.
               
               > **Note:** `member_name` will be required and will not take the value of `subresource_name` in the next major version.
        :param pulumi.Input[_builtins.str] subresource_name: Specifies the subresource this IP address applies to. `subresource_names` corresponds to `group_id`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if member_name is not None:
            pulumi.set(__self__, "member_name", member_name)
        if subresource_name is not None:
            pulumi.set(__self__, "subresource_name", subresource_name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Name of the IP Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the static IP address within the private endpoint's subnet to be used. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="memberName")
    def member_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the member name this IP address applies to. If it is not specified, it will use the value of `subresource_name`. Changing this forces a new resource to be created.

        > **Note:** `member_name` will be required and will not take the value of `subresource_name` in the next major version.
        """
        return pulumi.get(self, "member_name")

    @member_name.setter
    def member_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "member_name", value)

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the subresource this IP address applies to. `subresource_names` corresponds to `group_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subresource_name")

    @subresource_name.setter
    def subresource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subresource_name", value)


if not MYPY:
    class EndpointNetworkInterfaceArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Private DNS Zone Config.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
elif False:
    EndpointNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointNetworkInterfaceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the Private DNS Zone Config.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Private DNS Zone Config.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class EndpointPrivateDnsZoneConfigArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Private DNS Zone Config.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        private_dns_zone_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        A list of IP Addresses
        """
        record_sets: NotRequired[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigRecordSetArgsDict']]]]
        """
        A `record_sets` block as defined below.
        """
elif False:
    EndpointPrivateDnsZoneConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointPrivateDnsZoneConfigArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 record_sets: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigRecordSetArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the Private DNS Zone Config.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_dns_zone_id: A list of IP Addresses
        :param pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigRecordSetArgs']]] record_sets: A `record_sets` block as defined below.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if record_sets is not None:
            pulumi.set(__self__, "record_sets", record_sets)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Private DNS Zone Config.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A list of IP Addresses
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="recordSets")
    def record_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigRecordSetArgs']]]]:
        """
        A `record_sets` block as defined below.
        """
        return pulumi.get(self, "record_sets")

    @record_sets.setter
    def record_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointPrivateDnsZoneConfigRecordSetArgs']]]]):
        pulumi.set(self, "record_sets", value)


if not MYPY:
    class EndpointPrivateDnsZoneConfigRecordSetArgsDict(TypedDict):
        fqdn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fully qualified domain name to the `private_dns_zone`.
        """
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of all IP Addresses that map to the `private_dns_zone` fqdn.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        ttl: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time to live for each connection to the `private_dns_zone`.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of DNS record.
        """
elif False:
    EndpointPrivateDnsZoneConfigRecordSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointPrivateDnsZoneConfigRecordSetArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name to the `private_dns_zone`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_addresses: A list of all IP Addresses that map to the `private_dns_zone` fqdn.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] ttl: The time to live for each connection to the `private_dns_zone`.
        :param pulumi.Input[_builtins.str] type: The type of DNS record.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name to the `private_dns_zone`.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of all IP Addresses that map to the `private_dns_zone` fqdn.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Name of the Private Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to live for each connection to the `private_dns_zone`.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of DNS record.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class EndpointPrivateDnsZoneGroupArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the Name of the Private DNS Zone Group.
        """
        private_dns_zone_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies the list of Private DNS Zones to include within the `private_dns_zone_group`.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Private DNS Zone Config.
        """
elif False:
    EndpointPrivateDnsZoneGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointPrivateDnsZoneGroupArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 private_dns_zone_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private DNS Zone Group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_dns_zone_ids: Specifies the list of Private DNS Zones to include within the `private_dns_zone_group`.
        :param pulumi.Input[_builtins.str] id: The ID of the Private DNS Zone Config.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_dns_zone_ids", private_dns_zone_ids)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Name of the Private DNS Zone Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneIds")
    def private_dns_zone_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of Private DNS Zones to include within the `private_dns_zone_group`.
        """
        return pulumi.get(self, "private_dns_zone_ids")

    @private_dns_zone_ids.setter
    def private_dns_zone_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "private_dns_zone_ids", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Private DNS Zone Config.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class EndpointPrivateServiceConnectionArgsDict(TypedDict):
        is_manual_connection: pulumi.Input[_builtins.bool]
        """
        Does the Private Endpoint require Manual Approval from the remote resource owner? Changing this forces a new resource to be created.

        > **Note:** If you are trying to connect the Private Endpoint to a remote resource without having the correct RBAC permissions on the remote resource set this value to `true`.
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the Name of the Private Service Connection. Changing this forces a new resource to be created.
        """
        private_connection_resource_alias: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Service Alias of the Private Link Enabled Remote Resource which this Private Endpoint should be connected to. One of `private_connection_resource_id` or `private_connection_resource_alias` must be specified. Changing this forces a new resource to be created.
        """
        private_connection_resource_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Private Link Enabled Remote Resource which this Private Endpoint should be connected to. One of `private_connection_resource_id` or `private_connection_resource_alias` must be specified. Changing this forces a new resource to be created. For a web app or function app slot, the parent web app should be used in this field instead of a reference to the slot itself.
        """
        private_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Required) The static IP address set by this configuration. It is recommended to use the private IP address exported in the `private_service_connection` block to obtain the address associated with the private endpoint.
        """
        request_message: NotRequired[pulumi.Input[_builtins.str]]
        """
        A message passed to the owner of the remote resource when the private endpoint attempts to establish the connection to the remote resource. The provider allows a maximum request message length of `140` characters, however the request message maximum length is dependent on the service the private endpoint is connected to. Only valid if `is_manual_connection` is set to `true`.

        > **Note:** When connected to an SQL resource the `request_message` maximum length is `128`.
        """
        subresource_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of subresource names which the Private Endpoint is able to connect to. `subresource_names` corresponds to `group_id`. Possible values are detailed in the product [documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-overview#private-link-resource) in the `Subresources` column. Changing this forces a new resource to be created. 

        > **Note:** Some resource types (such as Storage Account) only support 1 subresource per private endpoint.

        > **Note:** For most Private Links one or more `subresource_names` will need to be specified, please see the linked documentation for details.
        """
elif False:
    EndpointPrivateServiceConnectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointPrivateServiceConnectionArgs:
    def __init__(__self__, *,
                 is_manual_connection: pulumi.Input[_builtins.bool],
                 name: pulumi.Input[_builtins.str],
                 private_connection_resource_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 private_connection_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 request_message: Optional[pulumi.Input[_builtins.str]] = None,
                 subresource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.bool] is_manual_connection: Does the Private Endpoint require Manual Approval from the remote resource owner? Changing this forces a new resource to be created.
               
               > **Note:** If you are trying to connect the Private Endpoint to a remote resource without having the correct RBAC permissions on the remote resource set this value to `true`.
        :param pulumi.Input[_builtins.str] name: Specifies the Name of the Private Service Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_connection_resource_alias: The Service Alias of the Private Link Enabled Remote Resource which this Private Endpoint should be connected to. One of `private_connection_resource_id` or `private_connection_resource_alias` must be specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] private_connection_resource_id: The ID of the Private Link Enabled Remote Resource which this Private Endpoint should be connected to. One of `private_connection_resource_id` or `private_connection_resource_alias` must be specified. Changing this forces a new resource to be created. For a web app or function app slot, the parent web app should be used in this field instead of a reference to the slot itself.
        :param pulumi.Input[_builtins.str] private_ip_address: (Required) The static IP address set by this configuration. It is recommended to use the private IP address exported in the `private_service_connection` block to obtain the address associated with the private endpoint.
        :param pulumi.Input[_builtins.str] request_message: A message passed to the owner of the remote resource when the private endpoint attempts to establish the connection to the remote resource. The provider allows a maximum request message length of `140` characters, however the request message maximum length is dependent on the service the private endpoint is connected to. Only valid if `is_manual_connection` is set to `true`.
               
               > **Note:** When connected to an SQL resource the `request_message` maximum length is `128`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subresource_names: A list of subresource names which the Private Endpoint is able to connect to. `subresource_names` corresponds to `group_id`. Possible values are detailed in the product [documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-overview#private-link-resource) in the `Subresources` column. Changing this forces a new resource to be created. 
               
               > **Note:** Some resource types (such as Storage Account) only support 1 subresource per private endpoint.
               
               > **Note:** For most Private Links one or more `subresource_names` will need to be specified, please see the linked documentation for details.
        """
        pulumi.set(__self__, "is_manual_connection", is_manual_connection)
        pulumi.set(__self__, "name", name)
        if private_connection_resource_alias is not None:
            pulumi.set(__self__, "private_connection_resource_alias", private_connection_resource_alias)
        if private_connection_resource_id is not None:
            pulumi.set(__self__, "private_connection_resource_id", private_connection_resource_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if subresource_names is not None:
            pulumi.set(__self__, "subresource_names", subresource_names)

    @_builtins.property
    @pulumi.getter(name="isManualConnection")
    def is_manual_connection(self) -> pulumi.Input[_builtins.bool]:
        """
        Does the Private Endpoint require Manual Approval from the remote resource owner? Changing this forces a new resource to be created.

        > **Note:** If you are trying to connect the Private Endpoint to a remote resource without having the correct RBAC permissions on the remote resource set this value to `true`.
        """
        return pulumi.get(self, "is_manual_connection")

    @is_manual_connection.setter
    def is_manual_connection(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_manual_connection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Name of the Private Service Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectionResourceAlias")
    def private_connection_resource_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Service Alias of the Private Link Enabled Remote Resource which this Private Endpoint should be connected to. One of `private_connection_resource_id` or `private_connection_resource_alias` must be specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_connection_resource_alias")

    @private_connection_resource_alias.setter
    def private_connection_resource_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connection_resource_alias", value)

    @_builtins.property
    @pulumi.getter(name="privateConnectionResourceId")
    def private_connection_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Private Link Enabled Remote Resource which this Private Endpoint should be connected to. One of `private_connection_resource_id` or `private_connection_resource_alias` must be specified. Changing this forces a new resource to be created. For a web app or function app slot, the parent web app should be used in this field instead of a reference to the slot itself.
        """
        return pulumi.get(self, "private_connection_resource_id")

    @private_connection_resource_id.setter
    def private_connection_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_connection_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required) The static IP address set by this configuration. It is recommended to use the private IP address exported in the `private_service_connection` block to obtain the address associated with the private endpoint.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message passed to the owner of the remote resource when the private endpoint attempts to establish the connection to the remote resource. The provider allows a maximum request message length of `140` characters, however the request message maximum length is dependent on the service the private endpoint is connected to. Only valid if `is_manual_connection` is set to `true`.

        > **Note:** When connected to an SQL resource the `request_message` maximum length is `128`.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_message", value)

    @_builtins.property
    @pulumi.getter(name="subresourceNames")
    def subresource_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of subresource names which the Private Endpoint is able to connect to. `subresource_names` corresponds to `group_id`. Possible values are detailed in the product [documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-overview#private-link-resource) in the `Subresources` column. Changing this forces a new resource to be created. 

        > **Note:** Some resource types (such as Storage Account) only support 1 subresource per private endpoint.

        > **Note:** For most Private Links one or more `subresource_names` will need to be specified, please see the linked documentation for details.
        """
        return pulumi.get(self, "subresource_names")

    @subresource_names.setter
    def subresource_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subresource_names", value)


