# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'AccountManagedResourceArgs',
    'AccountManagedResourceArgsDict',
]

MYPY = False

if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Purview Account. Possible values are `UserAssigned` and `SystemAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Purview Account.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Purview Account. Possible values are `UserAssigned` and `SystemAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Purview Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Purview Account. Possible values are `UserAssigned` and `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Purview Account.

        > **Note:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AccountManagedResourceArgsDict(TypedDict):
        event_hub_namespace_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the managed event hub namespace.
        """
        resource_group_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the managed resource group.
        """
        storage_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the managed storage account.
        """
elif False:
    AccountManagedResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountManagedResourceArgs:
    def __init__(__self__, *,
                 event_hub_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] event_hub_namespace_id: The ID of the managed event hub namespace.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the managed resource group.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the managed storage account.
        """
        if event_hub_namespace_id is not None:
            pulumi.set(__self__, "event_hub_namespace_id", event_hub_namespace_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="eventHubNamespaceId")
    def event_hub_namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the managed event hub namespace.
        """
        return pulumi.get(self, "event_hub_namespace_id")

    @event_hub_namespace_id.setter
    def event_hub_namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_hub_namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the managed resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the managed storage account.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


