# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertRuleNrtArgs', 'AlertRuleNrt']

@pulumi.input_type
class AlertRuleNrtArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 event_grouping: pulumi.Input['AlertRuleNrtEventGroupingArgs'],
                 log_analytics_workspace_id: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 severity: pulumi.Input[_builtins.str],
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]]] = None,
                 incident: Optional[pulumi.Input['AlertRuleNrtIncidentArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AlertRuleNrt resource.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel NRT Alert Rule.
        :param pulumi.Input['AlertRuleNrtEventGroupingArgs'] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input['AlertRuleNrtIncidentArgs'] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "event_grouping", event_grouping)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "severity", severity)
        if alert_details_overrides is not None:
            pulumi.set(__self__, "alert_details_overrides", alert_details_overrides)
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if alert_rule_template_version is not None:
            pulumi.set(__self__, "alert_rule_template_version", alert_rule_template_version)
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_mappings is not None:
            pulumi.set(__self__, "entity_mappings", entity_mappings)
        if incident is not None:
            pulumi.set(__self__, "incident", incident)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sentinel_entity_mappings is not None:
            pulumi.set(__self__, "sentinel_entity_mappings", sentinel_entity_mappings)
        if suppression_duration is not None:
            pulumi.set(__self__, "suppression_duration", suppression_duration)
        if suppression_enabled is not None:
            pulumi.set(__self__, "suppression_enabled", suppression_enabled)
        if tactics is not None:
            pulumi.set(__self__, "tactics", tactics)
        if techniques is not None:
            pulumi.set(__self__, "techniques", techniques)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The friendly name of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="eventGrouping")
    def event_grouping(self) -> pulumi.Input['AlertRuleNrtEventGroupingArgs']:
        """
        A `event_grouping` block as defined below.
        """
        return pulumi.get(self, "event_grouping")

    @event_grouping.setter
    def event_grouping(self, value: pulumi.Input['AlertRuleNrtEventGroupingArgs']):
        pulumi.set(self, "event_grouping", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        The query of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Input[_builtins.str]:
        """
        The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="alertDetailsOverrides")
    def alert_details_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]]]:
        """
        An `alert_details_override` block as defined below.
        """
        return pulumi.get(self, "alert_details_overrides")

    @alert_details_overrides.setter
    def alert_details_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]]]):
        pulumi.set(self, "alert_details_overrides", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateVersion")
    def alert_rule_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_version")

    @alert_rule_template_version.setter
    def alert_rule_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_version", value)

    @_builtins.property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        """
        return pulumi.get(self, "custom_details")

    @custom_details.setter
    def custom_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_details", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityMappings")
    def entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]]]:
        """
        A list of `entity_mapping` blocks as defined below.
        """
        return pulumi.get(self, "entity_mappings")

    @entity_mappings.setter
    def entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]]]):
        pulumi.set(self, "entity_mappings", value)

    @_builtins.property
    @pulumi.getter
    def incident(self) -> Optional[pulumi.Input['AlertRuleNrtIncidentArgs']]:
        """
        A `incident` block as defined below.
        """
        return pulumi.get(self, "incident")

    @incident.setter
    def incident(self, value: Optional[pulumi.Input['AlertRuleNrtIncidentArgs']]):
        pulumi.set(self, "incident", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sentinelEntityMappings")
    def sentinel_entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]]]:
        """
        A list of `sentinel_entity_mapping` blocks as defined below.

        > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        """
        return pulumi.get(self, "sentinel_entity_mappings")

    @sentinel_entity_mappings.setter
    def sentinel_entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]]]):
        pulumi.set(self, "sentinel_entity_mappings", value)

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        """
        return pulumi.get(self, "suppression_duration")

    @suppression_duration.setter
    def suppression_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suppression_duration", value)

    @_builtins.property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        """
        return pulumi.get(self, "suppression_enabled")

    @suppression_enabled.setter
    def suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppression_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        """
        return pulumi.get(self, "tactics")

    @tactics.setter
    def tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tactics", value)

    @_builtins.property
    @pulumi.getter
    def techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @techniques.setter
    def techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "techniques", value)


@pulumi.input_type
class _AlertRuleNrtState:
    def __init__(__self__, *,
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]]] = None,
                 event_grouping: Optional[pulumi.Input['AlertRuleNrtEventGroupingArgs']] = None,
                 incident: Optional[pulumi.Input['AlertRuleNrtIncidentArgs']] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AlertRuleNrt resources.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input['AlertRuleNrtEventGroupingArgs'] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input['AlertRuleNrtIncidentArgs'] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel NRT Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        """
        if alert_details_overrides is not None:
            pulumi.set(__self__, "alert_details_overrides", alert_details_overrides)
        if alert_rule_template_guid is not None:
            pulumi.set(__self__, "alert_rule_template_guid", alert_rule_template_guid)
        if alert_rule_template_version is not None:
            pulumi.set(__self__, "alert_rule_template_version", alert_rule_template_version)
        if custom_details is not None:
            pulumi.set(__self__, "custom_details", custom_details)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_mappings is not None:
            pulumi.set(__self__, "entity_mappings", entity_mappings)
        if event_grouping is not None:
            pulumi.set(__self__, "event_grouping", event_grouping)
        if incident is not None:
            pulumi.set(__self__, "incident", incident)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if sentinel_entity_mappings is not None:
            pulumi.set(__self__, "sentinel_entity_mappings", sentinel_entity_mappings)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if suppression_duration is not None:
            pulumi.set(__self__, "suppression_duration", suppression_duration)
        if suppression_enabled is not None:
            pulumi.set(__self__, "suppression_enabled", suppression_enabled)
        if tactics is not None:
            pulumi.set(__self__, "tactics", tactics)
        if techniques is not None:
            pulumi.set(__self__, "techniques", techniques)

    @_builtins.property
    @pulumi.getter(name="alertDetailsOverrides")
    def alert_details_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]]]:
        """
        An `alert_details_override` block as defined below.
        """
        return pulumi.get(self, "alert_details_overrides")

    @alert_details_overrides.setter
    def alert_details_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtAlertDetailsOverrideArgs']]]]):
        pulumi.set(self, "alert_details_overrides", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @alert_rule_template_guid.setter
    def alert_rule_template_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_guid", value)

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateVersion")
    def alert_rule_template_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_version")

    @alert_rule_template_version.setter
    def alert_rule_template_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alert_rule_template_version", value)

    @_builtins.property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        """
        return pulumi.get(self, "custom_details")

    @custom_details.setter
    def custom_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_details", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The friendly name of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="entityMappings")
    def entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]]]:
        """
        A list of `entity_mapping` blocks as defined below.
        """
        return pulumi.get(self, "entity_mappings")

    @entity_mappings.setter
    def entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtEntityMappingArgs']]]]):
        pulumi.set(self, "entity_mappings", value)

    @_builtins.property
    @pulumi.getter(name="eventGrouping")
    def event_grouping(self) -> Optional[pulumi.Input['AlertRuleNrtEventGroupingArgs']]:
        """
        A `event_grouping` block as defined below.
        """
        return pulumi.get(self, "event_grouping")

    @event_grouping.setter
    def event_grouping(self, value: Optional[pulumi.Input['AlertRuleNrtEventGroupingArgs']]):
        pulumi.set(self, "event_grouping", value)

    @_builtins.property
    @pulumi.getter
    def incident(self) -> Optional[pulumi.Input['AlertRuleNrtIncidentArgs']]:
        """
        A `incident` block as defined below.
        """
        return pulumi.get(self, "incident")

    @incident.setter
    def incident(self, value: Optional[pulumi.Input['AlertRuleNrtIncidentArgs']]):
        pulumi.set(self, "incident", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The query of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="sentinelEntityMappings")
    def sentinel_entity_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]]]:
        """
        A list of `sentinel_entity_mapping` blocks as defined below.

        > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        """
        return pulumi.get(self, "sentinel_entity_mappings")

    @sentinel_entity_mappings.setter
    def sentinel_entity_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleNrtSentinelEntityMappingArgs']]]]):
        pulumi.set(self, "sentinel_entity_mappings", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        """
        return pulumi.get(self, "suppression_duration")

    @suppression_duration.setter
    def suppression_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suppression_duration", value)

    @_builtins.property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        """
        return pulumi.get(self, "suppression_enabled")

    @suppression_enabled.setter
    def suppression_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suppression_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tactics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        """
        return pulumi.get(self, "tactics")

    @tactics.setter
    def tactics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tactics", value)

    @_builtins.property
    @pulumi.getter
    def techniques(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

    @techniques.setter
    def techniques(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "techniques", value)


@pulumi.type_token("azure:sentinel/alertRuleNrt:AlertRuleNrt")
class AlertRuleNrt(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtAlertDetailsOverrideArgs', 'AlertRuleNrtAlertDetailsOverrideArgsDict']]]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtEntityMappingArgs', 'AlertRuleNrtEntityMappingArgsDict']]]]] = None,
                 event_grouping: Optional[pulumi.Input[Union['AlertRuleNrtEventGroupingArgs', 'AlertRuleNrtEventGroupingArgsDict']]] = None,
                 incident: Optional[pulumi.Input[Union['AlertRuleNrtIncidentArgs', 'AlertRuleNrtIncidentArgsDict']]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtSentinelEntityMappingArgs', 'AlertRuleNrtSentinelEntityMappingArgsDict']]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Sentinel NRT Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="pergb2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_nrt = azure.sentinel.AlertRuleNrt("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example",
            severity="High",
            query=\"\"\"AzureActivity |
          where OperationName == "Create or Update Virtual Machine" or OperationName =="Create Deployment" |
          where ActivityStatus == "Succeeded" |
          make-series dcount(ResourceId) default=0 on EventSubmissionTimestamp in range(ago(7d), now(), 1d) by Caller
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights` - 2023-12-01-preview

        ## Import

        Sentinel NRT Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleNrt:AlertRuleNrt example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtAlertDetailsOverrideArgs', 'AlertRuleNrtAlertDetailsOverrideArgsDict']]]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtEntityMappingArgs', 'AlertRuleNrtEntityMappingArgsDict']]]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input[Union['AlertRuleNrtEventGroupingArgs', 'AlertRuleNrtEventGroupingArgsDict']] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input[Union['AlertRuleNrtIncidentArgs', 'AlertRuleNrtIncidentArgsDict']] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel NRT Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtSentinelEntityMappingArgs', 'AlertRuleNrtSentinelEntityMappingArgsDict']]]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertRuleNrtArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Sentinel NRT Alert Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="pergb2018")
        example_log_analytics_workspace_onboarding = azure.sentinel.LogAnalyticsWorkspaceOnboarding("example", workspace_id=example_analytics_workspace.id)
        example_alert_rule_nrt = azure.sentinel.AlertRuleNrt("example",
            name="example",
            log_analytics_workspace_id=example_log_analytics_workspace_onboarding.workspace_id,
            display_name="example",
            severity="High",
            query=\"\"\"AzureActivity |
          where OperationName == "Create or Update Virtual Machine" or OperationName =="Create Deployment" |
          where ActivityStatus == "Succeeded" |
          make-series dcount(ResourceId) default=0 on EventSubmissionTimestamp in range(ago(7d), now(), 1d) by Caller
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights` - 2023-12-01-preview

        ## Import

        Sentinel NRT Alert Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:sentinel/alertRuleNrt:AlertRuleNrt example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.OperationalInsights/workspaces/workspace1/providers/Microsoft.SecurityInsights/alertRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param AlertRuleNrtArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertRuleNrtArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtAlertDetailsOverrideArgs', 'AlertRuleNrtAlertDetailsOverrideArgsDict']]]]] = None,
                 alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtEntityMappingArgs', 'AlertRuleNrtEntityMappingArgsDict']]]]] = None,
                 event_grouping: Optional[pulumi.Input[Union['AlertRuleNrtEventGroupingArgs', 'AlertRuleNrtEventGroupingArgsDict']]] = None,
                 incident: Optional[pulumi.Input[Union['AlertRuleNrtIncidentArgs', 'AlertRuleNrtIncidentArgsDict']]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtSentinelEntityMappingArgs', 'AlertRuleNrtSentinelEntityMappingArgsDict']]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertRuleNrtArgs.__new__(AlertRuleNrtArgs)

            __props__.__dict__["alert_details_overrides"] = alert_details_overrides
            __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
            __props__.__dict__["alert_rule_template_version"] = alert_rule_template_version
            __props__.__dict__["custom_details"] = custom_details
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["entity_mappings"] = entity_mappings
            if event_grouping is None and not opts.urn:
                raise TypeError("Missing required property 'event_grouping'")
            __props__.__dict__["event_grouping"] = event_grouping
            __props__.__dict__["incident"] = incident
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["sentinel_entity_mappings"] = sentinel_entity_mappings
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["suppression_duration"] = suppression_duration
            __props__.__dict__["suppression_enabled"] = suppression_enabled
            __props__.__dict__["tactics"] = tactics
            __props__.__dict__["techniques"] = techniques
        super(AlertRuleNrt, __self__).__init__(
            'azure:sentinel/alertRuleNrt:AlertRuleNrt',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_details_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtAlertDetailsOverrideArgs', 'AlertRuleNrtAlertDetailsOverrideArgsDict']]]]] = None,
            alert_rule_template_guid: Optional[pulumi.Input[_builtins.str]] = None,
            alert_rule_template_version: Optional[pulumi.Input[_builtins.str]] = None,
            custom_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtEntityMappingArgs', 'AlertRuleNrtEntityMappingArgsDict']]]]] = None,
            event_grouping: Optional[pulumi.Input[Union['AlertRuleNrtEventGroupingArgs', 'AlertRuleNrtEventGroupingArgsDict']]] = None,
            incident: Optional[pulumi.Input[Union['AlertRuleNrtIncidentArgs', 'AlertRuleNrtIncidentArgsDict']]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            sentinel_entity_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtSentinelEntityMappingArgs', 'AlertRuleNrtSentinelEntityMappingArgsDict']]]]] = None,
            severity: Optional[pulumi.Input[_builtins.str]] = None,
            suppression_duration: Optional[pulumi.Input[_builtins.str]] = None,
            suppression_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tactics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            techniques: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AlertRuleNrt':
        """
        Get an existing AlertRuleNrt resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtAlertDetailsOverrideArgs', 'AlertRuleNrtAlertDetailsOverrideArgsDict']]]] alert_details_overrides: An `alert_details_override` block as defined below.
        :param pulumi.Input[_builtins.str] alert_rule_template_guid: The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] alert_rule_template_version: The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] custom_details: A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        :param pulumi.Input[_builtins.str] description: The description of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.str] display_name: The friendly name of this Sentinel NRT Alert Rule.
        :param pulumi.Input[_builtins.bool] enabled: Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtEntityMappingArgs', 'AlertRuleNrtEntityMappingArgsDict']]]] entity_mappings: A list of `entity_mapping` blocks as defined below.
        :param pulumi.Input[Union['AlertRuleNrtEventGroupingArgs', 'AlertRuleNrtEventGroupingArgsDict']] event_grouping: A `event_grouping` block as defined below.
        :param pulumi.Input[Union['AlertRuleNrtIncidentArgs', 'AlertRuleNrtIncidentArgsDict']] incident: A `incident` block as defined below.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        :param pulumi.Input[_builtins.str] query: The query of this Sentinel NRT Alert Rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertRuleNrtSentinelEntityMappingArgs', 'AlertRuleNrtSentinelEntityMappingArgsDict']]]] sentinel_entity_mappings: A list of `sentinel_entity_mapping` blocks as defined below.
               
               > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        :param pulumi.Input[_builtins.str] severity: The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        :param pulumi.Input[_builtins.str] suppression_duration: If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        :param pulumi.Input[_builtins.bool] suppression_enabled: Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tactics: A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] techniques: A list of techniques of attacks by which to classify the rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertRuleNrtState.__new__(_AlertRuleNrtState)

        __props__.__dict__["alert_details_overrides"] = alert_details_overrides
        __props__.__dict__["alert_rule_template_guid"] = alert_rule_template_guid
        __props__.__dict__["alert_rule_template_version"] = alert_rule_template_version
        __props__.__dict__["custom_details"] = custom_details
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_mappings"] = entity_mappings
        __props__.__dict__["event_grouping"] = event_grouping
        __props__.__dict__["incident"] = incident
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["sentinel_entity_mappings"] = sentinel_entity_mappings
        __props__.__dict__["severity"] = severity
        __props__.__dict__["suppression_duration"] = suppression_duration
        __props__.__dict__["suppression_enabled"] = suppression_enabled
        __props__.__dict__["tactics"] = tactics
        __props__.__dict__["techniques"] = techniques
        return AlertRuleNrt(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertDetailsOverrides")
    def alert_details_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRuleNrtAlertDetailsOverride']]]:
        """
        An `alert_details_override` block as defined below.
        """
        return pulumi.get(self, "alert_details_overrides")

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateGuid")
    def alert_rule_template_guid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The GUID of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_guid")

    @_builtins.property
    @pulumi.getter(name="alertRuleTemplateVersion")
    def alert_rule_template_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of the alert rule template which is used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "alert_rule_template_version")

    @_builtins.property
    @pulumi.getter(name="customDetails")
    def custom_details(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of string key-value pairs of columns to be attached to this Sentinel NRT Alert Rule. The key will appear as the field name in alerts and the value is the event parameter you wish to surface in the alerts.
        """
        return pulumi.get(self, "custom_details")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The friendly name of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Sentinel NRT Alert Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="entityMappings")
    def entity_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRuleNrtEntityMapping']]]:
        """
        A list of `entity_mapping` blocks as defined below.
        """
        return pulumi.get(self, "entity_mappings")

    @_builtins.property
    @pulumi.getter(name="eventGrouping")
    def event_grouping(self) -> pulumi.Output['outputs.AlertRuleNrtEventGrouping']:
        """
        A `event_grouping` block as defined below.
        """
        return pulumi.get(self, "event_grouping")

    @_builtins.property
    @pulumi.getter
    def incident(self) -> pulumi.Output['outputs.AlertRuleNrtIncident']:
        """
        A `incident` block as defined below.
        """
        return pulumi.get(self, "incident")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Log Analytics Workspace this Sentinel NRT Alert Rule belongs to. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Sentinel NRT Alert Rule. Changing this forces a new Sentinel NRT Alert Rule to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The query of this Sentinel NRT Alert Rule.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="sentinelEntityMappings")
    def sentinel_entity_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.AlertRuleNrtSentinelEntityMapping']]]:
        """
        A list of `sentinel_entity_mapping` blocks as defined below.

        > **Note:** `entity_mapping` and `sentinel_entity_mapping` together can't exceed 5.
        """
        return pulumi.get(self, "sentinel_entity_mappings")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[_builtins.str]:
        """
        The alert severity of this Sentinel NRT Alert Rule. Possible values are `High`, `Medium`, `Low` and `Informational`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If `suppression_enabled` is `true`, this is ISO 8601 timespan duration, which specifies the amount of time the query should stop running after alert is generated. Defaults to `PT5H`.
        """
        return pulumi.get(self, "suppression_duration")

    @_builtins.property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Sentinel NRT Alert Rulea stop running query after alert is generated? Defaults to `false`.
        """
        return pulumi.get(self, "suppression_enabled")

    @_builtins.property
    @pulumi.getter
    def tactics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of categories of attacks by which to classify the rule. Possible values are `Collection`, `CommandAndControl`, `CredentialAccess`, `DefenseEvasion`, `Discovery`, `Execution`, `Exfiltration`, `Impact`, `ImpairProcessControl`, `InhibitResponseFunction`, `InitialAccess`, `LateralMovement`, `Persistence`, `PreAttack`, `PrivilegeEscalation`, `Reconnaissance` and `ResourceDevelopment`.
        """
        return pulumi.get(self, "tactics")

    @_builtins.property
    @pulumi.getter
    def techniques(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of techniques of attacks by which to classify the rule.
        """
        return pulumi.get(self, "techniques")

