# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'HciClusterIdentityArgs',
    'HciClusterIdentityArgsDict',
    'HciDeploymentSettingScaleUnitArgs',
    'HciDeploymentSettingScaleUnitArgsDict',
    'HciDeploymentSettingScaleUnitClusterArgs',
    'HciDeploymentSettingScaleUnitClusterArgsDict',
    'HciDeploymentSettingScaleUnitHostNetworkArgs',
    'HciDeploymentSettingScaleUnitHostNetworkArgsDict',
    'HciDeploymentSettingScaleUnitHostNetworkIntentArgs',
    'HciDeploymentSettingScaleUnitHostNetworkIntentArgsDict',
    'HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs',
    'HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgsDict',
    'HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs',
    'HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgsDict',
    'HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs',
    'HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgsDict',
    'HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs',
    'HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgsDict',
    'HciDeploymentSettingScaleUnitInfrastructureNetworkArgs',
    'HciDeploymentSettingScaleUnitInfrastructureNetworkArgsDict',
    'HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs',
    'HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgsDict',
    'HciDeploymentSettingScaleUnitOptionalServiceArgs',
    'HciDeploymentSettingScaleUnitOptionalServiceArgsDict',
    'HciDeploymentSettingScaleUnitPhysicalNodeArgs',
    'HciDeploymentSettingScaleUnitPhysicalNodeArgsDict',
    'HciDeploymentSettingScaleUnitStorageArgs',
    'HciDeploymentSettingScaleUnitStorageArgsDict',
    'HciLogicalNetworkSubnetArgs',
    'HciLogicalNetworkSubnetArgsDict',
    'HciLogicalNetworkSubnetIpPoolArgs',
    'HciLogicalNetworkSubnetIpPoolArgsDict',
    'HciLogicalNetworkSubnetRouteArgs',
    'HciLogicalNetworkSubnetRouteArgsDict',
    'HciMarketplaceGalleryImageIdentifierArgs',
    'HciMarketplaceGalleryImageIdentifierArgsDict',
    'HciNetworkInterfaceIpConfigurationArgs',
    'HciNetworkInterfaceIpConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class HciClusterIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on the Azure Stack HCI Cluster. Possible value is `SystemAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.

        > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
elif False:
    HciClusterIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciClusterIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on the Azure Stack HCI Cluster. Possible value is `SystemAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
               
               > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on the Azure Stack HCI Cluster. Possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.

        > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitArgsDict(TypedDict):
        active_directory_organizational_unit_path: pulumi.Input[_builtins.str]
        """
        Specify the full name of the Active Directory Organizational Unit container object prepared for the deployment, including the domain components. For example:`OU=HCI01,DC=contoso,DC=com`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        cluster: pulumi.Input['HciDeploymentSettingScaleUnitClusterArgsDict']
        """
        A `cluster` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        domain_fqdn: pulumi.Input[_builtins.str]
        """
        Specifies the FQDN for deploying cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        host_network: pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkArgsDict']
        """
        A `host_network` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        infrastructure_networks: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkArgsDict']]]
        """
        One or more `infrastructure_network` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        name_prefix: pulumi.Input[_builtins.str]
        """
        Specifies the name prefix to deploy cluster. It must be 1-8 characters long and contain only letters, numbers and hyphens Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        optional_service: pulumi.Input['HciDeploymentSettingScaleUnitOptionalServiceArgsDict']
        """
        A `optional_service` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        physical_nodes: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitPhysicalNodeArgsDict']]]
        """
        One or more `physical_node` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        secrets_location: pulumi.Input[_builtins.str]
        """
        The URI to the Key Vault or secret store. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        storage: pulumi.Input['HciDeploymentSettingScaleUnitStorageArgsDict']
        """
        A `storage` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        bitlocker_boot_volume_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable BitLocker for boot volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        bitlocker_data_volume_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable BitLocker for data volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        credential_guard_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable credential guard. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        drift_control_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable drift control. Possible values are `true` and `false`. When set to `true`, the security baseline is re-applied regularly. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        drtm_protection_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable DRTM protection. Possible values are `true` and `false`. When set to `true`, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        episodic_data_upload_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to collect log data to facilitate quicker issue resolution. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        eu_location_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to store data sent to Microsoft in EU. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to `false` results in all data sent to Microsoft to be stored outside of the EU. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        hvci_protection_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable HVCI protection. Possible values are `true` and `false`. When set to `true`, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        side_channel_mitigation_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable side channel mitigation. Possible values are `true` and `false`. When set to `true`, all side channel mitigations are enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        smb_cluster_encryption_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable SMB cluster encryption. Possible values are `true` and `false`. When set to `true`, cluster east-west traffic is encrypted. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        smb_signing_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable SMB signing. Possible values are `true` and `false`. When set to `true`, the SMB default instance requires sign in for the client and server services. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        streaming_data_client_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the telemetry data will be sent to Microsoft. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        wdac_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable WDAC. Possible values are `true` and `false`. When set to `true`, applications and the code that you can run on your Azure Stack HCI cluster are limited. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitArgs:
    def __init__(__self__, *,
                 active_directory_organizational_unit_path: pulumi.Input[_builtins.str],
                 cluster: pulumi.Input['HciDeploymentSettingScaleUnitClusterArgs'],
                 domain_fqdn: pulumi.Input[_builtins.str],
                 host_network: pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkArgs'],
                 infrastructure_networks: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkArgs']]],
                 name_prefix: pulumi.Input[_builtins.str],
                 optional_service: pulumi.Input['HciDeploymentSettingScaleUnitOptionalServiceArgs'],
                 physical_nodes: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitPhysicalNodeArgs']]],
                 secrets_location: pulumi.Input[_builtins.str],
                 storage: pulumi.Input['HciDeploymentSettingScaleUnitStorageArgs'],
                 bitlocker_boot_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 bitlocker_data_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 credential_guard_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 drift_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 drtm_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 episodic_data_upload_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 eu_location_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hvci_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 side_channel_mitigation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_cluster_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_signing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 streaming_data_client_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 wdac_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] active_directory_organizational_unit_path: Specify the full name of the Active Directory Organizational Unit container object prepared for the deployment, including the domain components. For example:`OU=HCI01,DC=contoso,DC=com`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitClusterArgs'] cluster: A `cluster` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] domain_fqdn: Specifies the FQDN for deploying cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkArgs'] host_network: A `host_network` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkArgs']]] infrastructure_networks: One or more `infrastructure_network` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] name_prefix: Specifies the name prefix to deploy cluster. It must be 1-8 characters long and contain only letters, numbers and hyphens Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitOptionalServiceArgs'] optional_service: A `optional_service` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitPhysicalNodeArgs']]] physical_nodes: One or more `physical_node` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] secrets_location: The URI to the Key Vault or secret store. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitStorageArgs'] storage: A `storage` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] bitlocker_boot_volume_enabled: Whether to enable BitLocker for boot volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] bitlocker_data_volume_enabled: Whether to enable BitLocker for data volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] credential_guard_enabled: Whether to enable credential guard. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] drift_control_enabled: Whether to enable drift control. Possible values are `true` and `false`. When set to `true`, the security baseline is re-applied regularly. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] drtm_protection_enabled: Whether to enable DRTM protection. Possible values are `true` and `false`. When set to `true`, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] episodic_data_upload_enabled: Whether to collect log data to facilitate quicker issue resolution. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] eu_location_enabled: Whether to store data sent to Microsoft in EU. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to `false` results in all data sent to Microsoft to be stored outside of the EU. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] hvci_protection_enabled: Whether to enable HVCI protection. Possible values are `true` and `false`. When set to `true`, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] side_channel_mitigation_enabled: Whether to enable side channel mitigation. Possible values are `true` and `false`. When set to `true`, all side channel mitigations are enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] smb_cluster_encryption_enabled: Whether to enable SMB cluster encryption. Possible values are `true` and `false`. When set to `true`, cluster east-west traffic is encrypted. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] smb_signing_enabled: Whether to enable SMB signing. Possible values are `true` and `false`. When set to `true`, the SMB default instance requires sign in for the client and server services. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] streaming_data_client_enabled: Whether the telemetry data will be sent to Microsoft. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] wdac_enabled: Whether to enable WDAC. Possible values are `true` and `false`. When set to `true`, applications and the code that you can run on your Azure Stack HCI cluster are limited. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "active_directory_organizational_unit_path", active_directory_organizational_unit_path)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        pulumi.set(__self__, "host_network", host_network)
        pulumi.set(__self__, "infrastructure_networks", infrastructure_networks)
        pulumi.set(__self__, "name_prefix", name_prefix)
        pulumi.set(__self__, "optional_service", optional_service)
        pulumi.set(__self__, "physical_nodes", physical_nodes)
        pulumi.set(__self__, "secrets_location", secrets_location)
        pulumi.set(__self__, "storage", storage)
        if bitlocker_boot_volume_enabled is not None:
            pulumi.set(__self__, "bitlocker_boot_volume_enabled", bitlocker_boot_volume_enabled)
        if bitlocker_data_volume_enabled is not None:
            pulumi.set(__self__, "bitlocker_data_volume_enabled", bitlocker_data_volume_enabled)
        if credential_guard_enabled is not None:
            pulumi.set(__self__, "credential_guard_enabled", credential_guard_enabled)
        if drift_control_enabled is not None:
            pulumi.set(__self__, "drift_control_enabled", drift_control_enabled)
        if drtm_protection_enabled is not None:
            pulumi.set(__self__, "drtm_protection_enabled", drtm_protection_enabled)
        if episodic_data_upload_enabled is not None:
            pulumi.set(__self__, "episodic_data_upload_enabled", episodic_data_upload_enabled)
        if eu_location_enabled is not None:
            pulumi.set(__self__, "eu_location_enabled", eu_location_enabled)
        if hvci_protection_enabled is not None:
            pulumi.set(__self__, "hvci_protection_enabled", hvci_protection_enabled)
        if side_channel_mitigation_enabled is not None:
            pulumi.set(__self__, "side_channel_mitigation_enabled", side_channel_mitigation_enabled)
        if smb_cluster_encryption_enabled is not None:
            pulumi.set(__self__, "smb_cluster_encryption_enabled", smb_cluster_encryption_enabled)
        if smb_signing_enabled is not None:
            pulumi.set(__self__, "smb_signing_enabled", smb_signing_enabled)
        if streaming_data_client_enabled is not None:
            pulumi.set(__self__, "streaming_data_client_enabled", streaming_data_client_enabled)
        if wdac_enabled is not None:
            pulumi.set(__self__, "wdac_enabled", wdac_enabled)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryOrganizationalUnitPath")
    def active_directory_organizational_unit_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the full name of the Active Directory Organizational Unit container object prepared for the deployment, including the domain components. For example:`OU=HCI01,DC=contoso,DC=com`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "active_directory_organizational_unit_path")

    @active_directory_organizational_unit_path.setter
    def active_directory_organizational_unit_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "active_directory_organizational_unit_path", value)

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> pulumi.Input['HciDeploymentSettingScaleUnitClusterArgs']:
        """
        A `cluster` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input['HciDeploymentSettingScaleUnitClusterArgs']):
        pulumi.set(self, "cluster", value)

    @_builtins.property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the FQDN for deploying cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "domain_fqdn")

    @domain_fqdn.setter
    def domain_fqdn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_fqdn", value)

    @_builtins.property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkArgs']:
        """
        A `host_network` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "host_network")

    @host_network.setter
    def host_network(self, value: pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkArgs']):
        pulumi.set(self, "host_network", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureNetworks")
    def infrastructure_networks(self) -> pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkArgs']]]:
        """
        One or more `infrastructure_network` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "infrastructure_networks")

    @infrastructure_networks.setter
    def infrastructure_networks(self, value: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkArgs']]]):
        pulumi.set(self, "infrastructure_networks", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name prefix to deploy cluster. It must be 1-8 characters long and contain only letters, numbers and hyphens Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="optionalService")
    def optional_service(self) -> pulumi.Input['HciDeploymentSettingScaleUnitOptionalServiceArgs']:
        """
        A `optional_service` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "optional_service")

    @optional_service.setter
    def optional_service(self, value: pulumi.Input['HciDeploymentSettingScaleUnitOptionalServiceArgs']):
        pulumi.set(self, "optional_service", value)

    @_builtins.property
    @pulumi.getter(name="physicalNodes")
    def physical_nodes(self) -> pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitPhysicalNodeArgs']]]:
        """
        One or more `physical_node` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "physical_nodes")

    @physical_nodes.setter
    def physical_nodes(self, value: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitPhysicalNodeArgs']]]):
        pulumi.set(self, "physical_nodes", value)

    @_builtins.property
    @pulumi.getter(name="secretsLocation")
    def secrets_location(self) -> pulumi.Input[_builtins.str]:
        """
        The URI to the Key Vault or secret store. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "secrets_location")

    @secrets_location.setter
    def secrets_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secrets_location", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Input['HciDeploymentSettingScaleUnitStorageArgs']:
        """
        A `storage` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: pulumi.Input['HciDeploymentSettingScaleUnitStorageArgs']):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter(name="bitlockerBootVolumeEnabled")
    def bitlocker_boot_volume_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable BitLocker for boot volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "bitlocker_boot_volume_enabled")

    @bitlocker_boot_volume_enabled.setter
    def bitlocker_boot_volume_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bitlocker_boot_volume_enabled", value)

    @_builtins.property
    @pulumi.getter(name="bitlockerDataVolumeEnabled")
    def bitlocker_data_volume_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable BitLocker for data volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "bitlocker_data_volume_enabled")

    @bitlocker_data_volume_enabled.setter
    def bitlocker_data_volume_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bitlocker_data_volume_enabled", value)

    @_builtins.property
    @pulumi.getter(name="credentialGuardEnabled")
    def credential_guard_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable credential guard. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "credential_guard_enabled")

    @credential_guard_enabled.setter
    def credential_guard_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "credential_guard_enabled", value)

    @_builtins.property
    @pulumi.getter(name="driftControlEnabled")
    def drift_control_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable drift control. Possible values are `true` and `false`. When set to `true`, the security baseline is re-applied regularly. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "drift_control_enabled")

    @drift_control_enabled.setter
    def drift_control_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drift_control_enabled", value)

    @_builtins.property
    @pulumi.getter(name="drtmProtectionEnabled")
    def drtm_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable DRTM protection. Possible values are `true` and `false`. When set to `true`, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "drtm_protection_enabled")

    @drtm_protection_enabled.setter
    def drtm_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drtm_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="episodicDataUploadEnabled")
    def episodic_data_upload_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to collect log data to facilitate quicker issue resolution. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "episodic_data_upload_enabled")

    @episodic_data_upload_enabled.setter
    def episodic_data_upload_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "episodic_data_upload_enabled", value)

    @_builtins.property
    @pulumi.getter(name="euLocationEnabled")
    def eu_location_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to store data sent to Microsoft in EU. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to `false` results in all data sent to Microsoft to be stored outside of the EU. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "eu_location_enabled")

    @eu_location_enabled.setter
    def eu_location_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "eu_location_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hvciProtectionEnabled")
    def hvci_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable HVCI protection. Possible values are `true` and `false`. When set to `true`, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "hvci_protection_enabled")

    @hvci_protection_enabled.setter
    def hvci_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hvci_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sideChannelMitigationEnabled")
    def side_channel_mitigation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable side channel mitigation. Possible values are `true` and `false`. When set to `true`, all side channel mitigations are enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "side_channel_mitigation_enabled")

    @side_channel_mitigation_enabled.setter
    def side_channel_mitigation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "side_channel_mitigation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbClusterEncryptionEnabled")
    def smb_cluster_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable SMB cluster encryption. Possible values are `true` and `false`. When set to `true`, cluster east-west traffic is encrypted. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "smb_cluster_encryption_enabled")

    @smb_cluster_encryption_enabled.setter
    def smb_cluster_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_cluster_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbSigningEnabled")
    def smb_signing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable SMB signing. Possible values are `true` and `false`. When set to `true`, the SMB default instance requires sign in for the client and server services. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "smb_signing_enabled")

    @smb_signing_enabled.setter
    def smb_signing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_signing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="streamingDataClientEnabled")
    def streaming_data_client_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the telemetry data will be sent to Microsoft. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "streaming_data_client_enabled")

    @streaming_data_client_enabled.setter
    def streaming_data_client_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "streaming_data_client_enabled", value)

    @_builtins.property
    @pulumi.getter(name="wdacEnabled")
    def wdac_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable WDAC. Possible values are `true` and `false`. When set to `true`, applications and the code that you can run on your Azure Stack HCI cluster are limited. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "wdac_enabled")

    @wdac_enabled.setter
    def wdac_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wdac_enabled", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitClusterArgsDict(TypedDict):
        azure_service_endpoint: pulumi.Input[_builtins.str]
        """
        Specifies the Azure blob service endpoint, for example, `core.windows.net`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        cloud_account_name: pulumi.Input[_builtins.str]
        """
        Specifies the Azure Storage account name of the cloud witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the cluster. It must be 3-15 characters long and contain only letters, numbers and hyphens. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        witness_path: pulumi.Input[_builtins.str]
        """
        Specifies the fileshare path of the local witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        witness_type: pulumi.Input[_builtins.str]
        """
        Specifies the type of the witness. Possible values are `Cloud`, `FileShare`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitClusterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitClusterArgs:
    def __init__(__self__, *,
                 azure_service_endpoint: pulumi.Input[_builtins.str],
                 cloud_account_name: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 witness_path: pulumi.Input[_builtins.str],
                 witness_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] azure_service_endpoint: Specifies the Azure blob service endpoint, for example, `core.windows.net`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] cloud_account_name: Specifies the Azure Storage account name of the cloud witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the cluster. It must be 3-15 characters long and contain only letters, numbers and hyphens. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] witness_path: Specifies the fileshare path of the local witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] witness_type: Specifies the type of the witness. Possible values are `Cloud`, `FileShare`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "azure_service_endpoint", azure_service_endpoint)
        pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "witness_path", witness_path)
        pulumi.set(__self__, "witness_type", witness_type)

    @_builtins.property
    @pulumi.getter(name="azureServiceEndpoint")
    def azure_service_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Azure blob service endpoint, for example, `core.windows.net`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "azure_service_endpoint")

    @azure_service_endpoint.setter
    def azure_service_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_service_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Azure Storage account name of the cloud witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "cloud_account_name")

    @cloud_account_name.setter
    def cloud_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_account_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the cluster. It must be 3-15 characters long and contain only letters, numbers and hyphens. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="witnessPath")
    def witness_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the fileshare path of the local witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "witness_path")

    @witness_path.setter
    def witness_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "witness_path", value)

    @_builtins.property
    @pulumi.getter(name="witnessType")
    def witness_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of the witness. Possible values are `Cloud`, `FileShare`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "witness_type")

    @witness_type.setter
    def witness_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "witness_type", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitHostNetworkArgsDict(TypedDict):
        intents: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentArgsDict']]]
        """
        One or more `intent` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        storage_networks: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgsDict']]]
        """
        One or more `storage_network` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        storage_auto_ip_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically. Optional parameter required only for [3 nodes switchless deployments](https://learn.microsoft.com/azure-stack/hci/concepts/physical-network-requirements?tabs=overview%2C23H2reqs#using-switchless). Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        storage_connectivity_switchless_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Defines how the storage adapters between nodes are connected either switch or switch less. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitHostNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitHostNetworkArgs:
    def __init__(__self__, *,
                 intents: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentArgs']]],
                 storage_networks: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs']]],
                 storage_auto_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_connectivity_switchless_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentArgs']]] intents: One or more `intent` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs']]] storage_networks: One or more `storage_network` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] storage_auto_ip_enabled: Whether allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically. Optional parameter required only for [3 nodes switchless deployments](https://learn.microsoft.com/azure-stack/hci/concepts/physical-network-requirements?tabs=overview%2C23H2reqs#using-switchless). Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] storage_connectivity_switchless_enabled: Defines how the storage adapters between nodes are connected either switch or switch less. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "intents", intents)
        pulumi.set(__self__, "storage_networks", storage_networks)
        if storage_auto_ip_enabled is not None:
            pulumi.set(__self__, "storage_auto_ip_enabled", storage_auto_ip_enabled)
        if storage_connectivity_switchless_enabled is not None:
            pulumi.set(__self__, "storage_connectivity_switchless_enabled", storage_connectivity_switchless_enabled)

    @_builtins.property
    @pulumi.getter
    def intents(self) -> pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentArgs']]]:
        """
        One or more `intent` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "intents")

    @intents.setter
    def intents(self, value: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentArgs']]]):
        pulumi.set(self, "intents", value)

    @_builtins.property
    @pulumi.getter(name="storageNetworks")
    def storage_networks(self) -> pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs']]]:
        """
        One or more `storage_network` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage_networks")

    @storage_networks.setter
    def storage_networks(self, value: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs']]]):
        pulumi.set(self, "storage_networks", value)

    @_builtins.property
    @pulumi.getter(name="storageAutoIpEnabled")
    def storage_auto_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically. Optional parameter required only for [3 nodes switchless deployments](https://learn.microsoft.com/azure-stack/hci/concepts/physical-network-requirements?tabs=overview%2C23H2reqs#using-switchless). Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage_auto_ip_enabled")

    @storage_auto_ip_enabled.setter
    def storage_auto_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_auto_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storageConnectivitySwitchlessEnabled")
    def storage_connectivity_switchless_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines how the storage adapters between nodes are connected either switch or switch less. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage_connectivity_switchless_enabled")

    @storage_connectivity_switchless_enabled.setter
    def storage_connectivity_switchless_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "storage_connectivity_switchless_enabled", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitHostNetworkIntentArgsDict(TypedDict):
        adapters: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of ID of network interfaces used for the network intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        traffic_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of network traffic types. Possible values are `Compute`, `Storage`, `Management`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        adapter_property_override: NotRequired[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgsDict']]
        """
        A `adapter_property_override` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        adapter_property_override_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to override adapter properties. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        qos_policy_override: NotRequired[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgsDict']]
        """
        A `qos_policy_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        qos_policy_override_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to override QoS policy. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        virtual_switch_configuration_override: NotRequired[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgsDict']]
        """
        A `virtual_switch_configuration_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        virtual_switch_configuration_override_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to override virtual switch configuration. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitHostNetworkIntentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitHostNetworkIntentArgs:
    def __init__(__self__, *,
                 adapters: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 traffic_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 adapter_property_override: Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs']] = None,
                 adapter_property_override_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 qos_policy_override: Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs']] = None,
                 qos_policy_override_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_switch_configuration_override: Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs']] = None,
                 virtual_switch_configuration_override_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] adapters: Specifies a list of ID of network interfaces used for the network intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] traffic_types: Specifies a list of network traffic types. Possible values are `Compute`, `Storage`, `Management`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs'] adapter_property_override: A `adapter_property_override` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] adapter_property_override_enabled: Whether to override adapter properties. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs'] qos_policy_override: A `qos_policy_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] qos_policy_override_enabled: Whether to override QoS policy. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs'] virtual_switch_configuration_override: A `virtual_switch_configuration_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] virtual_switch_configuration_override_enabled: Whether to override virtual switch configuration. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "adapters", adapters)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "traffic_types", traffic_types)
        if adapter_property_override is not None:
            pulumi.set(__self__, "adapter_property_override", adapter_property_override)
        if adapter_property_override_enabled is not None:
            pulumi.set(__self__, "adapter_property_override_enabled", adapter_property_override_enabled)
        if qos_policy_override is not None:
            pulumi.set(__self__, "qos_policy_override", qos_policy_override)
        if qos_policy_override_enabled is not None:
            pulumi.set(__self__, "qos_policy_override_enabled", qos_policy_override_enabled)
        if virtual_switch_configuration_override is not None:
            pulumi.set(__self__, "virtual_switch_configuration_override", virtual_switch_configuration_override)
        if virtual_switch_configuration_override_enabled is not None:
            pulumi.set(__self__, "virtual_switch_configuration_override_enabled", virtual_switch_configuration_override_enabled)

    @_builtins.property
    @pulumi.getter
    def adapters(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of ID of network interfaces used for the network intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "adapters")

    @adapters.setter
    def adapters(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "adapters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="trafficTypes")
    def traffic_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of network traffic types. Possible values are `Compute`, `Storage`, `Management`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "traffic_types")

    @traffic_types.setter
    def traffic_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "traffic_types", value)

    @_builtins.property
    @pulumi.getter(name="adapterPropertyOverride")
    def adapter_property_override(self) -> Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs']]:
        """
        A `adapter_property_override` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "adapter_property_override")

    @adapter_property_override.setter
    def adapter_property_override(self, value: Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs']]):
        pulumi.set(self, "adapter_property_override", value)

    @_builtins.property
    @pulumi.getter(name="adapterPropertyOverrideEnabled")
    def adapter_property_override_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to override adapter properties. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "adapter_property_override_enabled")

    @adapter_property_override_enabled.setter
    def adapter_property_override_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "adapter_property_override_enabled", value)

    @_builtins.property
    @pulumi.getter(name="qosPolicyOverride")
    def qos_policy_override(self) -> Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs']]:
        """
        A `qos_policy_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "qos_policy_override")

    @qos_policy_override.setter
    def qos_policy_override(self, value: Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs']]):
        pulumi.set(self, "qos_policy_override", value)

    @_builtins.property
    @pulumi.getter(name="qosPolicyOverrideEnabled")
    def qos_policy_override_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to override QoS policy. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "qos_policy_override_enabled")

    @qos_policy_override_enabled.setter
    def qos_policy_override_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "qos_policy_override_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualSwitchConfigurationOverride")
    def virtual_switch_configuration_override(self) -> Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs']]:
        """
        A `virtual_switch_configuration_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "virtual_switch_configuration_override")

    @virtual_switch_configuration_override.setter
    def virtual_switch_configuration_override(self, value: Optional[pulumi.Input['HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs']]):
        pulumi.set(self, "virtual_switch_configuration_override", value)

    @_builtins.property
    @pulumi.getter(name="virtualSwitchConfigurationOverrideEnabled")
    def virtual_switch_configuration_override_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to override virtual switch configuration. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "virtual_switch_configuration_override_enabled")

    @virtual_switch_configuration_override_enabled.setter
    def virtual_switch_configuration_override_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_switch_configuration_override_enabled", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgsDict(TypedDict):
        jumbo_packet: NotRequired[pulumi.Input[_builtins.str]]
        """
        The jumbo frame size of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        network_direct: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network direct of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        network_direct_technology: NotRequired[pulumi.Input[_builtins.str]]
        """
        The network direct technology of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs:
    def __init__(__self__, *,
                 jumbo_packet: Optional[pulumi.Input[_builtins.str]] = None,
                 network_direct: Optional[pulumi.Input[_builtins.str]] = None,
                 network_direct_technology: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] jumbo_packet: The jumbo frame size of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] network_direct: The network direct of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] network_direct_technology: The network direct technology of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if jumbo_packet is not None:
            pulumi.set(__self__, "jumbo_packet", jumbo_packet)
        if network_direct is not None:
            pulumi.set(__self__, "network_direct", network_direct)
        if network_direct_technology is not None:
            pulumi.set(__self__, "network_direct_technology", network_direct_technology)

    @_builtins.property
    @pulumi.getter(name="jumboPacket")
    def jumbo_packet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The jumbo frame size of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "jumbo_packet")

    @jumbo_packet.setter
    def jumbo_packet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jumbo_packet", value)

    @_builtins.property
    @pulumi.getter(name="networkDirect")
    def network_direct(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network direct of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "network_direct")

    @network_direct.setter
    def network_direct(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_direct", value)

    @_builtins.property
    @pulumi.getter(name="networkDirectTechnology")
    def network_direct_technology(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network direct technology of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "network_direct_technology")

    @network_direct_technology.setter
    def network_direct_technology(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_direct_technology", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgsDict(TypedDict):
        bandwidth_percentage_smb: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the percentage of the allocated storage traffic bandwidth. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        priority_value8021_action_cluster: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Cluster traffic priority. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        priority_value8021_action_smb: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the Priority Flow Control where Data Center Bridging (DCB) is used. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs:
    def __init__(__self__, *,
                 bandwidth_percentage_smb: Optional[pulumi.Input[_builtins.str]] = None,
                 priority_value8021_action_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 priority_value8021_action_smb: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] bandwidth_percentage_smb: Specifies the percentage of the allocated storage traffic bandwidth. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] priority_value8021_action_cluster: Specifies the Cluster traffic priority. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] priority_value8021_action_smb: Specifies the Priority Flow Control where Data Center Bridging (DCB) is used. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if bandwidth_percentage_smb is not None:
            pulumi.set(__self__, "bandwidth_percentage_smb", bandwidth_percentage_smb)
        if priority_value8021_action_cluster is not None:
            pulumi.set(__self__, "priority_value8021_action_cluster", priority_value8021_action_cluster)
        if priority_value8021_action_smb is not None:
            pulumi.set(__self__, "priority_value8021_action_smb", priority_value8021_action_smb)

    @_builtins.property
    @pulumi.getter(name="bandwidthPercentageSmb")
    def bandwidth_percentage_smb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the percentage of the allocated storage traffic bandwidth. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "bandwidth_percentage_smb")

    @bandwidth_percentage_smb.setter
    def bandwidth_percentage_smb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_percentage_smb", value)

    @_builtins.property
    @pulumi.getter(name="priorityValue8021ActionCluster")
    def priority_value8021_action_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Cluster traffic priority. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "priority_value8021_action_cluster")

    @priority_value8021_action_cluster.setter
    def priority_value8021_action_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority_value8021_action_cluster", value)

    @_builtins.property
    @pulumi.getter(name="priorityValue8021ActionSmb")
    def priority_value8021_action_smb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Priority Flow Control where Data Center Bridging (DCB) is used. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "priority_value8021_action_smb")

    @priority_value8021_action_smb.setter
    def priority_value8021_action_smb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority_value8021_action_smb", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgsDict(TypedDict):
        enable_iov: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the IoV enable status for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        load_balancing_algorithm: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the load balancing algorithm for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs:
    def __init__(__self__, *,
                 enable_iov: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_algorithm: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] enable_iov: Specifies the IoV enable status for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] load_balancing_algorithm: Specifies the load balancing algorithm for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if enable_iov is not None:
            pulumi.set(__self__, "enable_iov", enable_iov)
        if load_balancing_algorithm is not None:
            pulumi.set(__self__, "load_balancing_algorithm", load_balancing_algorithm)

    @_builtins.property
    @pulumi.getter(name="enableIov")
    def enable_iov(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IoV enable status for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "enable_iov")

    @enable_iov.setter
    def enable_iov(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_iov", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingAlgorithm")
    def load_balancing_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the load balancing algorithm for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "load_balancing_algorithm")

    @load_balancing_algorithm.setter
    def load_balancing_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_algorithm", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the storage network. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        network_adapter_name: pulumi.Input[_builtins.str]
        """
        The name of the network adapter. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        vlan_id: pulumi.Input[_builtins.str]
        """
        Specifies the ID for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 network_adapter_name: pulumi.Input[_builtins.str],
                 vlan_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the storage network. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] network_adapter_name: The name of the network adapter. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] vlan_id: Specifies the ID for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_adapter_name", network_adapter_name)
        pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the storage network. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAdapterName")
    def network_adapter_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the network adapter. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "network_adapter_name")

    @network_adapter_name.setter
    def network_adapter_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_adapter_name", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vlan_id", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitInfrastructureNetworkArgsDict(TypedDict):
        dns_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies a list of IPv4 addresses of the DNS servers in your environment. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        gateway: pulumi.Input[_builtins.str]
        """
        Specifies the default gateway that should be used for the provided IP address space. It should be in the format of an IPv4 IP address. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        ip_pools: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgsDict']]]
        """
        One or more `ip_pool` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        subnet_mask: pulumi.Input[_builtins.str]
        """
        Specifies the subnet mask that matches the provided IP address space. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        dhcp_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether DHCP is enabled for hosts and cluster IPs. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.

        > **Note:** If `dhcp_enabled` is set to `false`, the deployment will use static IPs. If set to `true`, the gateway and DNS servers are not required.
        """
elif False:
    HciDeploymentSettingScaleUnitInfrastructureNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitInfrastructureNetworkArgs:
    def __init__(__self__, *,
                 dns_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 gateway: pulumi.Input[_builtins.str],
                 ip_pools: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs']]],
                 subnet_mask: pulumi.Input[_builtins.str],
                 dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Specifies a list of IPv4 addresses of the DNS servers in your environment. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] gateway: Specifies the default gateway that should be used for the provided IP address space. It should be in the format of an IPv4 IP address. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs']]] ip_pools: One or more `ip_pool` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] subnet_mask: Specifies the subnet mask that matches the provided IP address space. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.bool] dhcp_enabled: Whether DHCP is enabled for hosts and cluster IPs. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
               
               > **Note:** If `dhcp_enabled` is set to `false`, the deployment will use static IPs. If set to `true`, the gateway and DNS servers are not required.
        """
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_pools", ip_pools)
        pulumi.set(__self__, "subnet_mask", subnet_mask)
        if dhcp_enabled is not None:
            pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of IPv4 addresses of the DNS servers in your environment. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the default gateway that should be used for the provided IP address space. It should be in the format of an IPv4 IP address. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs']]]:
        """
        One or more `ip_pool` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "ip_pools")

    @ip_pools.setter
    def ip_pools(self, value: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs']]]):
        pulumi.set(self, "ip_pools", value)

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the subnet mask that matches the provided IP address space. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_mask", value)

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether DHCP is enabled for hosts and cluster IPs. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.

        > **Note:** If `dhcp_enabled` is set to `false`, the deployment will use static IPs. If set to `true`, the gateway and DNS servers are not required.
        """
        return pulumi.get(self, "dhcp_enabled")

    @dhcp_enabled.setter
    def dhcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dhcp_enabled", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgsDict(TypedDict):
        ending_address: pulumi.Input[_builtins.str]
        """
        Specifies starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        starting_address: pulumi.Input[_builtins.str]
        """
        Specifies ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs:
    def __init__(__self__, *,
                 ending_address: pulumi.Input[_builtins.str],
                 starting_address: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] ending_address: Specifies starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] starting_address: Specifies ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "ending_address", ending_address)
        pulumi.set(__self__, "starting_address", starting_address)

    @_builtins.property
    @pulumi.getter(name="endingAddress")
    def ending_address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "ending_address")

    @ending_address.setter
    def ending_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ending_address", value)

    @_builtins.property
    @pulumi.getter(name="startingAddress")
    def starting_address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "starting_address")

    @starting_address.setter
    def starting_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "starting_address", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitOptionalServiceArgsDict(TypedDict):
        custom_location: pulumi.Input[_builtins.str]
        """
        Specifies the name of custom location. A custom location will be created after the deployment is completed. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitOptionalServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitOptionalServiceArgs:
    def __init__(__self__, *,
                 custom_location: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] custom_location: Specifies the name of custom location. A custom location will be created after the deployment is completed. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "custom_location", custom_location)

    @_builtins.property
    @pulumi.getter(name="customLocation")
    def custom_location(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of custom location. A custom location will be created after the deployment is completed. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "custom_location")

    @custom_location.setter
    def custom_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_location", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitPhysicalNodeArgsDict(TypedDict):
        ipv4_address: pulumi.Input[_builtins.str]
        """
        Specifies the IPv4 address assigned to each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        name: pulumi.Input[_builtins.str]
        """
        The NETBIOS name of each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitPhysicalNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitPhysicalNodeArgs:
    def __init__(__self__, *,
                 ipv4_address: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] ipv4_address: Specifies the IPv4 address assigned to each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] name: The NETBIOS name of each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IPv4 address assigned to each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The NETBIOS name of each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class HciDeploymentSettingScaleUnitStorageArgsDict(TypedDict):
        configuration_mode: pulumi.Input[_builtins.str]
        """
        The configuration mode of storage. If set to `Express` and your storage is configured as per best practices based on the number of nodes in the cluster. Possible values are `Express`, `InfraOnly` and `KeepStorage`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
elif False:
    HciDeploymentSettingScaleUnitStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciDeploymentSettingScaleUnitStorageArgs:
    def __init__(__self__, *,
                 configuration_mode: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] configuration_mode: The configuration mode of storage. If set to `Express` and your storage is configured as per best practices based on the number of nodes in the cluster. Possible values are `Express`, `InfraOnly` and `KeepStorage`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "configuration_mode", configuration_mode)

    @_builtins.property
    @pulumi.getter(name="configurationMode")
    def configuration_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The configuration mode of storage. If set to `Express` and your storage is configured as per best practices based on the number of nodes in the cluster. Possible values are `Express`, `InfraOnly` and `KeepStorage`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "configuration_mode")

    @configuration_mode.setter
    def configuration_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "configuration_mode", value)


if not MYPY:
    class HciLogicalNetworkSubnetArgsDict(TypedDict):
        ip_allocation_method: pulumi.Input[_builtins.str]
        """
        The IP address allocation method for the subnet. Possible values are `Dynamic` and `Static`. Changing this forces a new resource to be created.
        """
        address_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The address prefix in CIDR notation. Changing this forces a new resource to be created.
        """
        ip_pools: NotRequired[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetIpPoolArgsDict']]]]
        """
        One or more `ip_pool` block as defined above. Changing this forces a new resource to be created.

        > **Note:** If `ip_pool` is not specified, it will be assigned by the server. If you experience a diff you may need to add this to `ignore_changes`.
        """
        routes: NotRequired[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetRouteArgsDict']]]]
        """
        A `route` block as defined above. Changing this forces a new resource to be created.
        """
        vlan_id: NotRequired[pulumi.Input[_builtins.int]]
        """
        The VLAN ID for the Logical Network. Changing this forces a new resource to be created.
        """
elif False:
    HciLogicalNetworkSubnetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciLogicalNetworkSubnetArgs:
    def __init__(__self__, *,
                 ip_allocation_method: pulumi.Input[_builtins.str],
                 address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_pools: Optional[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetIpPoolArgs']]]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetRouteArgs']]]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_allocation_method: The IP address allocation method for the subnet. Possible values are `Dynamic` and `Static`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] address_prefix: The address prefix in CIDR notation. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetIpPoolArgs']]] ip_pools: One or more `ip_pool` block as defined above. Changing this forces a new resource to be created.
               
               > **Note:** If `ip_pool` is not specified, it will be assigned by the server. If you experience a diff you may need to add this to `ignore_changes`.
        :param pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetRouteArgs']]] routes: A `route` block as defined above. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID for the Logical Network. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address allocation method for the subnet. Possible values are `Dynamic` and `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_allocation_method")

    @ip_allocation_method.setter
    def ip_allocation_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_allocation_method", value)

    @_builtins.property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address prefix in CIDR notation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_prefix", value)

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetIpPoolArgs']]]]:
        """
        One or more `ip_pool` block as defined above. Changing this forces a new resource to be created.

        > **Note:** If `ip_pool` is not specified, it will be assigned by the server. If you experience a diff you may need to add this to `ignore_changes`.
        """
        return pulumi.get(self, "ip_pools")

    @ip_pools.setter
    def ip_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetIpPoolArgs']]]]):
        pulumi.set(self, "ip_pools", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetRouteArgs']]]]:
        """
        A `route` block as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HciLogicalNetworkSubnetRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VLAN ID for the Logical Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)


if not MYPY:
    class HciLogicalNetworkSubnetIpPoolArgsDict(TypedDict):
        end: pulumi.Input[_builtins.str]
        """
        The IPv4 address of the end of the IP address pool. Changing this forces a new resource to be created.
        """
        start: pulumi.Input[_builtins.str]
        """
        The IPv4 address of the start of the IP address pool. Changing this forces a new resource to be created.
        """
elif False:
    HciLogicalNetworkSubnetIpPoolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciLogicalNetworkSubnetIpPoolArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[_builtins.str],
                 start: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] end: The IPv4 address of the end of the IP address pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] start: The IPv4 address of the start of the IP address pool. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def end(self) -> pulumi.Input[_builtins.str]:
        """
        The IPv4 address of the end of the IP address pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end", value)

    @_builtins.property
    @pulumi.getter
    def start(self) -> pulumi.Input[_builtins.str]:
        """
        The IPv4 address of the start of the IP address pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start", value)


if not MYPY:
    class HciLogicalNetworkSubnetRouteArgsDict(TypedDict):
        address_prefix: pulumi.Input[_builtins.str]
        """
        The Address in CIDR notation. Changing this forces a new resource to be created.
        """
        next_hop_ip_address: pulumi.Input[_builtins.str]
        """
        The IPv4 address of the next hop. Changing this forces a new resource to be created.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the route. Changing this forces a new resource to be created.
        """
elif False:
    HciLogicalNetworkSubnetRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciLogicalNetworkSubnetRouteArgs:
    def __init__(__self__, *,
                 address_prefix: pulumi.Input[_builtins.str],
                 next_hop_ip_address: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address_prefix: The Address in CIDR notation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] next_hop_ip_address: The IPv4 address of the next hop. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the route. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "address_prefix", address_prefix)
        pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The Address in CIDR notation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address_prefix", value)

    @_builtins.property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> pulumi.Input[_builtins.str]:
        """
        The IPv4 address of the next hop. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @next_hop_ip_address.setter
    def next_hop_ip_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "next_hop_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class HciMarketplaceGalleryImageIdentifierArgsDict(TypedDict):
        offer: pulumi.Input[_builtins.str]
        """
        The offer of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        publisher: pulumi.Input[_builtins.str]
        """
        The publisher of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        sku: pulumi.Input[_builtins.str]
        """
        The sku of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
elif False:
    HciMarketplaceGalleryImageIdentifierArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciMarketplaceGalleryImageIdentifierArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[_builtins.str],
                 publisher: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] offer: The offer of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] publisher: The publisher of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] sku: The sku of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> pulumi.Input[_builtins.str]:
        """
        The offer of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "offer", value)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[_builtins.str]:
        """
        The publisher of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The sku of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)


if not MYPY:
    class HciNetworkInterfaceIpConfigurationArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The resource ID of the Stack HCI Logical Network bound to the IP configuration. Changing this forces a new resource to be created.
        """
        gateway: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 address of the gateway for the Network Interface.
        """
        prefix_length: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix length for the address of the Network Interface.
        """
        private_ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 address of the IP configuration. Changing this forces a new resource to be created.
        """
elif False:
    HciNetworkInterfaceIpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HciNetworkInterfaceIpConfigurationArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The resource ID of the Stack HCI Logical Network bound to the IP configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gateway: The IPv4 address of the gateway for the Network Interface.
        :param pulumi.Input[_builtins.str] prefix_length: The prefix length for the address of the Network Interface.
        :param pulumi.Input[_builtins.str] private_ip_address: The IPv4 address of the IP configuration. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Stack HCI Logical Network bound to the IP configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address of the gateway for the Network Interface.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix length for the address of the Network Interface.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix_length", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address of the IP configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)


