# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HciDeploymentSettingArgs', 'HciDeploymentSetting']

@pulumi.input_type
class HciDeploymentSettingArgs:
    def __init__(__self__, *,
                 arc_resource_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 scale_units: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]],
                 stack_hci_cluster_id: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a HciDeploymentSetting resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arc_resource_ids: Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]] scale_units: One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] stack_hci_cluster_id: The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] version: The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "arc_resource_ids", arc_resource_ids)
        pulumi.set(__self__, "scale_units", scale_units)
        pulumi.set(__self__, "stack_hci_cluster_id", stack_hci_cluster_id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="arcResourceIds")
    def arc_resource_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "arc_resource_ids")

    @arc_resource_ids.setter
    def arc_resource_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "arc_resource_ids", value)

    @_builtins.property
    @pulumi.getter(name="scaleUnits")
    def scale_units(self) -> pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]]:
        """
        One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "scale_units")

    @scale_units.setter
    def scale_units(self, value: pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]]):
        pulumi.set(self, "scale_units", value)

    @_builtins.property
    @pulumi.getter(name="stackHciClusterId")
    def stack_hci_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "stack_hci_cluster_id")

    @stack_hci_cluster_id.setter
    def stack_hci_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_hci_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _HciDeploymentSettingState:
    def __init__(__self__, *,
                 arc_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scale_units: Optional[pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]]] = None,
                 stack_hci_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HciDeploymentSetting resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arc_resource_ids: Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]] scale_units: One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] stack_hci_cluster_id: The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] version: The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if arc_resource_ids is not None:
            pulumi.set(__self__, "arc_resource_ids", arc_resource_ids)
        if scale_units is not None:
            pulumi.set(__self__, "scale_units", scale_units)
        if stack_hci_cluster_id is not None:
            pulumi.set(__self__, "stack_hci_cluster_id", stack_hci_cluster_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="arcResourceIds")
    def arc_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "arc_resource_ids")

    @arc_resource_ids.setter
    def arc_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "arc_resource_ids", value)

    @_builtins.property
    @pulumi.getter(name="scaleUnits")
    def scale_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]]]:
        """
        One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "scale_units")

    @scale_units.setter
    def scale_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HciDeploymentSettingScaleUnitArgs']]]]):
        pulumi.set(self, "scale_units", value)

    @_builtins.property
    @pulumi.getter(name="stackHciClusterId")
    def stack_hci_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "stack_hci_cluster_id")

    @stack_hci_cluster_id.setter
    def stack_hci_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_hci_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:stack/hciDeploymentSetting:HciDeploymentSetting")
class HciDeploymentSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scale_units: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HciDeploymentSettingScaleUnitArgs', 'HciDeploymentSettingScaleUnitArgsDict']]]]] = None,
                 stack_hci_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stack HCI Deployment Setting.

        > **Note:** Completion of the prerequisites of deploying the Azure Stack HCI in your environment is outside the scope of this document. For more details refer to the [Azure Stack HCI deployment sequence](https://learn.microsoft.com/en-us/azure-stack/hci/deploy/deployment-introduction#deployment-sequence). If you encounter issues completing the prerequisites, we'd recommend opening a ticket with Microsoft Support.

        > **Note:** During the deployment process, the service will generate additional resources, including a new Arc Bridge Appliance and a Custom Location containing several Stack HCI Storage Paths. The provider will attempt to remove these resources on the deletion or recreation of `stack.HciDeploymentSetting`.

        ## Import

        Stack HCI Deployment Settings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciDeploymentSetting:HciDeploymentSetting example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.AzureStackHCI/clusters/clus1/deploymentSettings/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arc_resource_ids: Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HciDeploymentSettingScaleUnitArgs', 'HciDeploymentSettingScaleUnitArgsDict']]]] scale_units: One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] stack_hci_cluster_id: The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] version: The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HciDeploymentSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stack HCI Deployment Setting.

        > **Note:** Completion of the prerequisites of deploying the Azure Stack HCI in your environment is outside the scope of this document. For more details refer to the [Azure Stack HCI deployment sequence](https://learn.microsoft.com/en-us/azure-stack/hci/deploy/deployment-introduction#deployment-sequence). If you encounter issues completing the prerequisites, we'd recommend opening a ticket with Microsoft Support.

        > **Note:** During the deployment process, the service will generate additional resources, including a new Arc Bridge Appliance and a Custom Location containing several Stack HCI Storage Paths. The provider will attempt to remove these resources on the deletion or recreation of `stack.HciDeploymentSetting`.

        ## Import

        Stack HCI Deployment Settings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciDeploymentSetting:HciDeploymentSetting example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.AzureStackHCI/clusters/clus1/deploymentSettings/default
        ```

        :param str resource_name: The name of the resource.
        :param HciDeploymentSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HciDeploymentSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scale_units: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HciDeploymentSettingScaleUnitArgs', 'HciDeploymentSettingScaleUnitArgsDict']]]]] = None,
                 stack_hci_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HciDeploymentSettingArgs.__new__(HciDeploymentSettingArgs)

            if arc_resource_ids is None and not opts.urn:
                raise TypeError("Missing required property 'arc_resource_ids'")
            __props__.__dict__["arc_resource_ids"] = arc_resource_ids
            if scale_units is None and not opts.urn:
                raise TypeError("Missing required property 'scale_units'")
            __props__.__dict__["scale_units"] = scale_units
            if stack_hci_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_hci_cluster_id'")
            __props__.__dict__["stack_hci_cluster_id"] = stack_hci_cluster_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(HciDeploymentSetting, __self__).__init__(
            'azure:stack/hciDeploymentSetting:HciDeploymentSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arc_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            scale_units: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HciDeploymentSettingScaleUnitArgs', 'HciDeploymentSettingScaleUnitArgsDict']]]]] = None,
            stack_hci_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'HciDeploymentSetting':
        """
        Get an existing HciDeploymentSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] arc_resource_ids: Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HciDeploymentSettingScaleUnitArgs', 'HciDeploymentSettingScaleUnitArgsDict']]]] scale_units: One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] stack_hci_cluster_id: The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param pulumi.Input[_builtins.str] version: The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HciDeploymentSettingState.__new__(_HciDeploymentSettingState)

        __props__.__dict__["arc_resource_ids"] = arc_resource_ids
        __props__.__dict__["scale_units"] = scale_units
        __props__.__dict__["stack_hci_cluster_id"] = stack_hci_cluster_id
        __props__.__dict__["version"] = version
        return HciDeploymentSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="arcResourceIds")
    def arc_resource_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of IDs of Azure ARC machine resource to be part of cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "arc_resource_ids")

    @_builtins.property
    @pulumi.getter(name="scaleUnits")
    def scale_units(self) -> pulumi.Output[Sequence['outputs.HciDeploymentSettingScaleUnit']]:
        """
        One or more `scale_unit` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "scale_units")

    @_builtins.property
    @pulumi.getter(name="stackHciClusterId")
    def stack_hci_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "stack_hci_cluster_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The deployment template version. The format must be a set of numbers separated by dots such as `10.0.0.0`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "version")

