# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountStaticWebsiteInitArgs', 'AccountStaticWebsite']

@pulumi.input_type
class AccountStaticWebsiteInitArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[_builtins.str],
                 error404_document: Optional[pulumi.Input[_builtins.str]] = None,
                 index_document: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountStaticWebsite resource.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] error404_document: The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        :param pulumi.Input[_builtins.str] index_document: The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if error404_document is not None:
            pulumi.set(__self__, "error404_document", error404_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="error404Document")
    def error404_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        """
        return pulumi.get(self, "error404_document")

    @error404_document.setter
    def error404_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error404_document", value)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_document", value)


@pulumi.input_type
class _AccountStaticWebsiteState:
    def __init__(__self__, *,
                 error404_document: Optional[pulumi.Input[_builtins.str]] = None,
                 index_document: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountStaticWebsite resources.
        :param pulumi.Input[_builtins.str] error404_document: The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        :param pulumi.Input[_builtins.str] index_document: The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        """
        if error404_document is not None:
            pulumi.set(__self__, "error404_document", error404_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter(name="error404Document")
    def error404_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        """
        return pulumi.get(self, "error404_document")

    @error404_document.setter
    def error404_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error404_document", value)

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_document", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.type_token("azure:storage/accountStaticWebsite:AccountStaticWebsite")
class AccountStaticWebsite(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 error404_document: Optional[pulumi.Input[_builtins.str]] = None,
                 index_document: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Static Website of an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            tags={
                "environment": "staging",
            })
        example_account_static_website = azure.storage.AccountStaticWebsite("example",
            storage_account_id=example_account.id,
            error404_document="custom_not_found.html",
            index_document="custom_index.html")
        ```

        ## Import

        Storage Account Static Websites can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/accountStaticWebsite:AccountStaticWebsite mysite /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] error404_document: The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        :param pulumi.Input[_builtins.str] index_document: The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountStaticWebsiteInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Static Website of an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS",
            tags={
                "environment": "staging",
            })
        example_account_static_website = azure.storage.AccountStaticWebsite("example",
            storage_account_id=example_account.id,
            error404_document="custom_not_found.html",
            index_document="custom_index.html")
        ```

        ## Import

        Storage Account Static Websites can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/accountStaticWebsite:AccountStaticWebsite mysite /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Storage/storageAccounts/myaccount
        ```

        :param str resource_name: The name of the resource.
        :param AccountStaticWebsiteInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountStaticWebsiteInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 error404_document: Optional[pulumi.Input[_builtins.str]] = None,
                 index_document: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountStaticWebsiteInitArgs.__new__(AccountStaticWebsiteInitArgs)

            __props__.__dict__["error404_document"] = error404_document
            __props__.__dict__["index_document"] = index_document
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
        super(AccountStaticWebsite, __self__).__init__(
            'azure:storage/accountStaticWebsite:AccountStaticWebsite',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            error404_document: Optional[pulumi.Input[_builtins.str]] = None,
            index_document: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountStaticWebsite':
        """
        Get an existing AccountStaticWebsite resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] error404_document: The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        :param pulumi.Input[_builtins.str] index_document: The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountStaticWebsiteState.__new__(_AccountStaticWebsiteState)

        __props__.__dict__["error404_document"] = error404_document
        __props__.__dict__["index_document"] = index_document
        __props__.__dict__["storage_account_id"] = storage_account_id
        return AccountStaticWebsite(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="error404Document")
    def error404_document(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        """
        return pulumi.get(self, "error404_document")

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html.
        """
        return pulumi.get(self, "index_document")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Storage Account to set Static Website on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

