# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TableEntityArgs', 'TableEntity']

@pulumi.input_type
class TableEntityArgs:
    def __init__(__self__, *,
                 entity: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 partition_key: pulumi.Input[_builtins.str],
                 row_key: pulumi.Input[_builtins.str],
                 storage_table_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a TableEntity resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity: A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        :param pulumi.Input[_builtins.str] partition_key: The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_table_id: The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "entity", entity)
        pulumi.set(__self__, "partition_key", partition_key)
        pulumi.set(__self__, "row_key", row_key)
        pulumi.set(__self__, "storage_table_id", storage_table_id)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "entity", value)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "partition_key", value)

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "row_key")

    @row_key.setter
    def row_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "row_key", value)

    @_builtins.property
    @pulumi.getter(name="storageTableId")
    def storage_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_table_id")

    @storage_table_id.setter
    def storage_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_table_id", value)


@pulumi.input_type
class _TableEntityState:
    def __init__(__self__, *,
                 entity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_table_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TableEntity resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity: A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        :param pulumi.Input[_builtins.str] partition_key: The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_table_id: The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if row_key is not None:
            pulumi.set(__self__, "row_key", row_key)
        if storage_table_id is not None:
            pulumi.set(__self__, "storage_table_id", storage_table_id)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entity", value)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition_key", value)

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "row_key")

    @row_key.setter
    def row_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "row_key", value)

    @_builtins.property
    @pulumi.getter(name="storageTableId")
    def storage_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_table_id")

    @storage_table_id.setter
    def storage_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_table_id", value)


@pulumi.type_token("azure:storage/tableEntity:TableEntity")
class TableEntity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Entity within a Table in an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azureexample",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="azureexamplestorage1",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_table = azure.storage.Table("example",
            name="myexampletable",
            storage_account_name=example_account.name)
        example_table_entity = azure.storage.TableEntity("example",
            storage_table_id=example_table.id,
            partition_key="examplepartition",
            row_key="examplerow",
            entity={
                "example": "example",
            })
        ```

        ## Import

        Entities within a Table in an Azure Storage Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/tableEntity:TableEntity entity1 https://example.table.core.windows.net/table1(PartitionKey='samplepartition',RowKey='samplerow')
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity: A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        :param pulumi.Input[_builtins.str] partition_key: The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_table_id: The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableEntityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Entity within a Table in an Azure Storage Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="azureexample",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="azureexamplestorage1",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_table = azure.storage.Table("example",
            name="myexampletable",
            storage_account_name=example_account.name)
        example_table_entity = azure.storage.TableEntity("example",
            storage_table_id=example_table.id,
            partition_key="examplepartition",
            row_key="examplerow",
            entity={
                "example": "example",
            })
        ```

        ## Import

        Entities within a Table in an Azure Storage Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/tableEntity:TableEntity entity1 https://example.table.core.windows.net/table1(PartitionKey='samplepartition',RowKey='samplerow')
        ```

        :param str resource_name: The name of the resource.
        :param TableEntityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableEntityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                 row_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableEntityArgs.__new__(TableEntityArgs)

            if entity is None and not opts.urn:
                raise TypeError("Missing required property 'entity'")
            __props__.__dict__["entity"] = entity
            if partition_key is None and not opts.urn:
                raise TypeError("Missing required property 'partition_key'")
            __props__.__dict__["partition_key"] = partition_key
            if row_key is None and not opts.urn:
                raise TypeError("Missing required property 'row_key'")
            __props__.__dict__["row_key"] = row_key
            if storage_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_table_id'")
            __props__.__dict__["storage_table_id"] = storage_table_id
        super(TableEntity, __self__).__init__(
            'azure:storage/tableEntity:TableEntity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entity: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            partition_key: Optional[pulumi.Input[_builtins.str]] = None,
            row_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_table_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TableEntity':
        """
        Get an existing TableEntity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entity: A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        :param pulumi.Input[_builtins.str] partition_key: The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] row_key: The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_table_id: The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableEntityState.__new__(_TableEntityState)

        __props__.__dict__["entity"] = entity
        __props__.__dict__["partition_key"] = partition_key
        __props__.__dict__["row_key"] = row_key
        __props__.__dict__["storage_table_id"] = storage_table_id
        return TableEntity(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of key/value pairs that describe the entity to be inserted/merged in to the storage table.
        """
        return pulumi.get(self, "entity")

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key for the partition where the entity will be inserted/merged. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "partition_key")

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key for the row where the entity will be inserted/merged. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "row_key")

    @_builtins.property
    @pulumi.getter(name="storageTableId")
    def storage_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Storage Share ID in which this file will be placed into. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_table_id")

