# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HubEventHandler',
    'HubEventHandlerAuth',
    'HubEventListener',
    'NetworkAclPrivateEndpoint',
    'NetworkAclPublicNetwork',
    'ServiceIdentity',
    'ServiceLiveTrace',
    'SocketioIdentity',
    'SocketioSku',
    'GetPrivateLinkResourceSharedPrivateLinkResourceTypeResult',
]

@pulumi.output_type
class HubEventHandler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlTemplate":
            suggest = "url_template"
        elif key == "systemEvents":
            suggest = "system_events"
        elif key == "userEventPattern":
            suggest = "user_event_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubEventHandler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubEventHandler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubEventHandler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url_template: _builtins.str,
                 auth: Optional['outputs.HubEventHandlerAuth'] = None,
                 system_events: Optional[Sequence[_builtins.str]] = None,
                 user_event_pattern: Optional[_builtins.str] = None):
        """
        :param _builtins.str url_template: The Event Handler URL Template. Two predefined parameters `{hub}` and `{event}` are available to use in the template. The value of the EventHandler URL is dynamically calculated when the client request comes in. Example: `http://example.com/api/{hub}/{event}`.
        :param 'HubEventHandlerAuthArgs' auth: An `auth` block as defined below.
        :param Sequence[_builtins.str] system_events: Specifies the list of system events. Supported values are `connect`, `connected` and `disconnected`.
        :param _builtins.str user_event_pattern: Specifies the matching event names. There are 3 kind of patterns supported: * `*` matches any event name * `,` Combine multiple events with `,` for example `event1,event2`, it matches event `event1` and `event2` * The single event name, for example `event1`, it matches `event1`.
        """
        pulumi.set(__self__, "url_template", url_template)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if system_events is not None:
            pulumi.set(__self__, "system_events", system_events)
        if user_event_pattern is not None:
            pulumi.set(__self__, "user_event_pattern", user_event_pattern)

    @_builtins.property
    @pulumi.getter(name="urlTemplate")
    def url_template(self) -> _builtins.str:
        """
        The Event Handler URL Template. Two predefined parameters `{hub}` and `{event}` are available to use in the template. The value of the EventHandler URL is dynamically calculated when the client request comes in. Example: `http://example.com/api/{hub}/{event}`.
        """
        return pulumi.get(self, "url_template")

    @_builtins.property
    @pulumi.getter
    def auth(self) -> Optional['outputs.HubEventHandlerAuth']:
        """
        An `auth` block as defined below.
        """
        return pulumi.get(self, "auth")

    @_builtins.property
    @pulumi.getter(name="systemEvents")
    def system_events(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of system events. Supported values are `connect`, `connected` and `disconnected`.
        """
        return pulumi.get(self, "system_events")

    @_builtins.property
    @pulumi.getter(name="userEventPattern")
    def user_event_pattern(self) -> Optional[_builtins.str]:
        """
        Specifies the matching event names. There are 3 kind of patterns supported: * `*` matches any event name * `,` Combine multiple events with `,` for example `event1,event2`, it matches event `event1` and `event2` * The single event name, for example `event1`, it matches `event1`.
        """
        return pulumi.get(self, "user_event_pattern")


@pulumi.output_type
class HubEventHandlerAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedIdentityId":
            suggest = "managed_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubEventHandlerAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubEventHandlerAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubEventHandlerAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_identity_id: _builtins.str):
        """
        :param _builtins.str managed_identity_id: Specify the identity ID of the target resource.
               
               > **Note:** `managed_identity_id` is required if the auth block is defined
        """
        pulumi.set(__self__, "managed_identity_id", managed_identity_id)

    @_builtins.property
    @pulumi.getter(name="managedIdentityId")
    def managed_identity_id(self) -> _builtins.str:
        """
        Specify the identity ID of the target resource.

        > **Note:** `managed_identity_id` is required if the auth block is defined
        """
        return pulumi.get(self, "managed_identity_id")


@pulumi.output_type
class HubEventListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventhubName":
            suggest = "eventhub_name"
        elif key == "eventhubNamespaceName":
            suggest = "eventhub_namespace_name"
        elif key == "systemEventNameFilters":
            suggest = "system_event_name_filters"
        elif key == "userEventNameFilters":
            suggest = "user_event_name_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubEventListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubEventListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubEventListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eventhub_name: _builtins.str,
                 eventhub_namespace_name: _builtins.str,
                 system_event_name_filters: Optional[Sequence[_builtins.str]] = None,
                 user_event_name_filters: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str eventhub_name: Specifies the event hub name to receive the events.
        :param _builtins.str eventhub_namespace_name: Specifies the event hub namespace name to receive the events.
        :param Sequence[_builtins.str] system_event_name_filters: Specifies the list of system events. Supported values are `connected` and `disconnected`.
        :param Sequence[_builtins.str] user_event_name_filters: Specifies the list of matching user event names. `["*"]` can be used to match all events.
        """
        pulumi.set(__self__, "eventhub_name", eventhub_name)
        pulumi.set(__self__, "eventhub_namespace_name", eventhub_namespace_name)
        if system_event_name_filters is not None:
            pulumi.set(__self__, "system_event_name_filters", system_event_name_filters)
        if user_event_name_filters is not None:
            pulumi.set(__self__, "user_event_name_filters", user_event_name_filters)

    @_builtins.property
    @pulumi.getter(name="eventhubName")
    def eventhub_name(self) -> _builtins.str:
        """
        Specifies the event hub name to receive the events.
        """
        return pulumi.get(self, "eventhub_name")

    @_builtins.property
    @pulumi.getter(name="eventhubNamespaceName")
    def eventhub_namespace_name(self) -> _builtins.str:
        """
        Specifies the event hub namespace name to receive the events.
        """
        return pulumi.get(self, "eventhub_namespace_name")

    @_builtins.property
    @pulumi.getter(name="systemEventNameFilters")
    def system_event_name_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of system events. Supported values are `connected` and `disconnected`.
        """
        return pulumi.get(self, "system_event_name_filters")

    @_builtins.property
    @pulumi.getter(name="userEventNameFilters")
    def user_event_name_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of matching user event names. `["*"]` can be used to match all events.
        """
        return pulumi.get(self, "user_event_name_filters")


@pulumi.output_type
class NetworkAclPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRequestTypes":
            suggest = "allowed_request_types"
        elif key == "deniedRequestTypes":
            suggest = "denied_request_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 allowed_request_types: Optional[Sequence[_builtins.str]] = None,
                 denied_request_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str id: The ID of the Private Endpoint which is based on the Web Pubsub service.
        :param Sequence[_builtins.str] allowed_request_types: The allowed request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        :param Sequence[_builtins.str] denied_request_types: The denied request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
               
               > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        pulumi.set(__self__, "id", id)
        if allowed_request_types is not None:
            pulumi.set(__self__, "allowed_request_types", allowed_request_types)
        if denied_request_types is not None:
            pulumi.set(__self__, "denied_request_types", denied_request_types)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Private Endpoint which is based on the Web Pubsub service.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="allowedRequestTypes")
    def allowed_request_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The allowed request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        """
        return pulumi.get(self, "allowed_request_types")

    @_builtins.property
    @pulumi.getter(name="deniedRequestTypes")
    def denied_request_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The denied request types for the Private Endpoint Connection. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.

        > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        return pulumi.get(self, "denied_request_types")


@pulumi.output_type
class NetworkAclPublicNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedRequestTypes":
            suggest = "allowed_request_types"
        elif key == "deniedRequestTypes":
            suggest = "denied_request_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclPublicNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclPublicNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclPublicNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_request_types: Optional[Sequence[_builtins.str]] = None,
                 denied_request_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] allowed_request_types: The allowed request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        :param Sequence[_builtins.str] denied_request_types: The denied request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
               
               > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        if allowed_request_types is not None:
            pulumi.set(__self__, "allowed_request_types", allowed_request_types)
        if denied_request_types is not None:
            pulumi.set(__self__, "denied_request_types", denied_request_types)

    @_builtins.property
    @pulumi.getter(name="allowedRequestTypes")
    def allowed_request_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The allowed request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.
        """
        return pulumi.get(self, "allowed_request_types")

    @_builtins.property
    @pulumi.getter(name="deniedRequestTypes")
    def denied_request_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        The denied request types for the public network. Possible values are `ClientConnection`, `ServerConnection`, `RESTAPI` and `Trace`.

        > **Note:** When `default_action` is `Allow`, `allowed_request_types`cannot be set. When `default_action` is `Deny`, `denied_request_types`cannot be set.
        """
        return pulumi.get(self, "denied_request_types")


@pulumi.output_type
class ServiceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Web PubSub. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Web PubSub.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Web PubSub. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Web PubSub.

        > **Note:** This is required when `type` is set to `UserAssigned`
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ServiceLiveTrace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityLogsEnabled":
            suggest = "connectivity_logs_enabled"
        elif key == "httpRequestLogsEnabled":
            suggest = "http_request_logs_enabled"
        elif key == "messagingLogsEnabled":
            suggest = "messaging_logs_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLiveTrace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLiveTrace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLiveTrace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connectivity_logs_enabled: Optional[_builtins.bool] = None,
                 enabled: Optional[_builtins.bool] = None,
                 http_request_logs_enabled: Optional[_builtins.bool] = None,
                 messaging_logs_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool connectivity_logs_enabled: Whether the log category `ConnectivityLogs` is enabled? Defaults to `true`
        :param _builtins.bool enabled: Whether the live trace is enabled? Defaults to `true`.
        :param _builtins.bool http_request_logs_enabled: Whether the log category `HttpRequestLogs` is enabled? Defaults to `true`
        :param _builtins.bool messaging_logs_enabled: Whether the log category `MessagingLogs` is enabled? Defaults to `true`
        """
        if connectivity_logs_enabled is not None:
            pulumi.set(__self__, "connectivity_logs_enabled", connectivity_logs_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if http_request_logs_enabled is not None:
            pulumi.set(__self__, "http_request_logs_enabled", http_request_logs_enabled)
        if messaging_logs_enabled is not None:
            pulumi.set(__self__, "messaging_logs_enabled", messaging_logs_enabled)

    @_builtins.property
    @pulumi.getter(name="connectivityLogsEnabled")
    def connectivity_logs_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the log category `ConnectivityLogs` is enabled? Defaults to `true`
        """
        return pulumi.get(self, "connectivity_logs_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the live trace is enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="httpRequestLogsEnabled")
    def http_request_logs_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the log category `HttpRequestLogs` is enabled? Defaults to `true`
        """
        return pulumi.get(self, "http_request_logs_enabled")

    @_builtins.property
    @pulumi.getter(name="messagingLogsEnabled")
    def messaging_logs_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the log category `MessagingLogs` is enabled? Defaults to `true`
        """
        return pulumi.get(self, "messaging_logs_enabled")


@pulumi.output_type
class SocketioIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SocketioIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SocketioIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SocketioIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of Managed Identity for this Web PubSub Service. Possible Values are `SystemAssigned` and `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs for this Web PubSub Service.
               
               > **Note:** `identity_ids` is required when `type` is `UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Identity for this Web PubSub Service. Possible Values are `SystemAssigned` and `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs for this Web PubSub Service.

        > **Note:** `identity_ids` is required when `type` is `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class SocketioSku(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 capacity: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        :param _builtins.int capacity: The number of units associated with this Web PubSub Service. Defaults to `1`. Possible values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.
               
               > **Note:** The valid range depends on which `sku` is used. For `Free_F1` only `1` is supported, for `Standard_S1` and `Premium_P1` `1` through `100` are supported, and for `Premium_P2` the minimum capacity is `100`.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this Web PubSub Service. Changing this forces a new Web PubSub Service to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.int]:
        """
        The number of units associated with this Web PubSub Service. Defaults to `1`. Possible values are `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `10`, `20`, `30`, `40`, `50`, `60`, `70`, `80`, `90`, `100`, `200`, `300`, `400`, `500`, `600`, `700`, `800`, `900` and `1000`.

        > **Note:** The valid range depends on which `sku` is used. For `Free_F1` only `1` is supported, for `Standard_S1` and `Premium_P1` `1` through `100` are supported, and for `Premium_P2` the minimum capacity is `100`.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class GetPrivateLinkResourceSharedPrivateLinkResourceTypeResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 subresource_name: _builtins.str):
        """
        :param _builtins.str description: The description of the resource type that has been onboarded to private link service.
        :param _builtins.str subresource_name: The  name for the resource that has been onboarded to private link service.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "subresource_name", subresource_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the resource type that has been onboarded to private link service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="subresourceName")
    def subresource_name(self) -> _builtins.str:
        """
        The  name for the resource that has been onboarded to private link service.
        """
        return pulumi.get(self, "subresource_name")


