import time
import uuid
from functools import partial
from typing import Any, Dict, List

from fastapi import Request

from supervisely.annotation.label import Label
from supervisely.annotation.tag import Tag
from supervisely.geometry.rectangle import Rectangle
from supervisely.nn.inference.inference import Inference
from supervisely.nn.prediction_dto import PredictionBBox
from supervisely.sly_logger import logger


class ObjectDetection(Inference):
    def get_info(self) -> dict:
        info = super().get_info()
        info["task type"] = "object detection"
        info["tracking_on_videos_support"] = True
        # recommended parameters:
        # info["model_name"] = ""
        # info["checkpoint_name"] = ""
        # info["pretrained_on_dataset"] = ""
        # info["device"] = ""
        return info

    def _get_obj_class_shape(self):
        return Rectangle

    def _create_label(self, dto: PredictionBBox):
        obj_class = self.model_meta.get_obj_class(dto.class_name)
        if obj_class is None:
            raise KeyError(
                f"Class {dto.class_name} not found in model classes {self.get_classes()}"
            )
        geometry = Rectangle(*dto.bbox_tlbr)
        tags = []
        if dto.score is not None:
            tags.append(Tag(self._get_confidence_tag_meta(), dto.score))
        label = Label(geometry, obj_class, tags)
        return label

    def predict(self, image_path: str, settings: Dict[str, Any]) -> List[PredictionBBox]:
        raise NotImplementedError("Have to be implemented in child class")

    def predict_raw(self, image_path: str, settings: Dict[str, Any]) -> List[PredictionBBox]:
        raise NotImplementedError(
            "Have to be implemented in child class If sliding_window_mode is 'advanced'."
        )
