import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.factory.Factory import Factory
from type.executor.Command import Command

# io
from command.io.Input import Input
from command.io.Output import Output

# browser
from command.browser.Creator import Creator

# crawler
from command.crawler.Engine import Engine

# material
from command.material.Page import Page

# loginer
from command.loginer.Actor import Actor
from command.loginer.Checker import Checker

# notifier
from command.notifier.Email import Email

# --- flow command ---
# loginer
from flow.loginer.Actor import Actor as FlowActor
from flow.loginer.Checker import Checker as FlowChecker

class CommandFactory(Factory):

  _COMMANDS:dict[str,Command] = {
    # io
    Input.NAME:Input,
    Output.NAME:Output,
    
    # browser
    Creator.NAME:Creator,
    
    # crawler
    Engine.NAME:Engine,
    Page.NAME:Page,
    
    # crawler of loginer
    Actor.NAME:Actor,
    Checker.NAME:Checker,
    
    # notifier
    Email.NAME:Email,

    # flow command
    FlowChecker.NAME:FlowChecker,
    FlowActor.NAME:FlowActor,
  }
  
  def __init__(self,context:dict) -> None:
    self._context = context
    
  def create(self,cmd_name:str)->Command | None:
    # overide
    cmd = self._COMMANDS.get(cmd_name)
    return cmd(self._context) if cmd else None

