import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.executor.Command import Command
from type.output.STDOut import STDOut
from sele.browser.BrowserFactory import BrowserFactory   
from namespace.CommandName import CommandName

class Creator(Command):

  NAME = CommandName.Browser.CREATOR

  def execute(self):
    
    br_config = self._context[CommandName.IO.INPUT.value][CommandName.Browser.CREATOR.value].config
    if self._should_stop(br_config):
      return
    
    browser = self._get_br(br_config)
    stdout = STDOut(200,'ok',browser) if browser else STDOut(500,'fail',None)
    self._output(stdout)
    self._log(stdout)

  def _output(self,stdout):
      self._context[CommandName.Browser.CREATOR.value] = stdout

  def _log(self,stdout):
    if stdout.code==200:
      self._logger.info(f'[{self.NAME}] Managed to create a browser')
    else:
      raise Exception(f'[{self.NAME}] Failed to create a browser')
    
  def _should_stop(self,br_config)->bool:
    if not br_config:
      return True
    else:
      return False

  def _get_br(self,br_config):
    browser_mode = br_config.get('mode')
    if browser_mode == 'proxy':
      return self._get_proxy_br(br_config)

    if browser_mode == 'login':
      if browser:= self._get_login_br(br_config):
        return browser
      else:
        raise Exception(f'[{self.NAME}] Failed to login by the {login_url}')

    return self._get_common_br(br_config)

  def _get_common_br(self,br_config):
    browser_mode = br_config.get('mode','standard')
    executable_path = br_config.get('path')
    return BrowserFactory(browser_mode).create(executable_path=executable_path)
  
  def _get_login_br(self,br_config):
    browser_mode = 'login'
    executable_path = br_config.get('path')
    browser = BrowserFactory(browser_mode).create(executable_path=executable_path)
    login_url = br_config.get('login_url')
    logged_in_url = br_config.get('logged_in_url')
    login_element = br_config.get('login_element')
    wait_time = br_config.get('wait_time')
    is_logged_in = browser.login(login_url,logged_in_url,login_element,wait_time)
    return browser if is_logged_in else None

  def _get_proxy_br(self,br_config):
    browser_mode = 'proxy'
    executable_path = br_config.get('path')
    proxy_config = br_config.get('proxy')
    cookie_config = br_config.get('cookie')
    kwargs = {
      'executable_path':executable_path,
      'proxy_config':proxy_config,
      'cookie_config':cookie_config
    }
    return BrowserFactory(browser_mode).create(**kwargs)
