import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.executor.Command import Command
from type.output.STDOut import STDOut
from crawler.CrawlerFactory import CrawlerFactory
from namespace.CommandName import CommandName
from namespace.CrawlerName import CrawlerName

class Engine(Command):

  NAME = CommandName.Crawler.ENGINE

  def execute(self):
    stdout = self.crawl()
    if stdout:
      self._output(stdout)
      self._log(stdout)

  def crawl(self)->STDOut | None:
    model = self._context[CommandName.IO.INPUT.value].get(self.NAME.value)
    browser = self._context[CommandName.Browser.CREATOR.value].data
    if self._should_stop(model,browser):
      return None

    crawler = self._get_crawler(model,browser)
    return crawler.execute()
  
  def _get_crawler(self,model,browser): 
    summary:dict = model.config[CrawlerName.Field.SUMMARY.value]
    crawler_type = summary.get(CrawlerName.Field.TYPE.value,CrawlerName.Engine.BASE.value)
    name = CrawlerName.Engine.from_value(crawler_type)
    return CrawlerFactory(model,browser).create(name)

  def _output(self,stdout):
    self._context[self.NAME.value] = stdout

  def _log(self,stdout):
    if stdout.code==200:
      self._logger.info(f'[{self.NAME}] Managed to crawl')
    else:
      raise Exception(f'[{self.NAME}] Failed to crawl')

  def _should_stop(self,model,browser)->bool:
    if not model or not browser:
      return True
    return False



