import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from namespace.CommandName import CommandName
from namespace.CrawlerName import CrawlerName
from command.crawler.Engine import Engine

class Actor(Engine):

  NAME = CommandName.Loginer.ACTOR
  _LOGGEDIN = CrawlerName.Field.LOGGEDIN
  _CKFILE = CrawlerName.Field.CKFILE
  
  def _log(self,stdout):
    if stdout.code!=200:
      raise Exception(f'[{self.NAME}] Failed to login - {stdout.message}')

    is_logged_in = stdout.data.get(self._LOGGEDIN.value,False)
    cookie_file = stdout.data.get(self._CKFILE.value)
    if not is_logged_in:
      raise Exception(f'[{self.NAME}] Failed to login - failed to check the status')

    if not cookie_file:
      raise Exception(f'[{self.NAME}] Failed to login - failed to save the cookies')

    self._logger.info(f'[{self.NAME}] Managed to login and save the cookies - {cookie_file}')