import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from namespace.CommandName import CommandName
from namespace.CrawlerName import CrawlerName
from command.crawler.Engine import Engine

class Checker(Engine):
  
  NAME = CommandName.Loginer.CHECKER
  _LOGGEDIN = CrawlerName.Field.LOGGEDIN

  def _log(self,stdout):
    if stdout.code==200 and stdout.data:
      is_loggedin = stdout.data.get(self._LOGGEDIN.value,False)
      if is_loggedin:
        self._logger.info(f'[{self.NAME}] Managed to check - is logged in')
        return
    
    raise Exception(f'[{self.NAME}] Failed to check - is not logged in')
    
