import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.output.STDOut import STDOut
from type.model.Model import Model
from namespace.CrawlerName import CrawlerName
from crawler.Crawler import Crawler

class BaseCrawler(Crawler):

  NAME = CrawlerName.Engine.BASE
    
  def _run(self)->STDOut:
    # implement the crawl logic
    body_meta = self._model.meta[self._BODY.value]
    body_model = Model(body_meta,self._model.bizdata)
    return self._crawl(body_model)
        
  def _extract(self,stdout:STDOut):
    # implement the extract logic
    if stdout.data:
      stdout.data = stdout.data.get(self._DATA.value)