import sys,os,re
from abc import abstractmethod
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.executor.Executor import Executor
from behavior.BhvExecutor import BhvExecutor
from type.output.STDOut import STDOut
from type.model.Model import Model
from sele.browser.Browser import Browser 
from namespace.CrawlerName import CrawlerName

class Crawler(Executor):

  _SETUP = CrawlerName.Field.SETUP
  _DATA = CrawlerName.Field.DATA
  _TEARDOWN = CrawlerName.Field.TEARDOWN

  _SUMMARY = CrawlerName.Field.SUMMARY
  _BODY = CrawlerName.Field.BODY 
  
  _URLS = CrawlerName.Field.URLS
  _TYPE = CrawlerName.Field.TYPE

  def __init__(self,model:Model,browser:Browser) -> None:
    '''
    @param model {Model} : the model of crawler
    @param browser {Browser} : the browser instance to use
    '''
    super().__init__()
    self._model = model
    self._browser = browser

  def execute(self)->STDOut:
    # Template method: define the cal structure
    self._setup()
    stdout = self._run()
    self._extract(stdout)
    self._teardown(stdout)
    return stdout
  
    
  @abstractmethod
  def _run(self)->STDOut:
    pass
    
  def _extract(self,stdout:STDOut):
    pass
    
  def _setup(self):
    if not self._model or not self._browser:
      raise Exception(f'[{self.NAME}] Skip to crawl - the model or browser is missing')

  def _crawl(self,model:Model)->STDOut:
    try:
      bhv = BhvExecutor(model,self._browser)
      return bhv.execute()
    except Exception as e:
      message = f'[{self.NAME}] Failed to crawl any data - {e}'
      self._logger.error(message)
      return STDOut(500,message)
  
  def _teardown(self,stdout:STDOut):
    if stdout.code != 200:
      message = f'[{self.NAME}] Failed to crawl - {stdout.message}'
      self._logger.error(message)
    else:
      message = f'[{self.NAME}] Managed to crawl - {len(stdout.data)} rows'
      self._logger.info(message)