import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.factory.Factory import Factory
from type.executor.Flow import Flow
from namespace.FlowName import FlowName
from namespace.CommandName import CommandName
from command.CommandFactory import CommandFactory
from flow.FlowMap import FlowMap

class FlowFactory(Factory):
  
  def __init__(self,context:dict) -> None:
    self._context = context

  def create(self,flow_name:FlowName)->Flow | None:
    # override
    cmd_names:list[CommandName] = FlowMap.flows.get(flow_name)
    if not cmd_names:
      raise Exception(f'[{self.__class__.__name__}] Failed to create the flow {flow_name} instance')

    flow = Flow()
    for name in cmd_names:
      if command:= CommandFactory(self._context).create(name):
        flow.add_executor(command)
    return flow
