import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from namespace.FlowName import FlowName
from namespace.CommandName import CommandName

class FlowMap:

  flows:dict[FlowName,list[CommandName]] = {

    # test
    FlowName.Test.BASE: [
      CommandName.IO.INPUT,
      CommandName.Browser.CREATOR,
      CommandName.Crawler.ENGINE,
    ],

    # loginer
    FlowName.Loginer.CHECKER: [
      CommandName.IO.INPUT,
      CommandName.Browser.CREATOR,
      CommandName.Loginer.CHECKER,
    ],

    FlowName.Loginer.ACTOR: [
      CommandName.IO.INPUT,
      CommandName.Browser.CREATOR,
      CommandName.Loginer.ACTOR,
    ],

    # spider
    FlowName.Spider.ENGINE: [
      CommandName.IO.INPUT,
      CommandName.Browser.CREATOR,
      CommandName.Crawler.ENGINE,
    ],
    
    # formatter

    # --- flow command ---

    # loginer
    FlowName.Loginer.RUNNER: [
      CommandName.IO.INPUT,
      FlowName.Loginer.CHECKER,
      FlowName.Loginer.ACTOR,
    ],
    
  }