import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.executor.Command import Command
from type.output.STDOut import STDOut
from namespace.FlowName import FlowName
from namespace.CommandName import CommandName

class Actor(Command):

  NAME = FlowName.Loginer.ACTOR

  def execute(self)->STDOut:
    if self._should_stop():
      return STDOut(200,'ok')

    from flow.FlowFactory import FlowFactory
    context = self._context[CommandName.IO.INPUT.value][self.NAME.value]
    flow = FlowFactory(context).create(self.NAME)
    stdout:STDOut = flow.execute()
    self._context[self.NAME.value] = stdout
    return stdout

  def _should_stop(self)->bool:
    checker_output = self._context.get(FlowName.Loginer.CHECKER.value)
    if checker_output and checker_output.code==200:
      return True
    return False
