import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from namespace.NSEnum import NSEnum

class CrawlerName:
  
  # standard
  class Engine(NSEnum):
    BASE = "crawler.engine.base"
    LOOP = "crawler.engine.loop"
    DEPTH = "crawler.engine.depth"

  # static fields 
  class Field(NSEnum):
    # level 1
    SETUP = "crawler.field.setup" # {dict} the setup config
    DATA = "crawler.field.data" # {dict} the attr to save the crawled data dict
    TEARDOWN = "crawler.field.teardown" # {dict} the teardown config

    # level 2 : in DATA
    SUMMARY = "crawler.field.summary" # {dict} the info about the crawler
    BODY = "crawler.field.body" # {dict} the bhv executor's config
    
    # level3 : in SUMMARY
    TYPE = "crawler.field.type" # {str} the type of crawler
    URLS = "crawler.field.urls" # {list[str]} the urls to crawl

    # level 3 : in BODY
    LOGGEDIN = "crawler.field.loggedin" # {bool} is logged in
    CKFILE = "crawler.field.ckfile" # {str} is local file to save the cookie file
    