import sys,os,re
from typing import List
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.executor.Executor import Executor
from type.output.STDOut import STDOut

class Flow(Executor):
  
  def __init__(self):
    super().__init__()
    self._pre_executors:List[Executor] = []
    self._executors:List[Executor] = []
    self._post_executors:List[Executor] = []
  
  @property
  def pre_executors(self)->List[Executor]:
    return self._pre_executors

  @property
  def executors(self)->List[Executor]:
    return self._executors
  
  @property
  def post_executors(self)->List[Executor]:
    return self._post_executors
    
  def add_executor(self,executor:Executor):
    self._executors.append(executor)

  def add_pre_executor(self,executor:Executor):
    self._pre_executors.append(executor)  
    
  def add_post_executor(self,executor:Executor):
    self._post_executors.append(executor)
    
  def execute(self)->STDOut:
    try:
      if self._pre_executors:
        self._execute(self._pre_executors)
        message = f'[{self.__class__.__name__}] Managed to execute the flow - pre executors'
        self._logger.info(message)

      if self._executors:
        self._execute(self._executors)
      else:
        message = f'[{self.__class__.__name__}] Failed to execute the flow - no core executors'
        self._logger.error(message)
        return STDOut(500,message)

      message = f'[{self.__class__.__name__}] Managed to execute the flow - core executors'
      self._logger.info(message)
      return STDOut(200,message)
    except Exception as e:
      message = f'[{self.__class__.__name__}] Failed to execute the flow - {e}'
      self._logger.error(message)
      return STDOut(500,message)
    finally:
      self._post_execute()
        
  def _post_execute(self):
    if not self._post_executors:
      return

    try:
      self._execute(self._post_executors)
      message = f'[{self.__class__.__name__}] Managed to execute the flow - post executors'
      self._logger.info(message)
    except Exception as e:
      message = f'[{self.__class__.__name__}] Failed to execute the flow - post executors - {e}'
      self._logger.error(message)

  def _execute(self,executors:List[Executor])->None:
    for executor in executors:
      executor.execute()
