import sys,os,re
sys.path.append(re.sub('blues_lib.*','blues_lib',os.path.realpath(__file__)))
from type.model.Model import Model

class ModelTree:
  @classmethod
  def create(cls, tree: dict):
    return cls._process(tree)

  @classmethod
  def _process(cls, data):
    if not isinstance(data, dict):
      return data

    result = {}
    for key, value in data.items():
      if isinstance(value, list) and len(value) >= 2 and value[0] == '__model__':
        meta = value[1]
        bizdata = value[2] if len(value) > 2 else None
        result[key] = Model(meta, bizdata)
      elif isinstance(value, dict):
        result[key] = cls._process(value)
      elif isinstance(value, list):
        result[key] = [cls._process(item) for item in value]
      else:
        result[key] = value
    return result    