# TalkPipe Documentation

Welcome to the TalkPipe documentation! This directory contains comprehensive, API references, and examples for using TalkPipe effectively.

## Quick Navigation

### 🚀 [Getting Started](quickstart.md)
New to TalkPipe? Start here for installation, basic concepts, and your first pipeline.

### 💡 [Tutorials](tutorials/)
Real-world usage examples and tutorials:
- [Tutorial Overview](tutorials/) 
- [Tutorial 1: Document Indexing](tutorials/Tutorial_1-Document_Indexing/) - Basic TalkPipe concepts
- [Tutorial 2: Search & RAG](tutorials/Tutorial_2-Search_by_Example_and_RAG/) - Advanced search techniques
- [Tutorial 3: Report Writing](tutorials/Tutorial_3_Report_Writing/) - Automated report generation

### 📚 [API Reference](api-reference/)
Complete documentation for all TalkPipe commands and components:
- [ChatterlangServer / talkpipe_endpoint](api-reference/chatterlang-server.md) - Run a script as an API endpoint and with a customizable web interface
- [ChatterLang Workbench](api-reference/chatterlang-workbench.md) - Interactive web interface for writing and testing scripts interactively
- [ChatterLang Script Runner](api-reference/chatterlang-script.md) - Run a script from the command line
- [Documentation Generator](api-reference/talkpipe-ref.md) - Generate reference documentations for Segments and Sources
- [Plugin Manager](api-reference/talkpipe-plugin-manager.md) - Manage and inspect TalkPipe plugins

### 🏗️ [Architecture](architecture/)
Deep technical documentation:
- [Pipe API](architecture/pipe-api.md) - Internal DSL and pipeline construction
- [ChatterLang](architecture/chatterlang.md) - External DSL language reference
- [Extending TalkPipe](architecture/extending-talkpipe.md) - Creating custom components and plugins
- [Configuration](architecture/configuration.md) - Configuring variables for scripts


## Contributing to Documentation

Found a gap or error? Documentation improvements are welcome! Please:
1. Check existing issues for the topic
2. Submit a pull request with your improvements
3. Follow the existing documentation style and structure

---

*For the main project overview and installation instructions, see the [main README](../README.md).*