# API Reference

Complete technical reference for all TalkPipe commands, components, and APIs.

## Command-Line Tools

### [ChatterlangServer / talkpipe_endpoint](chatterlang-server.md)
Create web APIs and interactive forms for processing JSON data through ChatterLang pipelines.
- REST API endpoints
- Configurable web forms  
- Real-time streaming output
- Authentication support

### [ChatterLang Workbench](chatterlang-workbench.md)
Interactive web interface for writing, testing, and running ChatterLang scripts.
- Real-time script execution
- Built-in documentation
- Logging and debugging tools

### [ChatterLang Script Runner](chatterlang-script.md)
Command-line tool for executing ChatterLang scripts from files or command line.
- Batch script execution
- Environment variable support
- Pipeline automation

### [Documentation Generator](talkpipe-ref.md)
Generate HTML and text documentation for all available sources and segments.
- Auto-generated reference docs
- Custom module documentation
- Export formats: HTML, text

### [Plugin Manager](talkpipe-plugin-manager.md)
Manage and inspect TalkPipe plugins installed via Python entry points.
- List installed plugins
- Plugin status monitoring
- Development workflow support

---

*For conceptual overviews, see the [architecture](../architecture/) sections. For working examples, see the [tutorials](../tutorials/) directory.*

Last Reviewed: 20250814