# OpenAVMKit

[![PyPI version](https://img.shields.io/pypi/v/openavmkit?color=blue)](https://pypi.org/project/openavmkit/)
![Python versions](https://img.shields.io/pypi/pyversions/openavmkit.svg)
[![CI](https://github.com/larsiusprime/openavmkit/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/larsiusprime/openavmkit/actions/workflows/ci.yml)

OpenAVMKit is a python library for real estate mass appraisal. It includes modules for data cleaning, data enrichment, modeling, and statistical evaluation of predictive models. It also includes Jupyter notebooks that model typical workflows.

See the [Changelog](CHANGELOG.md)

# Table of Contents

## 1. Getting started
  - [Install from PyPI](docs/docs/getting_started.md#option-1---install-from-pypi)
  - [Install from Git](docs/docs/getting_started.md#option-2---install-from-git)
  - [Running Tests](docs/docs/getting_started.md#running-tests)
  - [Running your first locality](docs/docs/getting_started.md#running-your-first-locality)
## 2. The basics
  - [Creating a new locality](docs/docs/the_basics.md#creating-a-new-locality)
  - [Code modules](docs/docs/the_basics.md#code-modules)
  - [Jupyter Notebooks](docs/docs/the_basics.md#using-the-jupyter-notebooks)
  - [Terminology](docs/docs/the_basics.md#terminology)
## 3. Configuration
  - [Cloud storage](docs/docs/config.md#configuring-cloud-storage)
  - [PDF report generation](docs/docs/config.md#configuring-pdf-report-generation)
  - [US Census API](docs/docs/config.md#configuring-census-api-access)
  - [Open Street Map API](docs/docs/config.md#configuring-openstreetmap-enrichment)
## 4. Legal
  - [Contributing](CONTRIBUTING.md)
  - [License](LICENSE)
  - [License Philosophy](LICENSE-PHILOSOPHY.md)