from __future__ import annotations

from typing import Any, ClassVar, Self, overload

from pyrx import Ap as PyAp
from pyrx import Bim as PyBrxBim
from pyrx import Db as PyDb
from pyrx import Ge as PyGe
from pyrx.doc_utils.boost_meta import _BoostPythonEnum

eAggregateMultiPly: IfcExportOptionFlags  # 8
eAssociatedLibraryNotAccessible: ResultStatus  # 7
eBaseQuantities: IfcExportOptionFlags  # 1
eBimAnnotation: BimElementType  # 51
eBimBeam: BimElementType  # 7
eBimBuilding: BimObjectType  # 3
eBimBuildingType: BimElementType  # 54
eBimColumn: BimElementType  # 5
eBimComposition: BimObjectType  # 4
eBimCovering: BimElementType  # 9
eBimCurtainWall: BimElementType  # 10
eBimDetail: BimElementType  # 58
eBimDiscreteAccessory: BimElementType  # 43
eBimDistributionChamberElement: BimElementType  # 30
eBimDistributionControlElement: BimElementType  # 27
eBimDistributionFlowElement: BimElementType  # 29
eBimDistributionPort: BimElementType  # 28
eBimDoor: BimElementType  # 4
eBimEnergyConversionDevice: BimElementType  # 31
eBimFastener: BimElementType  # 44
eBimFlowConnectionPoint: BimElementType  # 49
eBimFlowController: BimElementType  # 33
eBimFlowFitting: BimElementType  # 32
eBimFlowMovingDevice: BimElementType  # 34
eBimFlowSegment: BimElementType  # 35
eBimFlowStorageDevice: BimElementType  # 36
eBimFlowTerminal: BimElementType  # 11
eBimFlowTreatmentDevice: BimElementType  # 37
eBimFooting: BimElementType  # 22
eBimFurnishingElement: BimElementType  # 12
eBimGenericBuildingElt: BimElementType  # 0
eBimGrid: BimElementType  # 48
eBimGridAxis: BimElementType  # 47
eBimMaterial: BimObjectType  # 7
eBimMechanicalFastener: BimElementType  # 45
eBimMember: BimElementType  # 13
eBimNotAvailable: ResultStatus  # 33
eBimNotImplementedYet: ResultStatus  # 32
eBimOpening: BimElementType  # 50
eBimPile: BimElementType  # 14
eBimPlate: BimElementType  # 42
eBimPly: BimObjectType  # 6
eBimProduct: BimElementType  # 57
eBimRailing: BimElementType  # 15
eBimRamp: BimElementType  # 16
eBimRampFlight: BimElementType  # 17
eBimReinforcingBar: BimElementType  # 38
eBimReinforcingMesh: BimElementType  # 39
eBimRoof: BimElementType  # 18
eBimRoom: BimElementType  # 8
eBimRoomObject: BimObjectType  # 5
eBimSchedule: BimElementType  # 46
eBimSection: BimElementType  # 1
eBimSite: BimElementType  # 19
eBimSlab: BimElementType  # 6
eBimSpaceType: BimElementType  # 53
eBimSpatialElementType: BimElementType  # 52
eBimSpatialLocation: BimObjectType  # 1
eBimStair: BimElementType  # 20
eBimStairFlight: BimElementType  # 21
eBimStory: BimObjectType  # 2
eBimStoryType: BimElementType  # 55
eBimTendon: BimElementType  # 40
eBimTendonAnchor: BimElementType  # 41
eBimUnknownObject: BimObjectType  # 0
eBimViewportType: BimElementType  # 56
eBimWall: BimElementType  # 2
eBimWindow: BimElementType  # 3
eBimXReference: BimElementType  # 26
eBinary: IfcValueType  # 7
eBool: IfcValueType  # 0
eDbNotAccessible: ResultStatus  # 2
eDbNotOpenForWrite: ResultStatus  # 4
eDbObjectNotSupported: ResultStatus  # 3
eDesignTransfer: IfcModelViewDefType  # 2
eEmpty: IfcValueType  # 12
eEntity: IfcValueType  # 5
eEnum: IfcValueType  # 9
eExplodeXrefs: IfcExportOptionFlags  # 4
eFootprint: BimSpaceRepresentation  # 1
eGuid: IfcValueType  # 8
eHatchCustom: BimHatchType  # 2
eHatchNone: BimHatchType  # -1
eHatchPredefined: BimHatchType  # 1
eHatchUserDefined: BimHatchType  # 0
eIFC2X3: IfcSchemaId  # 0
eIFC4: IfcSchemaId  # 1
eIFC4X1: IfcSchemaId  # 2
eIfcGlobalOrigin: IfcImportModelOrigin  # 0
eIfcProjectLocation: IfcImportModelOrigin  # 2
eIfcSchemaLast: IfcSchemaId  # 2
eIfcSiteLocation: IfcImportModelOrigin  # 1
eIncludeFrozenHidden: IfcExportOptionFlags  # 2
eInstantSave: BimPolicyOptions  # 1
eInt: IfcValueType  # 1
eInternalError: IfcResult  # 4
eInvalidArgument: ResultStatus  # 44
eInvalidIndex: ResultStatus  # 36
eInvalidInput: ResultStatus  # 37
eInvalidMaterial: ResultStatus  # 10
eInvalidMaterialComposition: ResultStatus  # 11
eInvalidName: ResultStatus  # 16
eInvalidSpatialLocation: ResultStatus  # 9
eInvalidValue: ResultStatus  # 18
eInvalidXmlFormat: ResultStatus  # 15
eLogical: IfcValueType  # 6
eMergeGuidForBlocks: IfcExportOptionFlags  # 16
eMergeGuidForXrefs: IfcExportOptionFlags  # 32
eModelSpaceNotAccessible: ResultStatus  # 5
eNameSpaceAlreadyExists: ResultStatus  # 39
eNoAttributeSet: ResultStatus  # 45
eNoBuildingElement: BimElementType  # 59
eNoData: ResultStatus  # 28
eNoDbResidentObject: ResultStatus  # 1
eNoNameSpace: ResultStatus  # 38
eNoProfileAssigned: ResultStatus  # 27
eNoProperty: ResultStatus  # 42
eNoPropertySet: ResultStatus  # 40
eNotApplicableForTheseParameters: ResultStatus  # 8
eNotAssignedToLibrary: ResultStatus  # 19
eNotImplemented: ResultStatus  # 43
eNotInitialized: IfcResult  # 1
eNotLinearBuildingElement: ResultStatus  # 17
eNotSet: IfcModelViewDefType  # 0
eNothing: BimPolicyOptions  # 0
eNullDatabase: ResultStatus  # 22
eNullDocument: ResultStatus  # 23
eNullObject: ResultStatus  # 20
eNullObjectId: ResultStatus  # 21
eNullString: ResultStatus  # 24
eObjectAlreadyExists: ResultStatus  # 12
eObjectCouldNotBeDeleted: ResultStatus  # 13
eObjectNotExisting: ResultStatus  # 25
eObjectNotSupported: ResultStatus  # 26
eOk: IfcResult  # 0
eProfileCenterOfGravity: IfcExportOptionFlags  # 256
eProjectDbNotAccessible: ResultStatus  # 6
ePropertySetAlreadyExists: ResultStatus  # 41
eReal: IfcValueType  # 3
eReference: IfcModelViewDefType  # 1
eSelect: IfcValueType  # 10
eSolid: BimSpaceRepresentation  # 0
eString: IfcValueType  # 4
eSweptSolidsAsBRep: IfcExportOptionFlags  # 128
eTesselateBSplines: IfcExportOptionFlags  # 64
eUInt: IfcValueType  # 2
eUnassignedEntity: ResultStatus  # 31
eUnknownData: ResultStatus  # 29
eUnknownError: ResultStatus  # 35
eVector: IfcValueType  # 11
eWrongDataType: ResultStatus  # 30
eWrongName: IfcResult  # 2
eWrongType: IfcResult  # 3
eXmlFileCouldNotBeParsed: ResultStatus  # 14
kBricsys: BimCategory  # 1
kClassfication: BimCategory  # 6
kIFC2x3: BimCategory  # 2
kIFC4: BimCategory  # 7
kIFCCustom: BimCategory  # 3
kIFCQuantity: BimCategory  # 8
kQuantity: BimCategory  # 5
kStandard: BimCategory  # 0
kUser: BimCategory  # 4

class BimAssets:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class BimBuilding(PyBrxBim.BimSpatialLocation):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def allObjectBuildings(db: PyDb.Database, /) -> list: ...
    def allObjectStories(self, /) -> list: ...
    @staticmethod
    def allObjectStoriesFromDb(db: PyDb.Database, /) -> list: ...
    @staticmethod
    def allStringBuildings(db: PyDb.Database, /) -> list: ...
    def allStringStories(self, /) -> list: ...
    @staticmethod
    def allStringStoriesFromDb(db: PyDb.Database, /) -> list: ...
    def assignToEntity(self, id: PyDb.ObjectId, /) -> None: ...
    @staticmethod
    def assignedBuilding(building: PyBrxBim.BimBuilding, id: PyDb.ObjectId, /) -> None: ...
    def assignedObjects(self, db: PyDb.Database, /) -> list: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimBuilding: ...
    @staticmethod
    def className() -> str: ...
    def createBuilding(self, name: str, db: PyDb.Database, /) -> None: ...
    @staticmethod
    def createNewBuilding(db: PyDb.Database, name: str, /) -> BimBuilding: ...
    def createStory(self, name: str, /) -> None: ...
    @staticmethod
    def deleteBuildingFromDb(db: PyDb.Database, name: str, /) -> None: ...
    def deleteStoryObject(self, story: PyBrxBim.BimStory, /) -> None: ...
    def deleteStoryString(self, story: str, /) -> None: ...
    def description(self, /) -> str: ...
    @staticmethod
    def getBuilding(db: PyDb.Database, name: str, /) -> BimBuilding: ...
    def getStory(self, story: str, /) -> BimStory: ...
    def isNull(self, /) -> bool: ...
    def longName(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, desc: str, /) -> None: ...
    def setLongName(self, name: str, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def setNull(self, /) -> None: ...
    def typeDesc(self, /) -> BimObjectType: ...
    def typeName(self, /) -> str: ...

class BimCategory(_BoostPythonEnum):
    kStandard: ClassVar[Self]  # 0
    kBricsys: ClassVar[Self]  # 1
    kIFC2x3: ClassVar[Self]  # 2
    kIFCCustom: ClassVar[Self]  # 3
    kUser: ClassVar[Self]  # 4
    kQuantity: ClassVar[Self]  # 5
    kClassfication: ClassVar[Self]  # 6
    kIFC4: ClassVar[Self]  # 7
    kIFCQuantity: ClassVar[Self]  # 8

class BimClassification:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @overload
    @staticmethod
    def classifyAs(id: PyDb.ObjectId, objectType: PyBrxBim.BimElementType, /) -> None: ...
    @overload
    @staticmethod
    def classifyAs(database: PyDb.database, objectType: PyBrxBim.BimElementType, /) -> None: ...
    @overload
    @staticmethod
    def classifyAs(id: PyDb.ObjectId, typeName: str, /) -> None: ...
    @overload
    @staticmethod
    def classifyAs(id: PyDb.ObjectId, typeName: str, localName: bool, /) -> None: ...
    @overload
    @staticmethod
    def classifyAs(*args) -> None: ...
    @overload
    @staticmethod
    def deleteProperty(id: PyDb.ObjectId, propertyName: str, /) -> bool: ...
    @overload
    @staticmethod
    def deleteProperty(
        id: PyDb.ObjectId, propertyName: str, category: PyBrxBim.EBimCategory, /
    ) -> bool: ...
    @overload
    @staticmethod
    def deleteProperty(id: PyDb.ObjectId, propertyName: str, category: str, /) -> bool: ...
    @overload
    @staticmethod
    def deleteProperty(*args) -> bool: ...
    @staticmethod
    def getAllClassified(db: PyDb.Database, /) -> list: ...
    @staticmethod
    def getAllClassifiedAs(name: str, db: PyDb.Database, /) -> list: ...
    @staticmethod
    def getAllClassifiedAsName(name: str, db: PyDb.Database, local: bool = False, /) -> list: ...
    @staticmethod
    def getAllUnclassified(db: PyDb.Database, /) -> list: ...
    @staticmethod
    def getAllUsedClassificationNames(db: PyDb.Database, local: bool = False, /) -> list: ...
    @staticmethod
    def getAllUsedClassifications(db: PyDb.Database, /) -> list: ...
    @staticmethod
    def getBimTypeNames(local: bool = False, /) -> list: ...
    @staticmethod
    def getClassification() -> Any: ...
    def getClassificationName(id: PyDb.ObjectId, localName: bool = False, /) -> str: ...
    @staticmethod
    def getDescription(id: PyDb.ObjectId, /) -> str: ...
    @staticmethod
    def getGUID(id: PyDb.ObjectId, /) -> str: ...
    @staticmethod
    def getName(id: PyDb.ObjectId, /) -> str: ...
    @overload
    @staticmethod
    def getProperty(id: PyDb.ObjectId, propertyName: str, /) -> PyDb.AcValue: ...
    @overload
    @staticmethod
    def getProperty(
        id: PyDb.ObjectId, propertyName: str, category: PyBrxBim.EBimCategory, /
    ) -> PyDb.AcValue: ...
    @overload
    @staticmethod
    def getProperty(id: PyDb.ObjectId, propertyName: str, category: str, /) -> PyDb.AcValue: ...
    @overload
    @staticmethod
    def getProperty(*args) -> PyDb.AcValue: ...
    @staticmethod
    def getPropertyDict(id: PyDb.ObjectId, /) -> dict: ...
    @staticmethod
    def getPropertyNames(id: PyDb.ObjectId, /) -> list: ...
    @overload
    @staticmethod
    def hasProperty(id: PyDb.ObjectId, propertyName: str, /) -> bool: ...
    @overload
    @staticmethod
    def hasProperty(
        id: PyDb.ObjectId, propertyName: str, category: PyBrxBim.EBimCategory, /
    ) -> bool: ...
    @overload
    @staticmethod
    def hasProperty(id: PyDb.ObjectId, propertyName: str, category: str, /) -> bool: ...
    @overload
    @staticmethod
    def hasProperty(*args) -> bool: ...
    @staticmethod
    def isClassified(val: PyDb.Database, /) -> bool: ...
    @overload
    @staticmethod
    def isClassifiedAs(id: PyDb.ObjectId, objectType: PyBrxBim.BimElementType, /) -> bool: ...
    @overload
    @staticmethod
    def isClassifiedAs(
        database: PyDb.database, objectType: PyBrxBim.BimElementType, /
    ) -> bool: ...
    @overload
    @staticmethod
    def isClassifiedAs(id: PyDb.ObjectId, typeName: str, /) -> bool: ...
    @overload
    @staticmethod
    def isClassifiedAs(id: PyDb.ObjectId, typeName: str, localName: bool, /) -> bool: ...
    @overload
    @staticmethod
    def isClassifiedAs(*args) -> bool: ...
    @staticmethod
    def isClassifiedAsAnyBuildingElement(id: PyDb.ObjectId, /) -> bool: ...
    @staticmethod
    def isUnclassified(id: PyDb.ObjectId, /) -> bool: ...
    @staticmethod
    def setDescription(id: PyDb.ObjectId, description: str, /) -> None: ...
    @staticmethod
    def setName(id: PyDb.ObjectId, description: str, /) -> None: ...
    @overload
    @staticmethod
    def setProperty(id: PyDb.ObjectId, propertyName: str, val: PyDb.AcValue, /) -> None: ...
    @overload
    @staticmethod
    def setProperty(
        id: PyDb.ObjectId, propertyName: str, val: PyDb.AcValue, category: PyBrxBim.EBimCategory, /
    ) -> None: ...
    @overload
    @staticmethod
    def setProperty(
        id: PyDb.ObjectId, propertyName: str, val: PyDb.AcValue, category: str, /
    ) -> None: ...
    @overload
    @staticmethod
    def setProperty(*args) -> None: ...
    @staticmethod
    def unClassify(val: PyDb.ObjectId | PyDb.Database, /) -> None: ...

class BimComposition(PyBrxBim.BimObject):
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, name: str, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimComposition: ...
    @staticmethod
    def className() -> str: ...

class BimElementType(_BoostPythonEnum):
    eBimGenericBuildingElt: ClassVar[Self]  # 0
    eBimSection: ClassVar[Self]  # 1
    eBimWall: ClassVar[Self]  # 2
    eBimWindow: ClassVar[Self]  # 3
    eBimDoor: ClassVar[Self]  # 4
    eBimColumn: ClassVar[Self]  # 5
    eBimSlab: ClassVar[Self]  # 6
    eBimBeam: ClassVar[Self]  # 7
    eBimRoom: ClassVar[Self]  # 8
    eBimCovering: ClassVar[Self]  # 9
    eBimCurtainWall: ClassVar[Self]  # 10
    eBimFlowTerminal: ClassVar[Self]  # 11
    eBimFurnishingElement: ClassVar[Self]  # 12
    eBimMember: ClassVar[Self]  # 13
    eBimPile: ClassVar[Self]  # 14
    eBimRailing: ClassVar[Self]  # 15
    eBimRamp: ClassVar[Self]  # 16
    eBimRampFlight: ClassVar[Self]  # 17
    eBimRoof: ClassVar[Self]  # 18
    eBimSite: ClassVar[Self]  # 19
    eBimStair: ClassVar[Self]  # 20
    eBimStairFlight: ClassVar[Self]  # 21
    eBimFooting: ClassVar[Self]  # 22
    eBimXReference: ClassVar[Self]  # 26
    eBimDistributionControlElement: ClassVar[Self]  # 27
    eBimDistributionPort: ClassVar[Self]  # 28
    eBimDistributionFlowElement: ClassVar[Self]  # 29
    eBimDistributionChamberElement: ClassVar[Self]  # 30
    eBimEnergyConversionDevice: ClassVar[Self]  # 31
    eBimFlowFitting: ClassVar[Self]  # 32
    eBimFlowController: ClassVar[Self]  # 33
    eBimFlowMovingDevice: ClassVar[Self]  # 34
    eBimFlowSegment: ClassVar[Self]  # 35
    eBimFlowStorageDevice: ClassVar[Self]  # 36
    eBimFlowTreatmentDevice: ClassVar[Self]  # 37
    eBimReinforcingBar: ClassVar[Self]  # 38
    eBimReinforcingMesh: ClassVar[Self]  # 39
    eBimTendon: ClassVar[Self]  # 40
    eBimTendonAnchor: ClassVar[Self]  # 41
    eBimPlate: ClassVar[Self]  # 42
    eBimDiscreteAccessory: ClassVar[Self]  # 43
    eBimFastener: ClassVar[Self]  # 44
    eBimMechanicalFastener: ClassVar[Self]  # 45
    eBimSchedule: ClassVar[Self]  # 46
    eBimGridAxis: ClassVar[Self]  # 47
    eBimGrid: ClassVar[Self]  # 48
    eBimFlowConnectionPoint: ClassVar[Self]  # 49
    eBimOpening: ClassVar[Self]  # 50
    eBimAnnotation: ClassVar[Self]  # 51
    eBimSpatialElementType: ClassVar[Self]  # 52
    eBimSpaceType: ClassVar[Self]  # 53
    eBimBuildingType: ClassVar[Self]  # 54
    eBimStoryType: ClassVar[Self]  # 55
    eBimViewportType: ClassVar[Self]  # 56
    eBimProduct: ClassVar[Self]  # 57
    eBimDetail: ClassVar[Self]  # 58
    eNoBuildingElement: ClassVar[Self]  # 59

class BimHatchPattern:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(
        self, scaleOrSpacing: float, angle: float = 0.0, cross: bool = False, /
    ) -> None: ...
    @overload
    def __init__(
        self,
        hType: PyBrxBim.BimHatchType,
        name: str,
        scaleOrSpacing: float = 1.0,
        angle: float = 0.0,
        /,
    ) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class BimHatchType(_BoostPythonEnum):
    eHatchNone: ClassVar[Self]  # -1
    eHatchUserDefined: ClassVar[Self]  # 0
    eHatchPredefined: ClassVar[Self]  # 1
    eHatchCustom: ClassVar[Self]  # 2

class BimInformationalAssets:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class BimLinearGeometry:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class BimMaterial(PyBrxBim.BimObject):
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, name: str, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimMaterial: ...
    @staticmethod
    def className() -> str: ...

class BimNameSpaces:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @overload
    @staticmethod
    def createNameSpace(szName: str, /) -> None: ...
    @overload
    @staticmethod
    def createNameSpace(
        szName: str, szLabel: str, visible: bool, db: PyDb.Database, /
    ) -> None: ...
    @overload
    @staticmethod
    def createNameSpace(*args) -> None: ...
    @staticmethod
    def deleteNameSpace(szNameOrLabel: str, db: PyDb.Database = ..., /) -> None: ...
    @staticmethod
    def getIsNameSpaceVisible(szNameOrLabel: str, db: PyDb.Database = ..., /) -> bool: ...
    @staticmethod
    def getNameSpaceLabel(szName: str, db: PyDb.Database = ..., /) -> str: ...
    @staticmethod
    def hasNameSpace(szNameOrLabel: str, db: PyDb.Database = ..., /) -> bool: ...
    @staticmethod
    def listNameSpaces(db: PyDb.Database = ..., /) -> dict: ...
    @staticmethod
    def setIsNameSpaceVisible(
        visible: bool, szNameOrLabel: str, db: PyDb.Database = ..., /
    ) -> None: ...
    @staticmethod
    def setNameSpaceLabel(szName: str, szLable: str, db: PyDb.Database = ..., /) -> None: ...

class BimObject:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimObject: ...
    @staticmethod
    def className() -> str: ...
    def description(self, /) -> str: ...
    def isNull(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def setDescription(self, val: str, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setNull(self, /) -> None: ...
    def typeDesc(self, /) -> BimObjectType: ...
    def typeName(self, /) -> str: ...

class BimObjectType(_BoostPythonEnum):
    eBimUnknownObject: ClassVar[Self]  # 0
    eBimSpatialLocation: ClassVar[Self]  # 1
    eBimStory: ClassVar[Self]  # 2
    eBimBuilding: ClassVar[Self]  # 3
    eBimComposition: ClassVar[Self]  # 4
    eBimRoomObject: ClassVar[Self]  # 5
    eBimPly: ClassVar[Self]  # 6
    eBimMaterial: ClassVar[Self]  # 7

class BimPly(PyBrxBim.BimObject):
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(
        self,
        material: PyBrxBim.BimMaterial,
        function: PyBrxBim.MaterialFunction = PyBrxBim.MaterialFunction.eNone,
        thickness: float = 1.0,
        /,
    ) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimPly: ...
    @staticmethod
    def className() -> str: ...

class BimPolicies:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def getPolicy(option: PyBrxBim.BimPolicyOptions, /) -> bool: ...
    @staticmethod
    def setPolicy(option: PyBrxBim.BimPolicyOptions, enable: bool, /) -> None: ...

class BimPolicyOptions(_BoostPythonEnum):
    eNothing: ClassVar[Self]  # 0
    eInstantSave: ClassVar[Self]  # 1

class BimProfile:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class BimRoom(PyBrxBim.BimObject):
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def assignToBuilding(self, val: PyBrxBim.BimBuilding, /) -> None: ...
    @staticmethod
    def assignToBuildingS(id: PyDb.ObjectId, val: PyBrxBim.BimBuilding, /) -> None: ...
    def assignToStory(self, val: PyBrxBim.BimStory, /) -> None: ...
    @staticmethod
    def assignToStoryS(id: PyDb.ObjectId, val: PyBrxBim.BimStory, /) -> None: ...
    @staticmethod
    def buildAssociativeRoomS(
        insidePoint: PyGe.Point3d, basePlane: PyGe.Plane, /
    ) -> PyDb.ObjectId: ...
    @staticmethod
    def buildNonAssociativeRoomS(id: PyDb.ObjectId, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimRoom: ...
    @staticmethod
    def className() -> str: ...
    def createAssociativeRoom(
        self, insidePoint: PyGe.Point3d, basePlane: PyGe.Plane, /
    ) -> PyDb.ObjectId: ...
    def createNonAssociativeRoom(self, id: PyDb.ObjectId, /) -> PyDb.ObjectId: ...
    def description(self, /) -> str: ...
    @staticmethod
    def descriptionS(id: PyDb.ObjectId, /) -> str: ...
    @overload
    @staticmethod
    def getAllRoomsS() -> list: ...
    @overload
    @staticmethod
    def getAllRoomsS(db: PyDb.Database, /) -> list: ...
    @overload
    @staticmethod
    def getAllRoomsS(val: PyBrxBim.BimStory, /) -> list: ...
    @overload
    @staticmethod
    def getAllRoomsS(val: PyBrxBim.BimBuilding, /) -> list: ...
    @overload
    @staticmethod
    def getAllRoomsS(val: PyBrxBim.BimStory, db: PyDb.Database, /) -> list: ...
    @overload
    @staticmethod
    def getAllRoomsS(val: PyBrxBim.BimBuilding, db: PyDb.Database, /) -> list: ...
    @overload
    @staticmethod
    def getAllRoomsS(*args) -> list: ...
    def getAssignedBuilding(self, /) -> BimBuilding: ...
    @staticmethod
    def getAssignedBuildingS(id: PyDb.ObjectId, /) -> BimBuilding: ...
    def getAssignedLocation(self, /) -> BimSpatialLocation: ...
    @staticmethod
    def getAssignedLocationS(id: PyDb.ObjectId, /) -> BimSpatialLocation: ...
    def getAssignedStory(self, /) -> BimStory: ...
    @staticmethod
    def getAssignedStoryS(id: PyDb.ObjectId, /) -> BimStory: ...
    def getBoundingElements(self, /) -> list: ...
    @staticmethod
    def getBoundingElementsS(id: PyDb.ObjectId, /) -> list: ...
    def getId(self, /) -> PyDb.ObjectId: ...
    def getOpenings(self, /) -> list: ...
    @staticmethod
    def getOpeningsS(id: PyDb.ObjectId, /) -> list: ...
    def getRoomDepartment(self, /) -> str: ...
    @staticmethod
    def getRoomDepartmentS(id: PyDb.ObjectId, /) -> str: ...
    def getRoomEntity(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def getRoomEntityS(val: PyBrxBim.BimRoom, /) -> PyDb.ObjectId: ...
    def getRoomRepresentation(self, /) -> str: ...
    @staticmethod
    def getRoomRepresentationS(id: PyDb.ObjectId, /) -> str: ...
    def isAssociativeRoom(self, /) -> bool: ...
    @staticmethod
    def isAssociativeRoomS(id: PyDb.ObjectId, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isRoomValid(self, /) -> bool: ...
    @staticmethod
    def isRoomValidS(id: PyDb.ObjectId, /) -> bool: ...
    def name(self, /) -> str: ...
    def roomArea(self, /) -> float: ...
    @staticmethod
    def roomAreaS(id: PyDb.ObjectId, /) -> float: ...
    def roomIdent(self, /) -> str: ...
    @staticmethod
    def roomIdentS(id: PyDb.ObjectId, /) -> str: ...
    def roomName(self, /) -> str: ...
    @staticmethod
    def roomNameS(id: PyDb.ObjectId, /) -> str: ...
    def roomNumber(self, /) -> str: ...
    @staticmethod
    def roomNumberS(id: PyDb.ObjectId, /) -> str: ...
    def setDescription(self, val: str, /) -> None: ...
    @staticmethod
    def setDescriptionS(id: PyDb.ObjectId, val: str, /) -> None: ...
    def setId(self, id: PyDb.ObjectId, /) -> None: ...
    def setName(self, val: str, /) -> None: ...
    def setNull(self, /) -> None: ...
    def setRoomDepartment(self, val: str, /) -> None: ...
    @staticmethod
    def setRoomDepartmentS(id: PyDb.ObjectId, val: str, /) -> None: ...
    def setRoomName(self, val: str, /) -> None: ...
    @staticmethod
    def setRoomNameS(id: PyDb.ObjectId, val: str, /) -> None: ...
    def setRoomNumber(self, val: str, /) -> None: ...
    @staticmethod
    def setRoomNumberS(id: PyDb.ObjectId, val: str, /) -> None: ...
    def setRoomRepresentation(self, val: str, /) -> None: ...
    @staticmethod
    def setRoomRepresentationS(id: PyDb.ObjectId, val: str, /) -> None: ...
    def typeDesc(self, /) -> BimObjectType: ...
    def typeName(self, /) -> str: ...
    def unassignLocation(self, /) -> None: ...
    @staticmethod
    def unassignLocationS(id: PyDb.ObjectId, /) -> None: ...
    def updateAssociativeRoom(self, /) -> None: ...
    @staticmethod
    def updateAssociativeRoomS(id: PyDb.ObjectId, /) -> None: ...

class BimSpace:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def assignToBuilding(id: PyDb.ObjectId, building: PyBrxBim.BimBuilding, /) -> None: ...
    @staticmethod
    def assignToStory(id: PyDb.ObjectId, building: PyBrxBim.BimStory, /) -> None: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def createSpace(pt: PyGe.Point3d, /) -> PyDb.ObjectId: ...
    @overload
    @staticmethod
    def getAllSpaces() -> list: ...
    @overload
    @staticmethod
    def getAllSpaces(db: PyDb.Database, /) -> list: ...
    @overload
    @staticmethod
    def getAllSpaces(val: PyBrxBim.BimStory, /) -> list: ...
    @overload
    @staticmethod
    def getAllSpaces(val: PyBrxBim.BimBuilding, /) -> list: ...
    @overload
    @staticmethod
    def getAllSpaces(val: PyBrxBim.BimStory, db: PyDb.Database, /) -> list: ...
    @overload
    @staticmethod
    def getAllSpaces(val: PyBrxBim.BimBuilding, db: PyDb.Database, /) -> list: ...
    @overload
    @staticmethod
    def getAllSpaces(*args) -> list: ...
    @staticmethod
    def getAssignedEntities(val: str | PyDb.ObjectId, db: PyDb.Database = ..., /) -> list: ...
    @staticmethod
    def getAssignedSpace(id: PyDb.ObjectId, /) -> tuple: ...
    @staticmethod
    def getBoundingElements(id: PyDb.ObjectId, /) -> list: ...
    @staticmethod
    def getSpaceArea(id: PyDb.ObjectId, /) -> float: ...
    @staticmethod
    def getSpaceEntity(spaceName: str, db: PyDb.Database = ..., /) -> PyDb.ObjectId: ...
    @staticmethod
    def getSpaceName(id: PyDb.ObjectId, /) -> str: ...
    @staticmethod
    def getSpaceNumber(id: PyDb.ObjectId, /) -> str: ...
    @staticmethod
    def getSpaceRepresentation(id: PyDb.ObjectId, /) -> BimSpaceRepresentation: ...
    @staticmethod
    def isSpaceUpdated(id: PyDb.ObjectId, /) -> bool: ...
    @staticmethod
    def isSpaceValid(id: PyDb.ObjectId, /) -> bool: ...
    @staticmethod
    def setAssignedSpace(id: PyDb.ObjectId, val: str | PyDb.ObjectId, /) -> None: ...
    @staticmethod
    def setSpaceName(id: PyDb.ObjectId, val: str, /) -> None: ...
    @staticmethod
    def setSpaceNumber(id: PyDb.ObjectId, val: str, /) -> None: ...
    @staticmethod
    def setSpaceRepresentation(
        id: PyDb.ObjectId, val: PyBrxBim.BimSpaceRepresentation, /
    ) -> None: ...
    @staticmethod
    def updateSpace(id: PyDb.ObjectId, /) -> None: ...

class BimSpaceRepresentation(_BoostPythonEnum):
    eSolid: ClassVar[Self]  # 0
    eFootprint: ClassVar[Self]  # 1

class BimSpatialLocation(PyBrxBim.BimObject):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def assignToEntity(self, id: PyDb.ObjectId, /) -> None: ...
    def assignedObjects(self, id: PyDb.ObjectId, /) -> list: ...
    @staticmethod
    def assignedSpatialLocation(id: PyDb.ObjectId, /) -> BimSpatialLocation: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimSpatialLocation: ...
    @staticmethod
    def className() -> str: ...
    def description(self, /) -> str: ...
    def hasBuilding(self, /) -> bool: ...
    def hasStory(self, /) -> bool: ...
    def isBuilding(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isStory(self, /) -> bool: ...
    def longName(self, /) -> str: ...
    def name(self, /) -> str: ...
    @staticmethod
    def removeSpatialLocationFrom(id: PyDb.ObjectId, /) -> None: ...
    def setDescription(self, desc: str, /) -> None: ...
    def setLongName(self, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def setNull(self, /) -> None: ...
    def typeDesc(self, /) -> BimObjectType: ...
    def typeName(self, /) -> str: ...

class BimStory(PyBrxBim.BimSpatialLocation):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def allStories(db: PyDb.Database, /) -> list: ...
    @staticmethod
    def allStoryNames(db: PyDb.Database, /) -> list: ...
    def assignToEntity(self, id: PyDb.ObjectId, /) -> None: ...
    def assignedObjects(self, db: PyDb.Database, /) -> list: ...
    @staticmethod
    def assignedStory(id: PyDb.ObjectId, /) -> BimStory: ...
    @staticmethod
    def cast(otherObject: PyBrxBim.BimObject, /) -> BimStory: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def createNewStory(db: PyDb.Database, buildingName: str, storyName: str, /) -> BimStory: ...
    def createStory(self, szName: str, building: PyBrxBim.BimBuilding, /) -> None: ...
    def deleteStory(self, /) -> None: ...
    @staticmethod
    def deleteStoryFromDatabase(
        db: PyDb.Database, buildingName: str, storyName: str, /
    ) -> None: ...
    def description(self, /) -> str: ...
    def elevation(self, /) -> float: ...
    def getBuilding(self, /) -> BimBuilding: ...
    @staticmethod
    def getStory(db: PyDb.Database, buildingName: str, storyName: str, /) -> BimStory: ...
    def isNull(self, /) -> bool: ...
    def longName(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, desc: str, /) -> None: ...
    def setElevation(self, val: float, /) -> None: ...
    def setLongName(self, name: str, /) -> None: ...
    def setName(self, name: str, /) -> None: ...
    def setNull(self, /) -> None: ...

class BrxBimAttributeSet:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class BrxBimDialogs:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class Core:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def createAnchoredBlockReference(
        blockRefId: PyDb.ObjectId,
        faceSubentPath: PyDb.FullSubentPath,
        pt: PyGe.Point3d,
        keepOrientation: bool,
        /,
    ) -> PyDb.ObjectId: ...
    @staticmethod
    def findMatchingBlockDefinition(entitySet: list[PyDb.ObjectId], /) -> tuple: ...
    @staticmethod
    def findSimilar3dSolids(entitySet: list[PyDb.ObjectId], /) -> tuple: ...
    @staticmethod
    def findSimilarGeometry(
        matchSet: list[PyDb.ObjectId], searchSet: list[PyDb.ObjectId], /
    ) -> tuple: ...
    @staticmethod
    def getAnchorFace(id: PyDb.ObjectId, /) -> PyDb.FullSubentPath: ...
    @staticmethod
    def getAnchoredBlockReferences(db: PyDb.Database, /) -> list: ...
    @staticmethod
    def isAnchoredBlockRef(id: PyDb.ObjectId, /) -> bool: ...
    @staticmethod
    def isSimilarGeometry(
        firstSet: list[PyDb.ObjectId], secondSet: list[PyDb.ObjectId], /
    ) -> tuple: ...
    @staticmethod
    def matchEntitiesToBlockDefinitions(entitySet: list[PyDb.ObjectId], /) -> tuple: ...
    @staticmethod
    def queryValidAnchorPt(pt: PyGe.Point3d, db: PyDb.Database, /) -> PyDb.FullSubentPath: ...
    @staticmethod
    def replaceGeometryByBlocks(similarGroups: tuple, /) -> tuple: ...
    @staticmethod
    def unAnchorBlockReference(id: PyDb.ObjectId, /) -> None: ...

class IfcBinary:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def getBit(self, val: int, /) -> bool: ...
    def getEncodedString(self, /) -> str: ...
    def isEmpty(self, /) -> bool: ...
    def numBits(self, /) -> int: ...
    def reset(self, val: str, /) -> None: ...
    def resize(self, val: int, /) -> None: ...

class IfcEntity:
    def IfcId(self, /) -> int: ...
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def create(model: PyBrxBim.IfcModel, entityDesc: PyBrxBim.IfcEntityDesc, /) -> IfcEntity: ...
    @staticmethod
    def createNull() -> IfcEntity: ...
    def getAttribute(self, val: str, /) -> IfcVariant: ...
    def getInverseRefs(self, /) -> list: ...
    def isA(self, /) -> IfcEntityDesc: ...
    def isKindOf(self, val: PyBrxBim.IfcEntityDesc, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def setAttribute(self, val: str, attribValue: PyBrxBim.IfcVariant, /) -> None: ...

class IfcEntityDesc:
    @staticmethod
    def Ifc2DCompositeCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcActionRequest() -> IfcEntityDesc: ...
    @staticmethod
    def IfcActor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcActorRole() -> IfcEntityDesc: ...
    @staticmethod
    def IfcActuator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcActuatorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAddress() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAdvancedBrep() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAdvancedBrepWithVoids() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAdvancedFace() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAirTerminal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAirTerminalBox() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAirTerminalBoxType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAirTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAirToAirHeatRecovery() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAirToAirHeatRecoveryType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlarm() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlarmType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DHorizontal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DHorizontalSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DVerSegCircularArc() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DVerSegLine() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DVerSegParabolicArc() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DVertical() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignment2DVerticalSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAlignmentCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAngularDimension() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationCurveOccurrence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationFillArea() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationFillAreaOccurrence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationOccurrence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationSurfaceOccurrence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationSymbolOccurrence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAnnotationTextOccurrence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcApplication() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAppliedValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAppliedValueRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcApproval() -> IfcEntityDesc: ...
    @staticmethod
    def IfcApprovalActorRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcApprovalPropertyRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcApprovalRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcArbitraryClosedProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcArbitraryOpenProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcArbitraryProfileDefWithVoids() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAsset() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAsymmetricIShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAudioVisualAppliance() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAudioVisualApplianceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAxis1Placement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAxis2Placement2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcAxis2Placement3D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBSplineCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBSplineCurveWithKnots() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBSplineSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBSplineSurfaceWithKnots() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBeam() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBeamStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBeamType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBezierCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBlobTexture() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBlock() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoiler() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoilerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBooleanClippingResult() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBooleanResult() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundaryCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundaryCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundaryEdgeCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundaryFaceCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundaryNodeCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundaryNodeConditionWarping() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundedCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundedSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoundingBox() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBoxedHalfSpace() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuilding() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElementComponent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElementPart() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElementPartType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElementProxy() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElementProxyType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingStorey() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBuildingSystem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBurner() -> IfcEntityDesc: ...
    @staticmethod
    def IfcBurnerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableCarrierFitting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableCarrierFittingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableCarrierSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableCarrierSegmentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableFitting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableFittingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCableSegmentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCalendarDate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianPoint() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianPointList() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianPointList2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianPointList3D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianTransformationOperator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianTransformationOperator2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianTransformationOperator2DnonUniform() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianTransformationOperator3D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCartesianTransformationOperator3DnonUniform() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCenterLineProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcChamferEdgeFeature() -> IfcEntityDesc: ...
    @staticmethod
    def IfcChiller() -> IfcEntityDesc: ...
    @staticmethod
    def IfcChillerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcChimney() -> IfcEntityDesc: ...
    @staticmethod
    def IfcChimneyType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCircle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCircleHollowProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCircleProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCircularArcSegment2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCivilElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCivilElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClassification() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClassificationItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClassificationItemRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClassificationNotation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClassificationNotationFacet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClassificationReference() -> IfcEntityDesc: ...
    @staticmethod
    def IfcClosedShell() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoil() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoilType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcColourRgb() -> IfcEntityDesc: ...
    @staticmethod
    def IfcColourRgbList() -> IfcEntityDesc: ...
    @staticmethod
    def IfcColourSpecification() -> IfcEntityDesc: ...
    @staticmethod
    def IfcColumn() -> IfcEntityDesc: ...
    @staticmethod
    def IfcColumnStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcColumnType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCommunicationsAppliance() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCommunicationsApplianceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcComplexProperty() -> IfcEntityDesc: ...
    @staticmethod
    def IfcComplexPropertyTemplate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCompositeCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCompositeCurveOnSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCompositeCurveSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCompositeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCompressor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCompressorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCondenser() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCondenserType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConditionCriterion() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConic() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectedFaceSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionCurveGeometry() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionGeometry() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionPointEccentricity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionPointGeometry() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionPortGeometry() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionSurfaceGeometry() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConnectionVolumeGeometry() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstraint() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstraintAggregationRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstraintClassificationRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstraintRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionEquipmentResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionEquipmentResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionMaterialResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionMaterialResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionProductResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionProductResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConstructionResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcContext() -> IfcEntityDesc: ...
    @staticmethod
    def IfcContextDependentUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcControl() -> IfcEntityDesc: ...
    @staticmethod
    def IfcController() -> IfcEntityDesc: ...
    @staticmethod
    def IfcControllerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConversionBasedUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcConversionBasedUnitWithOffset() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCooledBeam() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCooledBeamType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoolingTower() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoolingTowerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoordinateOperation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoordinateReferenceSystem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoordinatedUniversalTimeOffset() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCostItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCostSchedule() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCostValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCovering() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCoveringType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCraneRailAShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCraneRailFShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCrewResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCrewResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCsgPrimitive3D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCsgSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurrencyRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurtainWall() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurtainWallType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveBoundedPlane() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveBoundedSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveSegment2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveStyleFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveStyleFontAndScaling() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCurveStyleFontPattern() -> IfcEntityDesc: ...
    @staticmethod
    def IfcCylindricalSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDamper() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDamperType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDateAndTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDefinedSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDerivedProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDerivedUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDerivedUnitElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDiameterDimension() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDimensionCalloutRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDimensionCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDimensionCurveDirectedCallout() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDimensionCurveTerminator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDimensionPair() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDimensionalExponents() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDirection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDiscreteAccessory() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDiscreteAccessoryType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistanceExpression() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionChamberElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionChamberElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionCircuit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionControlElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionControlElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionFlowElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionFlowElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionPort() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDistributionSystem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDocumentElectronicFormat() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDocumentInformation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDocumentInformationRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDocumentReference() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDoor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDoorLiningProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDoorPanelProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDoorStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDoorStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDoorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDraughtingCallout() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDraughtingCalloutRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDraughtingPreDefinedColour() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDraughtingPreDefinedCurveFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDraughtingPreDefinedTextFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDuctFitting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDuctFittingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDuctSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDuctSegmentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDuctSilencer() -> IfcEntityDesc: ...
    @staticmethod
    def IfcDuctSilencerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEdge() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEdgeCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEdgeFeature() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEdgeLoop() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricAppliance() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricApplianceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricDistributionBoard() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricDistributionBoardType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricDistributionPoint() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricFlowStorageDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricFlowStorageDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricGenerator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricGeneratorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricHeaterType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricMotor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricMotorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricTimeControl() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricTimeControlType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricalBaseProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricalCircuit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElectricalElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementAssembly() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementAssemblyType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementComponent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementComponentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementQuantity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcElementarySurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEllipse() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEllipseProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEnergyConversionDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEnergyConversionDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEnergyProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEngine() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEngineType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEnvironmentalImpactValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEquipmentElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEquipmentStandard() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEvaporativeCooler() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEvaporativeCoolerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEvaporator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEvaporatorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEvent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEventTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcEventType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExtendedMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExtendedProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternalInformation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternalReference() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternalReferenceRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternalSpatialElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternalSpatialStructureElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternallyDefinedHatchStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternallyDefinedSurfaceStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternallyDefinedSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExternallyDefinedTextFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExtrudedAreaSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcExtrudedAreaSolidTapered() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFace() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFaceBasedSurfaceModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFaceBound() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFaceOuterBound() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFaceSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFacetedBrep() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFacetedBrepWithVoids() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFailureConnectionCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFan() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFanType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFastener() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFastenerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFeatureElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFeatureElementAddition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFeatureElementSubtraction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFillAreaStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFillAreaStyleHatching() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFillAreaStyleTileSymbolWithStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFillAreaStyleTiles() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFilter() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFilterType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFireSuppressionTerminal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFireSuppressionTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFixedReferenceSweptAreaSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowController() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowControllerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowFitting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowFittingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowInstrument() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowInstrumentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowMeter() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowMeterType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowMovingDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowMovingDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowSegmentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowStorageDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowStorageDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowTerminal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowTreatmentDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFlowTreatmentDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFluidFlowProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFooting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFootingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFuelProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFurnishingElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFurnishingElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFurniture() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFurnitureStandard() -> IfcEntityDesc: ...
    @staticmethod
    def IfcFurnitureType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGasTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeneralMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeneralProfileProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeographicElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeographicElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeometricCurveSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeometricRepresentationContext() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeometricRepresentationItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeometricRepresentationSubContext() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGeometricSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGrid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGridAxis() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGridPlacement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcGroup() -> IfcEntityDesc: ...
    @staticmethod
    def IfcHalfSpaceSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcHeatExchanger() -> IfcEntityDesc: ...
    @staticmethod
    def IfcHeatExchangerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcHumidifier() -> IfcEntityDesc: ...
    @staticmethod
    def IfcHumidifierType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcHygroscopicMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcImageTexture() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIndexedColourMap() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIndexedPolyCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIndexedPolygonalFace() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIndexedPolygonalFaceWithVoids() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIndexedTextureMap() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIndexedTriangleTextureMap() -> IfcEntityDesc: ...
    @staticmethod
    def IfcInterceptor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcInterceptorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIntersectionCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcInventory() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIrregularTimeSeries() -> IfcEntityDesc: ...
    @staticmethod
    def IfcIrregularTimeSeriesValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcJunctionBox() -> IfcEntityDesc: ...
    @staticmethod
    def IfcJunctionBoxType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLaborResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLaborResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLagTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLamp() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLampType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLibraryInformation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLibraryReference() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightDistributionData() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightFixture() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightFixtureType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightIntensityDistribution() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightSource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightSourceAmbient() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightSourceDirectional() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightSourceGoniometric() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightSourcePositional() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLightSourceSpot() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLine() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLineSegment2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLinearDimension() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLinearPlacement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLinearPositioningElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLocalPlacement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLocalTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcLoop() -> IfcEntityDesc: ...
    @staticmethod
    def IfcManifoldSolidBrep() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMapConversion() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMappedItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterial() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialClassificationRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialConstituent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialConstituentSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialDefinition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialDefinitionRepresentation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialLayer() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialLayerSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialLayerSetUsage() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialLayerWithOffsets() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialList() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialProfile() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialProfileSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialProfileSetUsage() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialProfileSetUsageTapering() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialProfileWithOffsets() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMaterialUsageDefinition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMeasureWithUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMechanicalConcreteMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMechanicalFastener() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMechanicalFastenerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMechanicalMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMechanicalSteelMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMedicalDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMedicalDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMember() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMemberStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMemberType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMetric() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMirroredProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMonetaryUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMotorConnection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMotorConnectionType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcMove() -> IfcEntityDesc: ...
    @staticmethod
    def IfcNamedUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcObject() -> IfcEntityDesc: ...
    @staticmethod
    def IfcObjectDefinition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcObjectPlacement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcObjective() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOccupant() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOffsetCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOffsetCurve2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOffsetCurve3D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOffsetCurveByDistances() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOneDirectionRepeatFactor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOpenShell() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOpeningElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOpeningStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOpticalMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOrderAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOrganization() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOrganizationRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOrientationExpression() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOrientedEdge() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOuterBoundaryCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOutlet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOutletType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcOwnerHistory() -> IfcEntityDesc: ...
    @staticmethod
    def IfcParameterizedProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPath() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPcurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPerformanceHistory() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPermeableCoveringProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPermit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPerson() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPersonAndOrganization() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPhysicalComplexQuantity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPhysicalQuantity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPhysicalSimpleQuantity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPile() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPileType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPipeFitting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPipeFittingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPipeSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPipeSegmentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPixelTexture() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlacement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlanarBox() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlanarExtent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlane() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlateStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPlateType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPoint() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPointOnCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPointOnSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPolyLoop() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPolygonalBoundedHalfSpace() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPolygonalFaceSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPolyline() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPort() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPositioningElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPostalAddress() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedColour() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedCurveFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedDimensionSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedPointMarkerSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedPropertySet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedTerminatorSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPreDefinedTextFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPresentationItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPresentationLayerAssignment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPresentationLayerWithStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPresentationStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPresentationStyleAssignment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProcedure() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProcedureType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProcess() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProduct() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProductDefinitionShape() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProductRepresentation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProductsOfCombustionProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProfileProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProject() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProjectLibrary() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProjectOrder() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProjectOrderRecord() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProjectedCRS() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProjectionCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProjectionElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProperty() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyAbstraction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyBoundedValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyConstraintRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyDefinition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyDependencyRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyEnumeratedValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyEnumeration() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyListValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyReferenceValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertySet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertySetDefinition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertySetTemplate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertySingleValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyTableValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyTemplate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPropertyTemplateDefinition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProtectiveDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProtectiveDeviceTrippingUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProtectiveDeviceTrippingUnitType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProtectiveDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcProxy() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPump() -> IfcEntityDesc: ...
    @staticmethod
    def IfcPumpType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantityArea() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantityCount() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantityLength() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantitySet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantityTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantityVolume() -> IfcEntityDesc: ...
    @staticmethod
    def IfcQuantityWeight() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRadiusDimension() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRailing() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRailingType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRamp() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRampFlight() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRampFlightType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRampType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRationalBSplineCurveWithKnots() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRationalBSplineSurfaceWithKnots() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRationalBezierCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRectangleHollowProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRectangleProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRectangularPyramid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRectangularTrimmedSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRecurrencePattern() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReference() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReferencesValueDocument() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReferent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRegularTimeSeries() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcementBarProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcementDefinitionProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcingBar() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcingBarType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcingElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcingElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcingMesh() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReinforcingMeshType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAggregates() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssigns() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsTasks() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToActor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToControl() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToGroup() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToGroupByFactor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToProcess() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToProduct() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToProjectOrder() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssignsToResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociates() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesAppliedValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesApproval() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesClassification() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesConstraint() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesDocument() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesLibrary() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesMaterial() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelAssociatesProfileProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnects() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsElements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsPathElements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsPortToElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsPorts() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsStructuralActivity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsStructuralElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsStructuralMember() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsWithEccentricity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelConnectsWithRealizingElements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelContainedInSpatialStructure() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelCoversBldgElements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelCoversSpaces() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDeclares() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDecomposes() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDefines() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDefinesByObject() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDefinesByProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDefinesByTemplate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelDefinesByType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelFillsElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelFlowControlElements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelInteractionRequirements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelInterferesElements() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelNests() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelOccupiesSpaces() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelOverridesProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelProjectsElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelReferencedInSpatialStructure() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelSchedulesCostItems() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelSequence() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelServicesBuildings() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelSpaceBoundary() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelSpaceBoundary1stLevel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelSpaceBoundary2ndLevel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelVoidsElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRelaxation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcReparametrisedCompositeCurveSegment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRepresentation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRepresentationContext() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRepresentationItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRepresentationMap() -> IfcEntityDesc: ...
    @staticmethod
    def IfcResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcResourceApprovalRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcResourceConstraintRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcResourceLevelRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcResourceTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRevolvedAreaSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRevolvedAreaSolidTapered() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRibPlateProfileProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRightCircularCone() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRightCircularCylinder() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRoof() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRoofType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRoot() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRoundedEdgeFeature() -> IfcEntityDesc: ...
    @staticmethod
    def IfcRoundedRectangleProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSIUnit() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSanitaryTerminal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSanitaryTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcScheduleTimeControl() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSchedulingTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSeamCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSectionProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSectionReinforcementProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSectionedSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSectionedSolidHorizontal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSectionedSpine() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSensor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSensorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcServiceLife() -> IfcEntityDesc: ...
    @staticmethod
    def IfcServiceLifeFactor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcShadingDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcShadingDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcShapeAspect() -> IfcEntityDesc: ...
    @staticmethod
    def IfcShapeModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcShapeRepresentation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcShellBasedSurfaceModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSimpleProperty() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSimplePropertyTemplate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSite() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSlab() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSlabElementedCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSlabStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSlabType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSlippageConnectionCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSolarDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSolarDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSolidModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSoundProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSoundValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpace() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpaceHeater() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpaceHeaterType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpaceProgram() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpaceThermalLoadProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpaceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpatialElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpatialElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpatialStructureElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpatialStructureElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpatialZone() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSpatialZoneType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSphere() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSphericalSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStackTerminal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStackTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStair() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStairFlight() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStairFlightType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStairType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralActivity() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralAnalysisModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralConnection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralConnectionCondition() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralCurveAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralCurveConnection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralCurveMember() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralCurveMemberVarying() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralCurveReaction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLinearAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLinearActionVarying() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoad() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadConfiguration() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadGroup() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadLinearForce() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadOrResult() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadPlanarForce() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadSingleDisplacement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadSingleDisplacementDistortion() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadSingleForce() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadSingleForceWarping() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadStatic() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralLoadTemperature() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralMember() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralPlanarAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralPlanarActionVarying() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralPointAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralPointConnection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralPointReaction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralProfileProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralReaction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralResultGroup() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralSteelProfileProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralSurfaceAction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralSurfaceConnection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralSurfaceMember() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralSurfaceMemberVarying() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuralSurfaceReaction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStructuredDimensionCallout() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStyleModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStyledItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcStyledRepresentation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSubContractResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSubContractResourceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSubedge() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceCurveSweptAreaSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceFeature() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceOfLinearExtrusion() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceOfRevolution() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceReinforcementArea() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceStyleLighting() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceStyleRefraction() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceStyleRendering() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceStyleShading() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceStyleWithTextures() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSurfaceTexture() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSweptAreaSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSweptDiskSolid() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSweptDiskSolidPolygonal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSweptSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSwitchingDevice() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSwitchingDeviceType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSymbolStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSystem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSystemFurnitureElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcSystemFurnitureElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTable() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTableColumn() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTableRow() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTank() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTankType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTask() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTaskTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTaskTimeRecurring() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTaskType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTelecomAddress() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTendon() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTendonAnchor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTendonAnchorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTendonType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTerminatorSymbol() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTessellatedFaceSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTessellatedItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextLiteral() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextLiteralWithExtent() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextStyleFontModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextStyleForDefinedFont() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextStyleTextModel() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextStyleWithBoxCharacteristics() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextureCoordinate() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextureCoordinateGenerator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextureMap() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextureVertex() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTextureVertexList() -> IfcEntityDesc: ...
    @staticmethod
    def IfcThermalMaterialProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTimePeriod() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTimeSeries() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTimeSeriesReferenceRelationship() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTimeSeriesSchedule() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTimeSeriesValue() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTopologicalRepresentationItem() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTopologyRepresentation() -> IfcEntityDesc: ...
    @staticmethod
    def IfcToroidalSurface() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTransformer() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTransformerType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTransitionCurveSegment2D() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTransportElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTransportElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTrapeziumProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTriangulatedFaceSet() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTriangulatedIrregularNetwork() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTrimmedCurve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTubeBundle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTubeBundleType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTwoDirectionRepeatFactor() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTypeObject() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTypeProcess() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTypeProduct() -> IfcEntityDesc: ...
    @staticmethod
    def IfcTypeResource() -> IfcEntityDesc: ...
    @staticmethod
    def IfcUShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcUnitAssignment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcUnitaryControlElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcUnitaryControlElementType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcUnitaryEquipment() -> IfcEntityDesc: ...
    @staticmethod
    def IfcUnitaryEquipmentType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcValve() -> IfcEntityDesc: ...
    @staticmethod
    def IfcValveType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVector() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVertex() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVertexBasedTextureMap() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVertexLoop() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVertexPoint() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVibrationIsolator() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVibrationIsolatorType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVirtualElement() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVirtualGridIntersection() -> IfcEntityDesc: ...
    @staticmethod
    def IfcVoidingFeature() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWall() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWallElementedCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWallStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWallType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWasteTerminal() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWasteTerminalType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWaterProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWindow() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWindowLiningProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWindowPanelProperties() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWindowStandardCase() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWindowStyle() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWindowType() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWorkCalendar() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWorkControl() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWorkPlan() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWorkSchedule() -> IfcEntityDesc: ...
    @staticmethod
    def IfcWorkTime() -> IfcEntityDesc: ...
    @staticmethod
    def IfcZShapeProfileDef() -> IfcEntityDesc: ...
    @staticmethod
    def IfcZone() -> IfcEntityDesc: ...
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def isDerivedFrom(self, entDesc: PyBrxBim.IfcEntityDesc, eSchema: IfcSchemaId, /) -> bool: ...
    def name(self, /) -> str: ...

class IfcEnumValue:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getValue(self, /) -> str: ...
    def setValue(self, val: str, /) -> None: ...

class IfcExportContext:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def database(self, /) -> PyDb.Database: ...
    def getAxis2Placement2D(self, coordSystem: PyGe.Matrix2d, /) -> IfcEntity: ...
    def getAxis2Placement3D(self, coordSystem: PyGe.Matrix3d, /) -> IfcEntity: ...
    def getCartesianPoint2D(self, pt: PyGe.Point2d, /) -> IfcEntity: ...
    def getCartesianPoint3D(self, pt: PyGe.Point3d, /) -> IfcEntity: ...
    def getDirection2D(self, vec: PyGe.Vector3d, /) -> IfcEntity: ...
    def getDirection3D(self, vec: PyGe.Vector3d, /) -> IfcEntity: ...
    def getProduct(self, val: PyDb.ObjectId | PyDb.FullSubentPath, /) -> IfcEntity: ...
    def ifcModel(self, /) -> IfcModel: ...
    @overload
    def setIfcRootData(self, ifcObject: PyBrxBim.IfcEntity, /) -> bool: ...
    @overload
    def setIfcRootData(
        self,
        ifcObject: PyBrxBim.IfcEntity,
        name: str,
        description: str,
        guid: str,
        hist: PyBrxBim.IfcEntity,
        /,
    ) -> bool: ...
    @overload
    def setIfcRootData(self, *args) -> bool: ...
    def setLocationRelToAssignedSpatialLocation(
        self,
        ifcElement: PyBrxBim.IfcEntity,
        correspondingEntity: PyDb.Entity,
        relativeCoordSys: PyGe.Matrix3d,
        /,
    ) -> bool: ...
    def setLocationRelToBuilding(
        self, ifcElement: PyBrxBim.IfcEntity, buildingName: str, relativeCoordSys: PyGe.Matrix3d, /
    ) -> bool: ...
    def setLocationRelToStory(
        self,
        ifcElement: PyBrxBim.IfcEntity,
        buildingName: str,
        storyName: str,
        relativeCoordSys: PyGe.Matrix3d,
        /,
    ) -> bool: ...
    def setLocationRelToWCS(
        self, ifcObject: PyBrxBim.IfcEntity, relativeCoordSys: PyGe.Matrix3d, /
    ) -> bool: ...
    def setMaterialToAssignedComposition(
        self,
        ifcObject: PyBrxBim.IfcEntity,
        correspondingEntity: PyDb.Entity,
        thicknessVariableLayer: float,
        /,
    ) -> bool: ...
    def setMaterialToComposition(
        self, ifcObject: PyBrxBim.IfcEntity, compositionName: str, thicknessVariableLayer: float, /
    ) -> bool: ...
    def setRepresentationAsBrep(
        self, ifcProduct: PyBrxBim.IfcEntity, correspondingEntity: PyDb.Entity, /
    ) -> bool: ...
    def setRepresentationAsClippedExtrudedAreaSolid(
        self,
        ifcProduct: PyBrxBim.IfcEntity,
        correspondingSolid: PyDb.Solid3d,
        extrusionDirection: PyGe.Vector3d,
        /,
    ) -> bool: ...
    def setRepresentationAsExtrudedAreaSolid(
        self,
        ifcProduct: PyBrxBim.IfcEntity,
        correspondingSolid: PyDb.Solid3d,
        preferredSweepingDirections: PyGe.Vector3d,
        /,
    ) -> bool: ...

class IfcExportOptionFlags(_BoostPythonEnum):
    eBaseQuantities: ClassVar[Self]  # 1
    eIncludeFrozenHidden: ClassVar[Self]  # 2
    eExplodeXrefs: ClassVar[Self]  # 4
    eAggregateMultiPly: ClassVar[Self]  # 8
    eMergeGuidForBlocks: ClassVar[Self]  # 16
    eMergeGuidForXrefs: ClassVar[Self]  # 32
    eTesselateBSplines: ClassVar[Self]  # 64
    eSweptSolidsAsBRep: ClassVar[Self]  # 128
    eProfileCenterOfGravity: ClassVar[Self]  # 256

class IfcExportOptions:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def exportIfcFile(
        db: PyAp.Document, filename: str, options: PyBrxBim.IfcExportOptions = ..., /
    ) -> None: ...
    def ifcVersion(self, /) -> IfcSchemaId: ...
    def mvdType(self, /) -> IfcModelViewDefType: ...
    def nestedObjectsToExport(self, /) -> list: ...
    def objectsToExport(self, /) -> list: ...
    def option(self, /) -> bool: ...
    def optionFlags(self, /) -> int: ...
    def setIfcVersion(self, val: PyBrxBim.IfcSchemaId, /) -> None: ...
    def setMvdType(self, val: PyBrxBim.IfcModelViewDefType, /) -> None: ...
    def setNestedObjectsToExport(self, ids: list[PyDb.FullSubentPath], /) -> None: ...
    def setObjectsToExport(self, ids: list[PyDb.ObjectId], /) -> None: ...
    def setOption(self, option: PyBrxBim.IfcExportOptionFlags, value: bool, /) -> None: ...
    def setOptionFlags(self, val: int, /) -> None: ...

class IfcExportReactor:
    def __init__(self, displayName: str, guid: str, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def adjustProjectData(
        self, context: PyBrxBim.IfcExportContext, project: PyBrxBim.IfcProjectData, /
    ) -> None: ...
    def attachReactor(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def detachReactor(self, /) -> bool: ...
    def onBeginIfcModelSetup(self, context: PyBrxBim.IfcExportContext, /) -> None: ...
    def onEndIfcModelSetup(self, context: PyBrxBim.IfcExportContext, /) -> None: ...
    def onEntity(
        self, context: PyBrxBim.IfcExportContext, entity: PyDb.Entity, /
    ) -> IfcEntity: ...
    def onEntityConstructed(
        self, contructedEntity: PyBrxBim.IfcEntity, sourceBCEntity: PyDb.Entity, /
    ) -> None: ...

class IfcGuid:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def create() -> IfcGuid: ...
    @staticmethod
    def createFromBase64(val: str, /) -> IfcGuid: ...
    @staticmethod
    def createFromText(val: str, /) -> IfcGuid: ...
    def getBase64(self, /) -> str: ...
    def getText(self, /) -> str: ...

class IfcHeader:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def author(self, /) -> IfcString: ...
    def authorization(self, /) -> IfcString: ...
    @staticmethod
    def className() -> str: ...
    def fileDescription(self, /) -> IfcString: ...
    def fileName(self, /) -> IfcString: ...
    def fileSchema(self, /) -> IfcString: ...
    def implementationLevel(self, /) -> IfcString: ...
    def organization(self, /) -> IfcString: ...
    def originatingSystem(self, /) -> IfcString: ...
    def preprocessorVersion(self, /) -> IfcString: ...
    def setAuthor(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setAuthorization(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setFileDescription(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setFileName(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setFileSchema(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setOrganization(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setOriginatingSystem(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setPreprocessorVersion(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setTimeStamp(self, val: PyBrxBim.IfcString, /) -> None: ...
    def timeStamp(self, /) -> IfcString: ...

class IfcImportContext:
    def IfcModel(self, /) -> IfcModel: ...
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def angleConversionFactor(self, /) -> float: ...
    def areaConversionFactor(self, /) -> float: ...
    @staticmethod
    def className() -> str: ...
    def createDefaultRepresentation(
        self, entity: PyBrxBim.IfcEntity, isParent: bool, parent: PyBrxBim.IfcEntity, /
    ) -> PyDb.Entity: ...
    def createPoint(self, entity: PyBrxBim.IfcEntity, /) -> PyGe.Point3d: ...
    def createRepresentationFromItem(self, entity: PyBrxBim.IfcEntity, /) -> PyDb.Entity: ...
    def createSweptArea(self, entity: PyBrxBim.IfcEntity, /) -> list: ...
    def database(self, /) -> PyDb.Database: ...
    def getEntity(self, entity: PyBrxBim.IfcEntity, /) -> PyDb.Entity: ...
    def getEntityId(self, entity: PyBrxBim.IfcEntity, /) -> PyDb.ObjectId: ...
    def getLocalPlacement(self, entity: PyBrxBim.IfcEntity, /) -> PyGe.Matrix3d: ...
    def lengthConversionFactor(self, /) -> float: ...
    def precision(self, /) -> float: ...
    def volumeConversionFactor(self, /) -> float: ...

class IfcImportInfo:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def author(self, /) -> str: ...
    def authorization(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    def importBimData(self, /) -> bool: ...
    def importBrepGeometryAsMeshes(self, /) -> bool: ...
    def importIfcProjectStructureAsXrefs(self, /) -> bool: ...
    def importIfcSpace(self, /) -> bool: ...
    def importParametricComponents(self, /) -> bool: ...
    def organization(self, /) -> str: ...
    def originatingSystem(self, /) -> str: ...
    def preprocessorVersion(self, /) -> str: ...
    def timeStamp(self, /) -> str: ...

class IfcImportModelOrigin(_BoostPythonEnum):
    eIfcGlobalOrigin: ClassVar[Self]  # 0
    eIfcSiteLocation: ClassVar[Self]  # 1
    eIfcProjectLocation: ClassVar[Self]  # 2

class IfcImportOptions:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def importBimData(self, /) -> bool: ...
    def importBrepGeometryAsMeshes(self, /) -> bool: ...
    @staticmethod
    def importIfcFile(
        db: PyDb.Database, filename: str, options: PyBrxBim.IfcImportOptions = ..., /
    ) -> None: ...
    def importIfcProjectStructureAsXrefs(self, /) -> bool: ...
    def importIfcSpace(self, /) -> bool: ...
    def importModelOrigin(self, /) -> IfcImportModelOrigin: ...
    def importParametricComponents(self, /) -> bool: ...
    def setImportBimData(self, val: bool, /) -> None: ...
    def setImportBrepGeometryAsMeshes(self, val: bool, /) -> None: ...
    def setImportIfcProjectStructureAsXrefs(self, val: bool, /) -> None: ...
    def setImportIfcSpace(self, val: bool, /) -> None: ...
    def setImportModelOrigin(self, val: PyBrxBim.IfcImportModelOrigin, /) -> None: ...
    def setImportParametricComponents(self, val: bool, /) -> None: ...

class IfcImportReactor:
    def __init__(self, displayName: str, guid: str, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def attachReactor(self, /) -> bool: ...
    def beforeCompletion(self, context: PyBrxBim.IfcImportContext, success: bool, /) -> None: ...
    @staticmethod
    def className() -> str: ...
    def detachReactor(self, /) -> bool: ...
    def onIfcProduct(
        self,
        context: PyBrxBim.IfcImportContext,
        entity: PyBrxBim.IfcEntity,
        isParent: bool,
        parentEntity: PyBrxBim.IfcEntity,
        /,
    ) -> bool: ...
    def onIfcProductImported(
        self, desc: PyBrxBim.IfcEntityDesc, schema: PyBrxBim.EIfcSchemaId, /
    ) -> None: ...
    def onStart(
        self,
        context: PyBrxBim.IfcImportContext,
        project: PyBrxBim.IfcEntity,
        info: PyBrxBim.IfcImportInfo,
        /,
    ) -> None: ...

class IfcLogical:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def isKnown(self, /) -> bool: ...
    def isUnknown(self, /) -> bool: ...

class IfcModel:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def get(self, index: int, /) -> IfcEntity: ...
    def getNumEntities(self, /) -> int: ...
    @staticmethod
    def read(fileName: str, /) -> IfcModel: ...
    def release(self, /) -> None: ...
    def schemaId(self, /) -> IfcSchemaId: ...
    @staticmethod
    def write(fileName: str, header: PyBrxBim.IfcHeader, /) -> bool: ...

class IfcModelViewDefType(_BoostPythonEnum):
    eNotSet: ClassVar[Self]  # 0
    eReference: ClassVar[Self]  # 1
    eDesignTransfer: ClassVar[Self]  # 2

class IfcProjectData:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getApplicationDeveloper(self, /) -> str: ...
    def getApplicationFullName(self, /) -> str: ...
    def getApplicationIdentifier(self, /) -> str: ...
    def getApplicationVersion(self, /) -> str: ...
    def getAuthorFamilyName(self, /) -> str: ...
    def getAuthorGivenName(self, /) -> str: ...
    def getAuthorOrganization(self, /) -> str: ...
    def getProjectDescription(self, /) -> str: ...
    def getProjectName(self, /) -> str: ...
    def getProjectNorthAngle(self, /) -> float: ...
    def getProjectPhase(self, /) -> str: ...
    def getSiteAddressLines(self, /) -> str: ...
    def getSiteBuildableArea(self, /) -> float: ...
    def getSiteBuildingHeightLimit(self, /) -> float: ...
    def getSiteCountry(self, /) -> str: ...
    def getSiteDescription(self, /) -> str: ...
    def getSiteElevation(self, /) -> float: ...
    def getSiteInternalLocation(self, /) -> str: ...
    def getSiteLandTitleNumber(self, /) -> str: ...
    def getSiteLatitude(self, /) -> float: ...
    def getSiteLongitude(self, /) -> float: ...
    def getSiteName(self, /) -> str: ...
    def getSitePostalBox(self, /) -> str: ...
    def getSitePostalCode(self, /) -> str: ...
    def getSiteRegion(self, /) -> str: ...
    def getSiteTotalArea(self, /) -> float: ...
    def getSiteTown(self, /) -> str: ...
    def setApplicationDeveloper(self, val: str, /) -> None: ...
    def setApplicationFullName(self, val: str, /) -> None: ...
    def setApplicationIdentifier(self, val: str, /) -> None: ...
    def setApplicationVersion(self, val: str, /) -> None: ...
    def setAuthorFamilyName(self, val: str, /) -> None: ...
    def setAuthorGivenName(self, val: str, /) -> None: ...
    def setAuthorOrganization(self, val: str, /) -> None: ...
    def setProjectDescription(self, val: str, /) -> None: ...
    def setProjectName(self, val: str, /) -> None: ...
    def setProjectNorthAngle(self, val: float, /) -> None: ...
    def setProjectPhase(self, val: str, /) -> None: ...
    def setSiteAddressLines(self, val: str, /) -> None: ...
    def setSiteBuildableArea(self, val: float, /) -> None: ...
    def setSiteBuildingHeightLimit(self, val: float, /) -> None: ...
    def setSiteCountry(self, val: str, /) -> None: ...
    def setSiteDescription(self, val: str, /) -> None: ...
    def setSiteElevation(self, val: float, /) -> None: ...
    def setSiteInternalLocation(self, val: str, /) -> None: ...
    def setSiteLandTitleNumber(self, val: str, /) -> None: ...
    def setSiteLatitude(self, val: float, /) -> None: ...
    def setSiteName(self, val: str, /) -> None: ...
    def setSitePostalBox(self, val: str, /) -> None: ...
    def setSitePostalCode(self, val: str, /) -> None: ...
    def setSiteRegion(self, val: str, /) -> None: ...
    def setSiteTotalArea(self, val: float, /) -> None: ...
    def setSiteTown(self, val: str, /) -> None: ...
    def setSitelongitude(self, val: float, /) -> None: ...

class IfcResult(_BoostPythonEnum):
    eOk: ClassVar[Self]  # 0
    eNotInitialized: ClassVar[Self]  # 1
    eWrongName: ClassVar[Self]  # 2
    eWrongType: ClassVar[Self]  # 3
    eInternalError: ClassVar[Self]  # 4

class IfcSchemaId(_BoostPythonEnum):
    eIFC2X3: ClassVar[Self]  # 0
    eIFC4: ClassVar[Self]  # 1
    eIFC4X1: ClassVar[Self]  # 2
    eIfcSchemaLast: ClassVar[Self]  # 2

class IfcSelectValue:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getValue(self, /) -> IfcVariant: ...
    def isNull(self, /) -> bool: ...
    def setValue(self, tag: str, val: PyBrxBim.IfcVariant, /) -> str: ...
    def tag(self, /) -> str: ...

class IfcSelectorDesc:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class IfcString:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, text: str, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def c_str(self, /) -> str: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def decode(val: str, /) -> IfcString: ...
    def getEncoded(self, /) -> str: ...
    def isEmpty(self, /) -> bool: ...
    def setEmpty(self, /) -> None: ...

class IfcValueType(_BoostPythonEnum):
    eBool: ClassVar[Self]  # 0
    eInt: ClassVar[Self]  # 1
    eUInt: ClassVar[Self]  # 2
    eReal: ClassVar[Self]  # 3
    eString: ClassVar[Self]  # 4
    eEntity: ClassVar[Self]  # 5
    eLogical: ClassVar[Self]  # 6
    eBinary: ClassVar[Self]  # 7
    eGuid: ClassVar[Self]  # 8
    eEnum: ClassVar[Self]  # 9
    eSelect: ClassVar[Self]  # 10
    eVector: ClassVar[Self]  # 11
    eEmpty: ClassVar[Self]  # 12

class IfcVariant:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getBinary(self, /) -> IfcBinary: ...
    def getBool(self, /) -> bool: ...
    def getEntity(self, /) -> IfcEntity: ...
    def getEnum(self, /) -> IfcEnumValue: ...
    def getGuid(self, /) -> IfcGuid: ...
    def getInt(self, /) -> int: ...
    def getLogical(self, /) -> IfcLogical: ...
    def getReal(self, /) -> float: ...
    def getSelect(self, /) -> IfcSelectValue: ...
    def getString(self, /) -> IfcString: ...
    def getUInt(self, /) -> int: ...
    def getVector(self, /) -> IfcVectorValue: ...
    def setBinary(self, val: PyBrxBim.IfcBinary, /) -> None: ...
    def setBool(self, val: bool, /) -> None: ...
    def setEntity(self, val: PyBrxBim.IfcEntity, /) -> None: ...
    def setEnum(self, val: PyBrxBim.IfcEnumValue, /) -> None: ...
    def setGuid(self, val: PyBrxBim.IfcGuid, /) -> None: ...
    def setInt(self, val: int, /) -> None: ...
    def setLogical(self, val: PyBrxBim.IfcLogical, /) -> None: ...
    def setReal(self, val: float, /) -> None: ...
    def setSelect(self, val: PyBrxBim.IfcVectorValue, /) -> None: ...
    def setString(self, val: PyBrxBim.IfcString, /) -> None: ...
    def setUInt(self, val: int, /) -> None: ...
    def setVector(self, val: PyBrxBim.IfcVectorValue, /) -> None: ...
    def type(self, /) -> IfcValueType: ...

class IfcVectorDesc:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class IfcVectorValue:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def add(self, val: PyBrxBim.IfcVariant, /) -> IfcResult: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def isNull(self, /) -> bool: ...
    def remove(self, val: int, /) -> bool: ...
    def size(self, /) -> int: ...
    def values(self, /) -> list: ...

class PyBrxBimPropertySets:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class ResultStatus(_BoostPythonEnum):
    eOk: ClassVar[Self]  # 0
    eNoDbResidentObject: ClassVar[Self]  # 1
    eDbNotAccessible: ClassVar[Self]  # 2
    eDbObjectNotSupported: ClassVar[Self]  # 3
    eDbNotOpenForWrite: ClassVar[Self]  # 4
    eModelSpaceNotAccessible: ClassVar[Self]  # 5
    eProjectDbNotAccessible: ClassVar[Self]  # 6
    eAssociatedLibraryNotAccessible: ClassVar[Self]  # 7
    eNotApplicableForTheseParameters: ClassVar[Self]  # 8
    eInvalidSpatialLocation: ClassVar[Self]  # 9
    eInvalidMaterial: ClassVar[Self]  # 10
    eInvalidMaterialComposition: ClassVar[Self]  # 11
    eObjectAlreadyExists: ClassVar[Self]  # 12
    eObjectCouldNotBeDeleted: ClassVar[Self]  # 13
    eXmlFileCouldNotBeParsed: ClassVar[Self]  # 14
    eInvalidXmlFormat: ClassVar[Self]  # 15
    eInvalidName: ClassVar[Self]  # 16
    eNotLinearBuildingElement: ClassVar[Self]  # 17
    eInvalidValue: ClassVar[Self]  # 18
    eNotAssignedToLibrary: ClassVar[Self]  # 19
    eNullObject: ClassVar[Self]  # 20
    eNullObjectId: ClassVar[Self]  # 21
    eNullDatabase: ClassVar[Self]  # 22
    eNullDocument: ClassVar[Self]  # 23
    eNullString: ClassVar[Self]  # 24
    eObjectNotExisting: ClassVar[Self]  # 25
    eObjectNotSupported: ClassVar[Self]  # 26
    eNoProfileAssigned: ClassVar[Self]  # 27
    eNoData: ClassVar[Self]  # 28
    eUnknownData: ClassVar[Self]  # 29
    eWrongDataType: ClassVar[Self]  # 30
    eUnassignedEntity: ClassVar[Self]  # 31
    eBimNotImplementedYet: ClassVar[Self]  # 32
    eBimNotAvailable: ClassVar[Self]  # 33
    eInternalError: ClassVar[Self]  # 34
    eUnknownError: ClassVar[Self]  # 35
    eInvalidIndex: ClassVar[Self]  # 36
    eInvalidInput: ClassVar[Self]  # 37
    eNoNameSpace: ClassVar[Self]  # 38
    eNameSpaceAlreadyExists: ClassVar[Self]  # 39
    eNoPropertySet: ClassVar[Self]  # 40
    ePropertySetAlreadyExists: ClassVar[Self]  # 41
    eNoProperty: ClassVar[Self]  # 42
    eNotImplemented: ClassVar[Self]  # 43
    eInvalidArgument: ClassVar[Self]  # 44
    eNoAttributeSet: ClassVar[Self]  # 45
