from __future__ import annotations

from typing import Any, ClassVar, Self, overload

from pyrx import Brx as PyBrx
from pyrx import Cv as PyBrxCv
from pyrx import Db as PyDb
from pyrx import Ge as PyGe
from pyrx import Rx as PyRx
from pyrx.doc_utils.boost_meta import _BoostPythonEnum

Decreasing: StationEquationType  # 1
Increasing: StationEquationType  # 0
eAddBoundaries: TinSurfaceDefinitionType  # 10
eAddBreaklines: TinSurfaceDefinitionType  # 9
eAddDrawingObjects: TinSurfaceDefinitionType  # 22
eAddLine: TinSurfaceDefinitionType  # 16
eAddLines: TinSurfaceDefinitionType  # 17
eAddPoint: TinSurfaceDefinitionType  # 2
eAddPointClouds: TinSurfaceDefinitionType  # 28
eAddPointFiles: TinSurfaceDefinitionType  # 26
eAddPointGroups: TinSurfaceDefinitionType  # 27
eAddPoints: TinSurfaceDefinitionType  # 3
eAddWalls: TinSurfaceDefinitionType  # 11
eAlignment: Civil3dEntityType  # 0
eAlignmentsLabels: Civil3dLabels  # 2
eAllLabels: Civil3dLabels  # 255
eAngle: VAlignmentParameterConstraint  # 4
eArc: VAlignmentElementType  # 2
eArc_BestFit: HAlignmentParameterConstraint  # 310
eArc_CenterPassThrough: HAlignmentParameterConstraint  # 302
eArc_CenterRadius: HAlignmentParameterConstraint  # 301
eArc_PassThrough: HAlignmentParameterConstraint  # 307
eArc_PassThroughAttachToEnd: HAlignmentParameterConstraint  # 304
eArc_PassThroughDirection: HAlignmentParameterConstraint  # 305
eArc_PassThroughRadius: HAlignmentParameterConstraint  # 303
eArc_PointOnTangent: HAlignmentParameterConstraint  # 309
eArc_Radius: HAlignmentParameterConstraint  # 306
eArc_RadiusAndLength: HAlignmentParameterConstraint  # 308
eArc_ThreePoints: HAlignmentParameterConstraint  # 300
eAutomatic: VAlignmentParameterConstraint  # 5
eBlock: DrawingObjectType  # 2
eBlockAttachmentBottomCenter: BlockAttachment  # 7
eBlockAttachmentBottomLeft: BlockAttachment  # 6
eBlockAttachmentBottomRight: BlockAttachment  # 8
eBlockAttachmentInsertionPoint: BlockAttachment  # 9
eBlockAttachmentMiddleCenter: BlockAttachment  # 4
eBlockAttachmentMiddleLeft: BlockAttachment  # 3
eBlockAttachmentMiddleRight: BlockAttachment  # 5
eBlockAttachmentTopCenter: BlockAttachment  # 1
eBlockAttachmentTopLeft: BlockAttachment  # 0
eBlockAttachmentTopRight: BlockAttachment  # 2
eBorderTypeCircular: BorderType  # 2
eBorderTypeRectangular: BorderType  # 0
eBorderTypeRoundedRectangular: BorderType  # 1
eBoth: VAlignmentTangencyConstraint  # 4
eBrxCvDataTypeAngle: CvDataType  # 7
eBrxCvDataTypeArea: CvDataType  # 9
eBrxCvDataTypeAzimuth: CvDataType  # 10
eBrxCvDataTypeBool: CvDataType  # 1
eBrxCvDataTypeDate: CvDataType  # 4
eBrxCvDataTypeDirection: CvDataType  # 11
eBrxCvDataTypeDistance: CvDataType  # 12
eBrxCvDataTypeElevation: CvDataType  # 13
eBrxCvDataTypeInteger: CvDataType  # 3
eBrxCvDataTypeLatitude: CvDataType  # 15
eBrxCvDataTypeLinear: CvDataType  # 5
eBrxCvDataTypeLongitude: CvDataType  # 16
eBrxCvDataTypeNone: CvDataType  # 0
eBrxCvDataTypeRatio: CvDataType  # 8
eBrxCvDataTypeRotation: CvDataType  # 17
eBrxCvDataTypeSlope: CvDataType  # 14
eBrxCvDataTypeSpeed: CvDataType  # 19
eBrxCvDataTypeStation: CvDataType  # 6
eBrxCvDataTypeString: CvDataType  # 2
eBrxCvDataTypeVolume: CvDataType  # 18
eCenterline: Civil3dAlignmentType  # 0
eChordLength: ArcParameterType  # 3
eCivilPoint: DrawingObjectType  # 7
eClothoid: SpiralParameterType  # 0
eCompound: ArcType  # 0
eContourLabel: StyleManagerType  # 4
eCreateFromC3D: TinSurfaceDefinitionType  # 36
eCreateFromContours: TinSurfaceDefinitionType  # 38
eCreateFromCorridor: TinSurfaceDefinitionType  # 35
eCreateFromFaces: TinSurfaceDefinitionType  # 21
eCreateMerged: TinSurfaceDefinitionType  # 32
eCreateSnapshot: TinSurfaceDefinitionType  # 23
eCreateTypedSnapshot: TinSurfaceDefinitionType  # 34
eCubicParabola: SpiralParameterType  # 0
eCurbReturn: Civil3dAlignmentType  # 2
eCurveAngle: ArcParameterType  # 7
eCurveCurveReverseCurve: HAlignmentElementType  # 19
eCurveLabel: StyleManagerType  # 2
eCurveLength: ArcParameterType  # 4
eCurveLineCurve: HAlignmentElementType  # 17
eCurveReverseCurve: HAlignmentElementType  # 18
eCurveSpiral: HAlignmentElementType  # 9
eCurveSpiralSpiral: HAlignmentElementType  # 16
eCurveThroughPoint: ArcParameterType  # 8
eCustomSymbolFrameCircle: CustomSymbol  # 32
eCustomSymbolFrameSquare: CustomSymbol  # 64
eCustomSymbolSpotCross: CustomSymbol  # 2
eCustomSymbolSpotCross45: CustomSymbol  # 3
eCustomSymbolSpotEmpty: CustomSymbol  # 1
eCustomSymbolSpotPoint: CustomSymbol  # 0
eCustomSymbolSpotVerticalLine: CustomSymbol  # 4
eDefaultLabels: Civil3dLabels  # 6
eDeform: TinSurfaceDefinitionType  # 30
eDegreeOfCurve: ArcParameterType  # 1
eDeleteEdge: TinSurfaceDefinitionType  # 14
eDeleteEdges: TinSurfaceDefinitionType  # 15
eDeletePoint: TinSurfaceDefinitionType  # 4
eDeletePoints: TinSurfaceDefinitionType  # 5
eDirectionLeft: SpiralDirectionType  # 1
eDirectionRight: SpiralDirectionType  # 0
eDisplayModeAsComposed: DisplayMode  # 0
eDisplayModeStackedText: DisplayMode  # 1
eDisplayOrientationModel: DisplayOrientation  # 1
eDisplayOrientationPlan: DisplayOrientation  # 0
eDisplayOrientationProfile: DisplayOrientation  # 2
eDisplayOrientationSection: DisplayOrientation  # 3
eDynamicSurface: VAlignmentType  # 2
eElementExtensions: HAlignmentVisualStyle  # 4
eElements: VAlignmentVisualStyle  # 1
eExtensions: VAlignmentVisualStyle  # 4
eExternalDist: ArcParameterType  # 5
eFace: DrawingObjectType  # 5
eFixed: VAlignmentTangencyConstraint  # 1
eForcedInsertionBottom: ForcedInsertion  # 2
eForcedInsertionNone: ForcedInsertion  # 0
eForcedInsertionTop: ForcedInsertion  # 1
eGradingAccurate: GradingCalculationMethod  # 0
eGradingDrawDaylight: GradingVisualStyle  # 4
eGradingDrawNothing: GradingVisualStyle  # 0
eGradingDrawRays: GradingVisualStyle  # 2
eGradingDrawSurface: GradingVisualStyle  # 1
eGradingFast: GradingCalculationMethod  # 1
eGradingGradingOutsideSurface: GradingStatus  # 64
eGradingIncorrectInputData: GradingStatus  # 4
eGradingInputDataMissing: GradingStatus  # 2048
eGradingInputDataOutsideSurface: GradingStatus  # 32
eGradingInvalidInput: GradingStatus  # 4096
eGradingInvalidRule: GradingStatus  # 8192
eGradingMultipleOffsetResult: GradingStatus  # 256
eGradingNoStatus: GradingStatus  # 0
eGradingOffsetFailed: GradingStatus  # 128
eGradingOk: GradingStatus  # 1
eGradingRuleMissing: GradingStatus  # 16
eGradingSideLeft: GradingSide  # 0
eGradingSideNone: GradingSide  # -1
eGradingSideRight: GradingSide  # 1
eGradingSurfaceMissing: GradingStatus  # 8
eGradingTimeout: GradingStatus  # 16384
eGradingTypeNone: GradingType  # -1
eGradingTypeSlopeOffset: GradingType  # 1
eGradingTypeSlopeSurface: GradingType  # 0
eGradingUnknownError: GradingStatus  # 1024
eGradingUpdateNeeded: GradingStatus  # 2
eGradingZeroGrading: GradingStatus  # 512
eGroupDefinitions: TinSurfaceDefinitionType  # 29
eIFC: TinSurfaceDefinitionType  # 33
eInCurve: SpiralCurveType  # 0
eLabelAnchorBottomCenter: LabelAnchor  # 10
eLabelAnchorBottomLeft: LabelAnchor  # 9
eLabelAnchorBottomRight: LabelAnchor  # 11
eLabelAnchorCurveCenter: LabelAnchor  # 13
eLabelAnchorCurvePI: LabelAnchor  # 14
eLabelAnchorEnd: LabelAnchor  # 2
eLabelAnchorFeatureLocation: LabelAnchor  # 69
eLabelAnchorInsertionPoint: LabelAnchor  # 12
eLabelAnchorMiddle: LabelAnchor  # 1
eLabelAnchorMiddleCenter: LabelAnchor  # 7
eLabelAnchorMiddleLeft: LabelAnchor  # 6
eLabelAnchorMiddleRight: LabelAnchor  # 8
eLabelAnchorStart: LabelAnchor  # 0
eLabelAnchorTopCenter: LabelAnchor  # 4
eLabelAnchorTopLeft: LabelAnchor  # 3
eLabelAnchorTopRight: LabelAnchor  # 5
eLabelAnchors: LabelAnchor  # 0
eLandXML: TinSurfaceDefinitionType  # 25
eLayout: VAlignmentType  # 0
eLeaderAttachmentBottomOfBottomLine: LeaderAttachment  # 4
eLeaderAttachmentMiddle: LeaderAttachment  # 2
eLeaderAttachmentMiddleOfBottomLine: LeaderAttachment  # 3
eLeaderAttachmentMiddleOfTopLine: LeaderAttachment  # 1
eLeaderAttachmentTopOfTopLine: LeaderAttachment  # 0
eLeaderTypeSpline: LeaderType  # 1
eLeaderTypeStraight: LeaderType  # 0
eLength: VAlignmentParameterConstraint  # 3
eLengthTypeFixed: LengthType  # 0
eLengthTypePercentage: LengthType  # 1
eLine: DrawingObjectType  # 4
eLineLabel: StyleManagerType  # 1
eLineSpiral: HAlignmentElementType  # 7
eLine_BestFit: HAlignmentParameterConstraint  # 203
eLine_Length: HAlignmentParameterConstraint  # 202
eLine_ThroughPoint: HAlignmentParameterConstraint  # 201
eLine_TwoPoints: HAlignmentParameterConstraint  # 200
eMerge: TinSurfaceDefinitionType  # 13
eMiddleOrdinate: ArcParameterType  # 6
eMinimizeFlatAreas: TinSurfaceDefinitionType  # 39
eMiscellaneous: Civil3dAlignmentType  # 4
eModifyPointElevation: TinSurfaceDefinitionType  # 18
eModifyPointsElevation: TinSurfaceDefinitionType  # 19
eModifyPointsElevations: TinSurfaceDefinitionType  # 20
eMovePoint: TinSurfaceDefinitionType  # 7
eMovePoints: TinSurfaceDefinitionType  # 8
eMultipleSegments: HAlignmentElementType  # 11
eNext: VAlignmentTangencyConstraint  # 3
eNoEntity: Civil3dEntityType  # -1
eNoLabels: Civil3dLabels  # 0
eNone: TinSurfaceDefinitionType  # 0
eNotAlignment: Civil3dAlignmentType  # -1
eNotProfile: Civil3dProfileType  # -1
eOffset: Civil3dAlignmentType  # 1
eOrientationReferenceObject: OrientationRef  # 0
eOrientationReferenceStartLeaderAtMarker: OrientationRef  # 9
eOrientationReferenceView: OrientationRef  # 1
eOrientationReferenceWCS: OrientationRef  # 2
eOutCurve: SpiralCurveType  # 1
ePI: HAlignmentElementType  # 100
ePVI: VAlignmentElementType  # 100
eParabola: VAlignmentElementType  # 3
eParamA: SpiralParameterType2  # 0
eParamLength: SpiralParameterType2  # 1
ePassThroughPoints: VAlignmentParameterConstraint  # 1
ePoint: DrawingObjectType  # 1
ePointLabel: StyleManagerType  # 3
ePointOnTangent: VAlignmentParameterConstraint  # 6
ePolyline: DrawingObjectType  # 6
ePrevious: VAlignmentTangencyConstraint  # 2
eProfile: Civil3dEntityType  # 1
eProfileView: Civil3dEntityType  # 3
eQuick: Civil3dProfileType  # 3
eRadius: VAlignmentParameterConstraint  # 2
eRail: Civil3dAlignmentType  # 3
eRemoveBelowAboveElevation: TinSurfaceDefinitionType  # 41
eRemoveOuterEdges: TinSurfaceDefinitionType  # 37
eReverse: ArcType  # 1
eRiseLower: TinSurfaceDefinitionType  # 24
eSCS_PointOnTangent: HAlignmentParameterConstraint  # 412
eSCS_SpiralAVal: HAlignmentParameterConstraint  # 411
eSCS_SpiralAValRadius: HAlignmentParameterConstraint  # 410
eSCS_SpiralAValRadiusArcLength: HAlignmentParameterConstraint  # 409
eSCS_SpiralAValRadiusPassThrough: HAlignmentParameterConstraint  # 408
eSCS_SpiralInAValRadiusSpiralOutAVal: HAlignmentParameterConstraint  # 407
eSCS_SpiralInAValSpiralOutAVal: HAlignmentParameterConstraint  # 406
eSCS_SpiralInLengthSpiralOutLength: HAlignmentParameterConstraint  # 405
eSCS_SpiralInRadiusSpiralOut: HAlignmentParameterConstraint  # 400
eSCS_SpiralLength: HAlignmentParameterConstraint  # 404
eSCS_SpiralLengthRadius: HAlignmentParameterConstraint  # 403
eSCS_SpiralLengthRadiusArcLength: HAlignmentParameterConstraint  # 402
eSCS_SpiralLengthRadiusPassThrough: HAlignmentParameterConstraint  # 401
eSSCSS_Sp1AValSp2AValPt1Pt2: HAlignmentParameterConstraint  # 703
eSSCSS_Sp1AValSp2AValRadiusPt: HAlignmentParameterConstraint  # 702
eSSCSS_Sp1LenSp2LenPt1Pt2: HAlignmentParameterConstraint  # 701
eSSCSS_Sp1LenSp2LenRadiusPt: HAlignmentParameterConstraint  # 700
eSTS_SpiralAValTangentLength: HAlignmentParameterConstraint  # 606
eSTS_SpiralAValTangentPassThrough: HAlignmentParameterConstraint  # 605
eSTS_SpiralInAValSpiralOutAVal: HAlignmentParameterConstraint  # 602
eSTS_SpiralInLengthSpiralOutLength: HAlignmentParameterConstraint  # 600
eSTS_SpiralLengthTangentLength: HAlignmentParameterConstraint  # 604
eSTS_SpiralLengthTangentPassThrough: HAlignmentParameterConstraint  # 603
eSTS_TangentLength: HAlignmentParameterConstraint  # 601
eScalingTypeAbsoluteUnits: ScalingType  # 2
eScalingTypeDrawingScale: ScalingType  # 0
eScalingTypeFixedScale: ScalingType  # 1
eScalingTypeRelativeToScreen: ScalingType  # 3
eSlopeDegrees: GradingSlopeFormat  # 1
eSlopeNoFormat: GradingSlopeFormat  # -1
eSlopePercent: GradingSlopeFormat  # 2
eSlopeRadians: GradingSlopeFormat  # 3
eSlopeRiseRun: GradingSlopeFormat  # 0
eSmoothen: TinSurfaceDefinitionType  # 31
eSolidTypeSurfaceDepth: TinSurfaceSolidType  # 2
eSolidTypeSurfaceElevation: TinSurfaceSolidType  # 1
eSolidTypeSurfaceSurface: TinSurfaceSolidType  # 0
eSpiral: HAlignmentElementType  # 3
eSpiralCurve: HAlignmentElementType  # 8
eSpiralCurveSpiral: HAlignmentElementType  # 4
eSpiralCurveSpiralCurveSpiral: HAlignmentElementType  # 12
eSpiralCurveSpiralSpiralCurveSpiral: HAlignmentElementType  # 13
eSpiralLine: HAlignmentElementType  # 6
eSpiralLineSpiral: HAlignmentElementType  # 5
eSpiralSpiral: HAlignmentElementType  # 14
eSpiralSpiralCurve: HAlignmentElementType  # 15
eSpiralSpiralCurveSpiralSpiral: HAlignmentElementType  # 10
eSpiral_StartPointDirRadiusLength: HAlignmentParameterConstraint  # 500
eSpiral_StartPointDirStartAndEndRadiusLength: HAlignmentParameterConstraint  # 501
eStaticSurface: VAlignmentType  # 1
eSurfaceElevationLabel: StyleManagerType  # 6
eSurfaceLabels: Civil3dLabels  # 1
eSurfaceSlopeLabel: StyleManagerType  # 5
eSwapEdge: TinSurfaceDefinitionType  # 6
eSymbolStyle: StyleManagerType  # 0
eSymbolTypeACADPoint: SymbolType  # 0
eSymbolTypeBlock: SymbolType  # 2
eSymbolTypeCustom: SymbolType  # 1
eSymbolTypeVerticalLine: SymbolType  # 3
eTangent: VAlignmentElementType  # 1
eTangentExtensions: HAlignmentVisualStyle  # 2
eTangentLength: ArcParameterType  # 2
eTangents: VAlignmentVisualStyle  # 2
eText: DrawingObjectType  # 3
eTinBoundary: TinConstraintType  # 1
eTinBreakline: TinConstraintType  # 0
eTinBreaklineNormal: TinBreaklineType  # 0
eTinElevationMax: BreaklineIntersectionElevation  # 2
eTinElevationMid: BreaklineIntersectionElevation  # 3
eTinElevationMin: BreaklineIntersectionElevation  # 1
eTinHide: TinBoundaryType  # 1
eTinNonDestructive: TinBreaklineType  # 1
eTinNotAllowed: BreaklineIntersectionElevation  # 0
eTinOuter: TinBoundaryType  # 2
eTinShow: TinBoundaryType  # 0
eTinStyleBoundaryLine: TinSurfaceStyle  # 1
eTinStyleContours: TinSurfaceStyle  # 8
eTinStyleElevationTooltip: TinSurfaceStyle  # 16
eTinStyleNone: TinSurfaceStyle  # 0
eTinStylePoints: TinSurfaceStyle  # 2
eTinStyleTriangles: TinSurfaceStyle  # 4
eTinSurface: Civil3dEntityType  # 2
eTinSurfaceAll: TinSurfaceIntersectType  # 1
eTinSurfaceFirstOnly: TinSurfaceIntersectType  # 0
eTinSurfaceMeshDepth: TinSurfaceMeshType  # 2
eTinSurfaceMeshElevation: TinSurfaceMeshType  # 1
eTinSurfaceMeshSurface: TinSurfaceMeshType  # 0
eTinVolumeBaseComparison: VolumeSurfaceType  # 0
eTinVolumeToDepth: VolumeSurfaceType  # 2
eTinVolumeToElevation: VolumeSurfaceType  # 1
eTinWall: TinConstraintType  # 2
eTinWallLeft: TinWallSide  # 0
eTinWallNormal: TinWallType  # 0
eTinWallProjected: TinWallType  # 1
eTinWallRight: TinWallSide  # 1
eTransform: TinSurfaceDefinitionType  # 1
eTrianglesVisibility: TinSurfaceDefinitionType  # 40
eUnattachedLabels: Civil3dLabels  # 4
eUndefined: VAlignmentParameterConstraint  # 0
eUnknown: DrawingObjectType  # 0
eVolume: TinSurfaceDefinitionType  # 12

class ArcParameterType(_BoostPythonEnum):
    eRadius: ClassVar[Self]  # 0
    eDegreeOfCurve: ClassVar[Self]  # 1
    eTangentLength: ClassVar[Self]  # 2
    eChordLength: ClassVar[Self]  # 3
    eCurveLength: ClassVar[Self]  # 4
    eExternalDist: ClassVar[Self]  # 5
    eMiddleOrdinate: ClassVar[Self]  # 6
    eCurveAngle: ClassVar[Self]  # 7
    eCurveThroughPoint: ClassVar[Self]  # 8

class ArcType(_BoostPythonEnum):
    eCompound: ClassVar[Self]  # 0
    eReverse: ClassVar[Self]  # 1

class BlockAttachment(_BoostPythonEnum):
    eBlockAttachmentTopLeft: ClassVar[Self]  # 0
    eBlockAttachmentTopCenter: ClassVar[Self]  # 1
    eBlockAttachmentTopRight: ClassVar[Self]  # 2
    eBlockAttachmentMiddleLeft: ClassVar[Self]  # 3
    eBlockAttachmentMiddleCenter: ClassVar[Self]  # 4
    eBlockAttachmentMiddleRight: ClassVar[Self]  # 5
    eBlockAttachmentBottomLeft: ClassVar[Self]  # 6
    eBlockAttachmentBottomCenter: ClassVar[Self]  # 7
    eBlockAttachmentBottomRight: ClassVar[Self]  # 8
    eBlockAttachmentInsertionPoint: ClassVar[Self]  # 9

class BorderType(_BoostPythonEnum):
    eBorderTypeRectangular: ClassVar[Self]  # 0
    eBorderTypeRoundedRectangular: ClassVar[Self]  # 1
    eBorderTypeCircular: ClassVar[Self]  # 2

class BreaklineIntersectionElevation(_BoostPythonEnum):
    eTinNotAllowed: ClassVar[Self]  # 0
    eTinElevationMin: ClassVar[Self]  # 1
    eTinElevationMax: ClassVar[Self]  # 2
    eTinElevationMid: ClassVar[Self]  # 3

class Civil3dAlignmentType(_BoostPythonEnum):
    eNotAlignment: ClassVar[Self]  # -1
    eCenterline: ClassVar[Self]  # 0
    eOffset: ClassVar[Self]  # 1
    eCurbReturn: ClassVar[Self]  # 2
    eRail: ClassVar[Self]  # 3
    eMiscellaneous: ClassVar[Self]  # 4

class Civil3dEntityType(_BoostPythonEnum):
    eNoEntity: ClassVar[Self]  # -1
    eAlignment: ClassVar[Self]  # 0
    eProfile: ClassVar[Self]  # 1
    eTinSurface: ClassVar[Self]  # 2
    eProfileView: ClassVar[Self]  # 3

class Civil3dLabels(_BoostPythonEnum):
    eNoLabels: ClassVar[Self]  # 0
    eSurfaceLabels: ClassVar[Self]  # 1
    eAlignmentsLabels: ClassVar[Self]  # 2
    eUnattachedLabels: ClassVar[Self]  # 4
    eDefaultLabels: ClassVar[Self]  # 6
    eAllLabels: ClassVar[Self]  # 255

class Civil3dProfileType(_BoostPythonEnum):
    eNotProfile: ClassVar[Self]  # -1
    eLayout: ClassVar[Self]  # 0
    eStaticSurface: ClassVar[Self]  # 1
    eDynamicSurface: ClassVar[Self]  # 2
    eQuick: ClassVar[Self]  # 3

class CustomSymbol(_BoostPythonEnum):
    eCustomSymbolSpotPoint: ClassVar[Self]  # 0
    eCustomSymbolSpotEmpty: ClassVar[Self]  # 1
    eCustomSymbolSpotCross: ClassVar[Self]  # 2
    eCustomSymbolSpotCross45: ClassVar[Self]  # 3
    eCustomSymbolSpotVerticalLine: ClassVar[Self]  # 4
    eCustomSymbolFrameCircle: ClassVar[Self]  # 32
    eCustomSymbolFrameSquare: ClassVar[Self]  # 64

class CvAttribVariant:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, val: str, /) -> None: ...
    @overload
    def __init__(self, val: PyBrxCv.CvDataType, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getAngle(self, /) -> float: ...
    def getArea(self, /) -> float: ...
    def getAzimuth(self, /) -> float: ...
    def getBool(self, /) -> bool: ...
    def getDirection(self, /) -> float: ...
    def getDistance(self, /) -> float: ...
    def getDouble(self, /) -> float: ...
    def getElevation(self, /) -> float: ...
    def getInteger(self, /) -> int: ...
    def getLatitude(self, /) -> float: ...
    def getLinear(self, /) -> float: ...
    def getLongitude(self, /) -> float: ...
    def getRatio(self, /) -> float: ...
    def getRotation(self, /) -> float: ...
    def getSlope(self, /) -> float: ...
    def getSpeed(self, /) -> float: ...
    def getStation(self, /) -> float: ...
    def getString(self, /) -> str: ...
    def getVolume(self, /) -> float: ...
    def isValid(self, /) -> bool: ...
    def setAngle(self, val: float, /) -> None: ...
    def setArea(self, val: float, /) -> None: ...
    def setAzimuth(self, val: float, /) -> None: ...
    def setBool(self, val: bool, /) -> None: ...
    def setDirection(self, val: float, /) -> None: ...
    def setDistance(self, val: float, /) -> None: ...
    def setElevation(self, val: float, /) -> None: ...
    def setInteger(self, val: int, /) -> None: ...
    def setLatitude(self, val: float, /) -> None: ...
    def setLinear(self, val: float, /) -> None: ...
    def setLongitude(self, val: float, /) -> None: ...
    def setRatio(self, val: float, /) -> None: ...
    def setRotation(self, val: float, /) -> None: ...
    def setSlope(self, val: float, /) -> None: ...
    def setSpeed(self, val: float, /) -> None: ...
    def setStation(self, val: float, /) -> None: ...
    def setString(self, val: str, /) -> None: ...
    def setVolume(self, val: float, /) -> None: ...
    def type(self, /) -> CvDataType: ...

class CvCivil3dConverter:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(
        self, sourceDb: PyDb.Database, targetDb: PyDb.Database, doLabels: PyBrxCv.Civil3dLabels, /
    ) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def attachedLabels(
        self, civilEntity: PyBrxCv.CvCivil3dEntityInfo, /
    ) -> list[PyDb.ObjectId]: ...
    @staticmethod
    def className() -> str: ...
    def convert(self, entitiesToConvert: list, /) -> list: ...
    def getCivilEntities(self, /) -> list[PyBrxCv.CvCivil3dEntityInfo]: ...
    def getInsertedEntities(self, /) -> list[PyDb.ObjectId]: ...
    def unattachedLabels(self, /) -> list[PyDb.ObjectId]: ...

class CvCivil3dEntityInfo:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def alignmentType(self, /) -> Civil3dAlignmentType: ...
    def baseAlignment(self, /) -> CvCivil3dEntityInfo: ...
    def baseSurface(self, /) -> CvCivil3dEntityInfo: ...
    @staticmethod
    def className() -> str: ...
    def description(self, /) -> str: ...
    def isNull(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def objectId(self, /) -> PyDb.ObjectId: ...
    def profileType(self, /) -> Civil3dProfileType: ...
    def profiles(self, /) -> list[PyBrxCv.CvCivil3dEntityInfo]: ...
    def type(self, /) -> Civil3dEntityType: ...

class CvDataType(_BoostPythonEnum):
    eBrxCvDataTypeNone: ClassVar[Self]  # 0
    eBrxCvDataTypeBool: ClassVar[Self]  # 1
    eBrxCvDataTypeString: ClassVar[Self]  # 2
    eBrxCvDataTypeInteger: ClassVar[Self]  # 3
    eBrxCvDataTypeDate: ClassVar[Self]  # 4
    eBrxCvDataTypeLinear: ClassVar[Self]  # 5
    eBrxCvDataTypeStation: ClassVar[Self]  # 6
    eBrxCvDataTypeAngle: ClassVar[Self]  # 7
    eBrxCvDataTypeRatio: ClassVar[Self]  # 8
    eBrxCvDataTypeArea: ClassVar[Self]  # 9
    eBrxCvDataTypeAzimuth: ClassVar[Self]  # 10
    eBrxCvDataTypeDirection: ClassVar[Self]  # 11
    eBrxCvDataTypeDistance: ClassVar[Self]  # 12
    eBrxCvDataTypeElevation: ClassVar[Self]  # 13
    eBrxCvDataTypeSlope: ClassVar[Self]  # 14
    eBrxCvDataTypeLatitude: ClassVar[Self]  # 15
    eBrxCvDataTypeLongitude: ClassVar[Self]  # 16
    eBrxCvDataTypeRotation: ClassVar[Self]  # 17
    eBrxCvDataTypeVolume: ClassVar[Self]  # 18
    eBrxCvDataTypeSpeed: ClassVar[Self]  # 19

class CvDb3dAlignment(PyBrxCv.CvDbCurve):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def baseHAlignment(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDb3dAlignment: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDb3dAlignment: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def getPointsArray(self, /) -> list[PyGe.Point3d]: ...
    def length(self, /) -> float: ...
    def setBaseHAlignment(self, id: PyDb.ObjectId, /) -> bool: ...
    def setVAlignment(self, id: PyDb.ObjectId, /) -> bool: ...
    def vAlignment(self, /) -> PyDb.ObjectId: ...

class CvDbCurve(PyDb.Curve):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbCurve: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbCurve: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def description(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, val: str, /) -> bool: ...
    def setName(self, val: str, /) -> bool: ...

class CvDbCurveLabelStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbCurveLabelStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbCurveLabelStyleManager: ...
    def createLabelStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(db: PyDb.Database, mode: PyDb.OpenMode, /) -> CvDbCurveLabelStyleManager: ...

class CvDbEntity(PyDb.Entity):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbEntity: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbEntity: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def description(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, val: str, /) -> bool: ...
    def setName(self, val: str, /) -> bool: ...

class CvDbFileFormatManager(PyBrxCv.CvDbObjectManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def allFileFormats(self, /) -> list[PyDb.ObjectId]: ...
    def applicableFileFormats(self, val: str, /) -> list[PyDb.ObjectId]: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbFileFormatManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbFileFormatManager: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManager(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def openManager(db: PyDb.Database, mode: PyDb.OpenMode, /) -> CvDbFileFormatManager: ...

class CvDbGrading(PyBrxCv.CvDbEntity):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbGrading: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbGrading: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def getCalculationCurve(self, /) -> PyGe.Curve3d: ...
    def getCalculationMethod(self, /) -> GradingCalculationMethod: ...
    def getGradingVisualStyle(self, /) -> GradingVisualStyle: ...
    def getInputEntityId(self, /) -> PyDb.ObjectId: ...
    def getIsAssociative(self, /) -> bool: ...
    def getIsDrawInfill(self, /) -> bool: ...
    def getMidOrdinateDist(self, /) -> float: ...
    def getRegionEnd(self, /) -> float: ...
    def getRegionStart(self, /) -> float: ...
    def getSegmentMaxAngle(self, /) -> float: ...
    def getSegmentMaxLength(self, /) -> float: ...
    def isClosed(self, /) -> bool: ...
    def resultDayLight(self, /) -> list[list[PyGe.Point3d]]: ...
    def rule(self, /) -> CvGradingRule: ...
    def setCalculationMethod(self, val: PyBrxCv.GradingCalculationMethod, /) -> bool: ...
    def setDrawInfill(self, val: bool, /) -> GradingStatus: ...
    def setGradingVisualStyle(self, val: PyBrxCv.GradingVisualStyle, /) -> bool: ...
    def setInputData(self, curve: PyGe.Curve3d, /) -> GradingStatus: ...
    def setInputDataId(self, id: PyDb.ObjectId, /) -> GradingStatus: ...
    def setIsAssociative(self, val: bool, /) -> bool: ...
    def setMidOrdinateDist(self, val: float, /) -> GradingStatus: ...
    def setRegionEnd(self, val: float, /) -> GradingStatus: ...
    def setRegionStart(self, val: float, /) -> GradingStatus: ...
    def setRule(self, val: PyBrxCv.CvGradingRule, /) -> GradingStatus: ...
    def setSegmentMaxAngle(self, val: float, /) -> GradingStatus: ...
    def setSegmentMaxLength(self, val: float, /) -> GradingStatus: ...
    def targetSurface(self, /) -> PyDb.ObjectId: ...
    def update(self, val: bool, /) -> GradingStatus: ...

class CvDbHAlignment(PyBrxCv.CvDbCurve):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addArcAuto(self, prevId: int, nextId: int, /) -> int: ...
    @overload
    def addArcBetween(
        self, prevId: int, nextId: int, passThroughPoint: PyGe.Point2d, /
    ) -> int: ...
    @overload
    def addArcBetween(
        self,
        prevId: int,
        nextId: int,
        parameter: float,
        paramType: PyBrxCv.EArcParameterType,
        isGreaterThan180: bool,
        arcType: PyBrxCv.ArcType,
        /,
    ) -> int: ...
    @overload
    def addArcBetween(self, *args) -> int: ...
    @overload
    def addArcFixed(self, center: PyGe.Point2d, radius: float, clockwise: bool, /) -> int: ...
    @overload
    def addArcFixed(
        self, startPoint: PyGe.Point2d, midPoint: PyGe.Point2d, endPoint: PyGe.Point2d, /
    ) -> int: ...
    @overload
    def addArcFixed(self, *args) -> int: ...
    @overload
    def addArcFrom(self, prevId: int, passThroughPoint: PyGe.Point2d, /) -> int: ...
    @overload
    def addArcFrom(
        self, prevId: int, passThroughPoint: PyGe.Point2d, direction: PyGe.Vector2d, /
    ) -> int: ...
    @overload
    def addArcFrom(
        self,
        prevId: int,
        passThroughPoint: PyGe.Point2d,
        radius: float,
        isGreaterThan180: bool,
        arcType: PyBrxCv.ArcType,
        /,
    ) -> int: ...
    @overload
    def addArcFrom(
        self,
        prevId: int,
        radius: float,
        paramValue: float,
        paramType: PyBrxCv.ArcType,
        isClockwise: bool,
        /,
    ) -> int: ...
    @overload
    def addArcFrom(self, *args) -> int: ...
    @overload
    def addArcTo(self, nextId: int, passThroughPoint: PyGe.Point2d, /) -> int: ...
    @overload
    def addArcTo(
        self, nextId: int, passThroughPoint: PyGe.Point2d, direction: PyGe.Vector2d, /
    ) -> int: ...
    @overload
    def addArcTo(
        self,
        nextId: int,
        passThroughPoint: PyGe.Point2d,
        radius: float,
        isGreaterThan180: bool,
        arcType: PyBrxCv.ArcType,
        /,
    ) -> int: ...
    @overload
    def addArcTo(
        self,
        nextId: int,
        radius: float,
        paramValue: float,
        paramType: PyBrxCv.ArcType,
        isClockwise: bool,
        /,
    ) -> int: ...
    @overload
    def addArcTo(self, *args) -> int: ...
    def addCSSTo(
        self,
        nextId: int,
        spiral1Param: float,
        spiral2Param: float,
        spiralParamType,
        radius: float,
        passThroughPoint: PyGe.Point2d,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addCSTo(
        self,
        nextId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        radius: float,
        passThroughPoint: PyGe.Point2d,
        isGreaterThan180: bool,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addCSTo(
        self,
        nextId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        radius: float,
        arcLength: float,
        isClockwise: bool,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addCSTo(self, *args) -> int: ...
    def addLineBetween(self, prevId: int, nextId: int, /) -> int: ...
    @overload
    def addLineFixed(self, prevId: int, length: float, /) -> int: ...
    @overload
    def addLineFixed(self, start: PyGe.Point2d, end: PyGe.Point2d, /) -> int: ...
    @overload
    def addLineFixed(self, *args) -> int: ...
    @overload
    def addLineFrom(self, prevId: int, length: float, /) -> int: ...
    @overload
    def addLineFrom(self, prevId: int, to: PyGe.Point2d, /) -> int: ...
    @overload
    def addLineFrom(self, *args) -> int: ...
    @overload
    def addLineTo(self, nextId: int, length: float, /) -> int: ...
    @overload
    def addLineTo(self, nextId: int, to: PyGe.Point2d, /) -> int: ...
    @overload
    def addLineTo(self, *args) -> int: ...
    @overload
    def addSCFrom(
        self,
        prevId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        radius: float,
        passThroughPoint: PyGe.Point2d,
        isGreaterThan180: bool,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addSCFrom(
        self,
        prevId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        radius: float,
        arcLength: float,
        isClockwise: bool,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addSCFrom(self, *args) -> int: ...
    def addSCSAuto(self, prevId: int, nextId: int, /) -> int: ...
    def addSCSBetween(
        self,
        prevId: int,
        nextId: int,
        spiral1: float,
        spiral2: float,
        spiralType: PyBrxCv.SpiralParameterType,
        radius: float,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    def addSSBetween(
        self,
        prevId: int,
        nextId: int,
        spiralRatio: float,
        spiralParamType: PyBrxCv.SpiralParameterType,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    def addSSCFrom(
        self,
        prevId: int,
        spiral1Param: float,
        spiral2Param: float,
        spiralParamType,
        radius: float,
        passThroughPoint: PyGe.Point2d,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addSTFrom(
        self,
        prevId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        passThroughPoint: PyGe.Point2d,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addSTFrom(
        self,
        prevId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        tangentLength: float,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addSTFrom(self, *args) -> int: ...
    def addSTSBetween(
        self,
        prevId: int,
        nextId: int,
        spiral1Param: float,
        spiral2Param: float,
        spiralType: PyBrxCv.SpiralParameterType,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    def addSpiralBetween(
        self, prevId: int, nextId: int, spiralDef: PyBrxCv.SpiralDefinitionType, /
    ) -> int: ...
    def addSpiralFrom(
        self,
        prevId: int,
        radius: float,
        length: float,
        isClockwise: bool,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    def addSpiralTo(
        self,
        nextId: int,
        radius: float,
        length: float,
        isClockwise: bool,
        spiralDef: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addTSTo(
        self,
        nextId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        passThroughPoint: PyGe.Point2d,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addTSTo(
        self,
        nextId: int,
        spiralParam: float,
        spiralParamType: PyBrxCv.EArcParameterType,
        tangentLength: float,
        spiralDefinition: PyBrxCv.SpiralDefinitionType,
        /,
    ) -> int: ...
    @overload
    def addTSTo(self, *args) -> int: ...
    def alignment3dAt(self, index: int, /) -> PyDb.ObjectId: ...
    def alignment3dCount(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignment: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbHAlignment: ...
    def curveAtPI(self, pi: PyBrxCv.CvDbHAlignmentPI, /) -> int: ...
    def curveElementColor(self, /) -> int: ...
    def deleteElement(self, id: int, /) -> bool: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def elementAtId(self, Id: int, /) -> CvDbHAlignmentElement: ...
    def elementAtStation(self, station: float, /) -> CvDbHAlignmentElement: ...
    def elementCount(self, /) -> int: ...
    def elementExtensionColor(self, /) -> int: ...
    def firstElementId(self, /) -> int: ...
    def firstLineElementId(self, /) -> int: ...
    def getElementId(self, gsMarker: int, /) -> int: ...
    def getPIsArray(self, /) -> list[PyBrxCv.CvDbHAlignmentPI]: ...
    def getPointAtStation(self, station: float, /) -> tuple[bool, PyGe.Point2d]: ...
    def getRadius(self, param: float, /) -> float: ...
    @overload
    def getStationAtPoint(self, station: PyGe.Point2d, /) -> tuple[bool, float, float]: ...
    @overload
    def getStationAtPoint(
        self, station: PyGe.Point2d, fromStation: float, toStation: float, /
    ) -> tuple[bool, float, float]: ...
    @overload
    def getStationAtPoint(self, *args) -> tuple[bool, float, float]: ...
    def getUnorderedElementIds(self, /) -> list[int]: ...
    def insertLineFixed(self, start: PyGe.Point2d, end: PyGe.Point2d, prevId: int, /) -> int: ...
    def lastElementId(self, /) -> int: ...
    def length(self, /) -> float: ...
    def lineElementColor(self, /) -> int: ...
    def nextLineElementId(self, Id: int, /) -> int: ...
    def previousLineElementId(self, Id: int, /) -> int: ...
    def setCurveElementColor(self, colACI: int, /) -> bool: ...
    def setElementExtensionColor(self, colACI: int, /) -> bool: ...
    def setLineElementColor(self, colACI: int, /) -> bool: ...
    def setSpiralElementColor(self, colACI: int, /) -> bool: ...
    def setStationEquations(self, val: PyBrxCv.CvStationEquations, /) -> bool: ...
    def setStyle(self, style: int, /) -> bool: ...
    def setTangentExtensionColor(self, colACI: int, /) -> bool: ...
    def spiralElementColor(self, /) -> int: ...
    def stationEquations(self, /) -> CvStationEquations: ...
    def style(self, /) -> int: ...
    def tangentExtensionColor(self, /) -> int: ...
    def update(self, /) -> bool: ...
    def verticalAlignmentAt(self, index: int, /) -> PyDb.ObjectId: ...
    def verticalAlignmentCount(self, /) -> int: ...
    def verticalAlignmentViewAt(self, index: int, /) -> PyDb.ObjectId: ...
    def verticalAlignmentViewCount(self, /) -> int: ...

class CvDbHAlignmentArc(PyBrxCv.CvDbHAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentArc: ...
    def center(self, /) -> PyGe.Point2d: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def isClockwise(self, /) -> bool: ...
    def isCompound(self, /) -> bool: ...
    def isLessThan180(self, /) -> bool: ...
    def paramLength(self, /) -> float: ...
    def passThroughPoint1(self, /) -> PyGe.Point2d: ...
    def passThroughPoint2(self, /) -> PyGe.Point2d: ...
    def passThroughPoint3(self, /) -> PyGe.Point2d: ...
    def radius(self, /) -> float: ...
    def setCenter(self, pt: PyGe.Point2d, /) -> bool: ...
    def setClockwise(self, val: bool, /) -> bool: ...
    def setCompound(self, val: bool, /) -> bool: ...
    def setLessThan180(self, val: bool, /) -> bool: ...
    def setParamLength(self, val: float, /) -> bool: ...
    def setPassThroughPoint1(self, pt: PyGe.Point2d, /) -> bool: ...
    def setPassThroughPoint2(self, pt: PyGe.Point2d, /) -> bool: ...
    def setPassThroughPoint3(self, pt: PyGe.Point2d, /) -> bool: ...
    def setRadius(self, val: float, /) -> bool: ...

class CvDbHAlignmentCurve(PyBrxCv.CvDbHAlignmentElement):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentCurve: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def endPoint(self, /) -> PyGe.Point2d: ...
    def endStation(self, /) -> float: ...
    def length(self, /) -> float: ...
    def startPoint(self, /) -> PyGe.Point2d: ...
    def startStation(self, /) -> float: ...

class CvDbHAlignmentElement(PyBrxCv.CvDbSubObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentElement: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def id(self, /) -> int: ...
    def isSubentity(self, /) -> bool: ...
    def nextId(self, /) -> int: ...
    def parameterConstraint(self, /) -> HAlignmentParameterConstraint: ...
    def previousId(self, /) -> int: ...
    def setNextId(self, val: int, /) -> bool: ...
    def setParameterConstraint(self, val: PyBrxCv.EParameterConstraint, /) -> bool: ...
    def setPreviousId(self, val: int, /) -> bool: ...
    def setTangencyConstraint(self, val: PyBrxCv.ETangencyConstraint, /) -> bool: ...
    def tangencyConstraint(self, /) -> HAlignmentTangencyConstraint: ...
    def type(self, /) -> HAlignmentElementType: ...

class CvDbHAlignmentLine(PyBrxCv.CvDbHAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentLine: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def paramLength(self, /) -> float: ...
    def passThroughPoint1(self, /) -> PyGe.Point2d: ...
    def passThroughPoint2(self, /) -> PyGe.Point2d: ...
    def setParamLength(self, val: float, /) -> bool: ...
    def setPassThroughPoint1(self, pt: PyGe.Point2d, /) -> bool: ...
    def setPassThroughPoint2(self, pt: PyGe.Point2d, /) -> bool: ...

class CvDbHAlignmentPI(PyBrxCv.CvDbHAlignmentElement):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentPI: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def location(self, /) -> PyGe.Point2d: ...

class CvDbHAlignmentSCS(PyBrxCv.CvDbHAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def arc(self, /) -> CvDbHAlignmentArc: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentSCS: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def spiralIn(self, /) -> CvDbHAlignmentSpiral: ...
    def spiralOut(self, /) -> CvDbHAlignmentSpiral: ...

class CvDbHAlignmentSSCSS(PyBrxCv.CvDbHAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def arc(self, /) -> CvDbHAlignmentArc: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentSSCSS: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def spiral1(self, /) -> CvDbHAlignmentSpiral: ...
    def spiral2(self, /) -> CvDbHAlignmentSpiral: ...
    def spiral3(self, /) -> CvDbHAlignmentSpiral: ...
    def spiral4(self, /) -> CvDbHAlignmentSpiral: ...

class CvDbHAlignmentSTS(PyBrxCv.CvDbHAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentSTS: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def line(self, /) -> CvDbHAlignmentLine: ...
    def spiralIn(self, /) -> CvDbHAlignmentSpiral: ...
    def spiralOut(self, /) -> CvDbHAlignmentSpiral: ...
    def spiralRatio(self, /) -> float: ...

class CvDbHAlignmentSpiral(PyBrxCv.CvDbHAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbHAlignmentSpiral: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def endDirection(self, /) -> float: ...
    def isCompound(self, /) -> bool: ...
    def paramA(self, /) -> float: ...
    def paramLength(self, /) -> float: ...
    def radiusIn(self, /) -> float: ...
    def radiusOut(self, /) -> float: ...
    def setClockwise(self, val: bool, /) -> bool: ...
    def setCompound(self, val: float, /) -> bool: ...
    def setEndDirection(self, val: float, /) -> bool: ...
    def setParamA(self, val: float, /) -> bool: ...
    def setParamLength(self, val: float, /) -> bool: ...
    def setRadiusIn(self, val: float, /) -> bool: ...
    def setRadiusOut(self, val: float, /) -> bool: ...
    def setSpiralCurveType(self, val: PyBrxCv.ESpiralCurveType, /) -> bool: ...
    def setSpiralDefinition(self, val: PyBrxCv.ESpiralDefinitionType, /) -> bool: ...
    def spiralCurveType(self, /) -> SpiralCurveType: ...
    def spiralDefinition(self, /) -> SpiralDefinitionTypeSpiral: ...
    def startDirection(self, /) -> float: ...

class CvDbLabelStyle(PyBrxCv.CvDbStyle):
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, metric: bool, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, mode: PyDb.OpenMode, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, mode: PyDb.OpenMode, erased: bool, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addComponent(self, val: PyBrxCv.CvDbLabelStyleComponent, /) -> None: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbLabelStyle: ...
    @staticmethod
    def className() -> str: ...
    def componentAt(self, index: int, /) -> CvDbLabelStyleComponent: ...
    def componentCount(self, /) -> int: ...
    def components(self, /) -> list[PyBrxCv.CvDbLabelStyleComponent]: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def draggedStateBackgroundMask(self, /) -> bool: ...
    def draggedStateBorderAndLeaderGap(self, /) -> float: ...
    def draggedStateBorderAndLeaderGapExprIndex(self, /) -> int: ...
    def draggedStateBorderIsVisible(self, /) -> bool: ...
    def draggedStateBorderType(self, /) -> BorderType: ...
    def draggedStateColor(self, /) -> PyDb.Color: ...
    def draggedStateDisplayMode(self, /) -> DisplayMode: ...
    def draggedStateLeaderArrowHeadSize(self, /) -> float: ...
    def draggedStateLeaderArrowHeadSizeExprIndex(self, /) -> int: ...
    def draggedStateLeaderArrowHeadStyle(self, /) -> PyDb.ObjectId: ...
    def draggedStateLeaderAttachment(self, /) -> LeaderAttachment: ...
    def draggedStateLeaderColor(self, /) -> PyDb.Color: ...
    def draggedStateLeaderIsVisible(self, /) -> bool: ...
    def draggedStateLeaderJustification(self, /) -> bool: ...
    def draggedStateLeaderLinetype(self, /) -> PyDb.ObjectId: ...
    def draggedStateLeaderLineweight(self, /) -> PyDb.LineWeight: ...
    def draggedStateLeaderTail(self, /) -> bool: ...
    def draggedStateLeaderType(self, /) -> LeaderType: ...
    def draggedStateLinetype(self, /) -> PyDb.ObjectId: ...
    def draggedStateLineweight(self, /) -> PyDb.LineWeight: ...
    def draggedStateMaximumTextWidth(self, /) -> float: ...
    def draggedStateMaximumTextWidthExprIndex(self, /) -> int: ...
    def draggedStateTagDisplayMode(self, /) -> bool: ...
    def draggedStateTextHeight(self, /) -> float: ...
    def draggedStateTextHeightExprIndex(self, /) -> int: ...
    def expressionAt(self, index: int, /) -> tuple[str, str]: ...
    def expressionCount(self, /) -> int: ...
    def flipAnchorsWithText(self, /) -> bool: ...
    def forceInsideCurve(self, /) -> bool: ...
    def forcedInsertion(self, /) -> ForcedInsertion: ...
    def isVisible(self, /) -> bool: ...
    def layer(self, /) -> PyDb.ObjectId: ...
    def moveComponent(self, _from: int, _to: int, /) -> None: ...
    def orientationReference(self, /) -> OrientationRef: ...
    def planReadable(self, /) -> bool: ...
    def readabilityBias(self, /) -> float: ...
    def removeComponent(self, val: int | PyBrxCv.CvDbLabelStyleComponent, /) -> None: ...
    def setDraggedStateBackgroundMask(self, val: bool, /) -> None: ...
    def setDraggedStateBorderAndLeaderGap(self, val: float, /) -> None: ...
    def setDraggedStateBorderAndLeaderGapExprIndex(self, val: int, /) -> None: ...
    def setDraggedStateBorderType(self, val: BorderType, /) -> None: ...
    def setDraggedStateBorderVisibility(self, val: bool, /) -> None: ...
    def setDraggedStateColor(self, val: PyDb.Color, /) -> None: ...
    def setDraggedStateDisplayMode(self, val: DisplayMode, /) -> None: ...
    def setDraggedStateLeaderArrowHeadSize(self, val: float, /) -> None: ...
    def setDraggedStateLeaderArrowHeadSizeExprIndex(self, val: int, /) -> None: ...
    def setDraggedStateLeaderArrowHeadStyle(self, id: PyDb.ObjectId, /) -> None: ...
    def setDraggedStateLeaderAttachment(self, val: LeaderAttachment, /) -> None: ...
    def setDraggedStateLeaderColor(self, val: PyDb.Color, /) -> None: ...
    def setDraggedStateLeaderJustification(self, val: bool, /) -> None: ...
    def setDraggedStateLeaderLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setDraggedStateLeaderLineweight(self, val: PyDb.LineWeight, /) -> None: ...
    def setDraggedStateLeaderTail(self, val: bool, /) -> None: ...
    def setDraggedStateLeaderType(self, val: LeaderType, /) -> None: ...
    def setDraggedStateLeaderVisibility(self, val: bool, /) -> None: ...
    def setDraggedStateLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setDraggedStateLineweight(self, val: PyDb.LineWeight, /) -> None: ...
    def setDraggedStateMaximumTextWidth(self, val: float, /) -> None: ...
    def setDraggedStateMaximumTextWidthExprIndex(self, val: int, /) -> None: ...
    def setDraggedStateTagDisplayMode(self, val: bool, /) -> None: ...
    def setDraggedStateTextHeight(self, val: float, /) -> None: ...
    def setDraggedStateTextHeightExprIndex(self, val: int, /) -> None: ...
    def setExpressionAt(
        self, index: int, name: str, expr: str, val: PyBrxCv.DataType, /
    ) -> None: ...
    def setFlipAnchorsWithText(self, val: bool, /) -> None: ...
    def setForceInsideCurve(self, val: bool, /) -> None: ...
    def setForcedInsertion(self, val: ForcedInsertion, /) -> None: ...
    def setLayer(self, id: PyDb.ObjectId, /) -> None: ...
    def setOrientationReference(self, val: PyBrxCv.OrientationRef, /) -> None: ...
    def setPlanReadable(self, val: bool, /) -> None: ...
    def setReadabilityBias(self, val: float, /) -> None: ...
    def setTextStyle(self, id: PyDb.ObjectId, /) -> None: ...
    def setVisibility(self, val: bool, /) -> None: ...
    def textStyle(self, /) -> PyDb.ObjectId: ...

class CvDbLabelStyleArrow(PyBrxCv.CvDbLabelStyleComponent):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def angle(self, /) -> float: ...
    def angleExprIndex(self, /) -> int: ...
    def arrowHeadSize(self, /) -> float: ...
    def arrowHeadStyle(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbLabelStyleArrow: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def isFixedLength(self, /) -> bool: ...
    def length(self, /) -> float: ...
    def lengthExprIndex(self, /) -> int: ...
    def linetype(self, /) -> PyDb.ObjectId: ...
    def lineweight(self, /) -> PyDb.LineWeight: ...
    def offset(self, /) -> PyGe.Vector2d: ...
    def setAngle(self, val: float, /) -> None: ...
    def setAngleExprIndex(self, val: int, /) -> None: ...
    def setArrowHeadSize(self, val: float, /) -> None: ...
    def setArrowHeadSizeExprIndex(self, val: int, /) -> None: ...
    def setArrowHeadStyle(self, id: PyDb.ObjectId, /) -> None: ...
    def setFixedLength(self, val: bool, /) -> None: ...
    def setLength(self, val: float, /) -> None: ...
    def setLengthExprIndex(self, val: int, /) -> None: ...
    def setLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setLineweight(self, val: PyDb.LineWeight, /) -> None: ...
    def setOffset(self, val: PyGe.Vector2d, /) -> None: ...

class CvDbLabelStyleBlock(PyBrxCv.CvDbLabelStyleComponent):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def angle(self, /) -> float: ...
    def angleExprIndex(self, /) -> int: ...
    def attachment(self, /) -> BlockAttachment: ...
    def blockId(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbLabelStyleBlock: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def height(self, /) -> float: ...
    def heightExprIndex(self, /) -> int: ...
    def linetype(self, /) -> PyDb.ObjectId: ...
    def lineweight(self, /) -> PyDb.LineWeight: ...
    def offset(self, /) -> PyGe.Vector2d: ...
    def setAngle(self, val: float, /) -> None: ...
    def setAngleExprIndex(self, val: int, /) -> None: ...
    def setAttachment(self, attachment: PyBrxCv.BlockAttachment, /) -> None: ...
    def setBlockId(self, id: PyDb.ObjectId, /) -> None: ...
    def setHeight(self, val: float, /) -> None: ...
    def setHeightExprIndex(self, val: int, /) -> None: ...
    def setLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setLineweight(self, lineWeight: PyDb.LineWeight, /) -> None: ...
    def setOffset(self, val: PyGe.Vector2d, /) -> None: ...

class CvDbLabelStyleComponent(PyBrxCv.CvDbSubObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def anchorIndex(self, /) -> int: ...
    def anchorPoint(self, /) -> LabelAnchor: ...
    def color(self, /) -> PyDb.Color: ...
    def displaySetting(self, /) -> bool: ...
    def setAnchorIndex(self, val: int, /) -> None: ...
    def setAnchorPoint(self, val: PyBrxCv.LabelAnchor, /) -> None: ...
    def setColor(self, clr: PyDb.Color, /) -> None: ...
    def setVisible(self, val: bool, /) -> None: ...

class CvDbLabelStyleLine(PyBrxCv.CvDbLabelStyleComponent):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def angle(self, /) -> float: ...
    def angleExprIndex(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbLabelStyleLine: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def endPointAnchorIndex(self, /) -> int: ...
    def endPointAnchorPoint(self, /) -> LabelAnchor: ...
    def endPointOffset(self, /) -> PyGe.Vector2d: ...
    def length(self, /) -> float: ...
    def lengthExprIndex(self, /) -> int: ...
    def lengthPercentage(self, /) -> float: ...
    def lengthPercentageExprIndex(self, /) -> int: ...
    def lengthType(self, /) -> LengthType: ...
    def linetype(self, /) -> PyDb.ObjectId: ...
    def lineweight(self, /) -> PyDb.LineWeight: ...
    def setAngle(self, val: float, /) -> None: ...
    def setAngleExprIndex(self, val: int, /) -> None: ...
    def setEndPointAnchorIndex(self, val: int, /) -> None: ...
    def setEndPointAnchorPoint(self, val: PyBrxCv.LabelAnchor, /) -> None: ...
    def setEndPointOffset(self, val: PyGe.Vector2d, /) -> None: ...
    def setLength(self, val: float, /) -> None: ...
    def setLengthExprIndex(self, val: int, /) -> None: ...
    def setLengthPercentage(self, val: float, /) -> None: ...
    def setLengthPercentageExprIndex(self, val: int, /) -> None: ...
    def setLengthType(self, val: PyBrxCv.LengthType, /) -> None: ...
    def setLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setLineweight(self, id: PyDb.LineWeight, /) -> None: ...
    def setStartPointOffset(self, val: PyGe.Vector2d, /) -> None: ...
    def setUseEndPointAnchor(self, val: bool, /) -> None: ...
    def startPointOffset(self, /) -> PyGe.Vector2d: ...
    def useEndPointAnchor(self, /) -> bool: ...

class CvDbLabelStyleText(PyBrxCv.CvDbLabelStyleComponent):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def allowCurvedText(self, /) -> bool: ...
    def borderBackgroudMask(self, /) -> bool: ...
    def borderColor(self, /) -> PyDb.Color: ...
    def borderGap(self, /) -> float: ...
    def borderGapExprIndex(self, /) -> int: ...
    def borderIsVisible(self, /) -> bool: ...
    def borderLinetype(self, /) -> PyDb.ObjectId: ...
    def borderLineweight(self, val: PyDb.LineWeight, /) -> PyDb.LineWeight: ...
    def borderType(self, /) -> BorderType: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbLabelStyleText: ...
    @staticmethod
    def className() -> str: ...
    def contents(self, /) -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def setAllowCurvedText(self, val: bool, /) -> None: ...
    def setBorderBackgroudMask(self, val: bool, /) -> None: ...
    def setBorderColor(self, val: PyDb.Color, /) -> None: ...
    def setBorderGap(self, val: float, /) -> None: ...
    def setBorderGapExprIndex(self, val: int, /) -> None: ...
    def setBorderLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setBorderLineweight(self, /) -> None: ...
    def setBorderType(self, val: BorderType, /) -> None: ...
    def setBorderVisibility(self, val: bool, /) -> None: ...
    def setContents(self, val: str, /) -> None: ...
    def setTextAngle(self, val: float, /) -> None: ...
    def setTextAngleExprIndex(self, val: int, /) -> None: ...
    def setTextAttachment(self, val: PyDb.MTextAttachmentPoint, /) -> None: ...
    def setTextHeight(self, val: float, /) -> None: ...
    def setTextHeightExprIndex(self, val: int, /) -> None: ...
    def setTextHorizontalAlignment(self, val: PyDb.TextHorzMode, /) -> None: ...
    def setTextLinetype(self, id: PyDb.ObjectId, /) -> None: ...
    def setTextLineweight(self, val: PyDb.LineWeight, /) -> None: ...
    def setTextMaximumWidth(self, val: float, /) -> None: ...
    def setTextMaximumWidthExprIndex(self, val: int, /) -> None: ...
    def setTextOffset(self, val: PyGe.Vector2d, /) -> None: ...
    def textAngle(self, /) -> float: ...
    def textAngleExprIndex(self, /) -> int: ...
    def textAttachment(self, /) -> PyDb.MTextAttachmentPoint: ...
    def textHeight(self, /) -> float: ...
    def textHeightExprIndex(self, /) -> int: ...
    def textHorizontalAlignment(self, /) -> PyDb.TextHorzMode: ...
    def textLinetype(self, /) -> PyDb.ObjectId: ...
    def textLineweight(self, /) -> PyDb.LineWeight: ...
    def textMaximumWidth(self, /) -> float: ...
    def textMaximumWidthExprIndex(self, /) -> int: ...
    def textOffset(self, /) -> PyGe.Vector2d: ...

class CvDbLineLabelStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbLineLabelStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbLineLabelStyleManager: ...
    def createLabelStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(db: PyDb.Database, mode: PyDb.OpenMode, /) -> CvDbLineLabelStyleManager: ...

class CvDbObject(PyDb.DbObject):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbObject: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbObject: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def description(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, val: str, /) -> bool: ...
    def setName(self, val: str, /) -> bool: ...

class CvDbObjectManager(PyBrxCv.CvDbObject):
    def __contains__(self, id: str | PyDb.ObjectId, /) -> bool: ...
    def __getitem__(self, val: int | str, /) -> PyDb.ObjectId: ...
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbObjectManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbObjectManager: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def elementCount(self, /) -> int: ...
    def has(self, id: str | PyDb.ObjectId, /) -> bool: ...
    def idAt(self, val: int | str, /) -> PyDb.ObjectId: ...
    def ids(self, /) -> list[PyDb.ObjectId]: ...
    def nameAt(self, val: int, /) -> str: ...
    def names(self, /) -> list[str]: ...
    def remove(self, id: str | PyDb.ObjectId, /) -> bool: ...
    def toDict(self, /) -> dict: ...

class CvDbPoint(PyBrxCv.CvDbEntity):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addUserAttribute(self, name: str, value: PyBrxCv.CvAttribVariant, /) -> bool: ...
    @staticmethod
    def assignPointToPointGroup(cvpoint: PyBrxCv.CvDbPoint, groupid: PyDb.ObjectId, /) -> None: ...
    @staticmethod
    def assignPointsToPointGroup(
        cvpoint: list[PyBrxCv.CvDbPoint], groupid: PyDb.ObjectId, /
    ) -> None: ...
    @staticmethod
    def assignStylesToPoints(
        cvpoint: list[PyBrxCv.CvDbPoint],
        symbolStyleId: PyDb.ObjectId,
        labelStyleId: PyDb.ObjectId,
        /,
    ) -> None: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbPoint: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbPoint: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def easting(self, /) -> float: ...
    def elevation(self, /) -> float: ...
    def fullDescription(self, /) -> str: ...
    @staticmethod
    def importPointsFromFile(
        files: list[str], fmtid: PyDb.ObjectId, /
    ) -> list[PyBrxCv.CvDbPoint]: ...
    def isLabelDragged(self, /) -> bool: ...
    def isLabelPinned(self, /) -> bool: ...
    def labelId(self, /) -> PyDb.ObjectId: ...
    def labelLeaderVertices(self, /) -> list[PyGe.Point3d]: ...
    def labelPosition(self, /) -> PyGe.Point3d: ...
    def labelRotation(self, /) -> float: ...
    def northing(self, /) -> float: ...
    def number(self, /) -> int: ...
    def pointGroupsIds(self, /) -> list[PyDb.ObjectId]: ...
    def pointGroupsNames(self, /) -> list[str]: ...
    def position(self, /) -> PyGe.Point3d: ...
    def rawDescription(self, /) -> str: ...
    def referencedEntityAt(self, val: int, /) -> CvDbPointReferencedEntity: ...
    def referencedEntityCount(self, /) -> int: ...
    def removeUserAttribute(self, name: str, value: PyBrxCv.CvDataType, /) -> bool: ...
    def resetLabel(self, /) -> bool: ...
    def setEasting(self, val: float, /) -> bool: ...
    def setElevation(self, val: float, /) -> bool: ...
    def setFullDescription(self, val: str, /) -> bool: ...
    def setLabelId(self, id: PyDb.ObjectId, /) -> bool: ...
    def setLabelLeaderVertices(self, vertices: list[PyGe.Point3d], /) -> bool: ...
    def setLabelPinned(self, val: bool, /) -> bool: ...
    def setLabelPosition(self, pt: PyGe.Point3d, /) -> bool: ...
    def setLabelRotation(self, val: float, /) -> bool: ...
    def setNorthing(self, val: float, /) -> bool: ...
    def setNumber(self, val: int, /) -> bool: ...
    def setPosition(self, pt: PyGe.Point3d, /) -> bool: ...
    def setRawDescription(self, val: str, /) -> bool: ...
    def setSymbolId(self, id: PyDb.ObjectId, /) -> bool: ...
    def setSymbolRotation(self, val: float, /) -> bool: ...
    def symbolId(self, /) -> PyDb.ObjectId: ...
    def symbolRotation(self, /) -> float: ...
    def update(self, /) -> bool: ...
    def userAttribute(self, name: str, value: PyBrxCv.CvDataType, /) -> CvAttribVariant: ...
    def userAttributeAt(self, index: int, /) -> tuple: ...
    def userAttributeCount(self, /) -> int: ...
    def userAttributeNames(self, /) -> list: ...
    def userAttributes(self, /) -> list: ...

class CvDbPointGroup(PyBrxCv.CvDbObject):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbPointGroup: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbPointGroup: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def excludeElevations(self, /) -> str: ...
    def excludeFullDescriptions(self, /) -> str: ...
    def excludeNames(self, /) -> str: ...
    def excludeNumbers(self, /) -> str: ...
    def excludeRawDescriptions(self, /) -> str: ...
    def excludeUserAttributesKeys(self, /) -> str: ...
    def excludeUserAttributesValues(self, /) -> str: ...
    def hasPoint(self, val: int, /) -> PyDb.ObjectId: ...
    def includeElevations(self, /) -> str: ...
    def includeFullDescriptions(self, /) -> str: ...
    def includeNames(self, /) -> str: ...
    def includeNumbers(self, /) -> str: ...
    def includeRawDescriptions(self, /) -> str: ...
    def includeUserAttributesKeys(self, /) -> str: ...
    def includeUserAttributesValues(self, /) -> str: ...
    def isApplicable(self, /) -> bool: ...
    def isEditable(self, /) -> bool: ...
    def pointCount(self, /) -> int: ...
    def pointIds(self, /) -> list[PyDb.ObjectId]: ...
    def setExcludeElevations(self, filter: str, /) -> bool: ...
    def setExcludeFullDescriptions(self, filter: str, /) -> bool: ...
    def setExcludeNames(self, filter: str, /) -> bool: ...
    def setExcludeNumbers(self, filter: str, /) -> bool: ...
    def setExcludeRawDescriptions(self, filter: str, /) -> bool: ...
    def setExcludeUserAttributesKeys(self, filter: str, /) -> bool: ...
    def setIncludeElevations(self, filter: str, /) -> bool: ...
    def setIncludeFullDescriptions(self, filter: str, /) -> bool: ...
    def setIncludeNames(self, filter: str, /) -> bool: ...
    def setIncludeNumbers(self, filter: str, /) -> bool: ...
    def setIncludeRawDescriptions(self, filter: str, /) -> bool: ...
    def setIncludeUserAttributesKeys(self, filter: str, /) -> bool: ...
    def setIncludeUserAttributesValues(self, filter: str, /) -> bool: ...
    def update(self, /) -> bool: ...
    def updateNeeded(self, /) -> bool: ...

class CvDbPointGroupManager(PyBrxCv.CvDbObjectManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbPointGroupManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbPointGroupManager: ...
    def createPointGroup(self, val: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    def groupsWithPoint(self, val: int, /) -> list[PyDb.ObjectId]: ...
    def nextPointNumber(self, /) -> int: ...
    @staticmethod
    def openManager(db: PyDb.Database, mode: PyDb.OpenMode, /) -> CvDbPointGroupManager: ...
    def setNextPointNumber(self, val: int, /) -> bool: ...
    def updatePointGroups(self, /) -> int: ...

class CvDbPointLabelStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbPointLabelStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbPointLabelStyleManager: ...
    def createLabelStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(db: PyDb.Database, mode: PyDb.OpenMode, /) -> CvDbPointLabelStyleManager: ...

class CvDbPointReferencedEntity(PyBrxCv.CvDbSubObject):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbPointReferencedEntity: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def id(self, /) -> PyDb.ObjectId: ...
    def setId(self, id: PyDb.ObjectId, /) -> bool: ...
    def type(self, /) -> PyRx.RxClass: ...

class CvDbStyle(PyBrxCv.CvDbObject):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbStyle: ...
    @staticmethod
    def className() -> str: ...
    def createdBy(self, /) -> str: ...
    def createdDate(self, /) -> PyDb.Date: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def displaySetting(
        self, orientation: PyBrxCv.DisplayOrientation, partName: str, /
    ) -> CvDbStylePartDisplaySettings: ...
    def displaySettings(
        self, orientation: PyBrxCv.DisplayOrientation, /
    ) -> list[PyBrxCv.CvDbStylePartDisplaySettings]: ...
    def lastEditedBy(self, /) -> str: ...
    def lastEditedDate(self, /) -> PyDb.Date: ...
    def setCreatedBy(self, filter: str, /) -> None: ...

class CvDbStyleManager(PyBrxCv.CvDbObjectManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbStyleManager: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManager(db: PyDb.Database, styleType: PyBrxCv.StyleManagerType, /) -> PyDb.ObjectId: ...
    @staticmethod
    def openManager(
        db: PyDb.Database, mode: PyDb.OpenMode, styleType: PyBrxCv.StyleManagerType, /
    ) -> CvDbObjectManager: ...

class CvDbStylePartDisplaySettings(PyBrxCv.CvDbSubObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def color(self, /) -> PyDb.Color: ...
    def displaySetting(self, /) -> bool: ...
    def layer(self, /) -> PyDb.ObjectId: ...
    def lineType(self, /) -> PyDb.ObjectId: ...
    def lineTypeScale(self, /) -> float: ...
    def lineWeight(self, /) -> PyDb.LineWeight: ...
    def plotStyleNameId(self, /) -> PyDb.ObjectId: ...
    def plotStyleNameType(self, /) -> PyDb.PlotStyleNameType: ...
    def setColor(self, clr: PyDb.Color, /) -> None: ...
    def setLayer(self, id: PyDb.ObjectId, /) -> None: ...
    def setLineType(self, id: PyDb.ObjectId, /) -> None: ...
    def setLineTypeScale(self, val: float, /) -> None: ...
    def setLineWeight(self, val: PyDb.LineWeight, /) -> None: ...
    def setPlotStyleNameId(self, id: PyDb.ObjectId, /) -> None: ...
    def setPlotStyleNameType(self, val: PyDb.PlotStyleNameType, /) -> None: ...
    def setVisible(self, val: bool, /) -> None: ...

class CvDbSubObject(PyRx.RxObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbSubObject: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def description(self, /) -> str: ...
    def name(self, /) -> str: ...
    def setDescription(self, val: str, /) -> bool: ...
    def setName(self, val: str, /) -> bool: ...

class CvDbSurfaceContourLabelStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbSurfaceContourLabelStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbSurfaceContourLabelStyleManager: ...
    def createLabelStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(
        db: PyDb.Database, mode: PyDb.OpenMode, /
    ) -> CvDbSurfaceContourLabelStyleManager: ...

class CvDbSurfaceElevationLabelStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbSurfaceElevationLabelStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbSurfaceElevationLabelStyleManager: ...
    def createLabelStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(
        db: PyDb.Database, mode: PyDb.OpenMode, /
    ) -> CvDbSurfaceElevationLabelStyleManager: ...

class CvDbSurfaceSlopeLabelStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbSurfaceSlopeLabelStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbSurfaceSlopeLabelStyleManager: ...
    def createLabelStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(
        db: PyDb.Database, mode: PyDb.OpenMode, /
    ) -> CvDbSurfaceSlopeLabelStyleManager: ...

class CvDbSymbolStyle(PyBrxCv.CvDbStyle):
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, metric: bool, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, mode: PyDb.OpenMode, /) -> None: ...
    @overload
    def __init__(self, id: PyDb.ObjectId, mode: PyDb.OpenMode, erased: bool, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def asPDMODE(self, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbSymbolStyle: ...
    def circleFrame(self, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def customSymbol(self, /) -> CustomSymbol: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def fixedScale(self, /) -> PyGe.Scale3d: ...
    def maximumSize(self, /) -> float: ...
    def orientationReference(self, /) -> OrientationRef: ...
    def rotationAngle(self, /) -> float: ...
    def scalingType(self, /) -> ScalingType: ...
    def setCircleFrame(self, val: bool, /) -> None: ...
    def setCustomSymbol(self, val: PyBrxCv.CustomSymbol, /) -> None: ...
    def setFixedScale(self, scale: PyGe.Scale3d, /) -> None: ...
    def setMaximumSize(self, val: float, /) -> None: ...
    def setOrientationReference(self, val: PyBrxCv.OrientationRef, /) -> None: ...
    def setPDMODE(self, val: int, /) -> None: ...
    def setRotationAngle(self, val: float, /) -> None: ...
    def setScalingType(self, val: PyBrxCv.ScalingType, /) -> None: ...
    def setSize(self, val: float, /) -> None: ...
    def setSquareFrame(self, val: bool, /) -> None: ...
    def setSymbolBlockId(self, id: PyDb.ObjectId, /) -> None: ...
    def setSymbolType(self, val: PyBrxCv.SymbolType, /) -> None: ...
    def size(self, /) -> float: ...
    def squareFrame(self, /) -> bool: ...
    def symbolBlockId(self, /) -> PyDb.ObjectId: ...
    def symbolType(self, /) -> SymbolType: ...

class CvDbSymbolStyleManager(PyBrxCv.CvDbStyleManager):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbSymbolStyleManager: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbSymbolStyleManager: ...
    def createSymbolStyle(self, name: str, /) -> PyDb.ObjectId: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    @staticmethod
    def getManagerId(db: PyDb.Database, /) -> PyDb.ObjectId: ...
    @staticmethod
    def managerId() -> str: ...
    @staticmethod
    def openManager(db: PyDb.Database, mode: PyDb.OpenMode, /) -> CvDbSymbolStyleManager: ...

class CvDbTinSurface(PyBrxCv.CvDbEntity):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addConstraint(
        self, constraint: PyBrxCv.CvDbTinSurfaceConstraint, addReactor: bool, /
    ) -> bool: ...
    def addConstraints(
        self, constraints: list[PyBrxCv.CvDbTinSurfaceConstraint], addReactor: bool, /
    ) -> bool: ...
    def addDefinition(self, ref: PyBrxCv.CvDbTinSurfaceDefinition, /) -> int: ...
    def addPoint(self, pt: PyGe.Point3d, /) -> bool: ...
    def addPoints(self, pts: list[PyGe.Point3d], /) -> bool: ...
    def area2d(self, visibleOnly: bool = False, /) -> float: ...
    def area3d(self, visibleOnly: bool = False, /) -> float: ...
    def boundingBox(self, /) -> tuple[PyGe.Point2d, PyGe.Point2d]: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurface: ...
    def changePointsElevations(
        self, pts: list[PyGe.Point3d], newZValues: list[float], /
    ) -> bool: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbTinSurface: ...
    def closestPointTo(self, pt: PyGe.Point3d, /) -> PyGe.Point3d: ...
    def contains(self, pt: PyGe.Point3d, /) -> bool: ...
    def contoursAtElevation(self, elevation: float, /) -> list[list[PyGe.Point3d]]: ...
    def createSnapshot(self, /) -> int: ...
    def definitionAt(self, index: int, /) -> CvDbTinSurfaceDefinition: ...
    def definitionCount(self, /) -> int: ...
    def definitionIndex(self, ref: PyBrxCv.CvDbTinSurfaceDefinition, /) -> tuple[bool, int]: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def drapeId(self, id: PyDb.ObjectId, /) -> list[list[PyGe.Point3d]]: ...
    def drapePoints(self, pts: list[PyGe.Point3d], /) -> list[list[PyGe.Point3d]]: ...
    def elevationAtPoint(self, pt: PyGe.Point3d, /) -> tuple[bool, float]: ...
    def eraseConstraint(self, id: PyDb.ObjectId | int, removeReactor: bool, /) -> bool: ...
    def eraseConstraints(self, int64ids: list[int], removeReactor: bool, /) -> bool: ...
    def eraseConstraintsIds(self, ids: list[PyDb.ObjectId], removeReactor: bool, /) -> bool: ...
    def findDefinition(self, id: int, /) -> CvDbTinSurfaceDefinition: ...
    def findTinPointAt(self, pt: PyGe.Point3d, /) -> tuple[bool, PyBrxCv.CvTinPoint]: ...
    def findTinTrianglesAt(self, pt: PyGe.Point3d, /) -> list[PyBrx.CvTinTriangle]: ...
    def getBorders(self, /) -> list[list[PyGe.Point3d]]: ...
    def getConstraint(self, id: PyDb.ObjectId | int, /) -> CvDbTinSurfaceConstraint: ...
    def getConstraints(self, /) -> list[PyBrxCv.CvDbTinSurfaceConstraint]: ...
    def getPoints(self, visibleOnly: bool = False, /) -> list[PyGe.Point3d]: ...
    def getPointsInsidePolygon(
        self, pts: list[PyGe.Point3d], includeOnEdge: bool, /
    ) -> list[PyGe.Point3d]: ...
    def getTinPoints(self, /) -> list[PyBrx.CvTinPoint]: ...
    def hasSnapshot(self, /) -> bool: ...
    def initialize(self, min: PyGe.Point3d, max: PyGe.Point3d, numOfPoints: int, /) -> None: ...
    def insertDefinitionAt(self, index: int, ref: PyBrxCv.CvDbTinSurfaceDefinition, /) -> int: ...
    def intersectionsWithLine(
        self,
        start: PyGe.Point3d,
        end: PyGe.Point3d,
        type: PyBrxCv.TinSurfaceIntersectType,
        visibleOnly: bool,
        /,
    ) -> tuple[bool, list[PyGe.Point3d]]: ...
    def isAssociative(self, /) -> bool: ...
    def isAutoUpdate(self, /) -> bool: ...
    def isRebuildPossible(self, /) -> bool: ...
    def isSnapshotUpdateNeeded(self, /) -> bool: ...
    def isUpdateNeeded(self, /) -> bool: ...
    def majorContours(self, /) -> list[list[PyGe.Point3d]]: ...
    def majorContoursColor(self, /) -> tuple[bool, int]: ...
    def majorContoursInterval(self, /) -> tuple[bool, int]: ...
    def maxElevation(self, visibleOnly: bool = False, /) -> float: ...
    def merge(self, other: PyBrxCv.CvDbTinSurface, /) -> bool: ...
    def mergeSurfaces(
        theOne: PyBrxCv.CvDbTinSurface, theOther: PyBrxCv.CvDbTinSurface, /
    ) -> CvDbTinSurface: ...
    def minElevation(self, visibleOnly: bool = False, /) -> float: ...
    def minorContours(self, /) -> list[list[PyGe.Point3d]]: ...
    def minorContoursColor(self, /) -> tuple[bool, int]: ...
    def minorContoursInterval(self, /) -> tuple[bool, int]: ...
    def moveDefinition(self, _from: int, _to: int, /) -> int: ...
    def movePoint(self, _from: PyGe.Point3d, _to: PyGe.Point3d, /) -> bool: ...
    def movePoints(self, _from: list[PyGe.Point3d], _to: list[PyGe.Point3d], /) -> bool: ...
    def pointsCount(self, visibleOnly: bool = False, /) -> int: ...
    def raiseSurface(self, offset: float, /) -> bool: ...
    def rebuild(self, val: bool, /) -> bool: ...
    def rebuildSnapshot(self, /) -> bool: ...
    def removeAllDefinitions(self, /) -> int: ...
    def removeDefinitionAt(self, index: int, /) -> bool: ...
    def removePoint(self, pt: PyGe.Point3d, /) -> bool: ...
    def removePoints(self, pts: list[PyGe.Point3d], /) -> bool: ...
    def removeSnapshot(self, /) -> bool: ...
    def setAssociative(self, isAssociative: bool, /) -> bool: ...
    def setIsAutoUpdate(self, autoUpdateOn: bool, /) -> bool: ...
    def setMajorContoursColor(self, colorIndex: int, /) -> bool: ...
    def setMajorContoursInterval(self, interval: float, /) -> bool: ...
    def setMinorContoursColor(self, colorIndex: int, /) -> bool: ...
    def setMinorContoursInterval(self, interval: float, /) -> bool: ...
    def setStyle(self, style: PyBrxCv.TinSurfaceStyle, /) -> bool: ...
    def setSurfaceElevation(self, elevation: float, /) -> bool: ...
    @overload
    def solid3d(self, surface: PyBrxCv.CvDbTinSurface, /) -> PyDb.Solid3d: ...
    @overload
    def solid3d(
        self, surfaceType: PyBrxCv.TinSurfaceMeshType, thickness: float, /
    ) -> PyDb.Solid3d: ...
    @overload
    def solid3d(self, *args) -> PyDb.Solid3d: ...
    def style(self, /) -> TinSurfaceStyle: ...
    @overload
    def subDMesh(self, /) -> PyDb.SubDMesh: ...
    @overload
    def subDMesh(self, surface: PyBrxCv.CvDbTinSurface, /) -> PyDb.SubDMesh: ...
    @overload
    def subDMesh(
        self, surfaceType: PyBrxCv.TinSurfaceMeshType, depthOrElevation: float, /
    ) -> PyDb.SubDMesh: ...
    @overload
    def subDMesh(self, *args) -> PyDb.SubDMesh: ...
    def swapEdge(self, pt: PyGe.Point3d, /) -> bool: ...
    def tinTriangles(self, /) -> list[PyBrx.CvTinTriangle]: ...
    def triangles(self, visibleOnly: bool = False, /) -> list[PyBrx.CvTinTriangle]: ...
    def trianglesCount(self, visibleOnly: bool = False, /) -> int: ...
    def updateConstraint(self, val: PyBrxCv.CvDbTinSurfaceConstraint, /) -> bool: ...
    def updateObjectData(self, /) -> None: ...

class CvDbTinSurfaceBoundary(PyBrxCv.CvDbTinSurfaceConstraint):
    def __init__(self, type: PyBrxCv.TinBoundaryType, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def wallType(self, /) -> TinBoundaryType: ...

class CvDbTinSurfaceBreakline(PyBrxCv.CvDbTinSurfaceConstraint):
    def __init__(self, type: PyBrxCv.TinBreaklineType, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def intersectionElevation(self, /) -> BreaklineIntersectionElevation: ...
    def setIntersectionElevation(self, val: PyBrxCv.TinBreaklineType, /) -> None: ...

class CvDbTinSurfaceConstraint:
    def __init__(self, type: PyBrxCv.TinConstraintType, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def constraintType(self, /) -> TinConstraintType: ...
    def data(self, /) -> list[PyGe.Point3d]: ...
    def id(self, /) -> int: ...
    def isDbResident(self, /) -> bool: ...
    def midOrdinateDistance(self, /) -> float: ...
    def setData(self, intId: int, pts: list[PyGe.Point3d], /) -> None: ...
    def setDataId(self, id: PyDb.ObjectId, midOrdinateDist: float, /) -> None: ...
    def setIsDbResident(self, val: bool, /) -> None: ...
    def setMidOrdinateDistance(self, val: float, /) -> None: ...

class CvDbTinSurfaceDefinition(PyBrxCv.CvDbSubObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinition: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def description(self, /) -> str: ...
    def id(self, /) -> int: ...
    def isEnabled(self, /) -> bool: ...
    def isReadOnly(self, /) -> bool: ...
    def isSubDefinition(self, /) -> bool: ...
    def isUpdateNeeded(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def setDescription(self, desc: str, /) -> bool: ...
    def setEnabled(self, val: bool, /) -> bool: ...
    def setName(self, name: str, /) -> bool: ...
    def setReadOnly(self, val: bool, /) -> bool: ...
    def type(self, /) -> TinSurfaceDefinitionType: ...

class CvDbTinSurfaceDefinitionAddDrawingObjects(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addEntity(self, entity: PyDb.Entity, /) -> bool: ...
    def addEntityId(self, id: PyDb.ObjectId, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddDrawingObjects: ...
    @staticmethod
    def className() -> str: ...
    def crossingsElevation(self, /) -> TinIntersectionElevation: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def drawingObjectAt(
        self, idx: int, /
    ) -> tuple[bool, PyBrx.DrawingObjectTypet, list[PyGe.Point3d]]: ...
    def drawingObjectsCount(self, /) -> int: ...
    def isApplyEdges(self, /) -> bool: ...
    def removeAllDrawingObjects(self, /) -> bool: ...
    def removeDrawingObjectAt(self, idx: int, /) -> bool: ...
    def setCrossingsElevation(self, val: PyBrxCv.TinIntersectionElevation, /) -> bool: ...
    def setIsApplyEdges(self, val: bool, /) -> bool: ...

class CvDbTinSurfaceDefinitionAddFromFiles(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddFromFiles: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def fileFormatId(self, /) -> PyDb.ObjectId: ...
    def filesPaths(self, /) -> list[str]: ...
    def setFileFormatId(self, id: PyDb.ObjectId, /) -> bool: ...
    def setFilesPaths(self, val: list[str], /) -> bool: ...

class CvDbTinSurfaceDefinitionAddFromPointClouds(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddFromPointClouds: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def pcObjectIds(self, /) -> list[PyDb.ObjectId]: ...
    def setPcObjectIds(self, val: list[PyDb.ObjectId], /) -> bool: ...

class CvDbTinSurfaceDefinitionAddLine(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddLine: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def line(self, /) -> PyGe.LineSeg2d: ...
    def setLine(self, line: PyGe.LineSeg2d, /) -> bool: ...

class CvDbTinSurfaceDefinitionAddLines(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddLines: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def lines(self, /) -> list[PyGe.LineSeg3d]: ...
    def setLines(self, lines: list[PyGe.LineSeg2d], /) -> bool: ...

class CvDbTinSurfaceDefinitionAddPoint(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddPoint: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def position(self, /) -> PyGe.Point3d: ...
    def setPosition(self, pt: PyGe.Point3d, /) -> bool: ...

class CvDbTinSurfaceDefinitionAddPointGroups(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddPointGroups: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def pointGroupsIds(self, /) -> list[PyDb.ObjectId]: ...
    def setPointGroupsIds(self, val: list[PyDb.ObjectId], /) -> bool: ...

class CvDbTinSurfaceDefinitionAddPoints(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionAddPoints: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def positions(self, /) -> list[PyGe.Point2d]: ...
    def setPositions(self, pt: list[PyGe.Point3d], /) -> bool: ...

class CvDbTinSurfaceDefinitionCreateFromC3D(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionCreateFromC3D: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def filePath(self, /) -> str: ...
    def setFilePath(self, val: str, /) -> bool: ...
    def setSurfaceName(self, val: str, /) -> bool: ...
    def surfaceName(self, /) -> str: ...

class CvDbTinSurfaceDefinitionCreateFromFaces(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionCreateFromFaces: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def faceAt(self, /) -> tuple[bool, PyDb.Face]: ...
    def facesCount(self, /) -> int: ...
    def isApplyEdgesVisibility(self, /) -> bool: ...
    def points(self, /) -> list[PyGe.Point3d]: ...
    def setIsApplyEdgesVisibility(self, /) -> bool: ...

class CvDbTinSurfaceDefinitionCreateFromLandXML(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionCreateFromLandXML: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def dwgUnits(self, /) -> PyDb.UnitsValue: ...
    def filePath(self, /) -> str: ...
    def scaleToDwgUnits(self, /) -> bool: ...
    def setFilePath(self, val: str, /) -> bool: ...
    def setScaleToDwgUnits(self, val: bool, /) -> bool: ...
    def setSurfaceName(self, val: str, /) -> bool: ...
    def surfaceName(self, /) -> str: ...

class CvDbTinSurfaceDefinitionDeleteEdge(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionDeleteEdge: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def position(self, /) -> PyGe.Point2d: ...
    def setPosition(self, pt: PyGe.Point2d, /) -> bool: ...

class CvDbTinSurfaceDefinitionDeleteEdges(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addPolygon(self, edgePolygon: list[PyGe.Point2d], includeIntersected: bool, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionDeleteEdges: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def polygonAt(self, index: int, /) -> tuple[bool, list[PyGe.Point2d]]: ...
    def polygonsCount(self, /) -> int: ...
    def removeAllPolygons(self, /) -> bool: ...
    def removePolygonAt(self, index: int, /) -> bool: ...

class CvDbTinSurfaceDefinitionDeletePoint(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionDeletePoint: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def position(self, /) -> PyGe.Point2d: ...
    def setPosition(self, pt: PyGe.Point2d, /) -> bool: ...

class CvDbTinSurfaceDefinitionGroupDefs(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addSubDefinition(self, val: PyBrxCv.CvDbTinSurfaceDefinition, /) -> int: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionGroupDefs: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def findSubDefinition(self, defid: int, /) -> int: ...
    def getSubDefinitionAt(self, index: int, /) -> CvDbTinSurfaceDefinition: ...
    def numSubDefinitions(self, /) -> int: ...
    def removeSubDefinitionAt(self, index: int, /) -> bool: ...

class CvDbTinSurfaceDefinitionModifyPointElevation(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionModifyPointElevation: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def elevation(self, /) -> float: ...
    def isDeltaElevation(self, /) -> bool: ...
    def position(self, /) -> PyGe.Point2d: ...
    def setElevation(self, val: float, /) -> bool: ...
    def setIsDeltaElevation(self, val: float, /) -> bool: ...
    def setPosition(self, pt: PyGe.Point2d, /) -> bool: ...

class CvDbTinSurfaceDefinitionModifyPointsElevation(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionModifyPointsElevation: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def elevation(self, /) -> float: ...
    def isDeltaElevation(self, /) -> bool: ...
    def positions(self, /) -> list[PyGe.Point2d]: ...
    def setElevation(self, val: float, /) -> bool: ...
    def setPositions(self, pt: list[PyGe.Point2d], /) -> bool: ...

class CvDbTinSurfaceDefinitionModifyPointsElevations(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addPointElevation(self, /) -> bool: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionModifyPointsElevations: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def pointElevationAt(self, /) -> tuple[bool, PyGe.Point2d]: ...
    def pointElevationsCount(self, /) -> int: ...
    def removeAllPointElevations(self, /) -> bool: ...
    def removePointElevationAt(self, /) -> bool: ...

class CvDbTinSurfaceDefinitionMovePoint(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionMovePoint: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def fromPosition(self, /) -> PyGe.Point2d: ...
    def setFromPosition(self, pt: PyGe.Point2d, /) -> bool: ...
    def setToPosition(self, pt: PyGe.Point2d, /) -> bool: ...
    def toPosition(self, /) -> PyGe.Point2d: ...

class CvDbTinSurfaceDefinitionMovePoints(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionMovePoints: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def displacement(self, /) -> PyGe.Vector2d: ...
    def fromPoints(self, /) -> list[PyGe.Point2d]: ...
    def setDisplacement(self, vec: PyGe.Vector3d, /) -> bool: ...
    def setFromPoints(self, pt: list[PyGe.Point2d], /) -> bool: ...

class CvDbTinSurfaceDefinitionRemoveElevations(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionRemoveElevations: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def removeAbove(self, /) -> bool: ...
    def removeAboveElevation(self, /) -> float: ...
    def removeBelow(self, /) -> bool: ...
    def removeBelowElevation(self, /) -> float: ...
    def removedPointsCount(self, /) -> int: ...
    def setRemoveAbove(self, val: bool, /) -> bool: ...
    def setRemoveAboveElevation(self, val: float, /) -> bool: ...
    def setRemoveBelow(self, val: bool, /) -> bool: ...
    def setRemoveBelowElevation(self, val: float, /) -> bool: ...

class CvDbTinSurfaceDefinitionRemoveOuterEdges(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionRemoveOuterEdges: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def maxAdjAngle(self, /) -> float: ...
    def maxEdgeLength(self, /) -> float: ...
    def minEdgeLength(self, /) -> float: ...
    def setMaxAdjAngle(self, val: float, /) -> bool: ...
    def setMaxEdgeLength(self, val: float, /) -> bool: ...
    def setMinEdgeLength(self, val: float, /) -> bool: ...
    def setUseMaxAdjAngle(self, val: bool, /) -> bool: ...
    def setUseMaxEdgeLength(self, val: bool, /) -> bool: ...
    def setUseMinEdgeLength(self, val: bool, /) -> bool: ...
    def useMaxAdjAngle(self, /) -> bool: ...
    def useMaxEdgeLength(self, /) -> bool: ...
    def useMinEdgeLength(self, /) -> bool: ...

class CvDbTinSurfaceDefinitionRiseLower(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionRiseLower: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def offset(self, /) -> float: ...
    def setOffset(self, val: float, /) -> bool: ...

class CvDbTinSurfaceDefinitionSwapEdge(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionSwapEdge: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def position(self, /) -> PyGe.Point2d: ...
    def setPosition(self, pt: PyGe.Point2d, /) -> bool: ...

class CvDbTinSurfaceDefinitionTransform(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionTransform: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def setTransformationMatrix(self, xform: PyGe.Matrix3d, /) -> bool: ...
    def transformationMatrix(self, /) -> PyGe.Matrix3d: ...

class CvDbTinSurfaceDefinitionTrianglesVisibility(PyBrxCv.CvDbTinSurfaceDefinition):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbTinSurfaceDefinitionTrianglesVisibility: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def positions(self, /) -> list[PyGe.Point2d]: ...
    def setPositions(self, val: list[PyGe.Point2d], /) -> bool: ...
    def setVisible(self, val: bool, /) -> bool: ...
    def visible(self, /) -> bool: ...

class CvDbTinSurfaceWall(PyBrxCv.CvDbTinSurfaceConstraint):
    def __init__(self, type: PyBrxCv.TinWallType, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def setHeight(self, val: float, /) -> None: ...
    def setWallSide(self, val: PyBrxCv.TinWallSide, /) -> None: ...
    def wallSide(self, /) -> TinWallSide: ...
    def wallType(self, /) -> TinWallType: ...

class CvDbVAlignment(PyBrxCv.CvDbCurve):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addArcAuto(self, prevId: int, nextId: int, /) -> int: ...
    def addArcBetween(self, prevId: int, nextId: int, radius: float, /) -> int: ...
    def addParabolaAuto(self, prevId: int, nextId: int, /) -> int: ...
    def addParabolaBetween(self, prevId: int, nextId: int, radius: float, /) -> int: ...
    def addTangentFixed(self, startPoint: PyGe.Point2d, endPoint: PyGe.Point2d, /) -> int: ...
    def baseHAlignment(self, /) -> PyDb.ObjectId: ...
    def baseSurface(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignment: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbVAlignment: ...
    def curveAtPVI(self, pvi: PyBrxCv.CvDbVAlignmentPVI, /) -> int: ...
    def curveElementColor(self, /) -> int: ...
    def deleteElement(self, id: int, /) -> bool: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def elementAtId(self, id: int, /) -> CvDbVAlignmentElement: ...
    def elementCount(self, /) -> int: ...
    def elevationMax(self, /) -> float: ...
    def elevationMin(self, /) -> float: ...
    def firstElementId(self, /) -> int: ...
    def firstTangentElementId(self, /) -> int: ...
    def getElementId(self, gsMarker: int, /) -> int: ...
    def getElevationAt(self, station: float, /) -> tuple[bool, float]: ...
    def getElevations(self, /) -> list[PyGe.Point2d]: ...
    def getPVIsArrays(self, /) -> list[PyBrxCv.CvDbVAlignmentPVI]: ...
    def getRadius(self, param: float, /) -> float: ...
    def getUnorderedElementIds(self, /) -> list[int]: ...
    def insertTangentFixed(
        self, startPoint: PyGe.Point2d, endPoint: PyGe.Point2d, val: int, /
    ) -> int: ...
    def lastElementId(self, /) -> int: ...
    def length(self, /) -> float: ...
    def lineElementColor(self, /) -> int: ...
    def nextTangentElementId(self, id: int, /) -> int: ...
    def previousTangentElementId(self, id: int, /) -> int: ...
    def pviAtCurve(self, curve: PyBrxCv.CvDbVAlignmentCurve, /) -> CvDbVAlignmentPVI: ...
    def setBaseHAlignment(self, id: PyDb.ObjectId, /) -> bool: ...
    def setBaseSurface(self, id: PyDb.ObjectId, /) -> bool: ...
    def setCurveElementColor(self, val: int, /) -> bool: ...
    def setLineElementColor(self, val: int, /) -> bool: ...
    def setStyle(self, val: int, /) -> bool: ...
    def setTangentPolygonColor(self, val: int, /) -> bool: ...
    def setType(self, val: VAlignmentType, /) -> bool: ...
    def style(self, /) -> int: ...
    def tangentPolygonColor(self, /) -> int: ...
    def type(self, /) -> VAlignmentType: ...
    def update(self, updateDependencies: bool, /) -> bool: ...

class CvDbVAlignmentArc(PyBrxCv.CvDbVAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentArc: ...
    def center(self, /) -> PyGe.Point2d: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def gradeIn(self, /) -> float: ...
    def gradeOut(self, /) -> float: ...
    def isClockwise(self, /) -> bool: ...
    def radius(self, /) -> float: ...
    def setCenter(self, pt: PyGe.Point2d, /) -> bool: ...
    def setClockwise(self, val: bool, /) -> bool: ...
    def setRadius(self, val: float, /) -> bool: ...

class CvDbVAlignmentCurve(PyBrxCv.CvDbVAlignmentElement):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentCurve: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def endPoint(self, /) -> PyGe.Point2d: ...
    def length(self, /) -> float: ...
    def startPoint(self, /) -> PyGe.Point2d: ...

class CvDbVAlignmentElement(PyBrxCv.CvDbSubObject):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentElement: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def id(self, /) -> int: ...
    def nextId(self, /) -> int: ...
    def parameterConstraint(self, /) -> VAlignmentParameterConstraint: ...
    def previousId(self, /) -> int: ...
    def setNextId(self, val: int, /) -> bool: ...
    def setParameterConstraint(self, val: PyBrxCv.VAlignmentParameterConstraint, /) -> bool: ...
    def setPreviousId(self, val: int, /) -> bool: ...
    def setTangencyConstraint(self, val: PyBrxCv.VAlignmentTangencyConstraint, /) -> bool: ...
    def tangencyConstraint(self, /) -> VAlignmentTangencyConstraint: ...
    def type(self, /) -> VAlignmentElementType: ...

class CvDbVAlignmentPVI(PyBrxCv.CvDbVAlignmentElement):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentPVI: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def location(self, /) -> PyGe.Point2d: ...

class CvDbVAlignmentParabola(PyBrxCv.CvDbVAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentParabola: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def gradeIn(self, /) -> float: ...
    def gradeOut(self, /) -> float: ...
    def radius(self, /) -> float: ...
    def setRadius(self, val: float, /) -> bool: ...

class CvDbVAlignmentTangent(PyBrxCv.CvDbVAlignmentCurve):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentTangent: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def passThroughPoint1(self, /) -> PyGe.Point2d: ...
    def passThroughPoint2(self, /) -> PyGe.Point2d: ...
    def setPassThroughPoint1(self, pt: PyGe.Point2d, /) -> bool: ...
    def setPassThroughPoint2(self, pt: PyGe.Point2d, /) -> bool: ...

class CvDbVAlignmentView(PyBrxCv.CvDbView):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentView: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbVAlignmentView: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def update(self, bUpdateDependencies: bool = True, updateOrigin: bool = True, /) -> bool: ...

class CvDbView(PyBrxCv.CvDbEntity):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addGraph(self, id: PyDb.ObjectId, /) -> bool: ...
    def baseElevation(self, /) -> float: ...
    def baseHAlignment(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbView: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbView: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def fromWCSPoint2d(self, pt: PyGe.Point2d, /) -> PyGe.Point2d: ...
    def fromWCSX(self, val: float, /) -> float: ...
    def fromWCSY(self, val: float, /) -> float: ...
    def graphAt(self, val: int, /) -> PyDb.ObjectId: ...
    def graphCount(self, /) -> int: ...
    def height(self, /) -> float: ...
    def horizontalScale(self, /) -> float: ...
    def length(self, /) -> float: ...
    def origin(self, /) -> PyGe.Point2d: ...
    def removeGraph(self, id: PyDb.ObjectId, /) -> bool: ...
    def setBaseElevation(self, val: float, /) -> bool: ...
    def setBaseHAlignment(self, id: PyDb.ObjectId, /) -> bool: ...
    def setHeight(self, val: float, /) -> bool: ...
    def setHorizontalScale(self, val: float, /) -> bool: ...
    def setLength(self, val: float, /) -> bool: ...
    def setOrigin(self, pt: PyGe.Point2d, /) -> bool: ...
    def setVerticalScale(self, val: float, /) -> bool: ...
    def toWCSPoint2d(self, pt: PyGe.Point2d, /) -> PyGe.Point2d: ...
    def toWCSX(self, val: float, /) -> float: ...
    def toWCSY(self, val: float, /) -> float: ...
    def verticalScale(self, /) -> float: ...

class CvDbVolumeSurface(PyBrxCv.CvDbTinSurface):
    def __init__(
        self,
        id: PyDb.ObjectId,
        mode: PyDb.OpenMode = PyDb.OpenMode.kForRead,
        erased: bool = False,
        /,
    ) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def baseSurfaceObjectId(self, /) -> PyDb.ObjectId: ...
    def boundingPolygon(self, /) -> list[PyGe.Point3d]: ...
    def boundingPolygonObjectId(self, /) -> PyDb.ObjectId: ...
    @staticmethod
    def cast(otherObject: PyRx.RxObject, /) -> CvDbVolumeSurface: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def cloneFrom(otherObject: PyRx.RxObject, /) -> CvDbVolumeSurface: ...
    def comparisonSurfaceObjectId(self, /) -> PyDb.ObjectId: ...
    def cutVolume(self, /) -> float: ...
    def depthElevation(self, /) -> float: ...
    @staticmethod
    def desc() -> PyRx.RxClass:
        """
        Returns a pointer to the AcRxClass object representing the specific class, or most recent
        parent class explicitly registered with ObjectARX of either the pointer type used to invoke
        it or the class qualifier used with it. (Remember that when a static member function is
        invoked via a pointer, the pointer type, not the object type, determines which
        implementation of the function is invoked.) When working with a pointer to an object and
        the proper AcRxClass object for the class of the object pointed to is desired, the
        AcRxObject::isA() function should be used, since it is a virtual non-static method and is
        therefore not pointer type dependent. Caching the value of the pointer returned by this
        method is acceptable, provided the application knows that the AcRxClass object pointed to
        by the returned pointer was created by an ObjectARX application that will not be unloaded.
        """
    def fillVolume(self, /) -> float: ...
    @overload
    def initialize(
        self,
        baseSurface: PyBrxCv.CvDbTinSurface,
        compSurface: PyBrxCv.CvDbTinSurface,
        boundingPolygon: list[PyGe.Poin3d],
        /,
    ) -> bool: ...
    @overload
    def initialize(
        self,
        baseSurface: PyBrxCv.CvDbTinSurface,
        compSurface: PyBrxCv.CvDbTinSurface,
        boundingPolygon: list[PyGe.Poin3d],
        midOrdinateDist: float,
        /,
    ) -> bool: ...
    @overload
    def initialize(
        self,
        baseSurface: PyBrxCv.CvDbTinSurface,
        referenceElevation: float,
        vType: PyBrxCv.VolumeSurfaceType,
        boundingPolygon: list[PyGe.Poin3d],
        /,
    ) -> bool: ...
    @overload
    def initialize(
        self,
        baseSurface: PyBrxCv.CvDbTinSurface,
        referenceElevation: float,
        vType: PyBrxCv.VolumeSurfaceType,
        boundingPolygonId: PyDb.ObjectId,
        midOrdinateDist: float,
        /,
    ) -> bool: ...
    @overload
    def initialize(self, *args) -> bool: ...
    def type(self, /) -> VolumeSurfaceType: ...

class CvGradingRule:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxCv.CvGradingRule, /) -> CvGradingRule: ...
    @staticmethod
    def className() -> str: ...
    @staticmethod
    def convertRadToSlope() -> float: ...
    @staticmethod
    def convertSlopeToRad() -> float: ...
    def isNull(self, /) -> bool: ...
    def release(self, /) -> bool: ...
    def setSide(self, format: int, /) -> bool: ...
    def setSlopeFormat(self, format: int, /) -> bool: ...
    def side(self, /) -> GradingSide: ...
    def slopeFormat(self, /) -> GradingSlopeFormat: ...
    def type(self, /) -> GradingType: ...

class CvGradingSlopeOffsetRule(PyBrxCv.CvGradingRule):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxCv.CvGradingRule, /) -> CvGradingSlopeOffsetRule: ...
    @staticmethod
    def className() -> str: ...
    def offset(self, /) -> float: ...
    def setOffset(self, offset: float, /) -> bool: ...
    def setSlope(self, slope: float, /) -> bool: ...
    def slope(self, /) -> float: ...

class CvGradingSlopeSurfaceRule(PyBrxCv.CvGradingRule):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PyBrxCv.CvGradingRule, /) -> CvGradingSlopeSurfaceRule: ...
    @staticmethod
    def className() -> str: ...
    def cutSlope(self, /) -> float: ...
    def fillSlope(self, /) -> float: ...
    def setCutSlope(self, val: float, /) -> bool: ...
    def setFillSlope(self, val: float, /) -> bool: ...
    def setSurfaceId(self, id: PyDb.ObjectId, /) -> bool: ...
    def surfaceId(self, /) -> PyDb.ObjectId: ...

class CvStationEquation:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(
        self, rawStation: float, stationForward: float, type: StationEquationType, /
    ) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getRawStation(self, /) -> float: ...
    def getStationForward(self, /) -> float: ...
    def getType(self, /) -> StationEquationType: ...
    def isNull(self, /) -> bool: ...
    def setRawStation(self, val: float, /) -> bool: ...
    def setStationForward(self, val: float, /) -> bool: ...
    def setType(self, val: PyBrxCv.EStationEquationType, /) -> bool: ...

class CvStationEquations:
    @overload
    def __init__(self, /) -> None: ...
    @overload
    def __init__(self, alignment: PyBrxCv.CvDbHAlignment, /) -> None: ...
    @overload
    def __init__(self, *args) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addStationEquation(self, equation: PyBrxCv.CvStationEquation, /) -> bool: ...
    @staticmethod
    def className() -> str: ...
    def getLengthFromRawStation(self, rawStation: float, /) -> float: ...
    def getRawStation(self, station: float, /) -> list[float]: ...
    def getRawStationFromLength(self, length: float, /) -> float: ...
    def getRefRawStartingStation(self, /) -> float: ...
    def getRefStartingLength(self, /) -> float: ...
    def getStartingStation(self, /) -> float: ...
    def getStation(self, rawStation: float, /) -> float: ...
    def getStationBack(self, idx: int, /) -> float: ...
    def getStationEquation(self, idx: int, /) -> CvStationEquation: ...
    def removeAllStationEquations(self, /) -> bool: ...
    def removeStationEquation(self, idx: int, /) -> bool: ...
    def setRefRawStartingStation(self, rawStartingStation: float, /) -> bool: ...
    def setRefStartingLength(self, startingStation: float, /) -> bool: ...
    def stationEquationsCount(self, /) -> int: ...
    def update(self, /) -> bool: ...

class CvTinPoint:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def isValid(self, /) -> bool: ...
    def location(self, /) -> PyGe.Point3d: ...
    def triangleWithPoint(self, /) -> CvTinTriangle: ...

class CvTinTriangle:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def isValid(self, /) -> bool: ...
    def isVisible(self, /) -> bool: ...
    def locationAt(self, index: int, /) -> PyGe.Point3d: ...
    def neighborAt(self, index: int, /) -> CvTinTriangle: ...
    def pointAt(self, index: int, /) -> CvTinPoint: ...

class DisplayMode(_BoostPythonEnum):
    eDisplayModeAsComposed: ClassVar[Self]  # 0
    eDisplayModeStackedText: ClassVar[Self]  # 1

class DisplayOrientation(_BoostPythonEnum):
    eDisplayOrientationPlan: ClassVar[Self]  # 0
    eDisplayOrientationModel: ClassVar[Self]  # 1
    eDisplayOrientationProfile: ClassVar[Self]  # 2
    eDisplayOrientationSection: ClassVar[Self]  # 3

class DrawingObjectType(_BoostPythonEnum):
    eUnknown: ClassVar[Self]  # 0
    ePoint: ClassVar[Self]  # 1
    eBlock: ClassVar[Self]  # 2
    eText: ClassVar[Self]  # 3
    eLine: ClassVar[Self]  # 4
    eFace: ClassVar[Self]  # 5
    ePolyline: ClassVar[Self]  # 6
    eCivilPoint: ClassVar[Self]  # 7

class ForcedInsertion(_BoostPythonEnum):
    eForcedInsertionNone: ClassVar[Self]  # 0
    eForcedInsertionTop: ClassVar[Self]  # 1
    eForcedInsertionBottom: ClassVar[Self]  # 2

class GradingCalculationMethod(_BoostPythonEnum):
    eGradingAccurate: ClassVar[Self]  # 0
    eGradingFast: ClassVar[Self]  # 1

class GradingSide(_BoostPythonEnum):
    eGradingSideNone: ClassVar[Self]  # -1
    eGradingSideLeft: ClassVar[Self]  # 0
    eGradingSideRight: ClassVar[Self]  # 1

class GradingSlopeFormat(_BoostPythonEnum):
    eSlopeNoFormat: ClassVar[Self]  # -1
    eSlopeRiseRun: ClassVar[Self]  # 0
    eSlopeDegrees: ClassVar[Self]  # 1
    eSlopePercent: ClassVar[Self]  # 2
    eSlopeRadians: ClassVar[Self]  # 3

class GradingStatus(_BoostPythonEnum):
    eGradingNoStatus: ClassVar[Self]  # 0
    eGradingOk: ClassVar[Self]  # 1
    eGradingUpdateNeeded: ClassVar[Self]  # 2
    eGradingIncorrectInputData: ClassVar[Self]  # 4
    eGradingSurfaceMissing: ClassVar[Self]  # 8
    eGradingRuleMissing: ClassVar[Self]  # 16
    eGradingInputDataOutsideSurface: ClassVar[Self]  # 32
    eGradingGradingOutsideSurface: ClassVar[Self]  # 64
    eGradingOffsetFailed: ClassVar[Self]  # 128
    eGradingMultipleOffsetResult: ClassVar[Self]  # 256
    eGradingZeroGrading: ClassVar[Self]  # 512
    eGradingUnknownError: ClassVar[Self]  # 1024
    eGradingInputDataMissing: ClassVar[Self]  # 2048
    eGradingInvalidInput: ClassVar[Self]  # 4096
    eGradingInvalidRule: ClassVar[Self]  # 8192
    eGradingTimeout: ClassVar[Self]  # 16384

class GradingType(_BoostPythonEnum):
    eGradingTypeNone: ClassVar[Self]  # -1
    eGradingTypeSlopeSurface: ClassVar[Self]  # 0
    eGradingTypeSlopeOffset: ClassVar[Self]  # 1

class GradingVisualStyle(_BoostPythonEnum):
    eGradingDrawNothing: ClassVar[Self]  # 0
    eGradingDrawSurface: ClassVar[Self]  # 1
    eGradingDrawRays: ClassVar[Self]  # 2
    eGradingDrawDaylight: ClassVar[Self]  # 4

class HAlignmentElementType(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    eLine: ClassVar[Self]  # 1
    eArc: ClassVar[Self]  # 2
    eSpiral: ClassVar[Self]  # 3
    eSpiralCurveSpiral: ClassVar[Self]  # 4
    eSpiralLineSpiral: ClassVar[Self]  # 5
    eSpiralLine: ClassVar[Self]  # 6
    eLineSpiral: ClassVar[Self]  # 7
    eSpiralCurve: ClassVar[Self]  # 8
    eCurveSpiral: ClassVar[Self]  # 9
    eSpiralSpiralCurveSpiralSpiral: ClassVar[Self]  # 10
    eMultipleSegments: ClassVar[Self]  # 11
    eSpiralCurveSpiralCurveSpiral: ClassVar[Self]  # 12
    eSpiralCurveSpiralSpiralCurveSpiral: ClassVar[Self]  # 13
    eSpiralSpiral: ClassVar[Self]  # 14
    eSpiralSpiralCurve: ClassVar[Self]  # 15
    eCurveSpiralSpiral: ClassVar[Self]  # 16
    eCurveLineCurve: ClassVar[Self]  # 17
    eCurveReverseCurve: ClassVar[Self]  # 18
    eCurveCurveReverseCurve: ClassVar[Self]  # 19
    ePI: ClassVar[Self]  # 100

class HAlignmentParameterConstraint(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    eAutomatic: ClassVar[Self]  # 100
    eLine_TwoPoints: ClassVar[Self]  # 200
    eLine_ThroughPoint: ClassVar[Self]  # 201
    eLine_Length: ClassVar[Self]  # 202
    eLine_BestFit: ClassVar[Self]  # 203
    eArc_ThreePoints: ClassVar[Self]  # 300
    eArc_CenterRadius: ClassVar[Self]  # 301
    eArc_CenterPassThrough: ClassVar[Self]  # 302
    eArc_PassThroughRadius: ClassVar[Self]  # 303
    eArc_PassThroughAttachToEnd: ClassVar[Self]  # 304
    eArc_PassThroughDirection: ClassVar[Self]  # 305
    eArc_Radius: ClassVar[Self]  # 306
    eArc_PassThrough: ClassVar[Self]  # 307
    eArc_RadiusAndLength: ClassVar[Self]  # 308
    eArc_PointOnTangent: ClassVar[Self]  # 309
    eArc_BestFit: ClassVar[Self]  # 310
    eSCS_SpiralInRadiusSpiralOut: ClassVar[Self]  # 400
    eSCS_SpiralLengthRadiusPassThrough: ClassVar[Self]  # 401
    eSCS_SpiralLengthRadiusArcLength: ClassVar[Self]  # 402
    eSCS_SpiralLengthRadius: ClassVar[Self]  # 403
    eSCS_SpiralLength: ClassVar[Self]  # 404
    eSCS_SpiralInLengthSpiralOutLength: ClassVar[Self]  # 405
    eSCS_SpiralInAValSpiralOutAVal: ClassVar[Self]  # 406
    eSCS_SpiralInAValRadiusSpiralOutAVal: ClassVar[Self]  # 407
    eSCS_SpiralAValRadiusPassThrough: ClassVar[Self]  # 408
    eSCS_SpiralAValRadiusArcLength: ClassVar[Self]  # 409
    eSCS_SpiralAValRadius: ClassVar[Self]  # 410
    eSCS_SpiralAVal: ClassVar[Self]  # 411
    eSCS_PointOnTangent: ClassVar[Self]  # 412
    eSpiral_StartPointDirRadiusLength: ClassVar[Self]  # 500
    eSpiral_StartPointDirStartAndEndRadiusLength: ClassVar[Self]  # 501
    eSTS_SpiralInLengthSpiralOutLength: ClassVar[Self]  # 600
    eSTS_TangentLength: ClassVar[Self]  # 601
    eSTS_SpiralInAValSpiralOutAVal: ClassVar[Self]  # 602
    eSTS_SpiralLengthTangentPassThrough: ClassVar[Self]  # 603
    eSTS_SpiralLengthTangentLength: ClassVar[Self]  # 604
    eSTS_SpiralAValTangentPassThrough: ClassVar[Self]  # 605
    eSTS_SpiralAValTangentLength: ClassVar[Self]  # 606
    eSSCSS_Sp1LenSp2LenRadiusPt: ClassVar[Self]  # 700
    eSSCSS_Sp1LenSp2LenPt1Pt2: ClassVar[Self]  # 701
    eSSCSS_Sp1AValSp2AValRadiusPt: ClassVar[Self]  # 702
    eSSCSS_Sp1AValSp2AValPt1Pt2: ClassVar[Self]  # 703

class HAlignmentTangencyConstraint(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    eFixed: ClassVar[Self]  # 1
    ePrevious: ClassVar[Self]  # 2
    eNext: ClassVar[Self]  # 3
    eBoth: ClassVar[Self]  # 4

class HAlignmentVisualStyle(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    eElements: ClassVar[Self]  # 1
    eTangentExtensions: ClassVar[Self]  # 2
    eElementExtensions: ClassVar[Self]  # 4

class LabelAnchor(_BoostPythonEnum):
    eLabelAnchors: ClassVar[Self]  # 0
    eLabelAnchorStart: ClassVar[Self]  # 0
    eLabelAnchorMiddle: ClassVar[Self]  # 1
    eLabelAnchorEnd: ClassVar[Self]  # 2
    eLabelAnchorTopLeft: ClassVar[Self]  # 3
    eLabelAnchorTopCenter: ClassVar[Self]  # 4
    eLabelAnchorTopRight: ClassVar[Self]  # 5
    eLabelAnchorMiddleLeft: ClassVar[Self]  # 6
    eLabelAnchorMiddleCenter: ClassVar[Self]  # 7
    eLabelAnchorMiddleRight: ClassVar[Self]  # 8
    eLabelAnchorBottomLeft: ClassVar[Self]  # 9
    eLabelAnchorBottomCenter: ClassVar[Self]  # 10
    eLabelAnchorBottomRight: ClassVar[Self]  # 11
    eLabelAnchorInsertionPoint: ClassVar[Self]  # 12
    eLabelAnchorCurveCenter: ClassVar[Self]  # 13
    eLabelAnchorCurvePI: ClassVar[Self]  # 14
    eLabelAnchorFeatureLocation: ClassVar[Self]  # 69

class LeaderAttachment(_BoostPythonEnum):
    eLeaderAttachmentTopOfTopLine: ClassVar[Self]  # 0
    eLeaderAttachmentMiddleOfTopLine: ClassVar[Self]  # 1
    eLeaderAttachmentMiddle: ClassVar[Self]  # 2
    eLeaderAttachmentMiddleOfBottomLine: ClassVar[Self]  # 3
    eLeaderAttachmentBottomOfBottomLine: ClassVar[Self]  # 4

class LeaderType(_BoostPythonEnum):
    eLeaderTypeStraight: ClassVar[Self]  # 0
    eLeaderTypeSpline: ClassVar[Self]  # 1

class LengthType(_BoostPythonEnum):
    eLengthTypeFixed: ClassVar[Self]  # 0
    eLengthTypePercentage: ClassVar[Self]  # 1

class OrientationRef(_BoostPythonEnum):
    eOrientationReferenceObject: ClassVar[Self]  # 0
    eOrientationReferenceView: ClassVar[Self]  # 1
    eOrientationReferenceWCS: ClassVar[Self]  # 2
    eOrientationReferenceStartLeaderAtMarker: ClassVar[Self]  # 9

class ScalingType(_BoostPythonEnum):
    eScalingTypeDrawingScale: ClassVar[Self]  # 0
    eScalingTypeFixedScale: ClassVar[Self]  # 1
    eScalingTypeAbsoluteUnits: ClassVar[Self]  # 2
    eScalingTypeRelativeToScreen: ClassVar[Self]  # 3

class SpiralCurveType(_BoostPythonEnum):
    eInCurve: ClassVar[Self]  # 0
    eOutCurve: ClassVar[Self]  # 1

class SpiralDefinitionType(_BoostPythonEnum):
    eClothoid: ClassVar[Self]  # 0
    eCubicParabola: ClassVar[Self]  # 1

class SpiralDefinitionTypeSpiral(_BoostPythonEnum):
    eClothoid: ClassVar[Self]  # 0
    eCubicParabola: ClassVar[Self]  # 1

class SpiralDirectionType(_BoostPythonEnum):
    eDirectionRight: ClassVar[Self]  # 0
    eDirectionLeft: ClassVar[Self]  # 1

class SpiralParameterType(_BoostPythonEnum):
    eClothoid: ClassVar[Self]  # 0
    eCubicParabola: ClassVar[Self]  # 0

class SpiralParameterType2(_BoostPythonEnum):
    eParamA: ClassVar[Self]  # 0
    eParamLength: ClassVar[Self]  # 1

class StationEquationType(_BoostPythonEnum):
    Increasing: ClassVar[Self]  # 0
    Decreasing: ClassVar[Self]  # 1

class StyleManagerType(_BoostPythonEnum):
    eSymbolStyle: ClassVar[Self]  # 0
    eLineLabel: ClassVar[Self]  # 1
    eCurveLabel: ClassVar[Self]  # 2
    ePointLabel: ClassVar[Self]  # 3
    eContourLabel: ClassVar[Self]  # 4
    eSurfaceSlopeLabel: ClassVar[Self]  # 5
    eSurfaceElevationLabel: ClassVar[Self]  # 6

class SymbolType(_BoostPythonEnum):
    eSymbolTypeACADPoint: ClassVar[Self]  # 0
    eSymbolTypeCustom: ClassVar[Self]  # 1
    eSymbolTypeBlock: ClassVar[Self]  # 2
    eSymbolTypeVerticalLine: ClassVar[Self]  # 3

class TinBoundaryType(_BoostPythonEnum):
    eTinShow: ClassVar[Self]  # 0
    eTinHide: ClassVar[Self]  # 1
    eTinOuter: ClassVar[Self]  # 2

class TinBreaklineType(_BoostPythonEnum):
    eTinBreaklineNormal: ClassVar[Self]  # 0
    eTinNonDestructive: ClassVar[Self]  # 1

class TinConstraintType(_BoostPythonEnum):
    eTinBreakline: ClassVar[Self]  # 0
    eTinBoundary: ClassVar[Self]  # 1
    eTinWall: ClassVar[Self]  # 2

class TinIntersectionElevation(_BoostPythonEnum):
    eTinNotAllowed: ClassVar[Self]  # 0
    eTinElevationMin: ClassVar[Self]  # 1
    eTinElevationMax: ClassVar[Self]  # 2
    eTinElevationMid: ClassVar[Self]  # 3

class TinSurfaceDefinitionType(_BoostPythonEnum):
    eNone: ClassVar[Self]  # 0
    eTransform: ClassVar[Self]  # 1
    eAddPoint: ClassVar[Self]  # 2
    eAddPoints: ClassVar[Self]  # 3
    eDeletePoint: ClassVar[Self]  # 4
    eDeletePoints: ClassVar[Self]  # 5
    eSwapEdge: ClassVar[Self]  # 6
    eMovePoint: ClassVar[Self]  # 7
    eMovePoints: ClassVar[Self]  # 8
    eAddBreaklines: ClassVar[Self]  # 9
    eAddBoundaries: ClassVar[Self]  # 10
    eAddWalls: ClassVar[Self]  # 11
    eVolume: ClassVar[Self]  # 12
    eMerge: ClassVar[Self]  # 13
    eDeleteEdge: ClassVar[Self]  # 14
    eDeleteEdges: ClassVar[Self]  # 15
    eAddLine: ClassVar[Self]  # 16
    eAddLines: ClassVar[Self]  # 17
    eModifyPointElevation: ClassVar[Self]  # 18
    eModifyPointsElevation: ClassVar[Self]  # 19
    eModifyPointsElevations: ClassVar[Self]  # 20
    eCreateFromFaces: ClassVar[Self]  # 21
    eAddDrawingObjects: ClassVar[Self]  # 22
    eCreateSnapshot: ClassVar[Self]  # 23
    eRiseLower: ClassVar[Self]  # 24
    eLandXML: ClassVar[Self]  # 25
    eAddPointFiles: ClassVar[Self]  # 26
    eAddPointGroups: ClassVar[Self]  # 27
    eAddPointClouds: ClassVar[Self]  # 28
    eGroupDefinitions: ClassVar[Self]  # 29
    eDeform: ClassVar[Self]  # 30
    eSmoothen: ClassVar[Self]  # 31
    eCreateMerged: ClassVar[Self]  # 32
    eIFC: ClassVar[Self]  # 33
    eCreateTypedSnapshot: ClassVar[Self]  # 34
    eCreateFromCorridor: ClassVar[Self]  # 35
    eCreateFromC3D: ClassVar[Self]  # 36
    eRemoveOuterEdges: ClassVar[Self]  # 37
    eCreateFromContours: ClassVar[Self]  # 38
    eMinimizeFlatAreas: ClassVar[Self]  # 39
    eTrianglesVisibility: ClassVar[Self]  # 40
    eRemoveBelowAboveElevation: ClassVar[Self]  # 41

class TinSurfaceIntersectType(_BoostPythonEnum):
    eTinSurfaceFirstOnly: ClassVar[Self]  # 0
    eTinSurfaceAll: ClassVar[Self]  # 1

class TinSurfaceMeshType(_BoostPythonEnum):
    eTinSurfaceMeshSurface: ClassVar[Self]  # 0
    eTinSurfaceMeshElevation: ClassVar[Self]  # 1
    eTinSurfaceMeshDepth: ClassVar[Self]  # 2

class TinSurfaceSolidType(_BoostPythonEnum):
    eSolidTypeSurfaceSurface: ClassVar[Self]  # 0
    eSolidTypeSurfaceElevation: ClassVar[Self]  # 1
    eSolidTypeSurfaceDepth: ClassVar[Self]  # 2

class TinSurfaceStyle(_BoostPythonEnum):
    eTinStyleNone: ClassVar[Self]  # 0
    eTinStyleBoundaryLine: ClassVar[Self]  # 1
    eTinStylePoints: ClassVar[Self]  # 2
    eTinStyleTriangles: ClassVar[Self]  # 4
    eTinStyleContours: ClassVar[Self]  # 8
    eTinStyleElevationTooltip: ClassVar[Self]  # 16

class TinWallSide(_BoostPythonEnum):
    eTinWallLeft: ClassVar[Self]  # 0
    eTinWallRight: ClassVar[Self]  # 1

class TinWallType(_BoostPythonEnum):
    eTinWallNormal: ClassVar[Self]  # 0
    eTinWallProjected: ClassVar[Self]  # 1

class VAlignmentElementType(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    eTangent: ClassVar[Self]  # 1
    eArc: ClassVar[Self]  # 2
    eParabola: ClassVar[Self]  # 3
    ePVI: ClassVar[Self]  # 100

class VAlignmentParameterConstraint(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    ePassThroughPoints: ClassVar[Self]  # 1
    eRadius: ClassVar[Self]  # 2
    eLength: ClassVar[Self]  # 3
    eAngle: ClassVar[Self]  # 4
    eAutomatic: ClassVar[Self]  # 5
    ePointOnTangent: ClassVar[Self]  # 6

class VAlignmentTangencyConstraint(_BoostPythonEnum):
    eUndefined: ClassVar[Self]  # 0
    eFixed: ClassVar[Self]  # 1
    ePrevious: ClassVar[Self]  # 2
    eNext: ClassVar[Self]  # 3
    eBoth: ClassVar[Self]  # 4

class VAlignmentType(_BoostPythonEnum):
    eLayout: ClassVar[Self]  # 0
    eStaticSurface: ClassVar[Self]  # 1
    eDynamicSurface: ClassVar[Self]  # 2
    eAutomatic: ClassVar[Self]  # 3

class VAlignmentVisualStyle(_BoostPythonEnum):
    eElements: ClassVar[Self]  # 1
    eTangents: ClassVar[Self]  # 2
    eExtensions: ClassVar[Self]  # 4

class VolumeSurfaceType(_BoostPythonEnum):
    eTinVolumeBaseComparison: ClassVar[Self]  # 0
    eTinVolumeToElevation: ClassVar[Self]  # 1
    eTinVolumeToDepth: ClassVar[Self]  # 2
