from __future__ import annotations

from typing import Any, ClassVar, Self

from pyrx import Db as PyDb
from pyrx import Ge as PyGe
from pyrx import Gs as PyGs
from pyrx.doc_utils.boost_meta import _BoostPythonEnum

kAerial: ViewProjection  # 1
kNoMap: ViewProjection  # 0

class Core:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def getBlockImage(
        blkid: PyDb.ObjectId, sx: int, sy: int, zoomFactor: float, bkrgb: list[int] = ..., /
    ) -> object: ...
    @staticmethod
    def getCurrent3DAcGsView(vpNum: int, /) -> GsView: ...
    @staticmethod
    def getCurrentAcGsView(vpNum: int, /) -> GsView: ...
    @staticmethod
    def getViewParameters(vpNum: int, view: PyGs.View, /) -> bool: ...
    @staticmethod
    def setViewParameters(
        vpNum: int, view: PyGs.View, bRegen: bool, bRescale: bool, bSync: bool = False, /
    ) -> bool: ...

class GraphicsKernel:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addRef(self, /) -> None: ...
    @staticmethod
    def className() -> str: ...
    def delRef(self, /) -> bool: ...

class GsManager:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...

class GsView:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def backClip(self, /) -> float: ...
    @staticmethod
    def className() -> str: ...
    def fieldHeight(self, /) -> float: ...
    def fieldWidth(self, /) -> float: ...
    def frontClip(self, /) -> float: ...
    def getViewport(self, /) -> tuple[PyGe.Point2d, PyGe.Point2d]: ...
    def graphicsKernel(self, /) -> GraphicsKernel: ...
    def isBackClipped(self, /) -> bool: ...
    def isFrontClipped(self, /) -> bool: ...
    def isNullObj(self, /) -> bool: ...
    def isPerspective(self, /) -> bool: ...
    def isViewportBorderVisible(self, /) -> bool: ...
    def objectToDeviceMatrix(self, /) -> PyGe.Matrix3d: ...
    def position(self, /) -> PyGe.Point3d: ...
    def projectionMatrix(self, /) -> PyGe.Matrix3d: ...
    def screenMatrix(self, /) -> PyGe.Matrix3d: ...
    def setBackClip(self, val: float, /) -> None: ...
    def setEnableBackClip(self, val: bool, /) -> None: ...
    def setEnableFrontClip(self, val: bool, /) -> None: ...
    def setFrontClip(self, val: float, /) -> None: ...
    def setView(
        self,
        pos: PyGe.Point3d,
        target: PyGe.Point3d,
        upVector: PyGe.Vector3d,
        fWidth: float,
        fHeight: float,
        projection: PyGs.ViewProjection = PyGs.ViewProjection.kParallel,
        /,
    ) -> None: ...
    def setViewport(self, lowerLeft: PyGe.Point2d, upperRight: PyGe.Point2d, /) -> None: ...
    def setViewportBorderVisibility(self, val: bool, /) -> None: ...
    def target(self, /) -> PyGe.Point3d: ...
    def upVector(self, /) -> PyGe.Vector3d: ...
    def viewingMatrix(self, /) -> PyGe.Matrix3d: ...
    def worldToDeviceMatrix(self, /) -> PyGe.Matrix3d: ...

class KernelDescriptor:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    def addSupport(self, /) -> None: ...
    @staticmethod
    def className() -> str: ...

class ViewProjection(_BoostPythonEnum):
    kNoMap: ClassVar[Self]  # 0
    kAerial: ClassVar[Self]  # 1
