from __future__ import annotations

from typing import Any, ClassVar, Self, overload

from pyrx import Db as PyDb
from pyrx import Sm as PySm
from pyrx.doc_utils.boost_meta import _BoostPythonEnum

kEmpty: PropertyFlags  # 0
kHardPointer: ObjectReferenceFlags  # 2
kIsChild: PropertyFlags  # 8
kLockedAccessDenied: LockStatus  # 16
kLockedLocal: LockStatus  # 1
kLockedNotConnected: LockStatus  # 8
kLockedReadOnly: LockStatus  # 4
kLockedRemote: LockStatus  # 2
kSheetProp: PropertyFlags  # 2
kSheetSetProp: PropertyFlags  # 1
kSoftPointer: ObjectReferenceFlags  # 1
kSubSetProp: PropertyFlags  # 4
kUnLocked: LockStatus  # 0

class CalloutBlocks(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, val: PySm.DbBlockRecordReference, /) -> None: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> CalloutBlocks: ...
    @staticmethod
    def className() -> str: ...
    def getDbBlockRecordReferences(self, /) -> list[PySm.DbBlockRecordReference]: ...
    def remove(self, val: PySm.DbBlockRecordReference, /) -> None: ...

class Component(PySm.Persist):
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> Component: ...
    @staticmethod
    def className() -> str: ...
    def getCustomPropertyBag(self, /) -> CustomPropertyBag: ...
    def getDesc(self, /) -> str: ...
    def getName(self, /) -> str: ...
    def setDesc(self, desc: str, /) -> None: ...
    def setName(self, name: str, /) -> None: ...

class CustomPropertyBag(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> CustomPropertyBag: ...
    @staticmethod
    def className() -> str: ...
    def getProperties(self, /) -> list[tuple[str, PySm.CustomPropertyValue]]: ...
    def getProperty(self, prop: str, /) -> CustomPropertyValue: ...
    def getPropertyValues(self, /) -> list[tuple[str, PyDb.AcValue]]: ...
    def hasProperty(self, prop: str, /) -> bool: ...
    def setProperty(self, prop: str, val: PySm.CustomPropertyValue, /) -> None: ...

class CustomPropertyValue(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> CustomPropertyValue: ...
    @staticmethod
    def className() -> str: ...
    def getFlags(self, /) -> PropertyFlags: ...
    def getValue(self, /) -> PyDb.AcValue: ...
    def setFlags(self, flags: PySm.PropertyFlags, /) -> None: ...
    def setValue(self, val: PyDb.AcValue | str | int | float, /) -> None: ...

class DbBlockRecordReference(PySm.NamedDbObjectReference):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> DbBlockRecordReference: ...
    @staticmethod
    def className() -> str: ...

class DbDatabase:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def getAcDbDatabase(self, /) -> PyDb.Database: ...

class DbLayoutReference(PySm.NamedDbObjectReference):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> DbLayoutReference: ...
    @staticmethod
    def className() -> str: ...

class DbObjectReference(PySm.FileReference):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> DbObjectReference: ...
    @staticmethod
    def className() -> str: ...
    def getAcDbHandle(self, /) -> PyDb.Handle: ...
    def getAcSmAcDbDatabase(self, /) -> DbDatabase: ...
    def resolveAcDbObject(self, db: PyDb.Database, /) -> PyDb.Handle: ...
    def setAcDbHandle(self, handle: PyDb.Handle, /) -> None: ...
    def setAcDbObject(self, obj: PyDb.Object, /) -> None: ...

class DbViewReference(PySm.NamedDbObjectReference):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> DbViewReference: ...
    @staticmethod
    def className() -> str: ...

class FileReference(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> FileReference: ...
    @staticmethod
    def className() -> str: ...
    def getFileName(self, /) -> str: ...
    def setFileName(self, fname: str, /) -> None: ...

class LockStatus(_BoostPythonEnum):
    kUnLocked: ClassVar[Self]  # 0
    kLockedLocal: ClassVar[Self]  # 1
    kLockedRemote: ClassVar[Self]  # 2
    kLockedReadOnly: ClassVar[Self]  # 4
    kLockedNotConnected: ClassVar[Self]  # 8
    kLockedAccessDenied: ClassVar[Self]  # 16

class NamedDbObjectReference(PySm.DbObjectReference):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> NamedDbObjectReference: ...
    @staticmethod
    def className() -> str: ...
    def getName(self, /) -> str: ...
    def getOwnerAcDbHandle(self, /) -> PyDb.Handle: ...
    def setName(self, val: str, /) -> None: ...
    def setOwnerAcDbHandle(self, val: PyDb.Handle, /) -> None: ...

class ObjectReference(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> ObjectReference: ...
    @staticmethod
    def className() -> str: ...
    def getReferenceFlags(self, /) -> ObjectReferenceFlags: ...
    def getReferencedObject(self, /) -> Persist: ...
    def setReferenceFlags(self, val: PySm.ObjectReferenceFlags, /) -> None: ...
    def setReferencedObject(self, val: PySm.Persist, /) -> None: ...

class ObjectReferenceFlags(_BoostPythonEnum):
    kSoftPointer: ClassVar[Self]  # 1
    kHardPointer: ClassVar[Self]  # 2

class Persist:
    def __init__(self) -> None:
        """
        Raises an exception.
        This class cannot be instantiated from Python.
        """
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> Persist: ...
    @staticmethod
    def className() -> str: ...
    def clear(self, /) -> None: ...
    def getDatabase(self, /) -> SmDatabase: ...
    def getIsDirty(self, /) -> bool: ...
    def getObjectId(self, /) -> object: ...
    def getOwner(self, /) -> Persist: ...
    def getTypeName(self, /) -> str: ...
    def initNew(self, owner: PySm.Persist, /) -> None: ...
    def isNull(self, /) -> bool: ...
    def setOwner(self, owner: PySm.Persist, /) -> None: ...

class PersistProxy(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> PersistProxy: ...
    @staticmethod
    def className() -> str: ...

class ProjectPointLocation(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> ProjectPointLocation: ...
    @staticmethod
    def className() -> str: ...
    def getFolder(self, /) -> str: ...
    def getPassword(self, /) -> str: ...
    def getResourceType(self, /) -> int: ...
    def getURL(self, /) -> str: ...
    def getUsername(self, /) -> str: ...
    def setFolder(self, val: str, /) -> None: ...
    def setPassword(self, val: str, /) -> None: ...
    def setResourceType(self, val: int, /) -> None: ...
    def setUsername(self, val: str, /) -> None: ...

class ProjectPointLocations(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addNewLocation(
        self, name: str, url: str, folder: str, username: str, password: str, /
    ) -> ProjectPointLocation: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> ProjectPointLocations: ...
    @staticmethod
    def className() -> str: ...
    def getLocation(self, locationName: str, /) -> ProjectPointLocation: ...
    def removeLocation(self, val: PySm.ProjectPointLocation, /) -> None: ...

class PropertyFlags(_BoostPythonEnum):
    kEmpty: ClassVar[Self]  # 0
    kSheetSetProp: ClassVar[Self]  # 1
    kSheetProp: ClassVar[Self]  # 2
    kSubSetProp: ClassVar[Self]  # 4
    kIsChild: ClassVar[Self]  # 8

class PublishOptions(PySm.Persist):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> PublishOptions: ...
    @staticmethod
    def className() -> str: ...
    def getDefaultFilename(self, /) -> str: ...
    def getDefaultOutputdir(self, /) -> FileReference: ...
    def getDwfType(self, /) -> bool: ...
    def getEplotFormat(self, /) -> int: ...
    def getIncludeSheetData(self, /) -> bool: ...
    def getIncludeSheetSetData(self, /) -> bool: ...
    def getLayerInfo(self, /) -> bool: ...
    def getLinesMerge(self, /) -> bool: ...
    def getPromptForName(self, /) -> bool: ...
    def getPromptForPassword(self, /) -> bool: ...
    def getUnrecognizedData(self, /) -> CustomPropertyBag: ...
    def getUnrecognizedSections(self, /) -> CustomPropertyBag: ...
    def getUsePassword(self, /) -> bool: ...
    def setDefaultFilename(self, val: str, /) -> None: ...
    def setDefaultOutputdir(self, val: PySm.FileReference, /) -> None: ...
    def setDwfType(self, val: bool, /) -> None: ...
    def setEplotFormat(self, val: int, /) -> None: ...
    def setIncludeSheetData(self, val: bool, /) -> None: ...
    def setIncludeSheetSetData(self, val: bool, /) -> None: ...
    def setLayerInfo(self, val: bool, /) -> None: ...
    def setLinesMerge(self, val: bool, /) -> None: ...
    def setPromptForName(self, val: bool, /) -> None: ...
    def setPromptForPassword(self, val: bool, /) -> None: ...
    def setUnrecognizedData(self, val: PySm.CustomPropertyBag, /) -> None: ...
    def setUnrecognizedSections(self, val: PySm.CustomPropertyBag, /) -> None: ...
    def setUsePassword(self, val: bool, /) -> None: ...

class Resources(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, val: PySm.FileReference, /) -> None: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> Resources: ...
    @staticmethod
    def className() -> str: ...
    def getFileReferences(self, /) -> list[PySm.FileReference]: ...
    def remove(self, val: PySm.FileReference, /) -> None: ...

class Sheet(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> Sheet: ...
    @staticmethod
    def className() -> str: ...
    def getCategory(self, /) -> str: ...
    def getDoNotPlot(self, /) -> bool: ...
    def getIssuePurpose(self, /) -> str: ...
    def getLayout(self, /) -> DbLayoutReference: ...
    def getNumber(self, /) -> str: ...
    def getRevisionDate(self, /) -> str: ...
    def getRevisionNumber(self, /) -> str: ...
    def getSheetViews(self, /) -> SheetViews: ...
    def getTitle(self, /) -> str: ...
    def setCategory(self, cat: str, /) -> None: ...
    def setDoNotPlot(self, flag: bool, /) -> None: ...
    def setIssuePurpose(self, why: str, /) -> None: ...
    def setLayout(self, layout: PySm.DbLayoutReference, /) -> None: ...
    def setNumber(self, number: str, /) -> None: ...
    def setRevisionDate(self, date: str, /) -> None: ...
    def setRevisionNumber(self, number: str, /) -> None: ...
    def setTitle(self, title: str, /) -> None: ...

class SheetSelSet(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, val: PySm.Component, /) -> None: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> SheetSelSet: ...
    @staticmethod
    def className() -> str: ...
    def getComponents(self, /) -> list[PySm.Component]: ...
    def remove(self, /) -> None: ...

class SheetSelSets(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def add(self, name: str, desc: str, /) -> SheetSelSet: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> SheetSelSets: ...
    @staticmethod
    def className() -> str: ...
    def getSheetSelSets(self, /) -> list[PySm.SheetSelSet]: ...
    def remove(self, val: PySm.SheetSelSet, /) -> None: ...

class SheetSet(PySm.Subset):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> SheetSet: ...
    @staticmethod
    def className() -> str: ...
    def getAltPageSetups(self, /) -> FileReference: ...
    def getCalloutBlocks(self, /) -> CalloutBlocks: ...
    def getDefAltPageSetup(self, /) -> NamedDbObjectReference: ...
    def getDefLabelBlk(self, /) -> DbBlockRecordReference: ...
    def getPromptForDwgName(self, /) -> bool: ...
    def getPublishOptions(self, /) -> PublishOptions: ...
    def getResources(self, /) -> Resources: ...
    def getSheetSelSets(self, /) -> SheetSelSets: ...
    def getViewCategories(self, /) -> ViewCategories: ...
    def setAltPageSetups(self, val: PySm.FileReference, /) -> None: ...
    def setDefAltPageSetup(self, val: PySm.NamedDbObjectReference, /) -> None: ...
    def setDefLabelBlk(self, val: PySm.DbBlockRecordReference, /) -> None: ...
    def setPromptForDwgName(self, val: bool, /) -> None: ...
    def sync(self, db: PyDb.Database, /) -> None: ...
    def updateSheetCustomProps(self, /) -> None: ...

class SheetSetMgr:
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def className() -> str: ...
    def close(self, smDb: PySm.Database, /) -> None: ...
    def closeAll(self, /) -> None: ...
    @overload
    def createDatabase(self, filename: str, /) -> SmDatabase: ...
    @overload
    def createDatabase(
        self, filename: str, template: str, bAlwaysCreate: bool, /
    ) -> SmDatabase: ...
    @overload
    def createDatabase(self, *args) -> SmDatabase: ...
    def findOpenDatabase(self, filename: str, /) -> SmDatabase: ...
    def getDatabases(self, /) -> list[PySm.SmDatabase]: ...
    def getParentSheetSet(
        self, dwg: str, layout: str, /
    ) -> tuple[PySm.SmDatabase, PySm.SheetSet]: ...
    def getSheetFromLayout(self, layout: PyDb.Object, /) -> tuple[PySm.SmDatabase, PySm.Sheet]: ...
    def openDatabase(self, filename: str, /) -> SmDatabase: ...

class SheetView(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> SheetView: ...
    @staticmethod
    def className() -> str: ...
    def getCategory(self, /) -> ViewCategory: ...
    def getNamedView(self, /) -> DbViewReference: ...
    def getNumber(self, /) -> str: ...
    def getTitle(self, /) -> str: ...
    def setCategory(self, val: PySm.ViewCategory, /) -> None: ...
    def setNamedView(self, val: PySm.AcDbViewReference, /) -> None: ...
    def setNumber(self, val: str, /) -> None: ...
    def setTitle(self, val: str, /) -> None: ...

class SheetViews(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> SheetViews: ...
    @staticmethod
    def className() -> str: ...
    def getSheetViews(self, /) -> list[PySm.SheetView]: ...
    def sync(self, val: PySm.AcDbLayoutReference, db: PyDb.Database, /) -> None: ...

class SmDatabase(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> SmDatabase: ...
    @staticmethod
    def className() -> str: ...
    def getFileName(self, /) -> str: ...
    def getLockOwnerInfo(self, /) -> tuple[str, str]: ...
    def getLockStatus(self, /) -> LockStatus: ...
    def getPersistObjects(self, /) -> list[PySm.Persist]: ...
    def getSheetSet(self, /) -> SheetSet: ...
    def getTemplateDstFileName(self, /) -> str: ...
    def loadFromFile(self, filename: str, /) -> None: ...
    def lockDb(self, /) -> None: ...
    def setFileName(self, filename: str, /) -> None: ...
    def unlockDb(self, commit: bool, /) -> None: ...

class Subset(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    def addNewSheet(self, name: str, desc: str, /) -> Sheet: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> Subset: ...
    @staticmethod
    def className() -> str: ...
    def createSubset(self, name: str, desc: str, /) -> Subset: ...
    def getDefDwtLayout(self, /) -> DbLayoutReference: ...
    def getNewSheetLocation(self, /) -> FileReference: ...
    def getOverrideSheetPublish(self, /) -> bool: ...
    def getPromptForDwt(self, /) -> bool: ...
    def getSheets(self, /) -> list[PySm.Sheet]: ...
    def importSheet(self, val: PySm.DbLayoutReference, /) -> Sheet: ...
    def insertComponent(
        self, newSheet: PySm.Component, beforeSheet: PySm.Component, /
    ) -> None: ...
    def insertComponentAfter(
        self, newSheet: PySm.Component, afterSheet: PySm.Component, /
    ) -> None: ...
    def insertComponentFirst(self, newSheet: PySm.Component, /) -> None: ...
    def removeSheet(self, val: PySm.Sheet, /) -> None: ...
    def removeSubset(self, val: PySm.Subset, /) -> None: ...
    def setDefDwtLayout(self, val: PySm.DbLayoutReference, /) -> None: ...
    def setNewSheetLocation(self, val: PySm.FileReference, /) -> None: ...
    def setOverrideSheetPublish(self, val: bool, /) -> None: ...
    def setPromptForDwt(self, val: bool, /) -> None: ...
    def updateInMemoryDwgHints(self, /) -> None: ...

class ViewCategories(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> ViewCategories: ...
    @staticmethod
    def className() -> str: ...
    def createViewCategory(self, name: str, desc: str, id: str, /) -> ViewCategory: ...
    def getDefaultViewCategory(self, /) -> ViewCategory: ...
    def getViewCategories(self, /) -> list[PySm.ViewCategory]: ...
    def removeViewCategory(self, val: PySm.ViewCategory, /) -> None: ...

class ViewCategory(PySm.Component):
    def __init__(self, /) -> None: ...
    def __reduce__(self, /) -> Any: ...
    @staticmethod
    def cast(otherObject: PySm.Persist, /) -> ViewCategory: ...
    @staticmethod
    def className() -> str: ...
    def getCalloutBlocks(self, /) -> CalloutBlocks: ...
    def getSheetViews(self, /) -> list[PySm.SheetView]: ...
