"""
restore missing indices and constraints on time_sku_data

Revision ID: 0f19c76c2458
Revises: 51adc521f5d4
Create Date: 2025-09-19 00:17:09.371709

"""

from collections.abc import Sequence

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "0f19c76c2458"
down_revision: str | Sequence[str] | None = "51adc521f5d4"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    bind = op.get_bind()

    # Drop staging tables conditionally using IF EXISTS (for fresh database compatibility)
    staging_tables = [
        "staging_time_sku_features_2023_07_9a44029e",
        "staging_time_sku_features_2021_02_d8c84cbd",
        "staging_time_sku_features_2022_02_81db6b88",
        "staging_time_sku_features_2022_07_4c0986db",
        "staging_time_sku_features_2021_12_f28d6f53",
        "staging_time_sku_features_2020_08_1c3944ec",
        "staging_time_sku_features_2021_07_c10e708e",
        "staging_time_sku_features_2021_09_a4815976",
        "staging_time_sku_features_2022_08_8931fe57",
        "staging_time_sku_features_2021_11_df1db7fe",
        "staging_time_sku_features_2023_06_29908c88",
        "staging_time_sku_features_2023_04_78d76f3e",
        "staging_time_sku_features_2023_03_6c447f33",
        "staging_time_sku_features_2022_06_c46cdf3c",
        "staging_time_sku_features_2023_01_08288098",
        "staging_time_sku_features_2020_10_81de1156",
        "staging_time_sku_features_2022_12_4b5a9a7c",
        "staging_time_sku_features_2021_03_f0a73c44",
        "staging_time_sku_features_2020_12_324ab215",
        "staging_time_sku_features_2023_11_7ca67d44",
        "staging_time_sku_features_2022_04_fec5e935",
        "staging_time_sku_features_2021_08_9dc4d536",
        "staging_time_sku_features_2021_06_38508d3b",
        "staging_time_sku_features_2023_02_7fa80e26",
        "staging_time_sku_features_2021_05_af433e67",
        "staging_time_sku_features_2021_04_451f2279",
        "staging_time_sku_features_2024_02_a7c33b66",
        "staging_time_sku_features_2023_08_4cdafad8",
        "staging_time_sku_features_2022_09_a3ab1e28",
        "staging_time_sku_features_2024_03_5d9e6203",
        "staging_time_sku_features_2023_09_a4b8b05a",
        "staging_time_sku_features_2020_11_d6cf1e4b",
        "staging_time_sku_features_2022_01_00811f6b",
        "staging_time_sku_features_2023_12_77293efe",
        "staging_time_sku_features_2021_01_3f1a0a18",
        "staging_time_sku_features_2022_03_c993d00a",
        "staging_time_sku_features_2022_03_90e3882a",
        "staging_time_sku_features_2022_10_d8d75c95",
        "staging_time_sku_features_2024_05_9f4b86d4",
        "staging_time_sku_features_2023_10_585522fa",
        "staging_time_sku_features_2021_10_75ee39ec",
        "staging_time_sku_features_2023_05_1e7e3863",
        "staging_time_sku_features_2021_09_1f07b073",
        "staging_time_sku_features_2022_05_05f95d19",
        "staging_time_sku_features_2022_11_2da0f275",
        "staging_time_sku_features_2020_09_ad77c31e",
        "staging_time_sku_features_2024_04_5f60f683",
        "staging_time_sku_features_2024_06_b5d2c38a",
        "staging_time_sku_features_2024_01_cff13f93"
    ]

    # Use SQL DROP IF EXISTS for each staging table
    for table_name in staging_tables:
        bind.execute(sa.text(f"DROP TABLE IF EXISTS {table_name}"))

    # Create the required indexes conditionally (main purpose of this migration)
    bind.execute(sa.text("""
        CREATE INDEX IF NOT EXISTS ix_tskuf_company_feature_ts
        ON time_sku_features (company_id, feature_id, ts)
    """))
    bind.execute(sa.text("""
        CREATE INDEX IF NOT EXISTS ix_tskuf_company_sku_ts
        ON time_sku_features (company_id, sku_id, ts)
    """))


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_tskuf_company_sku_ts", table_name="time_sku_features")
    op.drop_index("ix_tskuf_company_feature_ts", table_name="time_sku_features")
    op.create_table(
        "staging_time_sku_features_2024_01_cff13f93",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_06_b5d2c38a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_04_5f60f683",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_09_ad77c31e",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_11_2da0f275",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_05_05f95d19",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_09_1f07b073",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_05_1e7e3863",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_10_75ee39ec",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_10_585522fa",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_05_9f4b86d4",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_10_d8d75c95",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_03_90e3882a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_03_c993d00a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_01_3f1a0a18",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_12_77293efe",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_01_00811f6b",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_11_d6cf1e4b",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_09_a4b8b05a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_03_5d9e6203",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_09_a3ab1e28",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_08_4cdafad8",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_02_a7c33b66",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_04_451f2279",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_05_af433e67",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_02_7fa80e26",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_06_38508d3b",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_08_9dc4d536",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_04_fec5e935",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_11_7ca67d44",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_12_324ab215",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_03_f0a73c44",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_12_4b5a9a7c",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_10_81de1156",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_01_08288098",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_06_c46cdf3c",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_03_6c447f33",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_04_78d76f3e",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_06_29908c88",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_11_df1db7fe",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_08_8931fe57",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_09_a4815976",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_07_c10e708e",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_08_1c3944ec",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_12_f28d6f53",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_07_4c0986db",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_02_81db6b88",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_02_d8c84cbd",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_07_9a44029e",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    # ### end Alembic commands ###
