"""
add missing unique constraints

Revision ID: 9f2dac16ce3b
Revises: 136d2c0ff764
Create Date: 2025-09-15 14:04:05.419226

"""

from collections.abc import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "9f2dac16ce3b"
down_revision: str | Sequence[str] | None = "136d2c0ff764"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint(None, "category_relations", ["company_id", "sub_category_id", "parent_category_id"])
    op.create_unique_constraint(None, "product_categories", ["company_id", "product_id", "category_id"])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "product_categories", type_="unique")
    op.drop_constraint(None, "category_relations", type_="unique")
    # ### end Alembic commands ###
