"""
remove redundant indices from time tables

Revision ID: d2470bbb912d
Revises: 0f19c76c2458
Create Date: 2025-09-19 01:22:38.016833

"""

from collections.abc import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "d2470bbb912d"
down_revision: str | Sequence[str] | None = "0f19c76c2458"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_clc_asof"), table_name="change_log_committed")
    op.drop_index(op.f("ix_clc_company_delivery"), table_name="change_log_committed")
    op.drop_index(op.f("ix_dbd_company_day"), table_name="deliveries_by_day")
    op.drop_index(op.f("ix_dbd_company_sku_day"), table_name="deliveries_by_day")
    op.drop_index(op.f("ix_oid_company_orderday"), table_name="order_intake_daily")
    op.drop_index(op.f("ix_oid_company_sku_orderday"), table_name="order_intake_daily")
    op.drop_index(op.f("ix_tpf_company_feature_ts"), table_name="time_product_features")
    op.drop_index(op.f("ix_tpf_company_product_ts"), table_name="time_product_features")
    op.drop_index(op.f("ix_tpf_text_company_feature_ts"), table_name="time_product_features_text")
    op.drop_index(op.f("ix_tpf_text_company_product_ts"), table_name="time_product_features_text")
    op.drop_index(op.f("ix_trf_company_feature_ts"), table_name="time_region_features")
    op.drop_index(op.f("ix_trf_company_region_ts"), table_name="time_region_features")
    op.drop_index(op.f("ix_trf_text_company_feature_ts"), table_name="time_region_features_text")
    op.drop_index(op.f("ix_trf_text_company_region_ts"), table_name="time_region_features_text")
    op.drop_index(op.f("ix_tskuf_company_feature_ts"), table_name="time_sku_features")
    op.drop_index(op.f("ix_tskuf_company_sku_ts"), table_name="time_sku_features")
    op.drop_index(op.f("ix_tskuf_text_company_feature_ts"), table_name="time_sku_features_text")
    op.drop_index(op.f("ix_tskuf_text_company_sku_ts"), table_name="time_sku_features_text")
    op.drop_index(op.f("ix_tsf_company_feature_ts"), table_name="time_store_features")
    op.drop_index(op.f("ix_tsf_company_store_ts"), table_name="time_store_features")
    op.drop_index(op.f("ix_tsf_text_company_feature_ts"), table_name="time_store_features_text")
    op.drop_index(op.f("ix_tsf_text_company_store_ts"), table_name="time_store_features_text")
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        op.f("ix_tsf_text_company_store_ts"), "time_store_features_text", ["company_id", "store_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tsf_text_company_feature_ts"),
        "time_store_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_tsf_company_store_ts"), "time_store_features", ["company_id", "store_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tsf_company_feature_ts"), "time_store_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tskuf_text_company_sku_ts"), "time_sku_features_text", ["company_id", "sku_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tskuf_text_company_feature_ts"),
        "time_sku_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(op.f("ix_tskuf_company_sku_ts"), "time_sku_features", ["company_id", "sku_id", "ts"], unique=False)
    op.create_index(
        op.f("ix_tskuf_company_feature_ts"), "time_sku_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_trf_text_company_region_ts"),
        "time_region_features_text",
        ["company_id", "region_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_trf_text_company_feature_ts"),
        "time_region_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_trf_company_region_ts"), "time_region_features", ["company_id", "region_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_trf_company_feature_ts"), "time_region_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tpf_text_company_product_ts"),
        "time_product_features_text",
        ["company_id", "product_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_tpf_text_company_feature_ts"),
        "time_product_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_tpf_company_product_ts"), "time_product_features", ["company_id", "product_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tpf_company_feature_ts"), "time_product_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_oid_company_sku_orderday"), "order_intake_daily", ["company_id", "sku_id", "order_day"], unique=False
    )
    op.create_index(op.f("ix_oid_company_orderday"), "order_intake_daily", ["company_id", "order_day"], unique=False)
    op.create_index(
        op.f("ix_dbd_company_sku_day"), "deliveries_by_day", ["company_id", "sku_id", "delivery_day"], unique=False
    )
    op.create_index(op.f("ix_dbd_company_day"), "deliveries_by_day", ["company_id", "delivery_day"], unique=False)
    op.create_index(
        op.f("ix_clc_company_delivery"),
        "change_log_committed",
        ["company_id", "delivery_day", "valid_from"],
        unique=False,
    )
    op.create_index(
        op.f("ix_clc_asof"),
        "change_log_committed",
        ["company_id", "sku_id", "delivery_day", "valid_from"],
        unique=False,
    )
    # ### end Alembic commands ###
