"""rename quantity columns to quantity

Revision ID: 5df859d3bc55
Revises: c314c0e2becc
Create Date: 2025-09-19 16:46:31.076492

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '5df859d3bc55'
down_revision: Union[str, Sequence[str], None] = 'c314c0e2becc'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    bind = op.get_bind()

    # Add new quantity columns as nullable first (TimescaleDB constraint)
    op.add_column('change_log_committed', sa.Column('quantity', sa.DOUBLE_PRECISION(), nullable=True))
    op.add_column('expected_deliveries', sa.Column('quantity', sa.DOUBLE_PRECISION(), nullable=True))
    op.add_column('order_intake', sa.Column('quantity', sa.DOUBLE_PRECISION(), nullable=True))

    # Since tables are empty, we can directly set NOT NULL
    bind.execute(sa.text("ALTER TABLE change_log_committed ALTER COLUMN quantity SET NOT NULL"))
    bind.execute(sa.text("ALTER TABLE expected_deliveries ALTER COLUMN quantity SET NOT NULL"))
    bind.execute(sa.text("ALTER TABLE order_intake ALTER COLUMN quantity SET NOT NULL"))

    # Drop old columns and indexes
    op.drop_index(op.f('change_log_committed_sku_id_valid_from_idx'), table_name='change_log_committed')
    op.drop_index(op.f('change_log_committed_valid_from_idx'), table_name='change_log_committed')
    op.drop_column('change_log_committed', 'committed_qty')

    op.drop_index(op.f('expected_deliveries_expected_delivery_date_idx'), table_name='expected_deliveries')
    op.drop_index(op.f('expected_deliveries_sku_id_expected_delivery_date_idx'), table_name='expected_deliveries')
    op.drop_column('expected_deliveries', 'total_qty')

    op.drop_index(op.f('order_intake_order_date_idx'), table_name='order_intake')
    op.drop_index(op.f('order_intake_sku_id_order_date_idx'), table_name='order_intake')
    op.drop_column('order_intake', 'qty_total')


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('order_intake', sa.Column('qty_total', sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False))
    op.create_index(op.f('order_intake_sku_id_order_date_idx'), 'order_intake', ['sku_id', sa.literal_column('order_date DESC')], unique=False)
    op.create_index(op.f('order_intake_order_date_idx'), 'order_intake', [sa.literal_column('order_date DESC')], unique=False)
    op.drop_column('order_intake', 'quantity')
    op.add_column('expected_deliveries', sa.Column('total_qty', sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False))
    op.create_index(op.f('expected_deliveries_sku_id_expected_delivery_date_idx'), 'expected_deliveries', ['sku_id', sa.literal_column('expected_delivery_date DESC')], unique=False)
    op.create_index(op.f('expected_deliveries_expected_delivery_date_idx'), 'expected_deliveries', [sa.literal_column('expected_delivery_date DESC')], unique=False)
    op.drop_column('expected_deliveries', 'quantity')
    op.add_column('change_log_committed', sa.Column('committed_qty', sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False))
    op.create_index(op.f('change_log_committed_valid_from_idx'), 'change_log_committed', [sa.literal_column('valid_from DESC')], unique=False)
    op.create_index(op.f('change_log_committed_sku_id_valid_from_idx'), 'change_log_committed', ['sku_id', sa.literal_column('valid_from DESC')], unique=False)
    op.drop_column('change_log_committed', 'quantity')
    # ### end Alembic commands ###
