"""adds new experience configs for vendor asset disclosure

Revision ID: 3efe14d4469a
Revises: f108fa05c579
Create Date: 2025-09-09 11:19:24.060587

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "3efe14d4469a"
down_revision = "f108fa05c579"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "experienceconfigtemplate",
        sa.Column(
            "asset_disclosure_include_types",
            postgresql.ARRAY(sa.String()),
            nullable=True,
        ),
    )
    op.add_column(
        "experienceconfigtemplate",
        sa.Column(
            "allow_vendor_asset_disclosure",
            sa.Boolean(),
            server_default="f",
            nullable=False,
        ),
    )
    op.add_column(
        "privacyexperienceconfig",
        sa.Column(
            "asset_disclosure_include_types",
            postgresql.ARRAY(sa.String()),
            nullable=True,
        ),
    )
    op.add_column(
        "privacyexperienceconfig",
        sa.Column(
            "allow_vendor_asset_disclosure",
            sa.Boolean(),
            server_default="f",
            nullable=False,
        ),
    )
    op.add_column(
        "privacyexperienceconfighistory",
        sa.Column("allow_vendor_asset_disclosure", sa.Boolean(), nullable=True),
    )
    op.add_column(
        "privacyexperienceconfighistory",
        sa.Column(
            "asset_disclosure_include_types",
            postgresql.ARRAY(sa.String()),
            nullable=True,
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("privacyexperienceconfighistory", "asset_disclosure_include_types")
    op.drop_column("privacyexperienceconfighistory", "allow_vendor_asset_disclosure")
    op.drop_column("privacyexperienceconfig", "allow_vendor_asset_disclosure")
    op.drop_column("privacyexperienceconfig", "asset_disclosure_include_types")
    op.drop_column("experienceconfigtemplate", "allow_vendor_asset_disclosure")
    op.drop_column("experienceconfigtemplate", "asset_disclosure_include_types")
    # ### end Alembic commands ###
