"""adds experience config for delete cookie based on host domain

Revision ID: 65a1bc82ae09
Revises: 4bfbeff34611
Create Date: 2025-10-07 11:57:39.614312

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "65a1bc82ae09"
down_revision = "4bfbeff34611"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "experienceconfigtemplate",
        sa.Column(
            "cookie_deletion_based_on_host_domain",
            sa.Boolean(),
            server_default="t",
            nullable=False,
        ),
    )
    op.add_column(
        "privacyexperienceconfig",
        sa.Column(
            "cookie_deletion_based_on_host_domain",
            sa.Boolean(),
            server_default="t",
            nullable=False,
        ),
    )
    op.add_column(
        "privacyexperienceconfighistory",
        sa.Column("cookie_deletion_based_on_host_domain", sa.Boolean(), nullable=True),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column(
        "privacyexperienceconfighistory", "cookie_deletion_based_on_host_domain"
    )
    op.drop_column("privacyexperienceconfig", "cookie_deletion_based_on_host_domain")
    op.drop_column("experienceconfigtemplate", "cookie_deletion_based_on_host_domain")
    # ### end Alembic commands ###
