"""create ManualTaskConditionalDependency table

Revision ID: d0031087eacb
Revises: 9e3dab26f75f
Create Date: 2025-07-17 21:28:20.937945

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "d0031087eacb"
down_revision = "9e3dab26f75f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    op.create_table(
        "manual_task_conditional_dependency",
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column("manual_task_id", sa.String(), nullable=False),
        sa.Column("parent_id", sa.String(), nullable=True),
        sa.Column(
            "condition_type",
            sa.String(),  # Use String instead of Enum to avoid auto-creation
            nullable=False,
        ),
        sa.Column("field_address", sa.String(), nullable=True),
        sa.Column("operator", sa.String(), nullable=True),
        sa.Column("value", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
        sa.Column("logical_operator", sa.String(), nullable=True),
        sa.Column("sort_order", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["manual_task_id"], ["manual_task.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["parent_id"], ["manual_task_conditional_dependency.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
    )

    op.create_index(
        "ix_manual_task_conditional_dependency_condition_type",
        "manual_task_conditional_dependency",
        ["condition_type"],
        unique=False,
    )
    op.create_index(
        "ix_manual_task_conditional_dependency_manual_task_id",
        "manual_task_conditional_dependency",
        ["manual_task_id"],
        unique=False,
    )
    op.create_index(
        "ix_manual_task_conditional_dependency_parent_id",
        "manual_task_conditional_dependency",
        ["parent_id"],
        unique=False,
    )
    op.create_index(
        "ix_manual_task_conditional_dependency_sort_order",
        "manual_task_conditional_dependency",
        ["sort_order"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "ix_manual_task_conditional_dependency_sort_order",
        table_name="manual_task_conditional_dependency",
    )
    op.drop_index(
        "ix_manual_task_conditional_dependency_parent_id",
        table_name="manual_task_conditional_dependency",
    )
    op.drop_index(
        "ix_manual_task_conditional_dependency_manual_task_id",
        table_name="manual_task_conditional_dependency",
    )
    op.drop_index(
        "ix_manual_task_conditional_dependency_condition_type",
        table_name="manual_task_conditional_dependency",
    )

    op.drop_table("manual_task_conditional_dependency")
    # ### end Alembic commands ###
