from typing import Literal

from pydantic import BaseModel
from textual.app import ComposeResult
from textual.widget import Widget
from textual.widgets import Markdown


class HintMessage(BaseModel):
    message: str
    kind: Literal["hint"] = "hint"


class HintMessageWidget(Widget):
    """A message for the user generated by shotgun, not the agent.."""

    DEFAULT_CSS = """
        HintMessageWidget {
          background: $secondary-background-darken-1;
          height: auto;
          margin: 1;
          margin-left: 1;
          padding: 1;

          * > Markdown {
              height: auto;
              offset-x: -1;
              padding: 0;
              margin: 0;
          }
        }

    """

    def __init__(self, message: HintMessage) -> None:
        super().__init__()
        self.message = message

    def compose(self) -> ComposeResult:
        yield Markdown(markdown=f"{self.message.message}")
