# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainRouteArgs', 'DomainRoute']

@pulumi.input_type
class DomainRouteArgs:
    def __init__(__self__, *,
                 domain_link: pulumi.Input[builtins.str],
                 workload_link: pulumi.Input[builtins.str],
                 domain_port: Optional[pulumi.Input[builtins.int]] = None,
                 headers: Optional[pulumi.Input['DomainRouteHeadersArgs']] = None,
                 host_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 host_regex: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 regex: Optional[pulumi.Input[builtins.str]] = None,
                 replace_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 replica: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a DomainRoute resource.
        :param pulumi.Input[builtins.str] domain_link: The self link of the domain to add the route to.
        :param pulumi.Input[builtins.str] workload_link: The link of the workload to map the prefix to.
        :param pulumi.Input[builtins.int] domain_port: The port the route corresponds to. Default: 443
        :param pulumi.Input['DomainRouteHeadersArgs'] headers: Modify the headers for all http requests for this route.
        :param pulumi.Input[builtins.str] host_prefix: This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
               target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
               Slack or at support@controlplane.com for additional details.
        :param pulumi.Input[builtins.str] host_regex: A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
               the Domain is configure for wildcard support. Contact your account manager for details.
        :param pulumi.Input[builtins.int] port: For the linked workload, the port to route traffic to.
        :param pulumi.Input[builtins.str] prefix: The path will match any unmatched path prefixes for the subdomain.
        :param pulumi.Input[builtins.str] regex: Used to match URI paths. Uses the google re2 regex syntax.
        :param pulumi.Input[builtins.str] replace_prefix: A path prefix can be configured to be replaced when forwarding the request to the Workload.
        :param pulumi.Input[builtins.int] replica: The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        """
        pulumi.set(__self__, "domain_link", domain_link)
        pulumi.set(__self__, "workload_link", workload_link)
        if domain_port is not None:
            pulumi.set(__self__, "domain_port", domain_port)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host_prefix is not None:
            pulumi.set(__self__, "host_prefix", host_prefix)
        if host_regex is not None:
            pulumi.set(__self__, "host_regex", host_regex)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if replace_prefix is not None:
            pulumi.set(__self__, "replace_prefix", replace_prefix)
        if replica is not None:
            pulumi.set(__self__, "replica", replica)

    @property
    @pulumi.getter(name="domainLink")
    def domain_link(self) -> pulumi.Input[builtins.str]:
        """
        The self link of the domain to add the route to.
        """
        return pulumi.get(self, "domain_link")

    @domain_link.setter
    def domain_link(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_link", value)

    @property
    @pulumi.getter(name="workloadLink")
    def workload_link(self) -> pulumi.Input[builtins.str]:
        """
        The link of the workload to map the prefix to.
        """
        return pulumi.get(self, "workload_link")

    @workload_link.setter
    def workload_link(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_link", value)

    @property
    @pulumi.getter(name="domainPort")
    def domain_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port the route corresponds to. Default: 443
        """
        return pulumi.get(self, "domain_port")

    @domain_port.setter
    def domain_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "domain_port", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input['DomainRouteHeadersArgs']]:
        """
        Modify the headers for all http requests for this route.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input['DomainRouteHeadersArgs']]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="hostPrefix")
    def host_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
        target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
        Slack or at support@controlplane.com for additional details.
        """
        return pulumi.get(self, "host_prefix")

    @host_prefix.setter
    def host_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_prefix", value)

    @property
    @pulumi.getter(name="hostRegex")
    def host_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
        the Domain is configure for wildcard support. Contact your account manager for details.
        """
        return pulumi.get(self, "host_regex")

    @host_regex.setter
    def host_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_regex", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For the linked workload, the port to route traffic to.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path will match any unmatched path prefixes for the subdomain.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used to match URI paths. Uses the google re2 regex syntax.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter(name="replacePrefix")
    def replace_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A path prefix can be configured to be replaced when forwarding the request to the Workload.
        """
        return pulumi.get(self, "replace_prefix")

    @replace_prefix.setter
    def replace_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replace_prefix", value)

    @property
    @pulumi.getter
    def replica(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        """
        return pulumi.get(self, "replica")

    @replica.setter
    def replica(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica", value)


@pulumi.input_type
class _DomainRouteState:
    def __init__(__self__, *,
                 domain_link: Optional[pulumi.Input[builtins.str]] = None,
                 domain_port: Optional[pulumi.Input[builtins.int]] = None,
                 headers: Optional[pulumi.Input['DomainRouteHeadersArgs']] = None,
                 host_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 host_regex: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 regex: Optional[pulumi.Input[builtins.str]] = None,
                 replace_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 replica: Optional[pulumi.Input[builtins.int]] = None,
                 workload_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainRoute resources.
        :param pulumi.Input[builtins.str] domain_link: The self link of the domain to add the route to.
        :param pulumi.Input[builtins.int] domain_port: The port the route corresponds to. Default: 443
        :param pulumi.Input['DomainRouteHeadersArgs'] headers: Modify the headers for all http requests for this route.
        :param pulumi.Input[builtins.str] host_prefix: This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
               target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
               Slack or at support@controlplane.com for additional details.
        :param pulumi.Input[builtins.str] host_regex: A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
               the Domain is configure for wildcard support. Contact your account manager for details.
        :param pulumi.Input[builtins.int] port: For the linked workload, the port to route traffic to.
        :param pulumi.Input[builtins.str] prefix: The path will match any unmatched path prefixes for the subdomain.
        :param pulumi.Input[builtins.str] regex: Used to match URI paths. Uses the google re2 regex syntax.
        :param pulumi.Input[builtins.str] replace_prefix: A path prefix can be configured to be replaced when forwarding the request to the Workload.
        :param pulumi.Input[builtins.int] replica: The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        :param pulumi.Input[builtins.str] workload_link: The link of the workload to map the prefix to.
        """
        if domain_link is not None:
            pulumi.set(__self__, "domain_link", domain_link)
        if domain_port is not None:
            pulumi.set(__self__, "domain_port", domain_port)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host_prefix is not None:
            pulumi.set(__self__, "host_prefix", host_prefix)
        if host_regex is not None:
            pulumi.set(__self__, "host_regex", host_regex)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if replace_prefix is not None:
            pulumi.set(__self__, "replace_prefix", replace_prefix)
        if replica is not None:
            pulumi.set(__self__, "replica", replica)
        if workload_link is not None:
            pulumi.set(__self__, "workload_link", workload_link)

    @property
    @pulumi.getter(name="domainLink")
    def domain_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The self link of the domain to add the route to.
        """
        return pulumi.get(self, "domain_link")

    @domain_link.setter
    def domain_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_link", value)

    @property
    @pulumi.getter(name="domainPort")
    def domain_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port the route corresponds to. Default: 443
        """
        return pulumi.get(self, "domain_port")

    @domain_port.setter
    def domain_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "domain_port", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input['DomainRouteHeadersArgs']]:
        """
        Modify the headers for all http requests for this route.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input['DomainRouteHeadersArgs']]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="hostPrefix")
    def host_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
        target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
        Slack or at support@controlplane.com for additional details.
        """
        return pulumi.get(self, "host_prefix")

    @host_prefix.setter
    def host_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_prefix", value)

    @property
    @pulumi.getter(name="hostRegex")
    def host_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
        the Domain is configure for wildcard support. Contact your account manager for details.
        """
        return pulumi.get(self, "host_regex")

    @host_regex.setter
    def host_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_regex", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For the linked workload, the port to route traffic to.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path will match any unmatched path prefixes for the subdomain.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Used to match URI paths. Uses the google re2 regex syntax.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter(name="replacePrefix")
    def replace_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A path prefix can be configured to be replaced when forwarding the request to the Workload.
        """
        return pulumi.get(self, "replace_prefix")

    @replace_prefix.setter
    def replace_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replace_prefix", value)

    @property
    @pulumi.getter
    def replica(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        """
        return pulumi.get(self, "replica")

    @replica.setter
    def replica(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica", value)

    @property
    @pulumi.getter(name="workloadLink")
    def workload_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The link of the workload to map the prefix to.
        """
        return pulumi.get(self, "workload_link")

    @workload_link.setter
    def workload_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_link", value)


@pulumi.type_token("cpln:index/domainRoute:DomainRoute")
class DomainRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_link: Optional[pulumi.Input[builtins.str]] = None,
                 domain_port: Optional[pulumi.Input[builtins.int]] = None,
                 headers: Optional[pulumi.Input[Union['DomainRouteHeadersArgs', 'DomainRouteHeadersArgsDict']]] = None,
                 host_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 host_regex: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 regex: Optional[pulumi.Input[builtins.str]] = None,
                 replace_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 replica: Optional[pulumi.Input[builtins.int]] = None,
                 workload_link: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a DomainRoute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_link: The self link of the domain to add the route to.
        :param pulumi.Input[builtins.int] domain_port: The port the route corresponds to. Default: 443
        :param pulumi.Input[Union['DomainRouteHeadersArgs', 'DomainRouteHeadersArgsDict']] headers: Modify the headers for all http requests for this route.
        :param pulumi.Input[builtins.str] host_prefix: This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
               target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
               Slack or at support@controlplane.com for additional details.
        :param pulumi.Input[builtins.str] host_regex: A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
               the Domain is configure for wildcard support. Contact your account manager for details.
        :param pulumi.Input[builtins.int] port: For the linked workload, the port to route traffic to.
        :param pulumi.Input[builtins.str] prefix: The path will match any unmatched path prefixes for the subdomain.
        :param pulumi.Input[builtins.str] regex: Used to match URI paths. Uses the google re2 regex syntax.
        :param pulumi.Input[builtins.str] replace_prefix: A path prefix can be configured to be replaced when forwarding the request to the Workload.
        :param pulumi.Input[builtins.int] replica: The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        :param pulumi.Input[builtins.str] workload_link: The link of the workload to map the prefix to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DomainRoute resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DomainRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_link: Optional[pulumi.Input[builtins.str]] = None,
                 domain_port: Optional[pulumi.Input[builtins.int]] = None,
                 headers: Optional[pulumi.Input[Union['DomainRouteHeadersArgs', 'DomainRouteHeadersArgsDict']]] = None,
                 host_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 host_regex: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 regex: Optional[pulumi.Input[builtins.str]] = None,
                 replace_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 replica: Optional[pulumi.Input[builtins.int]] = None,
                 workload_link: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainRouteArgs.__new__(DomainRouteArgs)

            if domain_link is None and not opts.urn:
                raise TypeError("Missing required property 'domain_link'")
            __props__.__dict__["domain_link"] = domain_link
            __props__.__dict__["domain_port"] = domain_port
            __props__.__dict__["headers"] = headers
            __props__.__dict__["host_prefix"] = host_prefix
            __props__.__dict__["host_regex"] = host_regex
            __props__.__dict__["port"] = port
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["regex"] = regex
            __props__.__dict__["replace_prefix"] = replace_prefix
            __props__.__dict__["replica"] = replica
            if workload_link is None and not opts.urn:
                raise TypeError("Missing required property 'workload_link'")
            __props__.__dict__["workload_link"] = workload_link
        super(DomainRoute, __self__).__init__(
            'cpln:index/domainRoute:DomainRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_link: Optional[pulumi.Input[builtins.str]] = None,
            domain_port: Optional[pulumi.Input[builtins.int]] = None,
            headers: Optional[pulumi.Input[Union['DomainRouteHeadersArgs', 'DomainRouteHeadersArgsDict']]] = None,
            host_prefix: Optional[pulumi.Input[builtins.str]] = None,
            host_regex: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            prefix: Optional[pulumi.Input[builtins.str]] = None,
            regex: Optional[pulumi.Input[builtins.str]] = None,
            replace_prefix: Optional[pulumi.Input[builtins.str]] = None,
            replica: Optional[pulumi.Input[builtins.int]] = None,
            workload_link: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainRoute':
        """
        Get an existing DomainRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_link: The self link of the domain to add the route to.
        :param pulumi.Input[builtins.int] domain_port: The port the route corresponds to. Default: 443
        :param pulumi.Input[Union['DomainRouteHeadersArgs', 'DomainRouteHeadersArgsDict']] headers: Modify the headers for all http requests for this route.
        :param pulumi.Input[builtins.str] host_prefix: This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
               target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
               Slack or at support@controlplane.com for additional details.
        :param pulumi.Input[builtins.str] host_regex: A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
               the Domain is configure for wildcard support. Contact your account manager for details.
        :param pulumi.Input[builtins.int] port: For the linked workload, the port to route traffic to.
        :param pulumi.Input[builtins.str] prefix: The path will match any unmatched path prefixes for the subdomain.
        :param pulumi.Input[builtins.str] regex: Used to match URI paths. Uses the google re2 regex syntax.
        :param pulumi.Input[builtins.str] replace_prefix: A path prefix can be configured to be replaced when forwarding the request to the Workload.
        :param pulumi.Input[builtins.int] replica: The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        :param pulumi.Input[builtins.str] workload_link: The link of the workload to map the prefix to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainRouteState.__new__(_DomainRouteState)

        __props__.__dict__["domain_link"] = domain_link
        __props__.__dict__["domain_port"] = domain_port
        __props__.__dict__["headers"] = headers
        __props__.__dict__["host_prefix"] = host_prefix
        __props__.__dict__["host_regex"] = host_regex
        __props__.__dict__["port"] = port
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["regex"] = regex
        __props__.__dict__["replace_prefix"] = replace_prefix
        __props__.__dict__["replica"] = replica
        __props__.__dict__["workload_link"] = workload_link
        return DomainRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainLink")
    def domain_link(self) -> pulumi.Output[builtins.str]:
        """
        The self link of the domain to add the route to.
        """
        return pulumi.get(self, "domain_link")

    @property
    @pulumi.getter(name="domainPort")
    def domain_port(self) -> pulumi.Output[builtins.int]:
        """
        The port the route corresponds to. Default: 443
        """
        return pulumi.get(self, "domain_port")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional['outputs.DomainRouteHeaders']]:
        """
        Modify the headers for all http requests for this route.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="hostPrefix")
    def host_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This option allows forwarding traffic for different host headers to different workloads. This will only be used when the
        target GVC has dedicated load balancing enabled and the Domain is configured for wildcard support. Please contact us on
        Slack or at support@controlplane.com for additional details.
        """
        return pulumi.get(self, "host_prefix")

    @property
    @pulumi.getter(name="hostRegex")
    def host_regex(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A regex to match the host header. This will only be used when the target GVC has dedicated load balancing enabled and
        the Domain is configure for wildcard support. Contact your account manager for details.
        """
        return pulumi.get(self, "host_regex")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        For the linked workload, the port to route traffic to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path will match any unmatched path prefixes for the subdomain.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def regex(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Used to match URI paths. Uses the google re2 regex syntax.
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="replacePrefix")
    def replace_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A path prefix can be configured to be replaced when forwarding the request to the Workload.
        """
        return pulumi.get(self, "replace_prefix")

    @property
    @pulumi.getter
    def replica(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The replica number of a stateful workload to route to. If not provided, traffic will be routed to all replicas.
        """
        return pulumi.get(self, "replica")

    @property
    @pulumi.getter(name="workloadLink")
    def workload_link(self) -> pulumi.Output[builtins.str]:
        """
        The link of the workload to map the prefix to.
        """
        return pulumi.get(self, "workload_link")

