"""Display Name added

Revision ID: 327febbf555f
Revises: f2013b08daac
Create Date: 2025-09-17 11:47:14.197878

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "327febbf555f"
down_revision: str | Sequence[str] | None = "f2013b08daac"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("agent", sa.Column("display_name", sa.String(length=255), nullable=True))
    op.create_unique_constraint("uq_agent_display_name", "agent", ["display_name"])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("uq_agent_display_name", "agent", type_="unique")
    op.drop_column("agent", "display_name")
    # ### end Alembic commands ###
