"""preview mode

Revision ID: bbc1955191e6
Revises: b0bcb7ca1dc9
Create Date: 2025-09-18 15:11:14.986185

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "bbc1955191e6"
down_revision: str | Sequence[str] | None = "b0bcb7ca1dc9"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("conversation", sa.Column("preview_mode", sa.Boolean(), nullable=True))
    # set old to false
    op.execute("UPDATE conversation SET preview_mode = FALSE")
    # set to non nullable
    op.alter_column("conversation", "preview_mode", nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("conversation", "preview_mode")
    # ### end Alembic commands ###
