"""Added chunk id and vector embeddings to vector table

Revision ID: 07dc8c2589e0
Revises: f8b0ea2e743c
Create Date: 2025-09-26 15:05:17.194213

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '07dc8c2589e0'
down_revision: Union[str, Sequence[str], None] = 'f8b0ea2e743c'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('vector', sa.Column('chunk_id', sa.Integer(), nullable=False))
    op.add_column('vector', sa.Column('vector_embeddings', postgresql.ARRAY(sa.Float()), nullable=True))
    op.drop_index(op.f('idx_vector_source'), table_name='vector')
    op.create_unique_constraint(op.f('vector_chunk_id_key'), 'vector', ['chunk_id'])
    op.create_foreign_key(op.f('vector_chunk_id_fkey'), 'vector', 'chunk', ['chunk_id'], ['id'])
    op.drop_column('vector', 'source_type')
    op.drop_column('vector', 'source_id')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('vector', sa.Column('source_id', sa.INTEGER(), autoincrement=False, nullable=False))
    op.add_column('vector', sa.Column('source_type', sa.VARCHAR(length=20), autoincrement=False, nullable=False))
    op.drop_constraint(op.f('vector_chunk_id_fkey'), 'vector', type_='foreignkey')
    op.drop_constraint(op.f('vector_chunk_id_key'), 'vector', type_='unique')
    op.create_index(op.f('idx_vector_source'), 'vector', ['source_type', 'source_id'], unique=False)
    op.drop_column('vector', 'vector_embeddings')
    op.drop_column('vector', 'chunk_id')
    # ### end Alembic commands ###
