"""Removed doc id from config table and add config id to document table

Revision ID: bf1472a9b021
Revises: 46ba2693b883
Create Date: 2025-10-02 15:20:08.035679

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'bf1472a9b021'
down_revision: Union[str, Sequence[str], None] = '46ba2693b883'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('document', sa.Column('chunk_config_id', sa.Integer(), nullable=True))
    op.create_foreign_key(op.f('document_chunk_config_id_fkey'), 'document', 'chunk_config', ['chunk_config_id'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('document_chunk_config_id_fkey'), 'document', type_='foreignkey')
    op.drop_column('document', 'chunk_config_id')
    # ### end Alembic commands ###
