"""config id on delete will be set to null

Revision ID: 1b3eb48f5017
Revises: 6c0e63e0fef8
Create Date: 2025-10-02 16:08:37.604477

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '1b3eb48f5017'
down_revision: Union[str, Sequence[str], None] = '6c0e63e0fef8'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('document_chunk_config_id_fkey'), 'document', type_='foreignkey')
    op.create_foreign_key(op.f('document_chunk_config_id_fkey'), 'document', 'chunk_config', ['chunk_config_id'], ['id'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('document_chunk_config_id_fkey'), 'document', type_='foreignkey')
    op.create_foreign_key(op.f('document_chunk_config_id_fkey'), 'document', 'chunk_config', ['chunk_config_id'], ['id'])
    # ### end Alembic commands ###
