"""added qa id to vovetor

Revision ID: 796b720ea35f
Revises: c91eb8e38cc7
Create Date: 2025-10-09 13:08:56.972719

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '796b720ea35f'
down_revision: Union[str, Sequence[str], None] = 'c91eb8e38cc7'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('vector', sa.Column('qa_pair_id', sa.Integer(), nullable=True))
    op.alter_column('vector', 'chunk_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.create_unique_constraint(op.f('vector_qa_pair_id_key'), 'vector', ['qa_pair_id'])
    op.create_foreign_key(op.f('vector_qa_pair_id_fkey'), 'vector', 'qa_pair', ['qa_pair_id'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('vector_qa_pair_id_fkey'), 'vector', type_='foreignkey')
    op.drop_constraint(op.f('vector_qa_pair_id_key'), 'vector', type_='unique')
    op.alter_column('vector', 'chunk_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.drop_column('vector', 'qa_pair_id')
    # ### end Alembic commands ###
