"""added chunk config to source again, last one failed

Revision ID: 7d0982bae4db
Revises: b228888a01ee
Create Date: 2025-11-06 16:56:55.958659

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '7d0982bae4db'
down_revision: Union[str, Sequence[str], None] = 'b228888a01ee'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('source', sa.Column('chunk_config_id', sa.Integer(), nullable=True))
    op.create_index(op.f('source_chunk_config_id_idx'), 'source', ['chunk_config_id'], unique=False)
    op.create_foreign_key(op.f('source_chunk_config_id_fkey'), 'source', 'chunk_config', ['chunk_config_id'], ['id'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('source_chunk_config_id_fkey'), 'source', type_='foreignkey')
    op.drop_index(op.f('source_chunk_config_id_idx'), table_name='source')
    op.drop_column('source', 'chunk_config_id')
    # ### end Alembic commands ###
