# Changelog


---

## [Unreleased]

## [0.1.30]
### Fixed
- Fixed local BQM computation: improved solution file parsing and handling
- Fixed parsing of solution files with salt but no metrics (handles files created by solver before metrics are appended)
- Improved add_salt_local to correctly handle files ending with .dnx (without existing salt)
- Improved list_files_with_text_local to match exact filename or prefixed files
- Added bounds checking for voltages array access to prevent IndexError
### Changed
- Refactored metric parsing to use single split() call instead of multiple calls (performance improvement)
- Used enumerate() instead of manual index increment (code quality improvement)
- Aligned local BQM logic with original version from dynex_public for compatibility

## [0.1.29]
### Fixed
- Fixed package distribution: pennylane_bridge module now included in wheel and sdist

## [0.1.28]
### Added
- Local QASM to BQM conversion for testnet (replaces external dynex_circuit_backend.py script)
- Integrated PennylaneBridge module for local circuit conversion
- Support for testnet QASM circuit execution without external dependencies
### Changed
- Refactored QASM conversion: moved from subprocess call to internal method `_convert_qasm_to_bqm`
- Improved code style: all method and variable names now use snake_case
- Replaced all print() statements with proper logging
- Moved imports to top of file (PEP 8 compliance)
- Fixed private method naming: `save_wcnf` → `_save_wcnf`
### Fixed
- Fixed missing `os` and `sys` imports in QASM conversion method
- Fixed AttributeError: '_DynexSampler' object has no attribute 'save_wcnf'
- Replaced Russian text in code with English translations

## [0.1.27]
### Added
- Multi-model parallel sampling (f.e. for parameter tuning jobs, etc.)

## [0.1.27]
### Refactored and upgraded 
- Divided sample file by logic parts
- Refactored circuit

## [0.1.26]
### Refactored
- Divided init file by logic parts

## [0.1.25]
### Refactored
- Start of global refactoring

## [0.1.24]
### Fixed
- Bugfix native circuit execution

## [0.1.23]
### Added
- Support for quantum algorithm v2

## [0.1.22]
### Fixed
- Bugfix

## [0.1.21]
### Added
- Native q.node support for `shots`

## [0.1.20]
### Fixed
- Circuit bug fix

## [0.1.19]
### Added
- Support for Dynex Quantum nodes: new parameters `cluster_type` (default `1`) and `is_cluster` (default `True`)
- Energy ground state display: now showing underlying model energy

## [0.1.18]
### Added
- Native support for PennyLane gate-based circuits
- Native support for OpenQASM gate-based circuits
- Native support for Qiskit gate-based circuits

## [0.1.17]
### Added
- Native support for Discrete Quadratic Models (DQM)
### Fixed
- Return sampleset format of CQM models by inverting to original CQM

## [0.1.16]
### Added
- Dynex cluster support

## [0.1.15]
### Added
- Support for subscription model
- Support for `n.quantum` gates and qubits
### Changed
- Updated terminology from "chips" to "circuits"
- Fixed elapsed time display bug
- Minor typo fixes

## [0.1.14]
### Fixed
- Small testnet sampling bugfix

## [0.1.13]
### Added
- `dynex.estimate_costs()` function
### Fixed
- Sampling of model type `sat`

## [0.1.12]
### Added
- Compression of compute file for mainnet sampling

## [0.1.11]
### Added
- Official Dynex marketplace version
- Billing functionality
- File upload / encryption / data handling (server side)
- API layer & AWS Elastic Cloud support
- Validation clauses
- Progress % and step display during compute
- New DNX encryption format
### Changed
- Updated `dynex.ini` for marketplace compatibility
- Using SDK API application layer
- Removed file upload progress bar
- Changed display refresh interval from 2 → 5 seconds

## [0.1.10]
### Fixed
- `np.float64` conversion bug

## [0.1.9]
### Added
- Energy ground state calculation moved into `_DynexSampler` class
- `debugging=True` option for sampling
- New parameter: `bnb=True/False` (testnet only, branch-and-bound method)
- `dynex.sample(bqm, **parameters)`
- `dynex.sample_qubo(Q, offset, **parameters)`
- `dynex.sample_ising(h, j, **parameters)`
### Improved
- `bqm2bin` function:
  - Faster: direct conversion from BQM (skipped QUBO step)
  - Rydberg Hamiltonian formulation
  - Reduction of linear terms

## [0.1.8]
### Added
- Accuracy improvement: validate solution file energies with voltages and omit incorrect reads
- Improved sampling display (showing ground state, decluttered)
- Default `logging=False` for CQM/BQM/SAT models

## [0.1.7]
### Changed
- All internal functions renamed with `_x` prefix
- Don't raise exception on missing `.ini`, issue warning instead (fix for `import dynex`)
- Testnet: auto-use max fitting circuits, ignore `num_reads`
- Temporarily removed "boost job priority"
