# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: sp_bus.proto, sp_command.proto, sp_common.proto, sp_external.proto, sp_info.proto, sp_internal.proto, sp_kv.proto, sp_notify.proto, sp_pipeline.proto, sp_sdk.proto, sp_wsm.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from . import (
    shared,
    steps,
)


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class NotificationType(betterproto.Enum):
    NOTIFICATION_TYPE_UNSET = 0
    NOTIFICATION_TYPE_SLACK = 1
    NOTIFICATION_TYPE_EMAIL = 2
    NOTIFICATION_TYPE_PAGERDUTY = 3


class NotificationEmailType(betterproto.Enum):
    TYPE_UNSET = 0
    TYPE_SMTP = 1
    TYPE_SES = 2


class NotificationPagerDutyUrgency(betterproto.Enum):
    URGENCY_UNSET = 0
    URGENCY_LOW = 1
    URGENCY_HIGH = 2


class AbortCondition(betterproto.Enum):
    """Defines the ways in which a pipeline can be aborted"""

    ABORT_CONDITION_UNSET = 0
    ABORT_CONDITION_ABORT_CURRENT = 1
    ABORT_CONDITION_ABORT_ALL = 2


class PipelineStepNotificationPayloadType(betterproto.Enum):
    PAYLOAD_TYPE_UNSET = 0
    """Same functionality as PAYLOAD_TYPE_EXCLUDE"""

    PAYLOAD_TYPE_EXCLUDE = 1
    """Default. No payload data included in notification"""

    PAYLOAD_TYPE_FULL_PAYLOAD = 2
    """Entire payload content included in notification"""

    PAYLOAD_TYPE_SELECT_PATHS = 3
    """
    Only specified paths of payload content included in notification Only works
    on JSON. Plaintext payloads will be ignored.
    """


class ResponseCode(betterproto.Enum):
    """Common status codes used in gRPC method responses"""

    RESPONSE_CODE_UNSET = 0
    RESPONSE_CODE_OK = 1
    RESPONSE_CODE_BAD_REQUEST = 2
    RESPONSE_CODE_NOT_FOUND = 3
    RESPONSE_CODE_INTERNAL_SERVER_ERROR = 4
    RESPONSE_CODE_GENERIC_ERROR = 5


class OperationType(betterproto.Enum):
    """Each SDK client is a $service + $component + $operation_type"""

    OPERATION_TYPE_UNSET = 0
    OPERATION_TYPE_CONSUMER = 1
    OPERATION_TYPE_PRODUCER = 2


class TailResponseType(betterproto.Enum):
    TAIL_RESPONSE_TYPE_UNSET = 0
    TAIL_RESPONSE_TYPE_PAYLOAD = 1
    TAIL_RESPONSE_TYPE_ERROR = 2


class TailRequestType(betterproto.Enum):
    TAIL_REQUEST_TYPE_UNSET = 0
    TAIL_REQUEST_TYPE_START = 1
    TAIL_REQUEST_TYPE_STOP = 2
    TAIL_REQUEST_TYPE_PAUSE = 3
    TAIL_REQUEST_TYPE_RESUME = 4


class ClientType(betterproto.Enum):
    CLIENT_TYPE_UNSET = 0
    CLIENT_TYPE_SDK = 1
    CLIENT_TYPE_SHIM = 2


class AppRegistrationStatusResponseStatus(betterproto.Enum):
    STATUS_UNSET = 0
    STATUS_SUBMIT = 1
    """Submit means the user is not registered yet"""

    STATUS_VERIFY = 2
    """Verify means the user is registered but not verified yet"""

    STATUS_DONE = 3
    """Done means the user is registered and verified"""


class NotifyRequestConditionType(betterproto.Enum):
    """
    This will be used to pull the condition type (true, false, error) from the
    pipeline step, so that we can include metadata, abort condition, etc., in
    the notification The condition will contain the notification configuration
    also.
    """

    CONDITION_TYPE_UNSET = 0
    CONDITION_TYPE_ON_TRUE = 1
    CONDITION_TYPE_ON_FALSE = 2
    CONDITION_TYPE_ON_ERROR = 3


class ExecStatus(betterproto.Enum):
    EXEC_STATUS_UNSET = 0
    """
    Unset status. This should never be returned by the SDK. If it does, it is
    probably a bug (and you should file an issue)
    """

    EXEC_STATUS_TRUE = 1
    """Indicates that the step execution evaluated to "true"""

    EXEC_STATUS_FALSE = 2
    """Indicates that the step execution evaluated to "false"""

    EXEC_STATUS_ERROR = 3
    """
    Indicates that the SDK encountered an error while trying to process the
    request. Example error cases: SDK can't find the appropriate Wasm module,
    Wasm function cannot alloc or dealloc memory, etc.
    """


class WasmExitCode(betterproto.Enum):
    """
    Included in Wasm response; the SDK should use the WASMExitCode to determine
    what to do next - should it execute next step, should it notify or should
    it stop execution/abort the rest of the steps in current or all pipelines.
    Example: a. Wasm func returns WASM_EXIT_CODE_FALSE - read
    PipelineStep.on_false conditions to determine what to do next. b. Wasm func
    returns WASM_EXIT_CODE_TRUE - read PipelineStep.on_true conditions to
    determine what to do next. .. and so on. TODO: This might be a dupe -
    should Wasm use ExecStatus instead of this? protolint:disable:next
    ENUM_FIELD_NAMES_PREFIX
    """

    WASM_EXIT_CODE_UNSET = 0
    WASM_EXIT_CODE_TRUE = 1
    WASM_EXIT_CODE_FALSE = 2
    WASM_EXIT_CODE_ERROR = 3


@dataclass(eq=False, repr=False)
class NotificationConfig(betterproto.Message):
    id: Optional[str] = betterproto.string_field(1, optional=True, group="_id")
    name: str = betterproto.string_field(2)
    type: "NotificationType" = betterproto.enum_field(3)
    slack: "NotificationSlack" = betterproto.message_field(1000, group="config")
    email: "NotificationEmail" = betterproto.message_field(1001, group="config")
    pagerduty: "NotificationPagerDuty" = betterproto.message_field(1002, group="config")
    created_by: Optional[str] = betterproto.string_field(
        10000, optional=True, group="X_created_by"
    )
    """
    Used internally by server and k8s operator to determine who manages this
    resource
    """


@dataclass(eq=False, repr=False)
class NotificationSlack(betterproto.Message):
    bot_token: str = betterproto.string_field(1)
    channel: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class NotificationEmail(betterproto.Message):
    type: "NotificationEmailType" = betterproto.enum_field(1)
    recipients: List[str] = betterproto.string_field(2)
    from_address: str = betterproto.string_field(3)
    smtp: "NotificationEmailSmtp" = betterproto.message_field(1000, group="config")
    ses: "NotificationEmailSes" = betterproto.message_field(1001, group="config")


@dataclass(eq=False, repr=False)
class NotificationEmailSmtp(betterproto.Message):
    host: str = betterproto.string_field(1)
    port: int = betterproto.int32_field(2)
    user: str = betterproto.string_field(3)
    password: str = betterproto.string_field(4)
    use_tls: bool = betterproto.bool_field(5)


@dataclass(eq=False, repr=False)
class NotificationEmailSes(betterproto.Message):
    ses_region: str = betterproto.string_field(1)
    ses_access_key_id: str = betterproto.string_field(2)
    ses_secret_access_key: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class NotificationPagerDuty(betterproto.Message):
    token: str = betterproto.string_field(1)
    """Auth token"""

    email: str = betterproto.string_field(2)
    """Must be a valid email for a PagerDuty user"""

    service_id: str = betterproto.string_field(3)
    """Must be a valid PagerDuty service"""

    urgency: "NotificationPagerDutyUrgency" = betterproto.enum_field(4)


@dataclass(eq=False, repr=False)
class Pipeline(betterproto.Message):
    """
    Pipeline is a structure that holds one or more pipeline steps. This
    structure is intended to be immutable; clients are expected to generate
    WASMRequest's that contain a pipeline step.
    """

    id: str = betterproto.string_field(1)
    """
    If left blank, the server will generate a unique ID. If one is provided,
    the server will check if that is ID is already in use when creating a
    pipeline.
    """

    name: str = betterproto.string_field(2)
    """Friendly name for the pipeline"""

    steps: List["PipelineStep"] = betterproto.message_field(3)
    """One or more steps to execute"""

    notification_configs: List["NotificationConfig"] = betterproto.message_field(4)
    """
    Notification configs for this pipeline. Only filled out in external API
    responses This is deprecated and the data has moved to PipelineStep
    """

    paused: Optional[bool] = betterproto.bool_field(
        1000, optional=True, group="X_paused"
    )
    """
    Indicates whether the pipeline is paused or not. Used internally by server.
    """

    description: Optional[str] = betterproto.string_field(
        1001, optional=True, group="X_description"
    )
    version: Optional[str] = betterproto.string_field(
        1002, optional=True, group="X_version"
    )
    url: Optional[str] = betterproto.string_field(1003, optional=True, group="X_url")
    created_at_unix_ts_utc: Optional[int] = betterproto.int64_field(
        1004, optional=True, group="X_created_at_unix_ts_utc"
    )
    updated_at_unix_ts_utc: Optional[int] = betterproto.int64_field(
        1005, optional=True, group="X_updated_at_unix_ts_utc"
    )
    created_by: Optional[str] = betterproto.string_field(
        1006, optional=True, group="X_created_by"
    )
    """
    Used internally by server and k8s operator to determine who manages this
    resource
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("notification_configs"):
            warnings.warn(
                "Pipeline.notification_configs is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class PipelineStepConditions(betterproto.Message):
    """
    Conditions define how the SDK should handle a Wasm response in a step.
    Should it continue executing the pipeline, should it abort, should it
    notify and on_error. TODO: de-pluralize this name
    """

    abort: "AbortCondition" = betterproto.enum_field(1)
    """Should we abort execution?"""

    notify: bool = betterproto.bool_field(2)
    metadata: Dict[str, str] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    Should we include additional metadata that SDK should pass back to user?
    """

    notification: "PipelineStepNotification" = betterproto.message_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("notify"):
            warnings.warn(
                "PipelineStepConditions.notify is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class PipelineStepNotification(betterproto.Message):
    notification_config_ids: List[str] = betterproto.string_field(1)
    """
    The UUIDs of the notification config to use This is kept separate to avoid
    having to configure slack/email settings every time and also because that
    config info is sensitive and is encrypted
    """

    payload_type: "PipelineStepNotificationPayloadType" = betterproto.enum_field(2)
    paths: List[str] = betterproto.string_field(3)
    """
    If type == paths, then we will look here for a list of json paths to
    include in the notification payload.
    """


@dataclass(eq=False, repr=False)
class PipelineStep(betterproto.Message):
    """A pipeline step is a single step in a pipeline."""

    name: str = betterproto.string_field(1)
    """Friendly name for the step"""

    on_true: "PipelineStepConditions" = betterproto.message_field(2)
    """
    SDKs should read this when Wasm returns 'true' to determine what to do
    next.
    """

    on_false: "PipelineStepConditions" = betterproto.message_field(3)
    """
    SDKs should read this when Wasm returns 'false' to determine what to do
    next.
    """

    dynamic: bool = betterproto.bool_field(4)
    """
    Indicates whether to use the results from a previous step as input to this
    step
    """

    on_error: "PipelineStepConditions" = betterproto.message_field(5)
    """
    SDKs should read this when Wasm returns 'error' to determine what to do
    next.
    """

    detective: "steps.DetectiveStep" = betterproto.message_field(1000, group="step")
    transform: "steps.TransformStep" = betterproto.message_field(1001, group="step")
    encode: "steps.EncodeStep" = betterproto.message_field(1002, group="step")
    decode: "steps.DecodeStep" = betterproto.message_field(1003, group="step")
    custom: "steps.CustomStep" = betterproto.message_field(1004, group="step")
    """If set, _wasm_id MUST be set"""

    http_request: "steps.HttpRequestStep" = betterproto.message_field(
        1005, group="step"
    )
    kv: "steps.KvStep" = betterproto.message_field(1006, group="step")
    infer_schema: "steps.InferSchemaStep" = betterproto.message_field(
        1007, group="step"
    )
    valid_json: "steps.ValidJsonStep" = betterproto.message_field(1008, group="step")
    schema_validation: "steps.SchemaValidationStep" = betterproto.message_field(
        1009, group="step"
    )
    wasm_id: Optional[str] = betterproto.string_field(
        10000, optional=True, group="X_wasm_id"
    )
    """Set by server UNLESS step is CustomStep"""

    wasm_bytes: Optional[bytes] = betterproto.bytes_field(
        10001, optional=True, group="X_wasm_bytes"
    )
    """Set by server"""

    wasm_function: Optional[str] = betterproto.string_field(
        10002, optional=True, group="X_wasm_function"
    )
    """Set by server"""


@dataclass(eq=False, repr=False)
class PipelineConfigs(betterproto.Message):
    """
    PipelineConfigs is stored encoded in redis:streamdal_audience:$audStr; it
    is also used in external.GetAllResponse:config.
    """

    configs: List["PipelineConfig"] = betterproto.message_field(1)
    is_empty: Optional[bool] = betterproto.bool_field(
        1000, optional=True, group="X_is_empty"
    )
    """
    !!!!!!!! IMPORTANT !!!!!!!!!! For internal use only in server. We need this
    because marshalling/encoding an empty protobuf results in nil. If someone
    does a SetPipelines() with empty pipeline IDs - we will set this, so that
    the encoded protobuf gets written as the actual object and not nil.
    """

    created_by: Optional[str] = betterproto.string_field(
        1001, optional=True, group="X_created_by"
    )
    """
    Used internally by server and k8s operator to determine who manages this
    resource/mapping
    """


@dataclass(eq=False, repr=False)
class PipelineConfig(betterproto.Message):
    """PipelineConfig is structure used in protos.PipelineConfigs"""

    id: str = betterproto.string_field(1)
    paused: bool = betterproto.bool_field(2)
    created_at_unix_ts_utc: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class StandardResponse(betterproto.Message):
    """Common response message for many gRPC methods"""

    id: str = betterproto.string_field(1)
    """Co-relation ID for the request / response"""

    code: "ResponseCode" = betterproto.enum_field(2)
    message: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class Audience(betterproto.Message):
    """Used to indicate who a command is intended for"""

    service_name: str = betterproto.string_field(1)
    """
    Name of the service -- let's include the service name on all calls, we can
    optimize later ~DS
    """

    component_name: str = betterproto.string_field(2)
    """
    Name of the component the SDK is interacting with (ie. kafka-$topic-name)
    """

    operation_type: "OperationType" = betterproto.enum_field(3)
    """Consumer or Producer"""

    operation_name: str = betterproto.string_field(4)
    """Name for the consumer or producer"""

    created_by: Optional[str] = betterproto.string_field(
        1000, optional=True, group="X_created_by"
    )
    """
    Used internally by server and k8s operator to determine who manages this
    resource
    """


@dataclass(eq=False, repr=False)
class Metric(betterproto.Message):
    name: str = betterproto.string_field(1)
    labels: Dict[str, str] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    value: float = betterproto.double_field(3)
    audience: "Audience" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class TailRequest(betterproto.Message):
    type: "TailRequestType" = betterproto.enum_field(1)
    id: str = betterproto.string_field(2)
    audience: "Audience" = betterproto.message_field(3)
    pipeline_id: Optional[str] = betterproto.string_field(
        4, optional=True, group="_pipeline_id"
    )
    sample_options: "SampleOptions" = betterproto.message_field(5)
    metadata: Dict[str, str] = betterproto.map_field(
        1000, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("pipeline_id"):
            warnings.warn("TailRequest.pipeline_id is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class TailResponse(betterproto.Message):
    """
    TailResponse originates in the SDK and then is sent to streamdal servers
    where it is forwarded to the correct frontend streaming gRPC connection
    """

    type: "TailResponseType" = betterproto.enum_field(1)
    tail_request_id: str = betterproto.string_field(2)
    audience: "Audience" = betterproto.message_field(3)
    pipeline_id: str = betterproto.string_field(4)
    session_id: str = betterproto.string_field(5)
    timestamp_ns: int = betterproto.int64_field(6)
    """Timestamp in nanoseconds"""

    original_data: bytes = betterproto.bytes_field(7)
    """
    Payload data. For errors, this will be the error message For payloads, this
    will be JSON of the payload data, post processing
    """

    new_data: bytes = betterproto.bytes_field(8)
    """For payloads, this will be the new data, post processing"""

    metadata: Dict[str, str] = betterproto.map_field(
        1000, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    keepalive: Optional[bool] = betterproto.bool_field(
        1001, optional=True, group="X_keepalive"
    )
    """Set by server to indicate that the response is a keepalive message"""


@dataclass(eq=False, repr=False)
class AudienceRate(betterproto.Message):
    bytes: float = betterproto.double_field(1)
    processed: float = betterproto.double_field(2)


@dataclass(eq=False, repr=False)
class Schema(betterproto.Message):
    json_schema: bytes = betterproto.bytes_field(1)
    version: int = betterproto.int32_field(100)
    metadata: Dict[str, str] = betterproto.map_field(
        1000, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )


@dataclass(eq=False, repr=False)
class SampleOptions(betterproto.Message):
    """ """

    sample_rate: int = betterproto.uint32_field(1)
    sample_interval_seconds: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class Config(betterproto.Message):
    """
    Config is returned by external.GetConfig() and is used by the K8S operator
    """

    audiences: List["Audience"] = betterproto.message_field(1)
    pipelines: List["Pipeline"] = betterproto.message_field(2)
    notifications: List["NotificationConfig"] = betterproto.message_field(3)
    wasm_modules: List["shared.WasmModule"] = betterproto.message_field(4)
    audience_mappings: Dict[str, "PipelineConfigs"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class LiveInfo(betterproto.Message):
    audiences: List["Audience"] = betterproto.message_field(1)
    """If empty, client has not announced any audiences"""

    client: "ClientInfo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class PipelineInfo(betterproto.Message):
    audiences: List["Audience"] = betterproto.message_field(1)
    """What audience(s) this pipeline is attached to (none if empty)"""

    pipeline: "Pipeline" = betterproto.message_field(2)
    """Pipeline config"""


@dataclass(eq=False, repr=False)
class ClientInfo(betterproto.Message):
    """
    Most of this is constructed by client SDKs and provided during Register
    call
    """

    client_type: "ClientType" = betterproto.enum_field(1)
    library_name: str = betterproto.string_field(2)
    library_version: str = betterproto.string_field(3)
    language: str = betterproto.string_field(4)
    arch: str = betterproto.string_field(5)
    os: str = betterproto.string_field(6)
    session_id: Optional[str] = betterproto.string_field(
        7, optional=True, group="X_session_id"
    )
    """Filled out by server on GetAll()"""

    service_name: Optional[str] = betterproto.string_field(
        8, optional=True, group="X_service_name"
    )
    node_name: Optional[str] = betterproto.string_field(
        9, optional=True, group="X_node_name"
    )


@dataclass(eq=False, repr=False)
class GetAllRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetAllResponse(betterproto.Message):
    live: List["LiveInfo"] = betterproto.message_field(1)
    """Clients currently connected to the server"""

    audiences: List["Audience"] = betterproto.message_field(2)
    """All of the audiences that are known to the server"""

    pipelines: Dict[str, "PipelineInfo"] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    All of the pipelines known to the server + pipeline <-> audience mappings
    key == pipeline_id; if "Audience" is not filled out - pipeline is not
    attached to any audience.
    """

    configs: Dict[str, "PipelineConfigs"] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """Audience to pipeline mapping config; key == $audience_as_string"""

    generated_at_unix_ts_ns_utc: int = betterproto.int64_field(100)
    """
    When was this response generated. This is useful for determining what is
    the latest update when using GetAllStream().
    """

    keepalive: Optional[bool] = betterproto.bool_field(
        1000, optional=True, group="X_keepalive"
    )
    """Set by server to indicate that the response is a keepalive message"""


@dataclass(eq=False, repr=False)
class GetPipelinesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetPipelinesResponse(betterproto.Message):
    """Array of pipeline definitions"""

    pipelines: List["Pipeline"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetPipelineRequest(betterproto.Message):
    pipeline_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetPipelineResponse(betterproto.Message):
    pipeline: "Pipeline" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreatePipelineRequest(betterproto.Message):
    """
    Create a new pipeline; accepts either pipeline object or pipeline as JSON
    bytes
    """

    pipeline: "Pipeline" = betterproto.message_field(1)
    pipeline_json: Optional[bytes] = betterproto.bytes_field(
        2, optional=True, group="_pipeline_json"
    )


@dataclass(eq=False, repr=False)
class CreatePipelineResponse(betterproto.Message):
    message: str = betterproto.string_field(1)
    pipeline_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class UpdatePipelineRequest(betterproto.Message):
    pipeline: "Pipeline" = betterproto.message_field(1)
    pipeline_json: Optional[bytes] = betterproto.bytes_field(
        2, optional=True, group="_pipeline_json"
    )


@dataclass(eq=False, repr=False)
class DeletePipelineRequest(betterproto.Message):
    pipeline_id: str = betterproto.string_field(1)
    audiences: List["Audience"] = betterproto.message_field(1000)
    """
    This field is for internal usage only by the server. It is used to indicate
    to the bus handler who this pipeline was used by so the handler can decide
    who we need to emit a SetPipelines cmd to.
    """


@dataclass(eq=False, repr=False)
class SetPipelinesRequest(betterproto.Message):
    pipeline_ids: List[str] = betterproto.string_field(1)
    audience: "Audience" = betterproto.message_field(2)
    created_by: Optional[str] = betterproto.string_field(
        100, optional=True, group="X_created_by"
    )
    """Used by automation tooling"""


@dataclass(eq=False, repr=False)
class PausePipelineRequest(betterproto.Message):
    pipeline_id: str = betterproto.string_field(1)
    audience: "Audience" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ResumePipelineRequest(betterproto.Message):
    pipeline_id: str = betterproto.string_field(1)
    audience: "Audience" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CreateNotificationRequest(betterproto.Message):
    """Notifications"""

    notification: "NotificationConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateNotificationResponse(betterproto.Message):
    notification: "NotificationConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateNotificationRequest(betterproto.Message):
    notification: "NotificationConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteNotificationRequest(betterproto.Message):
    notification_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetNotificationsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetNotificationsResponse(betterproto.Message):
    notifications: Dict[str, "NotificationConfig"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """Key == id of the notification config"""


@dataclass(eq=False, repr=False)
class GetNotificationRequest(betterproto.Message):
    notification_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetNotificationResponse(betterproto.Message):
    notification: "NotificationConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AttachNotificationRequest(betterproto.Message):
    notification_id: str = betterproto.string_field(1)
    pipeline_id: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        warnings.warn("AttachNotificationRequest is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class DetachNotificationRequest(betterproto.Message):
    notification_id: str = betterproto.string_field(1)
    pipeline_id: str = betterproto.string_field(2)

    def __post_init__(self) -> None:
        warnings.warn("DetachNotificationRequest is deprecated", DeprecationWarning)
        super().__post_init__()


@dataclass(eq=False, repr=False)
class CreateAudienceRequest(betterproto.Message):
    audience: "Audience" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteAudienceRequest(betterproto.Message):
    audience: "Audience" = betterproto.message_field(1)
    force: Optional[bool] = betterproto.bool_field(2, optional=True, group="_force")
    """
    If true, will also detach all pipelines from the audience (if it has any)
    """


@dataclass(eq=False, repr=False)
class DeleteServiceRequest(betterproto.Message):
    service_name: str = betterproto.string_field(1)
    force: Optional[bool] = betterproto.bool_field(2, optional=True, group="_force")


@dataclass(eq=False, repr=False)
class GetMetricsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetMetricsResponse(betterproto.Message):
    metrics: Dict[str, "Metric"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    keepalive: Optional[bool] = betterproto.bool_field(
        1000, optional=True, group="X_keepalive"
    )
    """Set by server to indicate that the response is a keepalive message"""


@dataclass(eq=False, repr=False)
class GetAudienceRatesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetAudienceRatesResponse(betterproto.Message):
    rates: Dict[str, "AudienceRate"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    keepalive: Optional[bool] = betterproto.bool_field(
        1000, optional=True, group="X_keepalive"
    )
    """Set by server to indicate that the response is a keepalive message"""


@dataclass(eq=False, repr=False)
class GetSchemaRequest(betterproto.Message):
    audience: "Audience" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetSchemaResponse(betterproto.Message):
    schema: "Schema" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AppRegistrationStatusRequest(betterproto.Message):
    email: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class AppRegistrationStatusResponse(betterproto.Message):
    status: "AppRegistrationStatusResponseStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class AppRegistrationRequest(betterproto.Message):
    email: str = betterproto.string_field(1)
    cluster_id: str = betterproto.string_field(2)
    code: str = betterproto.string_field(100)
    """Used for storage on ui-bff backend"""


@dataclass(eq=False, repr=False)
class AppVerifyRegistrationRequest(betterproto.Message):
    email: str = betterproto.string_field(1)
    code: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class AppRegisterRejectRequest(betterproto.Message):
    cluster_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class PauseTailRequest(betterproto.Message):
    tail_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ResumeTailRequest(betterproto.Message):
    tail_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetWasmRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetWasmResponse(betterproto.Message):
    wasm: "shared.WasmModule" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetAllWasmRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetAllWasmResponse(betterproto.Message):
    wasm: List["shared.WasmModule"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateWasmRequest(betterproto.Message):
    wasm: "shared.WasmModule" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateWasmResponse(betterproto.Message):
    message: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class UpdateWasmRequest(betterproto.Message):
    wasm: "shared.WasmModule" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteWasmRequest(betterproto.Message):
    ids: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class TestRequest(betterproto.Message):
    input: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class TestResponse(betterproto.Message):
    output: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetConfigRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetConfigResponse(betterproto.Message):
    config: "Config" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class KvObject(betterproto.Message):
    """
    KVObject represents a single KV object used in protos.KVInstruction; this
    is constructed by server and broadcast out to other server nodes.
    """

    key: str = betterproto.string_field(1)
    """Valid key regex: /^[a-zA-Z0-9_-:]+$/)"""

    value: bytes = betterproto.bytes_field(2)
    """KV value"""

    created_at_unix_ts_nano_utc: int = betterproto.int64_field(3)
    """When was this object created"""

    updated_at_unix_ts_nano_utc: int = betterproto.int64_field(4)
    """Last time the object was updated"""


@dataclass(eq=False, repr=False)
class KvInstruction(betterproto.Message):
    """
    Container for one or more KVObject's; server broadcasts KVCommand that
    contains one or more of these instructions when a "POST /api/v1/kv" request
    is made.
    """

    id: str = betterproto.string_field(1)
    """Unique ID for this instruction"""

    action: "shared.KvAction" = betterproto.enum_field(2)
    """What kind of an action is this?"""

    object: "KvObject" = betterproto.message_field(3)
    """KV object"""

    requested_at_unix_ts_nano_utc: int = betterproto.int64_field(4)
    """
    When this instruction was requested (usually will be the HTTP API request
    time)
    """


@dataclass(eq=False, repr=False)
class KvRequest(betterproto.Message):
    """
    Used for broadcasting KV instructions to other server nodes. NOTE: While
    this data structure is similar to KVCommand it makes sense to keep them
    separate. It would cause more confusion if we tried to re-use KVCommand for
    the purpose of broadcasting AND for sending SDK commands. ~DS This request
    structure is used for including all updates - create/update/delete.
    """

    instructions: List["KvInstruction"] = betterproto.message_field(1)
    overwrite: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class KvCreateHttpRequest(betterproto.Message):
    """
    "POST /api/v1/kv" accepts JSON of this type for it's request payload. This
    is converted by BroadcastKV() to a KVCommand
    """

    kvs: List["KvObject"] = betterproto.message_field(1)
    overwrite: bool = betterproto.bool_field(2)
    """
    Whether to treat create as upsert -- ie. do not error if key already exists
    """


@dataclass(eq=False, repr=False)
class KvUpdateHttpRequest(betterproto.Message):
    kvs: List["KvObject"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Command(betterproto.Message):
    """Command is used by streamdal server for sending commands to SDKs"""

    audience: "Audience" = betterproto.message_field(1)
    """
    Who is this command intended for? NOTE: Some commands (such as
    KeepAliveCommand, KVCommand) do NOT use audience and will ignore it
    """

    set_pipelines: "SetPipelinesCommand" = betterproto.message_field(
        100, group="command"
    )
    """
    Emitted by server when a user makes a pause, resume, delete or update
    pipeline and set pipelines external grpc API call. NOTE: This was
    introduced during ordered pipeline updates.
    """

    keep_alive: "KeepAliveCommand" = betterproto.message_field(101, group="command")
    """Server sends this periodically to SDKs to keep the connection alive"""

    kv: "KvCommand" = betterproto.message_field(102, group="command")
    """
    Server will emit this when a user makes changes to the KV store via the KV
    HTTP API.
    """

    tail: "TailCommand" = betterproto.message_field(103, group="command")
    """
    Emitted by server when a user makes a Tail() call Consumed by all server
    instances and by SDKs
    """


@dataclass(eq=False, repr=False)
class SetPipelinesCommand(betterproto.Message):
    pipelines: List["Pipeline"] = betterproto.message_field(1)
    wasm_modules: Dict[str, "shared.WasmModule"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """ID = wasm ID"""


@dataclass(eq=False, repr=False)
class KeepAliveCommand(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class KvCommand(betterproto.Message):
    """Sent by server on Register channel(s) to live SDKs"""

    instructions: List["KvInstruction"] = betterproto.message_field(1)
    overwrite: bool = betterproto.bool_field(2)
    """
    Create & Update specific setting that will cause the Create or Update to
    work as an upsert.
    """


@dataclass(eq=False, repr=False)
class TailCommand(betterproto.Message):
    request: "TailRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class NewAudienceRequest(betterproto.Message):
    session_id: str = betterproto.string_field(1)
    """The session that is performing this call"""

    audience: "Audience" = betterproto.message_field(2)
    """Newly created audience."""


@dataclass(eq=False, repr=False)
class HeartbeatRequest(betterproto.Message):
    """
    Each consumer and producer should send periodic heartbeats to the server to
    let the server know that they are still active.
    """

    session_id: str = betterproto.string_field(1)
    """Session ID for this instance of the SDK."""

    service_name: str = betterproto.string_field(2)
    """
    Name of the service that is sending the heartbeat. Used for refreshing
    registration
    """

    audiences: List["Audience"] = betterproto.message_field(3)
    """
    Used for refreshing live audience keys in the event that backing store
    connection is lost and TTLed audience keys are lost
    """

    client_info: "ClientInfo" = betterproto.message_field(4)
    """Used for refreshing registration"""


@dataclass(eq=False, repr=False)
class NotifyRequest(betterproto.Message):
    condition_type: "NotifyRequestConditionType" = betterproto.enum_field(1)
    step: "PipelineStep" = betterproto.message_field(2)
    """Used for pulling step name and any other info needed in the future"""

    audience: "Audience" = betterproto.message_field(3)
    """Included in notification"""

    occurred_at_unix_ts_utc: int = betterproto.int64_field(4)
    """Included in notification"""

    pipeline_id: str = betterproto.string_field(5)
    """Included in notification"""

    payload: bytes = betterproto.bytes_field(6)
    """Included in notification"""


@dataclass(eq=False, repr=False)
class MetricsRequest(betterproto.Message):
    metrics: List["Metric"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RegisterRequest(betterproto.Message):
    service_name: str = betterproto.string_field(1)
    """REQUIRED -- Name of the service that is registering."""

    session_id: str = betterproto.string_field(2)
    """
    REQUIRED -- Unique ID for this SDK instance. This should be generated every
    time the SDK is instantiated (oe. every time a NEW registration is
    performed).
    """

    client_info: "ClientInfo" = betterproto.message_field(3)
    """REQUIRED -- Info about the client (lib name, lang, os, arch, etc.)"""

    audiences: List["Audience"] = betterproto.message_field(4)
    """
    OPTIONAL -- if these are defined, these will show up in the UI even if
    there is no active .Process() call from the SDK.
    """

    dry_run: bool = betterproto.bool_field(5)
    """
    OPTIONAL -- If set, we know that any pipelines or steps executed in this
    SDK will NOT modify the input/output data. As in, the SDK will log what it
    _would_ do and always return the original data set.
    """


@dataclass(eq=False, repr=False)
class DeregisterRequest(betterproto.Message):
    """
    Same as RegisterRequest - used for broadcasting a deregistration event
    """

    service_name: str = betterproto.string_field(1)
    session_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetSetPipelinesCommandsByServiceRequest(betterproto.Message):
    """
    Method used by SDKs to fetch all SetPipelinesCommands for a given service
    name. The SDK may not know of all audiences yet so this method returns ALL
    SetPipelinesCommands that use the same same service name. SDKs should store
    the commands (or pipelines) in memory tied to an audience, so that if/when
    a .Process() call occurs with an audience - the SDK will already have the
    pipeline config in memory.
    """

    service_name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetSetPipelinesCommandsByServiceResponse(betterproto.Message):
    set_pipeline_commands: List["Command"] = betterproto.message_field(1)
    """SetPipelinesCommands for all active pipelines"""

    wasm_modules: Dict[str, "shared.WasmModule"] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """ID = wasm ID"""


@dataclass(eq=False, repr=False)
class SendSchemaRequest(betterproto.Message):
    audience: "Audience" = betterproto.message_field(1)
    schema: "Schema" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class BusEvent(betterproto.Message):
    """Type used by `server` for broadcasting events to other nodes"""

    source: str = betterproto.string_field(1)
    register_request: "RegisterRequest" = betterproto.message_field(100, group="event")
    deregister_request: "DeregisterRequest" = betterproto.message_field(
        101, group="event"
    )
    create_pipeline_request: "CreatePipelineRequest" = betterproto.message_field(
        102, group="event"
    )
    delete_pipeline_request: "DeletePipelineRequest" = betterproto.message_field(
        103, group="event"
    )
    update_pipeline_request: "UpdatePipelineRequest" = betterproto.message_field(
        104, group="event"
    )
    pause_pipeline_request: "PausePipelineRequest" = betterproto.message_field(
        107, group="event"
    )
    resume_pipeline_request: "ResumePipelineRequest" = betterproto.message_field(
        108, group="event"
    )
    metrics_request: "MetricsRequest" = betterproto.message_field(109, group="event")
    kv_request: "KvRequest" = betterproto.message_field(110, group="event")
    delete_audience_request: "DeleteAudienceRequest" = betterproto.message_field(
        111, group="event"
    )
    new_audience_request: "NewAudienceRequest" = betterproto.message_field(
        112, group="event"
    )
    tail_request: "TailRequest" = betterproto.message_field(113, group="event")
    tail_response: "TailResponse" = betterproto.message_field(114, group="event")
    set_pipelines_request: "SetPipelinesRequest" = betterproto.message_field(
        115, group="event"
    )
    metadata: Dict[str, str] = betterproto.map_field(
        1000, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    All gRPC metadata is stored in ctx; when request goes outside of gRPC
    bounds, we will translate ctx metadata into this field. Example: 1. Request
    comes into server via external gRPC to set new pipeline 2. server has to
    send SetPipeline cmd to SDK via gRPC - it passes    on original metadata in
    request. 3. server has to broadcast SetPipeline cmd to other services via
    bus 4. Since this is not a gRPC call, server translates ctx metadata to
    this field and includes it in the bus event.
    """


@dataclass(eq=False, repr=False)
class SdkResponse(betterproto.Message):
    """Common return response used by all SDKs"""

    data: bytes = betterproto.bytes_field(1)
    """Contains (potentially) modified input data"""

    status: "ExecStatus" = betterproto.enum_field(2)
    """Execution status of the last step"""

    status_message: Optional[str] = betterproto.string_field(
        3, optional=True, group="_status_message"
    )
    """Optional message accompanying the exec status for the last step"""

    pipeline_status: List["PipelineStatus"] = betterproto.message_field(4)
    """
    An array of pipelines that the SDK executed and the status of each step
    """

    metadata: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    Includes any metadata that the step(s) may want to pass back to the user.
    NOTE: Metadata is aggregated across all steps in the pipeline, so if two
    steps both set a key "foo" to different values, the value of "foo" in the
    response will be the value set by the last step in the pipeline. To learn
    more about "metadata", see SDK Spec V2 doc "Pipeline Step & Error Behavior"
    section.
    """


@dataclass(eq=False, repr=False)
class PipelineStatus(betterproto.Message):
    id: str = betterproto.string_field(1)
    """ID of the pipeline"""

    name: str = betterproto.string_field(2)
    """The name of the pipeline"""

    step_status: List["StepStatus"] = betterproto.message_field(3)
    """The status of each step in the pipeline"""


@dataclass(eq=False, repr=False)
class StepStatus(betterproto.Message):
    name: str = betterproto.string_field(1)
    """The name of the step"""

    status: "ExecStatus" = betterproto.enum_field(2)
    """Execution outcome status of the step"""

    status_message: Optional[str] = betterproto.string_field(
        3, optional=True, group="_status_message"
    )
    """Optional message accompanying the exec status"""

    abort_condition: "AbortCondition" = betterproto.enum_field(4)
    """
    Indicates if current or all future pipelines were aborted. IMPORTANT: The
    SDK running into an error does not automatically abort current or all
    future pipelines - the user must define the abort conditions for
    "on_error".
    """


@dataclass(eq=False, repr=False)
class WasmRequest(betterproto.Message):
    """SDK generates a WASM request and passes this to the WASM func"""

    step: "PipelineStep" = betterproto.message_field(1)
    """
    The actual step that the WASM func will operate on. This is the same step
    that is declared in protos.Pipeline.
    """

    input_payload: bytes = betterproto.bytes_field(2)
    """Payload data that WASM func will operate on"""

    input_step: Optional[bytes] = betterproto.bytes_field(
        3, optional=True, group="_input_step"
    )
    """
    Potentially filled out result from previous step. If this is first step in
    the pipeline, it will be empty.
    """

    inter_step_result: Optional["InterStepResult"] = betterproto.message_field(
        4, optional=True, group="_inter_step_result"
    )
    """
    Potential input from a previous step if `Step.Dynamic == true` This is used
    for communicating data between steps. For example, when trying to find
    email addresses in a payload and then passing on the results to a transform
    step to obfuscate them
    """


@dataclass(eq=False, repr=False)
class WasmResponse(betterproto.Message):
    """Returned by all WASM functions"""

    output_payload: bytes = betterproto.bytes_field(1)
    """
    Potentially modified input payload. Concept: All WASM funcs accept an
    input_payload in WASMRequest, WASM func reads input payload, modifies it
    and writes the modified output to output_payload.
    """

    exit_code: "WasmExitCode" = betterproto.enum_field(2)
    """
    Exit code that the WASM func exited with; more info in WASMExitCode's
    comment
    """

    exit_msg: str = betterproto.string_field(3)
    """Additional info about the reason a specific exit code was returned"""

    output_step: Optional[bytes] = betterproto.bytes_field(
        4, optional=True, group="_output_step"
    )
    """
    Potential additional step output - ie. if a WASM func is an HTTPGet,
    output_step would contain the HTTP response body; if the WASM func is a
    KVGet, the output_step would be the value of the fetched key.
    """

    inter_step_result: Optional["InterStepResult"] = betterproto.message_field(
        5, optional=True, group="_inter_step_result"
    )
    """
    If `Step.Dynamic == true`, this field should be filled out by the WASM
    module This is used for communicating data between steps. For example, when
    trying to find email addresses in a payload and then passing on the results
    to a transform step to obfuscate them
    """


@dataclass(eq=False, repr=False)
class InterStepResult(betterproto.Message):
    """
    Intended for communicating wasm results between steps. Currently only used
    for passing results from a Detective Step to a Transform step
    """

    detective_result: "steps.DetectiveStepResult" = betterproto.message_field(
        1, group="input_from"
    )


class ExternalStub(betterproto.ServiceStub):
    async def get_all(
        self,
        get_all_request: "GetAllRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetAllResponse":
        return await self._unary_unary(
            "/protos.External/GetAll",
            get_all_request,
            GetAllResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_config(
        self,
        get_config_request: "GetConfigRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetConfigResponse":
        return await self._unary_unary(
            "/protos.External/GetConfig",
            get_config_request,
            GetConfigResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_all_stream(
        self,
        get_all_request: "GetAllRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["GetAllResponse"]:
        async for response in self._unary_stream(
            "/protos.External/GetAllStream",
            get_all_request,
            GetAllResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def get_pipelines(
        self,
        get_pipelines_request: "GetPipelinesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetPipelinesResponse":
        return await self._unary_unary(
            "/protos.External/GetPipelines",
            get_pipelines_request,
            GetPipelinesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_pipeline(
        self,
        get_pipeline_request: "GetPipelineRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetPipelineResponse":
        return await self._unary_unary(
            "/protos.External/GetPipeline",
            get_pipeline_request,
            GetPipelineResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_pipeline(
        self,
        create_pipeline_request: "CreatePipelineRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreatePipelineResponse":
        return await self._unary_unary(
            "/protos.External/CreatePipeline",
            create_pipeline_request,
            CreatePipelineResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_pipeline(
        self,
        update_pipeline_request: "UpdatePipelineRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/UpdatePipeline",
            update_pipeline_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_pipeline(
        self,
        delete_pipeline_request: "DeletePipelineRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/DeletePipeline",
            delete_pipeline_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_pipelines(
        self,
        set_pipelines_request: "SetPipelinesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/SetPipelines",
            set_pipelines_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def pause_pipeline(
        self,
        pause_pipeline_request: "PausePipelineRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/PausePipeline",
            pause_pipeline_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def resume_pipeline(
        self,
        resume_pipeline_request: "ResumePipelineRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/ResumePipeline",
            resume_pipeline_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_notification(
        self,
        create_notification_request: "CreateNotificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateNotificationResponse":
        return await self._unary_unary(
            "/protos.External/CreateNotification",
            create_notification_request,
            CreateNotificationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_notification(
        self,
        update_notification_request: "UpdateNotificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/UpdateNotification",
            update_notification_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_notification(
        self,
        delete_notification_request: "DeleteNotificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/DeleteNotification",
            delete_notification_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_notifications(
        self,
        get_notifications_request: "GetNotificationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetNotificationsResponse":
        return await self._unary_unary(
            "/protos.External/GetNotifications",
            get_notifications_request,
            GetNotificationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_notification(
        self,
        get_notification_request: "GetNotificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetNotificationResponse":
        return await self._unary_unary(
            "/protos.External/GetNotification",
            get_notification_request,
            GetNotificationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def attach_notification(
        self,
        attach_notification_request: "AttachNotificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/AttachNotification",
            attach_notification_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def detach_notification(
        self,
        detach_notification_request: "DetachNotificationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/DetachNotification",
            detach_notification_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_audience(
        self,
        create_audience_request: "CreateAudienceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/CreateAudience",
            create_audience_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_audience(
        self,
        delete_audience_request: "DeleteAudienceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/DeleteAudience",
            delete_audience_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_service(
        self,
        delete_service_request: "DeleteServiceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/DeleteService",
            delete_service_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_metrics(
        self,
        get_metrics_request: "GetMetricsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["GetMetricsResponse"]:
        async for response in self._unary_stream(
            "/protos.External/GetMetrics",
            get_metrics_request,
            GetMetricsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def tail(
        self,
        tail_request: "TailRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["TailResponse"]:
        async for response in self._unary_stream(
            "/protos.External/Tail",
            tail_request,
            TailResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def pause_tail(
        self,
        pause_tail_request: "PauseTailRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/PauseTail",
            pause_tail_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def resume_tail(
        self,
        resume_tail_request: "ResumeTailRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/ResumeTail",
            resume_tail_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_audience_rates(
        self,
        get_audience_rates_request: "GetAudienceRatesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["GetAudienceRatesResponse"]:
        async for response in self._unary_stream(
            "/protos.External/GetAudienceRates",
            get_audience_rates_request,
            GetAudienceRatesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def get_schema(
        self,
        get_schema_request: "GetSchemaRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetSchemaResponse":
        return await self._unary_unary(
            "/protos.External/GetSchema",
            get_schema_request,
            GetSchemaResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def app_registration_status(
        self,
        app_registration_status_request: "AppRegistrationStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AppRegistrationStatusResponse":
        return await self._unary_unary(
            "/protos.External/AppRegistrationStatus",
            app_registration_status_request,
            AppRegistrationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def app_register(
        self,
        app_registration_request: "AppRegistrationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/AppRegister",
            app_registration_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def app_verify_registration(
        self,
        app_verify_registration_request: "AppVerifyRegistrationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/AppVerifyRegistration",
            app_verify_registration_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def app_register_reject(
        self,
        app_register_reject_request: "AppRegisterRejectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/AppRegisterReject",
            app_register_reject_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_wasm(
        self,
        get_wasm_request: "GetWasmRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetWasmResponse":
        return await self._unary_unary(
            "/protos.External/GetWasm",
            get_wasm_request,
            GetWasmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_all_wasm(
        self,
        get_all_wasm_request: "GetAllWasmRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetAllWasmResponse":
        return await self._unary_unary(
            "/protos.External/GetAllWasm",
            get_all_wasm_request,
            GetAllWasmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_wasm(
        self,
        create_wasm_request: "CreateWasmRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateWasmResponse":
        return await self._unary_unary(
            "/protos.External/CreateWasm",
            create_wasm_request,
            CreateWasmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_wasm(
        self,
        update_wasm_request: "UpdateWasmRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/UpdateWasm",
            update_wasm_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_wasm(
        self,
        delete_wasm_request: "DeleteWasmRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.External/DeleteWasm",
            delete_wasm_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def test(
        self,
        test_request: "TestRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "TestResponse":
        return await self._unary_unary(
            "/protos.External/Test",
            test_request,
            TestResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class InternalStub(betterproto.ServiceStub):
    async def register(
        self,
        register_request: "RegisterRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["Command"]:
        async for response in self._unary_stream(
            "/protos.Internal/Register",
            register_request,
            Command,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def new_audience(
        self,
        new_audience_request: "NewAudienceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.Internal/NewAudience",
            new_audience_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def heartbeat(
        self,
        heartbeat_request: "HeartbeatRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.Internal/Heartbeat",
            heartbeat_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def notify(
        self,
        notify_request: "NotifyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.Internal/Notify",
            notify_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def metrics(
        self,
        metrics_request: "MetricsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.Internal/Metrics",
            metrics_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_set_pipelines_commands_by_service(
        self,
        get_set_pipelines_commands_by_service_request: "GetSetPipelinesCommandsByServiceRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetSetPipelinesCommandsByServiceResponse":
        return await self._unary_unary(
            "/protos.Internal/GetSetPipelinesCommandsByService",
            get_set_pipelines_commands_by_service_request,
            GetSetPipelinesCommandsByServiceResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def send_tail(
        self,
        tail_response_iterator: Union[
            AsyncIterable["TailResponse"], Iterable["TailResponse"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._stream_unary(
            "/protos.Internal/SendTail",
            tail_response_iterator,
            TailResponse,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def send_schema(
        self,
        send_schema_request: "SendSchemaRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StandardResponse":
        return await self._unary_unary(
            "/protos.Internal/SendSchema",
            send_schema_request,
            StandardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ExternalBase(ServiceBase):
    async def get_all(self, get_all_request: "GetAllRequest") -> "GetAllResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_config(
        self, get_config_request: "GetConfigRequest"
    ) -> "GetConfigResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_all_stream(
        self, get_all_request: "GetAllRequest"
    ) -> AsyncIterator["GetAllResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield GetAllResponse()

    async def get_pipelines(
        self, get_pipelines_request: "GetPipelinesRequest"
    ) -> "GetPipelinesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_pipeline(
        self, get_pipeline_request: "GetPipelineRequest"
    ) -> "GetPipelineResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_pipeline(
        self, create_pipeline_request: "CreatePipelineRequest"
    ) -> "CreatePipelineResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_pipeline(
        self, update_pipeline_request: "UpdatePipelineRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_pipeline(
        self, delete_pipeline_request: "DeletePipelineRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_pipelines(
        self, set_pipelines_request: "SetPipelinesRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pause_pipeline(
        self, pause_pipeline_request: "PausePipelineRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def resume_pipeline(
        self, resume_pipeline_request: "ResumePipelineRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_notification(
        self, create_notification_request: "CreateNotificationRequest"
    ) -> "CreateNotificationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_notification(
        self, update_notification_request: "UpdateNotificationRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_notification(
        self, delete_notification_request: "DeleteNotificationRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_notifications(
        self, get_notifications_request: "GetNotificationsRequest"
    ) -> "GetNotificationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_notification(
        self, get_notification_request: "GetNotificationRequest"
    ) -> "GetNotificationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def attach_notification(
        self, attach_notification_request: "AttachNotificationRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def detach_notification(
        self, detach_notification_request: "DetachNotificationRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_audience(
        self, create_audience_request: "CreateAudienceRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_audience(
        self, delete_audience_request: "DeleteAudienceRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_service(
        self, delete_service_request: "DeleteServiceRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_metrics(
        self, get_metrics_request: "GetMetricsRequest"
    ) -> AsyncIterator["GetMetricsResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield GetMetricsResponse()

    async def tail(self, tail_request: "TailRequest") -> AsyncIterator["TailResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield TailResponse()

    async def pause_tail(
        self, pause_tail_request: "PauseTailRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def resume_tail(
        self, resume_tail_request: "ResumeTailRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_audience_rates(
        self, get_audience_rates_request: "GetAudienceRatesRequest"
    ) -> AsyncIterator["GetAudienceRatesResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield GetAudienceRatesResponse()

    async def get_schema(
        self, get_schema_request: "GetSchemaRequest"
    ) -> "GetSchemaResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def app_registration_status(
        self, app_registration_status_request: "AppRegistrationStatusRequest"
    ) -> "AppRegistrationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def app_register(
        self, app_registration_request: "AppRegistrationRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def app_verify_registration(
        self, app_verify_registration_request: "AppVerifyRegistrationRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def app_register_reject(
        self, app_register_reject_request: "AppRegisterRejectRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_wasm(self, get_wasm_request: "GetWasmRequest") -> "GetWasmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_all_wasm(
        self, get_all_wasm_request: "GetAllWasmRequest"
    ) -> "GetAllWasmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_wasm(
        self, create_wasm_request: "CreateWasmRequest"
    ) -> "CreateWasmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_wasm(
        self, update_wasm_request: "UpdateWasmRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_wasm(
        self, delete_wasm_request: "DeleteWasmRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def test(self, test_request: "TestRequest") -> "TestResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_all(
        self, stream: "grpclib.server.Stream[GetAllRequest, GetAllResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_all(request)
        await stream.send_message(response)

    async def __rpc_get_config(
        self, stream: "grpclib.server.Stream[GetConfigRequest, GetConfigResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_config(request)
        await stream.send_message(response)

    async def __rpc_get_all_stream(
        self, stream: "grpclib.server.Stream[GetAllRequest, GetAllResponse]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.get_all_stream,
            stream,
            request,
        )

    async def __rpc_get_pipelines(
        self, stream: "grpclib.server.Stream[GetPipelinesRequest, GetPipelinesResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_pipelines(request)
        await stream.send_message(response)

    async def __rpc_get_pipeline(
        self, stream: "grpclib.server.Stream[GetPipelineRequest, GetPipelineResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_pipeline(request)
        await stream.send_message(response)

    async def __rpc_create_pipeline(
        self,
        stream: "grpclib.server.Stream[CreatePipelineRequest, CreatePipelineResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_pipeline(request)
        await stream.send_message(response)

    async def __rpc_update_pipeline(
        self, stream: "grpclib.server.Stream[UpdatePipelineRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_pipeline(request)
        await stream.send_message(response)

    async def __rpc_delete_pipeline(
        self, stream: "grpclib.server.Stream[DeletePipelineRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_pipeline(request)
        await stream.send_message(response)

    async def __rpc_set_pipelines(
        self, stream: "grpclib.server.Stream[SetPipelinesRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_pipelines(request)
        await stream.send_message(response)

    async def __rpc_pause_pipeline(
        self, stream: "grpclib.server.Stream[PausePipelineRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.pause_pipeline(request)
        await stream.send_message(response)

    async def __rpc_resume_pipeline(
        self, stream: "grpclib.server.Stream[ResumePipelineRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.resume_pipeline(request)
        await stream.send_message(response)

    async def __rpc_create_notification(
        self,
        stream: "grpclib.server.Stream[CreateNotificationRequest, CreateNotificationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_notification(request)
        await stream.send_message(response)

    async def __rpc_update_notification(
        self,
        stream: "grpclib.server.Stream[UpdateNotificationRequest, StandardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_notification(request)
        await stream.send_message(response)

    async def __rpc_delete_notification(
        self,
        stream: "grpclib.server.Stream[DeleteNotificationRequest, StandardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_notification(request)
        await stream.send_message(response)

    async def __rpc_get_notifications(
        self,
        stream: "grpclib.server.Stream[GetNotificationsRequest, GetNotificationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_notifications(request)
        await stream.send_message(response)

    async def __rpc_get_notification(
        self,
        stream: "grpclib.server.Stream[GetNotificationRequest, GetNotificationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_notification(request)
        await stream.send_message(response)

    async def __rpc_attach_notification(
        self,
        stream: "grpclib.server.Stream[AttachNotificationRequest, StandardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.attach_notification(request)
        await stream.send_message(response)

    async def __rpc_detach_notification(
        self,
        stream: "grpclib.server.Stream[DetachNotificationRequest, StandardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.detach_notification(request)
        await stream.send_message(response)

    async def __rpc_create_audience(
        self, stream: "grpclib.server.Stream[CreateAudienceRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_audience(request)
        await stream.send_message(response)

    async def __rpc_delete_audience(
        self, stream: "grpclib.server.Stream[DeleteAudienceRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_audience(request)
        await stream.send_message(response)

    async def __rpc_delete_service(
        self, stream: "grpclib.server.Stream[DeleteServiceRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_service(request)
        await stream.send_message(response)

    async def __rpc_get_metrics(
        self, stream: "grpclib.server.Stream[GetMetricsRequest, GetMetricsResponse]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.get_metrics,
            stream,
            request,
        )

    async def __rpc_tail(
        self, stream: "grpclib.server.Stream[TailRequest, TailResponse]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.tail,
            stream,
            request,
        )

    async def __rpc_pause_tail(
        self, stream: "grpclib.server.Stream[PauseTailRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.pause_tail(request)
        await stream.send_message(response)

    async def __rpc_resume_tail(
        self, stream: "grpclib.server.Stream[ResumeTailRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.resume_tail(request)
        await stream.send_message(response)

    async def __rpc_get_audience_rates(
        self,
        stream: "grpclib.server.Stream[GetAudienceRatesRequest, GetAudienceRatesResponse]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.get_audience_rates,
            stream,
            request,
        )

    async def __rpc_get_schema(
        self, stream: "grpclib.server.Stream[GetSchemaRequest, GetSchemaResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_schema(request)
        await stream.send_message(response)

    async def __rpc_app_registration_status(
        self,
        stream: "grpclib.server.Stream[AppRegistrationStatusRequest, AppRegistrationStatusResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.app_registration_status(request)
        await stream.send_message(response)

    async def __rpc_app_register(
        self, stream: "grpclib.server.Stream[AppRegistrationRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.app_register(request)
        await stream.send_message(response)

    async def __rpc_app_verify_registration(
        self,
        stream: "grpclib.server.Stream[AppVerifyRegistrationRequest, StandardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.app_verify_registration(request)
        await stream.send_message(response)

    async def __rpc_app_register_reject(
        self,
        stream: "grpclib.server.Stream[AppRegisterRejectRequest, StandardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.app_register_reject(request)
        await stream.send_message(response)

    async def __rpc_get_wasm(
        self, stream: "grpclib.server.Stream[GetWasmRequest, GetWasmResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_wasm(request)
        await stream.send_message(response)

    async def __rpc_get_all_wasm(
        self, stream: "grpclib.server.Stream[GetAllWasmRequest, GetAllWasmResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_all_wasm(request)
        await stream.send_message(response)

    async def __rpc_create_wasm(
        self, stream: "grpclib.server.Stream[CreateWasmRequest, CreateWasmResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_wasm(request)
        await stream.send_message(response)

    async def __rpc_update_wasm(
        self, stream: "grpclib.server.Stream[UpdateWasmRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_wasm(request)
        await stream.send_message(response)

    async def __rpc_delete_wasm(
        self, stream: "grpclib.server.Stream[DeleteWasmRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_wasm(request)
        await stream.send_message(response)

    async def __rpc_test(
        self, stream: "grpclib.server.Stream[TestRequest, TestResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.test(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/protos.External/GetAll": grpclib.const.Handler(
                self.__rpc_get_all,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetAllRequest,
                GetAllResponse,
            ),
            "/protos.External/GetConfig": grpclib.const.Handler(
                self.__rpc_get_config,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetConfigRequest,
                GetConfigResponse,
            ),
            "/protos.External/GetAllStream": grpclib.const.Handler(
                self.__rpc_get_all_stream,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetAllRequest,
                GetAllResponse,
            ),
            "/protos.External/GetPipelines": grpclib.const.Handler(
                self.__rpc_get_pipelines,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPipelinesRequest,
                GetPipelinesResponse,
            ),
            "/protos.External/GetPipeline": grpclib.const.Handler(
                self.__rpc_get_pipeline,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPipelineRequest,
                GetPipelineResponse,
            ),
            "/protos.External/CreatePipeline": grpclib.const.Handler(
                self.__rpc_create_pipeline,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreatePipelineRequest,
                CreatePipelineResponse,
            ),
            "/protos.External/UpdatePipeline": grpclib.const.Handler(
                self.__rpc_update_pipeline,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdatePipelineRequest,
                StandardResponse,
            ),
            "/protos.External/DeletePipeline": grpclib.const.Handler(
                self.__rpc_delete_pipeline,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeletePipelineRequest,
                StandardResponse,
            ),
            "/protos.External/SetPipelines": grpclib.const.Handler(
                self.__rpc_set_pipelines,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetPipelinesRequest,
                StandardResponse,
            ),
            "/protos.External/PausePipeline": grpclib.const.Handler(
                self.__rpc_pause_pipeline,
                grpclib.const.Cardinality.UNARY_UNARY,
                PausePipelineRequest,
                StandardResponse,
            ),
            "/protos.External/ResumePipeline": grpclib.const.Handler(
                self.__rpc_resume_pipeline,
                grpclib.const.Cardinality.UNARY_UNARY,
                ResumePipelineRequest,
                StandardResponse,
            ),
            "/protos.External/CreateNotification": grpclib.const.Handler(
                self.__rpc_create_notification,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateNotificationRequest,
                CreateNotificationResponse,
            ),
            "/protos.External/UpdateNotification": grpclib.const.Handler(
                self.__rpc_update_notification,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateNotificationRequest,
                StandardResponse,
            ),
            "/protos.External/DeleteNotification": grpclib.const.Handler(
                self.__rpc_delete_notification,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteNotificationRequest,
                StandardResponse,
            ),
            "/protos.External/GetNotifications": grpclib.const.Handler(
                self.__rpc_get_notifications,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetNotificationsRequest,
                GetNotificationsResponse,
            ),
            "/protos.External/GetNotification": grpclib.const.Handler(
                self.__rpc_get_notification,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetNotificationRequest,
                GetNotificationResponse,
            ),
            "/protos.External/AttachNotification": grpclib.const.Handler(
                self.__rpc_attach_notification,
                grpclib.const.Cardinality.UNARY_UNARY,
                AttachNotificationRequest,
                StandardResponse,
            ),
            "/protos.External/DetachNotification": grpclib.const.Handler(
                self.__rpc_detach_notification,
                grpclib.const.Cardinality.UNARY_UNARY,
                DetachNotificationRequest,
                StandardResponse,
            ),
            "/protos.External/CreateAudience": grpclib.const.Handler(
                self.__rpc_create_audience,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateAudienceRequest,
                StandardResponse,
            ),
            "/protos.External/DeleteAudience": grpclib.const.Handler(
                self.__rpc_delete_audience,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteAudienceRequest,
                StandardResponse,
            ),
            "/protos.External/DeleteService": grpclib.const.Handler(
                self.__rpc_delete_service,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteServiceRequest,
                StandardResponse,
            ),
            "/protos.External/GetMetrics": grpclib.const.Handler(
                self.__rpc_get_metrics,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetMetricsRequest,
                GetMetricsResponse,
            ),
            "/protos.External/Tail": grpclib.const.Handler(
                self.__rpc_tail,
                grpclib.const.Cardinality.UNARY_STREAM,
                TailRequest,
                TailResponse,
            ),
            "/protos.External/PauseTail": grpclib.const.Handler(
                self.__rpc_pause_tail,
                grpclib.const.Cardinality.UNARY_UNARY,
                PauseTailRequest,
                StandardResponse,
            ),
            "/protos.External/ResumeTail": grpclib.const.Handler(
                self.__rpc_resume_tail,
                grpclib.const.Cardinality.UNARY_UNARY,
                ResumeTailRequest,
                StandardResponse,
            ),
            "/protos.External/GetAudienceRates": grpclib.const.Handler(
                self.__rpc_get_audience_rates,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetAudienceRatesRequest,
                GetAudienceRatesResponse,
            ),
            "/protos.External/GetSchema": grpclib.const.Handler(
                self.__rpc_get_schema,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetSchemaRequest,
                GetSchemaResponse,
            ),
            "/protos.External/AppRegistrationStatus": grpclib.const.Handler(
                self.__rpc_app_registration_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                AppRegistrationStatusRequest,
                AppRegistrationStatusResponse,
            ),
            "/protos.External/AppRegister": grpclib.const.Handler(
                self.__rpc_app_register,
                grpclib.const.Cardinality.UNARY_UNARY,
                AppRegistrationRequest,
                StandardResponse,
            ),
            "/protos.External/AppVerifyRegistration": grpclib.const.Handler(
                self.__rpc_app_verify_registration,
                grpclib.const.Cardinality.UNARY_UNARY,
                AppVerifyRegistrationRequest,
                StandardResponse,
            ),
            "/protos.External/AppRegisterReject": grpclib.const.Handler(
                self.__rpc_app_register_reject,
                grpclib.const.Cardinality.UNARY_UNARY,
                AppRegisterRejectRequest,
                StandardResponse,
            ),
            "/protos.External/GetWasm": grpclib.const.Handler(
                self.__rpc_get_wasm,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetWasmRequest,
                GetWasmResponse,
            ),
            "/protos.External/GetAllWasm": grpclib.const.Handler(
                self.__rpc_get_all_wasm,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetAllWasmRequest,
                GetAllWasmResponse,
            ),
            "/protos.External/CreateWasm": grpclib.const.Handler(
                self.__rpc_create_wasm,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateWasmRequest,
                CreateWasmResponse,
            ),
            "/protos.External/UpdateWasm": grpclib.const.Handler(
                self.__rpc_update_wasm,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateWasmRequest,
                StandardResponse,
            ),
            "/protos.External/DeleteWasm": grpclib.const.Handler(
                self.__rpc_delete_wasm,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteWasmRequest,
                StandardResponse,
            ),
            "/protos.External/Test": grpclib.const.Handler(
                self.__rpc_test,
                grpclib.const.Cardinality.UNARY_UNARY,
                TestRequest,
                TestResponse,
            ),
        }


class InternalBase(ServiceBase):
    async def register(
        self, register_request: "RegisterRequest"
    ) -> AsyncIterator["Command"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield Command()

    async def new_audience(
        self, new_audience_request: "NewAudienceRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def heartbeat(
        self, heartbeat_request: "HeartbeatRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def notify(self, notify_request: "NotifyRequest") -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def metrics(self, metrics_request: "MetricsRequest") -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_set_pipelines_commands_by_service(
        self,
        get_set_pipelines_commands_by_service_request: "GetSetPipelinesCommandsByServiceRequest",
    ) -> "GetSetPipelinesCommandsByServiceResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def send_tail(
        self, tail_response_iterator: AsyncIterator["TailResponse"]
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def send_schema(
        self, send_schema_request: "SendSchemaRequest"
    ) -> "StandardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_register(
        self, stream: "grpclib.server.Stream[RegisterRequest, Command]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.register,
            stream,
            request,
        )

    async def __rpc_new_audience(
        self, stream: "grpclib.server.Stream[NewAudienceRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.new_audience(request)
        await stream.send_message(response)

    async def __rpc_heartbeat(
        self, stream: "grpclib.server.Stream[HeartbeatRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.heartbeat(request)
        await stream.send_message(response)

    async def __rpc_notify(
        self, stream: "grpclib.server.Stream[NotifyRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.notify(request)
        await stream.send_message(response)

    async def __rpc_metrics(
        self, stream: "grpclib.server.Stream[MetricsRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.metrics(request)
        await stream.send_message(response)

    async def __rpc_get_set_pipelines_commands_by_service(
        self,
        stream: "grpclib.server.Stream[GetSetPipelinesCommandsByServiceRequest, GetSetPipelinesCommandsByServiceResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_set_pipelines_commands_by_service(request)
        await stream.send_message(response)

    async def __rpc_send_tail(
        self, stream: "grpclib.server.Stream[TailResponse, StandardResponse]"
    ) -> None:
        request = stream.__aiter__()
        response = await self.send_tail(request)
        await stream.send_message(response)

    async def __rpc_send_schema(
        self, stream: "grpclib.server.Stream[SendSchemaRequest, StandardResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.send_schema(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/protos.Internal/Register": grpclib.const.Handler(
                self.__rpc_register,
                grpclib.const.Cardinality.UNARY_STREAM,
                RegisterRequest,
                Command,
            ),
            "/protos.Internal/NewAudience": grpclib.const.Handler(
                self.__rpc_new_audience,
                grpclib.const.Cardinality.UNARY_UNARY,
                NewAudienceRequest,
                StandardResponse,
            ),
            "/protos.Internal/Heartbeat": grpclib.const.Handler(
                self.__rpc_heartbeat,
                grpclib.const.Cardinality.UNARY_UNARY,
                HeartbeatRequest,
                StandardResponse,
            ),
            "/protos.Internal/Notify": grpclib.const.Handler(
                self.__rpc_notify,
                grpclib.const.Cardinality.UNARY_UNARY,
                NotifyRequest,
                StandardResponse,
            ),
            "/protos.Internal/Metrics": grpclib.const.Handler(
                self.__rpc_metrics,
                grpclib.const.Cardinality.UNARY_UNARY,
                MetricsRequest,
                StandardResponse,
            ),
            "/protos.Internal/GetSetPipelinesCommandsByService": grpclib.const.Handler(
                self.__rpc_get_set_pipelines_commands_by_service,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetSetPipelinesCommandsByServiceRequest,
                GetSetPipelinesCommandsByServiceResponse,
            ),
            "/protos.Internal/SendTail": grpclib.const.Handler(
                self.__rpc_send_tail,
                grpclib.const.Cardinality.STREAM_UNARY,
                TailResponse,
                StandardResponse,
            ),
            "/protos.Internal/SendSchema": grpclib.const.Handler(
                self.__rpc_send_schema,
                grpclib.const.Cardinality.UNARY_UNARY,
                SendSchemaRequest,
                StandardResponse,
            ),
        }
